;
;	PCML.COM
;
;	pcm load & play for msdrv4.exe + pcmdriver
;		programed by kenji
;
;[tasm ver6.0]
;tasm /jJUMPS /m4 pcml;
;tlink /t pcml.obj,pcml.com
;
;[optasm]
;optasm pcml;
;optlink pcml.exe pcml.com;
;
;[masm ver6.0]
;ml /AT msms_f00.asm
;
;AZu̒
;΋ -128 ` 127 ͈͊ÕWvgpĂ܂BLȊÕAZu
;gpꍇ͋CtĉB
;
;=============================================================================
;=============================================================================
;	define
;=============================================================================
;=============================================================================
vec_msp		equ	63h		; pcm 䊄荞݃xN^[ԍ


debug		equ	0
cr		equ	0dh
lf		equ	0ah
ssg_buffer_size	equ	256*(16+12)
opn_buffer_size	equ	256*(48+12)

FileNameSize	equ	128
msp_read_buffer_size equ 1024


;=============================================================================
;=============================================================================
;	structure
;=============================================================================
;=============================================================================
wfmt_data		struc
wfmt_ckID		db	4 dup(?)
wfmt_ckSize		dd	?
wfmt_ckIDwave		dd	?		; "WAVE"
wfmt_ckIDfmt		dd	?		; "fmt "
wfmt_fmtSize		dd	?
wfmt_wFormatTag		dw	?		; 1 ȊOs
wfmt_nChannels		dw	?
wfmt_nSamplesPerSec	dd	?
wfmt_nAvgBytesPerSec	dd	?
wfmt_nBlockAlign	dw	?
wfmt_nBitPerSample	dw	?
wfmt_ckIDdata		dd	?		; "data"
wfmt_pcmSize		dd	?
wfmt_data		ends


code	segment
	assume cs:code,ds:code
	.186
;=============================================================================
;=============================================================================
;	PSP
;=============================================================================
;=============================================================================
	org	2ch
envseg	dw	?			;environment segment
	org	80h
argc	db	?			;size of command
argv	db	127 dup (?)		;command line


;=============================================================================
;=============================================================================
;	program
;=============================================================================
;=============================================================================
start		proc	near
;
;	main
;
	cld
	mov	sp,offset stack_pointer


	;
	;	program ̂
	;
	push	es
	push	cs
	pop	es
	mov	bx,( offset end_program - offset start + 10fh ) / 10h
	mov	ah,4ah
	int	21h
	pop	es


	;
	;	get option and file name
	;
	mov	si,offset argv
main_loop0:
	lodsb
	cmp	al,cr
	je	main_next0
	cmp	al,"/"
	je	main_option
	cmp	al,"-"
	je	main_option
	cmp	al," "
	jbe	main_loop0

	mov	di,offset FileName
	dec	si
main_loop1:
	lodsb
	stosb
	cmp	al," "
	ja	main_loop1
	dec	di
	dec	si
	xor	al,al
	stosb
	call	set_filename
	jmp	main_loop0


	;
	;	option check
	;
main_option:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"F"			; freq
	je	main_option_f
	cmp	al,"V"			; volume
	je	main_option_v
	cmp	al,"P"			; pan
	je	main_option_p
	cmp	al,"S"			; streo
	je	main_option_s
	jmp	error_0004


	;
	;	set freq
	;
main_option_f:
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	mov	[pcm_freq],ax
	jmp	main_loop0


	;
	;	set volume
	;
main_option_v:
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	or	ah,ah
	jne	error_0004
	mov	[play_volume],al
	jmp	main_loop0


	;
	;	set pan
	;
main_option_p:
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	or	ah,ah
	jne	error_0004
	mov	[play_pan],al
	jmp	main_loop0


	;
	;	set streo
	;
main_option_s:
	or	[pcm_type],00010000b
	mov	[pcm_pan],001000b
	jmp	main_loop0


	;
	;	main
	;
main_next0:
	call	check_msp		; check that msp(=pcm driver) exist
	jc	error_0005

	mov	dx,cs
	mov	ds,dx
	call	play_pcm
	mov	ax,4c00h		; exit to dos
	int	21h


error_0002:
	mov	ax,0002
	jmp	error_main


error_0004:
	mov	ax,0004
	jmp	error_main


error_0005:
	mov	ax,0005
	jmp	error_main


usage:	mov	dx,offset mes_usa	; usage
	jmp	exit
start		endp
;-----------------------------------------------------------------------------
exit		proc	near
;
;	exit
;
	mov	ah,09h
	int	21h
	mov	ax,04c01h		; error exit
	int	21h
exit		endp
;-----------------------------------------------------------------------------
get_dec		proc	near
;
;	get dec
;
;(out)	carry = 0 : ok
;	dx:ax = number
;
;	carry =	1 : error
;
	push	bx
	push	cx
	push	di
	xor	dx,dx
	xor	ax,ax
	xor	bl,bl			; bl = flag
get_dec_loop:
	mov	bh,ds:[si]
	cmp	bh,cr
	JE	get_dec_exit
	sub	bh,"0"			; ic case number
	jc	get_dec_exit
	cmp	bh,9
	ja	get_dec_exit
	inc	si
	mov	bl,1			; bl = flag ( 1 = on )


	sal	ax,1			; dx:ax = dx:ax * 10
	rcl	dx,1
	jc	get_dec_overflow
	mov	cx,ax
	mov	di,dx
	sal	ax,1
	rcl	dx,1
	jc	get_dec_overflow
	sal	ax,1
	rcl	dx,1
	jc	get_dec_overflow
	add	ax,cx
	add	dx,di
	jc	get_dec_overflow


	xor	cx,cx			; dx:ax = dx:ax + bh
	mov	cl,bh
	add	ax,cx
	jnc	get_dec_next
	add	dx,1
	jc	get_dec_overflow
get_dec_next:


	mov	cx,dx
	jmp	get_dec_loop
get_dec_exit:
	sub	bl,1			; carry = 0
	pop	di
	pop	cx
	pop	bx
	ret

get_dec_overflow:
	pop	di
	pop	cx
	pop	bx
	stc
	ret

get_dec		endp
;------------------------------------------------------------------------------
error_main		proc	near
;
;	error main
;
;(in)	ax = error code
;
	mov	bx,offset mes_err_tbl
error_main_loop0:
	cmp	[bx],ax
	je	error_main_ok
	add	bx,4
	cmp	bx,offset mes_err_end
	jb	error_main_loop0
	mov	dx,offset mes_err0001
	jmp	error_main_exit
error_main_ok:
	mov	dx,[bx+2]
error_main_exit:
	jmp	exit
error_main		endp
;------------------------------------------------------------------------------
set_filename	proc	near
;
;	t@C͂ĐU蕪
;
;(in)	[FileName] = filename ( asciizero )
;
	push	ax
	push	cx
	push	si
	mov	si,offset FileName
	cmp	byte ptr ds:[si],0
	je	set_filename_error
set_filename_loop0:
	lodsb
	or	al,al
	je	set_filename_none	; gq̎w肪Ƃ .wav
	cmp	al,"."
	jne	set_filename_loop0

	;
	;	gq]
	;
	mov	di,offset FileExt
set_filename_loop1:
	lodsb
	call	set_filename_sub
	stosb
	or	al,al
	jne	set_filename_loop1

	;
	;	gq`FbN
	;
	mov	si,offset FileExt	; .wav 
	mov	cx,offset file_wav_ext_end - offset file_wav_ext
	mov	di,offset file_wav_ext
	repe	cmpsb
	jz	set_filename_wav

	mov	si,offset FileExt	; .phl 
	mov	cx,offset file_phl_ext_end - offset file_phl_ext
	mov	di,offset file_phl_ext
	repe	cmpsb
	jz	set_filename_phl

	mov	si,offset FileExt	; .pc8 
	mov	cx,offset file_pc8_ext_end - offset file_pc8_ext
	mov	di,offset file_pc8_ext
	repe	cmpsb
	jz	set_filename_pc8

	mov	si,offset FileExt	; .spb 
	mov	cx,offset file_spb_ext_end - offset file_spb_ext
	mov	di,offset file_spb_ext
	repe	cmpsb
	jz	set_filename_spb

	mov	si,offset FileExt	; .spc 
	mov	cx,offset file_spc_ext_end - offset file_spc_ext
	mov	di,offset file_spc_ext
	repe	cmpsb
	jz	set_filename_spc

	mov	si,offset FileExt	; .p16 
	mov	cx,offset file_p16_ext_end - offset file_p16_ext
	mov	di,offset file_p16_ext
	repe	cmpsb
	jz	set_filename_p16

set_filename_error:
	mov	ax,0003
	jmp	error_main

set_filename_exit:
	pop	si
	pop	cx
	pop	ax
	ret


	;
	;	gq̎w肪Ƃ .wav
	;
set_filename_none:
	mov	di,si			; gq .wav ]
	mov	byte ptr es:[di-1],"."
	mov	si,offset file_wav_ext
	mov	cx,offset file_wav_ext_end - offset file_wav_ext
	rep	movsb


	;
	;	.wav
	;
set_filename_wav:
	mov	[file_type],0
	jmp	set_filename_exit


	;
	;	.phl
	;
set_filename_phl:
	or	[pcm_type],00000011b
	mov	[file_type],1
	cmp	[pcm_freq],0			; freq w肩
	jne	set_filename_exit
	mov	[pcm_freq],22050		; default = 22050
	jmp	set_filename_exit


	;
	;	.pc8
	;
set_filename_pc8:
	or	[pcm_type],00000010b
	mov	[file_type],2
	cmp	[pcm_freq],0			; freq w肩
	jne	set_filename_exit
	mov	[pcm_freq],22050		; default = 22050
	jmp	set_filename_exit


	;
	;	.spb
	;
set_filename_spb:
	or	[pcm_type],01000001b
	mov	[file_type],3
	cmp	[pcm_freq],0			; freq w肩
	jne	set_filename_exit
	mov	[pcm_freq],16000		; default = 16000
	jmp	set_filename_exit


	;
	;	.spc
	;
set_filename_spc:
	or	[pcm_type],00000001b
	mov	[file_type],4
	cmp	[pcm_freq],0			; freq w肩
	jne	set_filename_exit
	mov	[pcm_freq],16000		; default = 16000
	jmp	set_filename_exit


	;
	;	.p16
	;
set_filename_p16:
	or	[pcm_type],00000011b
	mov	[file_type],5
	cmp	[pcm_freq],0			; freq w肩
	jne	set_filename_exit
	mov	[pcm_freq],22050		; default = 22050
	jmp	set_filename_exit


set_filename_sub:
;
;	̏ꍇA啶ɂBȊOȂe
;
;(in)	al = ank moji
;
;(out)	al = ank moji
;
	cmp	al,"a"
	jb	set_filename_sub_next0
	cmp	al,"z"
	ja	set_filename_sub_next0
	sub	al,"a"-"A"
set_filename_sub_next0:
	ret


set_filename	endp
;==============================================================================
;==============================================================================
;	pcm program
;==============================================================================
;==============================================================================
check_msp	proc	near
;
;	msp 풓Ă邩
;
;(out)	carry = off : msp 풓Ă
;	carry = on  : msp 풓ĂȂ
;
	pusha
	push	ds
	push	es
	MOV	AX,3500H+vec_msp	;荞݃xN^[E
	INT	21H			;drFaw荞݃xN^[
	mov	di,bx
	inc	di
	inc	di
	MOV	SI,CS
	MOV	DS,SI
	MOV	SI,OFFSET msp_tsrid	;crFrhNvOAhX
	MOV	CX,7
	REPE	CMPSB			; ؏풓
	pop	es
	pop	ds
	popa
	jne	check_msp_error
	clc
	RET
check_msp_error:
	stc
	ret

msp_TSRID	db	'PCMmiho'
check_msp	endp
;------------------------------------------------------------------------------
play_pcm	proc	near
;
;	pcm play
;
	pusha
	push	es

	mov	ah,01h			; stop pcm
	int	vec_msp


	;
	;	.msp file  load
	;
	mov	dx,offset mes_pcm
	mov	ah,09h
	int	21h
	mov	di,offset FileName
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf

	call	read_pcm
	jc	error_5000
;;;make	[bit] [pcm/adpcm] [freq],[pan],[volume] ̕\DDD̂˂


	;
	;	soubd pcm
	;
	mov	al,0
	mov	ah,02h
	mov	bl,[play_volume]
	mov	bh,[play_pan]
	int	vec_msp


	pop	es
	popa
	clc
	ret


	;
	;	.msp file read error
	;
error_5000:
	mov	ax,5000
	jmp	error_main


play_pcm	endp
;------------------------------------------------------------------------------
print_file_name		proc	near
;
;	file name \
;
;(in)	es:di = filename
;
	mov	dx,di
	xor	al,al
	mov	cx,FileNameSize
	repne	scasb
	jne	print_file_name_ret
	dec	di
	mov	byte ptr es:[di],"$"
	mov	ah,09h
	int	21h
	mov	byte ptr es:[di],0
print_file_name_ret:
	ret
print_file_name		endp
;------------------------------------------------------------------------------
print_cr_lf		proc	near
;
;	print cr lf
;
	mov	dl,cr
	mov	ah,06h
	int	21h
	mov	dl,lf
	mov	ah,06h
	int	21h
	ret
print_cr_lf		endp
;-----------------------------------------------------------------------------
;	pcm
;-----------------------------------------------------------------------------
read_pcm		proc	near
;
;	read pcm
;
;(out)	carry = off: success
;		on : error
;
	;
	;	open handle
	;
	mov	ax,3d00h			; open file
	mov	dx,offset FileName
	int	21h
	jc	error_5000
	mov	[file_handle],ax


	;
	;	.wav file
	;
	cmp	[file_type],0		; .wav ?
	jne	read_pcm_wave_exit
	mov	ah,3fh			; read .wav header
	mov	dx,offset msp_read_buffer
	mov	bx,[file_handle]
	mov	cx,size wfmt_data
	int	21h
	jc	read_pcm_error
	cmp	[msp_read_buffer.wfmt_wFormatTag],1	; type = 1:pcm `
	jne	read_pcm_error
	mov	[pcm_type],00000000b			; mono
	mov	[pcm_pan],000000b
	cmp	[msp_read_buffer.wfmt_nChannels],1
	je	read_pcm_wave_next0
	cmp	[msp_read_buffer.wfmt_nChannels],2	; streo
	jne	read_pcm_error
	mov	[pcm_type],00010000b
	mov	[pcm_pan],001000b
read_pcm_wave_next0:

	cmp	[msp_read_buffer.wfmt_nBitPerSample],8	; 8bit
	jne	read_pcm_wave_next1
	or	[pcm_type],00000010b
	jmp	read_pcm_wave_next2
read_pcm_wave_next1:
	cmp	[msp_read_buffer.wfmt_nBitPerSample],16	; 16bit
	jne	read_pcm_error
	or	[pcm_type],00000011b
read_pcm_wave_next2:

	cmp	word ptr [msp_read_buffer.wfmt_nSamplesPerSec+2],0; freq
	jne	read_pcm_error
	mov	ax,word ptr [msp_read_buffer.wfmt_nSamplesPerSec]
	mov	[pcm_freq],ax

	mov	ax,word ptr [msp_read_buffer.wfmt_pcmSize]; size
	mov	word ptr [file_size],ax
	mov	ax,word ptr [msp_read_buffer.wfmt_pcmSize+2]
	mov	word ptr [file_size+2],ax

	jmp	read_pcm_size_exit
read_pcm_wave_exit:


	;
	;	get file size
	;
	xor	cx,cx			; set end
	xor	dx,dx
	mov	bx,[file_handle]
	mov	ax,4202h
	int	21h
	jc	read_pcm_error
	mov	word ptr [file_size],ax
	mov	word ptr [file_size+2],dx
	xor	cx,cx			; set top
	xor	dx,dx
	mov	ax,4200h
	int	21h
	jc	read_pcm_error
read_pcm_size_exit:


	;
	;	emb  main memory ł check
	;
	mov	ah,00h			; get pcm version
	int	vec_msp
	cmp	bh,0
	je	read_pcm_main
	cmp	bh,1
	je	read_pcm_emb
read_pcm_error:
	stc
	ret



;
;	main memory
;
read_pcm_main:
	mov	ah,10h
	int	vec_msp
	mov	[pcm_buffer_size],cx
	mov	[pcm_buffer_handle_or_seg],es

	;
	;	size check
	;
	mov	si,word ptr [file_size]
	mov	di,word ptr [file_size+2]
	add	si,100h+10h		; .msp header AZ
	adc	di,0
	mov	ax,1024
	mul	[pcm_buffer_size]
	cmp	di,dx
	ja	read_pcm_error
	jb	read_pcm_main_next0
	cmp	si,ax
	ja	read_pcm_error
read_pcm_main_next0:

	;
	;	.msp file Ŝ header
	;
	mov	es,[pcm_buffer_handle_or_seg]
	xor	di,di
	mov	cx,100h
	mov	al,0
	cld
	rep	stosb

	;
	;	e pcm  header
	;
	mov	word ptr es:[di],100h+10h; pointer to pcm data ( 32bitjA )
	mov	word ptr es:[di+2],0
	mov	ax,word ptr [file_size]	; pcm size
	mov	word ptr es:[di+4],ax
	mov	ax,word ptr [file_size+2]
	mov	word ptr es:[di+6],ax
	mov	ax,[pcm_freq]		; pcm freq
	mov	word ptr es:[di+8],ax
	mov	al,[pcm_type]		; pcm type
	mov	byte ptr es:[di+0ah],al
	mov	al,[pcm_pan]		; pcm ch pan
	mov	byte ptr es:[di+0bh],al
	mov	byte ptr es:[di+0ch],255; pcm volume
	mov	byte ptr es:[di+0dh],1	; pcm priority
	mov	byte ptr es:[di+0eh],127; pcm pan

	;
	;	trans data
	;
	mov	bx,[file_handle]
	mov	dx,100h+10h		; .msp header AZ
	mov	di,[pcm_buffer_handle_or_seg]
read_pcm_main_loop0:			; read pcm file
	push	ds
	mov	ah,3fh
	mov	cx,8000h
	cmp	word ptr [file_size+2],0
	ja	read_pcm_main_next2
	cmp	word ptr [file_size],8000h
	jae	read_pcm_main_next2
	mov	cx,word ptr [file_size]
read_pcm_main_next2:
	mov	ds,di
	int	21h
	pop	ds
	jc	read_pcm_error
	sub	word ptr [file_size],ax
	sbb	word ptr [file_size+2],0
	push	ds
	mov	ds,di
	call	convert_pcm
	pop	ds
	add	di,8000h/16
	cmp	ax,8000h
	je	read_pcm_main_loop0
read_pcm_main_next1:
	mov	ah,3eh			; close handle
	mov	bx,[file_handle]
	int	21h
	clc
	ret



;
;	emb ( Ɍ xms memory  read )
;
read_pcm_emb:
	mov	ax,4300h		; xmsdriver ̑݃`FbN
	int	2fh
	cmp	al,80h
	jne	read_pcm_error
	mov	ax,4310h		; xmsdriver ̃Gg[E
	int	2fh
	mov	word ptr [lpfn_xms],bx
	mov	word ptr [lpfn_xms+2],es

read_pcm_emb_loop1:
	mov	ah,10h			; ݎgp emb nhE
	int	vec_msp
	mov	[pcm_buffer_size],cx
	mov	[pcm_buffer_handle_or_seg],dx

	;
	;	size check
	;
	mov	si,word ptr [file_size]
	mov	di,word ptr [file_size+2]
	add	si,100h+10h		; .msp header AZ
	adc	di,0
	mov	ax,1024
	mul	[pcm_buffer_size]
	cmp	di,dx
	ja	read_pcm_emb_allocate
	jb	read_pcm_emb_next0
	cmp	si,ax
	jbe	read_pcm_emb_next0

	;
	;	allocate
	;
read_pcm_emb_allocate:
	add	si,1023
	adc	di,0
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	shr	di,1
	rcr	si,1
	or	di,di
	jne	read_pcm_error
	mov	cx,si
	mov	ah,11h
	int	vec_msp
	or	bp,bp
	jne	read_pcm_error
	jmp	read_pcm_emb_loop1
read_pcm_emb_next0:


	;
	;	.msp file Ŝ header
	;
	push	cs
	pop	es
	mov	di,offset msp_read_buffer
	mov	cx,100h
	mov	al,0
	cld
	rep	stosb

	;
	;	e pcm  header
	;
	mov	word ptr es:[di],100h+10h; pointer to pcm data ( 32bitjA )
	mov	word ptr es:[di+2],0
	mov	ax,word ptr [file_size]	; pcm size
	mov	word ptr es:[di+4],ax
	mov	ax,word ptr [file_size+2]
	mov	word ptr es:[di+6],ax
	mov	ax,[pcm_freq]		; pcm freq
	mov	word ptr es:[di+8],ax
	mov	al,[pcm_type]		; pcm type
	mov	byte ptr es:[di+0ah],al
	mov	al,[pcm_pan]		; pcm ch pan
	mov	byte ptr es:[di+0bh],al
	mov	byte ptr es:[di+0ch],255; pcm volume
	mov	byte ptr es:[di+0dh],1	; pcm priority
	mov	byte ptr es:[di+0eh],127; pcm pan

	;
	;	header ]
	;
	mov	word ptr [movelength],100h+10h
	mov	word ptr [movelength+2],0

	mov	[sourcehandle],0
	mov	word ptr [sourceoffset],offset msp_read_buffer
	mov	word ptr [sourceoffset+2],cs

	mov	ax,[pcm_buffer_handle_or_seg]
	mov	[desthandle],ax
	mov	word ptr [destoffset],0
	mov	word ptr [destoffset+2],0

	mov	ah,0bh			; move emb memory
	mov	si,offset movelength
	call	[lpfn_xms]
	cmp	ax,0
	je	read_pcm_error


	;
	;	trans data
	;
	mov	di,100h+10h		; .msp header AZ
	xor	bp,bp
read_pcm_emb_loop0:
	mov	ah,3fh
	mov	dx,offset msp_read_buffer
	mov	bx,[file_handle]
	mov	cx,msp_read_buffer_size
	cmp	word ptr [file_size+2],0
	ja	read_pcm_emb_next2
	cmp	word ptr [file_size],msp_read_buffer_size
	jae	read_pcm_emb_next2
	mov	cx,word ptr [file_size]
read_pcm_emb_next2:
	int	21h
	jc	read_pcm_error
	or	ax,ax
	je	read_pcm_emb_next1
	sub	word ptr [file_size],ax
	sbb	word ptr [file_size+2],0
	call	convert_pcm

	inc	ax
	and	ax,0fffeh
	mov	word ptr [movelength],ax
	mov	word ptr [movelength+2],0

	mov	[sourcehandle],0
	mov	word ptr [sourceoffset],offset msp_read_buffer
	mov	word ptr [sourceoffset+2],cs

	mov	ax,[pcm_buffer_handle_or_seg]
	mov	[desthandle],ax
	mov	word ptr [destoffset],di
	mov	word ptr [destoffset+2],bp

	mov	ah,0bh			; move emb memory
	mov	si,offset movelength
	call	[lpfn_xms]
	cmp	ax,0
	je	read_pcm_error
	mov	ax,word ptr [movelength]
	add	di,ax
	adc	bp,0
	cmp	ax,msp_read_buffer_size
	je	read_pcm_emb_loop0
read_pcm_emb_next1:

	mov	ah,13h			; init pcm
	int	vec_msp

	mov	ah,3eh			; close handle
	mov	bx,[file_handle]
	int	21h
	clc
	ret

read_pcm		endp
;-----------------------------------------------------------------------------
convert_pcm		proc	near
;
;	read buffer ̒ pcm ̃Ro[g
;
;	p16       -> phl
;	8bit wav  -> pc8
;	16bit wav -> phl
;
;(in)	ds:dx = pointer
;	ax    = size
;
	pusha
	push	ds
	push	es

	mov	cx,ax
	mov	bx,dx

	push	ds
	pop	es

	push	cs
	pop	ds

	cmp	[file_type],5
	je	convert_p16
	cmp	[file_type],0
	jne	convert_pcm_exit

	mov	al,[pcm_type]
	and	al,00001111b
	cmp	al,00000011b
	je	convert_wav16


	;
	;	8bit wav  -> pc8 ( signed pcm ɂ )
	;
convert_wav8_loop0:
	add	byte ptr es:[bx],80h
	inc	bx
	loop	convert_wav8_loop0
convert_pcm_exit:
	pop	es
	pop	ds
	popa
	ret


	;
	;	16bit wav -> phl ( h,l ̋t] )
	;	p16       -> phl ( h,l ̋t] )
	;
convert_wav16:
convert_p16:
	inc	cx
	shr	cx,1
convert_wav16_loop0:
	mov	ax,es:[bx]
	xchg	al,ah
	mov	es:[bx],ax
	inc	bx
	inc	bx
	loop	convert_wav16_loop0
	jmp	convert_pcm_exit


convert_pcm		endp
;==============================================================================
;==============================================================================
;	data area
;==============================================================================
;==============================================================================
if debug
	include \obj\testcom.inc
endif

mes_usa		label	byte
db "PCML v4.5a for MsDRV4.5 + pcmdriver Copyright(c)KENJI 1995.1-",CR,LF
db "usage : pcml [options...] [filename] [options...]",CR,LF
db "	/Fn		freq",cr,lf
db "	/Vn		volume ( default 255 : 0 - 255 )",cr,lf
db "	/Pn		pan ( default 127 : 0 - 255 )",cr,lf
db "	/W		streo",cr,lf
db "$"


mes_err_tbl	dw	0003,offset mes_err0003
		dw	0004,offset mes_err0004
		dw	0005,offset mes_err0005
		dw	5000,offset mes_err5000
mes_err_end	label	word


mes_err0001 db "err0001:error",cr,lf,"$"
mes_err0003 db "err0003:gqُł",cr,lf,"$"
mes_err0004 db "err0004:command line error",cr,lf,"$"
mes_err0005 db "err0005:msp ( pcm driver ) 풓Ă܂",cr,lf,"$"
mes_err5000 db "err5000:.msp file read error",cr,lf,"$"


mes_allocate	db	"pcm memory Ȃ̂ŁAmۂ܂",cr,lf,"$"
mes_pcm		db	"pcm file = $"


file_wav_ext	db	"WAV",0
file_wav_ext_end	label	byte

file_phl_ext	db	"PHL",0
file_phl_ext_end	label	byte

file_pc8_ext	db	"PC8",0
file_pc8_ext_end	label	byte

file_spb_ext	db	"SPB",0
file_spb_ext_end	label	byte

file_spc_ext	db	"SPC",0
file_spc_ext_end	label	byte


file_p16_ext	db	"P16",0
file_p16_ext_end	label	byte

FileName	db	FileNameSize dup(?)	; t@C
FileExt		db	FileNameSize dup(?)	; gq


pcm_freq	dw	0
pcm_type	db	00000000b
pcm_pan		db	000000b

play_volume	db	255
play_pan	db	127
file_type	db	?


movelength		dd	?		; move emb \
sourcehandle		dw	?		
sourceoffset		dd	?		
desthandle		dw	?		
destoffset		dd	?		


lpfn_xms		dd	?		; xms driver  entry address

file_size		dd	?		; pcm file size
file_handle		dw	?		; pcm  file handle

pcm_buffer_size		dw	?		; buffer size ( kbyte P )
pcm_buffer_handle_or_seg dw	?		; handle or segment
msp_read_buffer	db msp_read_buffer_size dup(?)	; read buffer


			dw	100h dup(?)
stack_pointer		label	word
end_program		label	byte
code	ends
	end	start
