;
;	msms_f20.com
;
;	msms track add-in filter "substisute"
;			programed by kenji
;
;=============================================================================
;=============================================================================
;	define
;=============================================================================
;=============================================================================
cr			equ	0dh
lf			equ	0ah
eof			equ	1ah
debug			equ	1
FileNameSize		equ	128
msdrv4_size		equ	4		; ߂ 4 byte 
FileNameLength		equ	128


code	segment	para	public	'code'
	assume	cs:code,ds:code,es:code,ss:code
;=============================================================================
;=============================================================================
;	PSP
;=============================================================================
;=============================================================================
	org	2ch
envseg	dw	?			;environment segment
	org	80h
argc	db	?			;size of command
argv	db	127 dup (?)		;command line


;=============================================================================
;=============================================================================
;	program
;=============================================================================
;=============================================================================
	org	100h
	.186
start		proc	near
;
;	main
;
	cld

	call	set_path

	mov	di,offset InputFileName	; 1 ڂ inputfilename

	;
	;	get option and file name
	;
	mov	si,offset argv
main_loop0:
	lodsb
	cmp	al,cr
	je	main_next0
	cmp	al,"/"
	je	main_option
	cmp	al,"-"
	je	main_option
	cmp	al," "
	jbe	main_loop0

	dec	si			; file name ̐ݒ
main_loop1:
	lodsb
	stosb
	cmp	al," "
	ja	main_loop1
	dec	di
	dec	si
	xor	al,al
	stosb
	inc	[filename_type]		; 2 ڂ outputfilename
	mov	di,offset OutputFileName
	jmp	main_loop0


	;
	;	option check
	;
main_option:
	lodsb
	cmp	al,"?"
	je	usage
	cmp	al," "
	jbe	error_0001
	and	al,11011111b		; ->啶

	cmp	al,"H"			; help
	je	usage

	cmp	al,"V"			; v Œlݒ
	jne	main_option_v_exit
	call	get_dec
	jc	error_0002
	cmp	ax,9
	jg	error_0001
	cmp	ax,0
	jl	error_0001
	mov	[value0_data],ax
	mov	[value0_flag],1
	jmp	main_loop0
main_option_v_exit:
	jmp	error_0001


	;
	;	main
	;
main_next0:
	cmp	[filename_type],2
	jne	error_0003
	call	get_value
	call	msms_filter_main
	mov	ax,4c00h		; exit to dos
	int	21h


error_0001:		; IvVُłB
	mov	ax,1
	jmp	error_exit
error_0002:		; lُłB
	mov	ax,2
	jmp	error_exit
error_0003:		; ̓t@CƏo̓t@Cw肵ĉB
	mov	ax,3
	jmp	error_exit


usage:	mov	dx,offset mes_usa	; usage
	mov	ah,09h
	int	21h
	mov	ax,04c01h		; error exit
	int	21h


start		endp
;-----------------------------------------------------------------------------
error_exit	proc	near
;
;	error exit
;
;(in)	ax = error code
;		0001	 IvVُłB
;		0002	 lُłB
;		0003	 ̓t@CƏo̓t@Cw肵ĉB
;		0004	 t@Cǂݍ߂܂B
;		0005	 t@C߂܂B
;		0006	 msms.exe ̉ŎsĉB
;		0007	 l͂̓rŏI
;
	dec	ax
	sal	ax,2
	mov	bx,ax

	push	bx
	call	check_kenji_window
	pop	bx
	jnc	error_exit_next1

	mov	dx,[bx+error_data]
	cmp	dx,0
	je	error_exit_next2
	mov	ah,09h
	int	21h
error_exit_next0:
	mov	ax,04c01h		; error exit
	int	21h


error_exit_next1:
	;
	;	open error box
	;
	;
	;(in)	al    = 11h
	;	bl    = window x
	;	bh    = window y
	;	ds:si = moji pointer
	;
	mov	si,[bx+error_data+2]	; error message
	cmp	si,0
	je	error_exit_next2
	mov	al,11h			; open error box
	mov	bl,14			; x
	mov	bh,11			; y
	mov	ah,[int2fh_number]	; int2fh number
	int	2fh
error_exit_next2:
	mov	ax,04cffh		; error exit
	int	21h			; ( msms.exe  error message \
					;   Ȃ悤ɂ邽߂ɁAerror 
					;   code 255 ŏI                  )

error_exit	endp
;-----------------------------------------------------------------------------
get_dec		proc	near
;
;	get dec
;
;(out)	carry = 0 : ok
;			ax = number
;
;	carry =	1 : error
;
	push	bx
	push	cx
	push	di

	mov	bl,0			; plus / minus
	cmp	byte ptr ds:[si],"+"
	jne	get_dec_next0
	inc	si
get_dec_next0:
	cmp	byte ptr ds:[si],"-"
	jne	get_dec_next1
	inc	si
	mov	bl,1
get_dec_next1:
	push	bx

	xor	dx,dx
	xor	ax,ax
	xor	bl,bl			; bl = flag
get_dec_loop:
	mov	bh,ds:[si]
	cmp	bh,cr
	JE	get_dec_exit
	sub	bh,"0"			; ic case number
	jc	get_dec_exit
	cmp	bh,9
	ja	get_dec_exit
	inc	si
	mov	bl,1			; bl = flag ( 1 = on )


	sal	ax,1			; dx:ax = dx:ax * 10
	jc	get_dec_overflow0
	mov	cx,ax
	sal	ax,1
	jc	get_dec_overflow0
	sal	ax,1
	jc	get_dec_overflow0
	add	ax,cx
	jc	get_dec_overflow0


	xor	cx,cx			; dx:ax = dx:ax + bh
	mov	cl,bh
	add	ax,cx
	jc	get_dec_overflow0

	jmp	get_dec_loop

get_dec_exit:
	sub	bl,1			; carry = 0
	jc	get_dec_overflow0

	pop	bx
	cmp	bl,0
	je	get_dec_plus0
	cmp	ax,8001h		; check 8001h
	jae	get_dec_overflow1
	neg	ax
	jmp	get_dec_minus

get_dec_plus0:
	cmp	ax,8000h		; check 8000h
	jae	get_dec_overflow1
get_dec_minus:
	clc
get_dec_exit0:
	pop	di
	pop	cx
	pop	bx
	ret

get_dec_overflow0:
	pop	bx
get_dec_overflow1:
	stc
	jmp	get_dec_exit0

get_dec		endp
;-----------------------------------------------------------------------------
msms_filter_main	proc	near
;
;	filter s
;
	call	read_def_file

	;
	;	open handle
	;
	mov	dx,offset InputFileName
	mov	ax,3d00h
	int	21h
	jc	filter_err_read
	mov	[read_handle],ax

	;
	;	create handle
	;
	mov	dx,offset OutputFileName
	mov	ah,3ch
	xor	cx,cx
	int	21h
	jc	filter_err_write
	mov	[write_handle],ax


msms_filter_main_loop:

	;
	;	read .ms data
	;
	mov	ah,3fh
	mov	bx,[read_handle]
	mov	cx,msdrv4_size		; ߂ 4 byte 
	mov	dx,offset msdrv4_buffer
	int	21h
	jc	filter_err_read
	or	ax,ax			; eof ?
	je	msms_filter_main_exit

	;
	;	tB^[|
	;
	call	msms_filter_convert
	jmp	msms_filter_main_loop


msms_filter_main_exit:
	;
	;	close handle
	;
	call	filter_close_handle
	ret


	;
	;	error
	;
filter_err_read:
	call	filter_close_handle
	mov	ax,4			; error_code
	jmp	error_exit
filter_err_write:
	call	filter_close_handle
	mov	ax,5			; error_code
	jmp	error_exit


	;
	;	close handle
	;
filter_close_handle:
	mov	bx,[write_handle]
	cmp	bx,0
	je	filter_close_handle_next0
	call	close_handle
filter_close_handle_next0:
	mov	bx,[read_handle]
	cmp	bx,0
	je	filter_close_handle_next1
	call	close_handle
filter_close_handle_next1:
	ret


msms_filter_main	endp
;-----------------------------------------------------------------------------
read_def_file		proc	near
;
;	read def file
;
	;
	;	pX]
	;
	push	cs
	pop	es
	mov	di,offset filename
	mov	si,offset msms_f20_path
#loop0:	lodsb
	or	al,al
	je	#next0
	stosb
	jmp	#loop0
#next0:


	;
	;	t@C]
	;
	mov	si,[value0_data]
	sal	si,1
	mov	si,ds:[def_tbl+si]
#loop1:	lodsb
	stosb
	or	al,al
	jne	#loop1


	;
	;	open handle
	;
	mov	dx,offset filename
	mov	ax,3d00h
	int	21h
	jc	#error1
	mov	bx,ax


	;
	;	read handle
	;
	mov	dx,offset def_buffer
	mov	cx,size def_buffer
	mov	ah,3fh
	int	21h
	pushf
	push	ax
	call	close_handle
	pop	ax
	popf
	jc	#error0


	;
	;	eof ̕t
	;
	mov	bx,ax
	mov	byte ptr [def_buffer+bx],eof

	ret


#error0:call	close_handle
#error1:mov	ax,8			; error_code
	jmp	error_exit
read_def_file		endp
;-----------------------------------------------------------------------------
msms_filter_convert	proc	near
;
;	tB^[|
;
	call	search_from_def
	jnc	#next0

	;
	;	write .ms data
	;
	mov	ah,40h
	mov	bx,[write_handle]
	mov	cx,4
	mov	dx,offset msdrv4_buffer
	int	21h
	jc	filter_err_write
	ret

#next0:	call	set_from_def
	ret
msms_filter_convert	endp
;-----------------------------------------------------------------------------
search_from_def		proc	near
;
;	Yl .def T
;
	mov	si,offset def_buffer
#loop0:	lodsb
	cmp	al,eof
	je	#not
	cmp	al,"#"
	je	#check

	;
	;	̍s
	;
#loop1:	lodsb
	cmp	al,eof
	je	#not

	cmp	al,cr
	jne	#next1
	lodsb
	cmp	al,lf
	je	#loop0
	dec	si
	jmp	#loop0
#next1:

	cmp	al,lf
	jne	#next2
	lodsb
	cmp	al,cr
	je	#loop0
	dec	si
	jmp	#loop0
#next2:

	jmp	#loop1


	;
	;	check
	;
#check:	call	#get_data
	jc	#loop1
	cmp	ax,-1
	je	#check0
	cmp	[msdrv4_buffer+0],al
	jne	#loop1
#check0:call	#get_data
	jc	#loop1
	cmp	ax,-1
	je	#check1
	cmp	[msdrv4_buffer+1],al
	jne	#loop1
#check1:call	#get_data
	jc	#loop1
	cmp	ax,-1
	je	#check2
	cmp	[msdrv4_buffer+2],al
	jne	#loop1
#check2:call	#get_data
	jc	#loop1
	cmp	ax,-1
	je	#check3
	cmp	[msdrv4_buffer+3],al
	jne	#loop1
#check3:clc
	ret


#not:	stc
	ret


#get_data:
;
;	get data
;
	mov	ax,-1

	mov	bl,ds:[si]		; first
	cmp	bl,":"
	je	#get_data_ret
	cmp	bl,"0"
	jb	#get_data_not
	cmp	bl,"9"
	ja	#get_data_next0
	sub	bl,"0"
	jmp	#get_data_next1
#get_data_next0:
	and	bl,11011111b
	cmp	bl,"A"
	jb	#get_data_next0
	cmp	bl,"F"
	ja	#get_data_next0
	sub	bl,"A"-10
#get_data_next1:
	xor	ah,ah
	mov	al,bl
	inc	si


	mov	bl,ds:[si]		; first
	cmp	bl,":"
	je	#get_data_ret
	cmp	bl,"0"
	jb	#get_data_not
	cmp	bl,"9"
	ja	#get_data_next2
	sub	bl,"0"
	jmp	#get_data_next3
#get_data_next2:
	and	bl,11011111b
	cmp	bl,"A"
	jb	#get_data_next2
	cmp	bl,"F"
	ja	#get_data_next2
	sub	bl,"A"-10
#get_data_next3:
	xor	ah,ah
	sal	al,4
	or	al,bl
	inc	si

#get_data_ret:
	cmp	byte ptr ds:[si],":"
	jne	#get_data_exit
	inc	si
#get_data_exit:
	clc
	ret

#get_data_not:
	stc
	ret


search_from_def		endp
;-----------------------------------------------------------------------------
set_from_def		proc	near
;
;	set from def
;
	;
	;	search number
	;
#loop0:	lodsb
	cmp	al,","
	je	#loop0
	cmp	al," "
	je	#loop0
	cmp	al,"	"
	je	#loop0
	cmp	al,"\"
	je	#number
	cmp	al,"0"
	jb	#ret
	cmp	al,"9"
	jbe	#next1
	and	al,11011111b
	cmp	al,"A"
	jb	#ret
	cmp	al,"F"
	ja	#ret
#next1:	dec	si

	;
	;	get number
	;
	lodsb
	cmp	al,"0"
	jb	#ret
	cmp	al,"9"
	ja	#get_data_next0
	sub	al,"0"
	jmp	#get_data_next1
#get_data_next0:
	and	al,11011111b
	cmp	al,"A"
	jb	#get_data_next1
	cmp	al,"F"
	ja	#get_data_next1
	sub	al,"A"-10
#get_data_next1:
	sal	al,4
	mov	bl,al


	lodsb
	cmp	al,"0"
	jb	#ret
	cmp	al,"9"
	ja	#get_data_next2
	sub	al,"0"
	jmp	#get_data_next3
#get_data_next2:
	and	al,11011111b
	cmp	al,"A"
	jb	#get_data_next2
	cmp	al,"F"
	ja	#get_data_next2
	sub	al,"A"-10
#get_data_next3:
	or	bl,al
	mov	[msdrv4_buffer2],bl


	;
	;	write .ms data
	;
#write:	mov	ah,40h
	mov	bx,[write_handle]
	mov	cx,1
	mov	dx,offset msdrv4_buffer2
	int	21h
	jc	filter_err_write

	jmp	#loop0


#number:lodsb
	cmp	al,"0"
	jb	#ret
	cmp	al,"3"
	ja	#ret
	sub	al,"0"
	xor	bh,bh
	mov	bl,al
	mov	al,[msdrv4_buffer+bx]
	mov	[msdrv4_buffer2],al
	jmp	#write


#ret:	ret
set_from_def		endp
;-----------------------------------------------------------------------------
close_handle		proc	near
;
;	close handle
;
	mov	ah,3eh
	int	21h
	ret
close_handle		endp
;-----------------------------------------------------------------------------
get_value		proc	near
;
;	get value
;
	cmp	[value0_flag],1
	je	get_value_ret

	call	check_kenji_window
	mov	ax,6
	jc	error_exit

	;
	;	select string ( pop text Ȃ̂Œ )
	;
	;(in)	al    = 13h
	;	bl    = x
	;	bh    = y
	;	ds:si = strings
	;	cl    = ݂̑I
	;
	;(out)	bl    = x
	;	bh    = y
	;	cl    = selected ( -1 = [esc] )
	;
	mov	al,13h			; select string
	mov	bl,30			; x
	mov	bh,6			; y
	mov	si,offset msms_value0	; string
	mov	cl,0			; ݂̑I
	mov	ah,[int2fh_number]	; int2fh number
	int	2fh

	;
	;	pop text
	;
	;(in)	al    = 12h
	;
	push	cx
	mov	al,12h			; pop text
	mov	ah,[int2fh_number]	; int2fh number
	int	2fh
	pop	cx

	cmp	cl,-1			; cl = -1 then [esc]
	jne	get_value_next0
	mov	ax,7
	jmp	error_exit

get_value_next0:
	mov	[value0_flag],1
	xor	ch,ch
	mov	[value0_data],cx

get_value_ret:
	ret
get_value		endp
;-----------------------------------------------------------------------------
check_kenji_window	proc	near
;
;	kenji window ς݂H
;
;(out)	carry = off: kenji window ς
;	[int2fh_number] = int2fh ĂԂƂ ah ֓ԍ
;
;	carry = on : kenji window 񓱓
;
	pusha
	push	ds
	push	es
	;
	;	check 0c0h ` 0ffh
	;
	mov	ah,0c0h
check_kenji_window_loop0:
	push	ax
	mov	al,00h
	int	2fh
	inc	al			; if al = 0ffh then zero = on
	pop	ax
	jne	check_kenji_window_next

	mov	si,offset kenji_windiw_id
	mov	cx,16
	cld
	repz	cmpsb
	je	check_kenji_window_found

check_kenji_window_next:
	inc	ah
	jne	check_kenji_window_loop0

	stc
	jmp	check_kenji_window_exit

check_kenji_window_found:
	mov	[int2fh_number],ah
	clc

check_kenji_window_exit:
	pop	es
	pop	ds
	popa
	ret
check_kenji_window	endp
;-----------------------------------------------------------------------------
set_path		proc	near
;
;	set msms_f20 path
;
	push	ds
	push	es

	mov	es,cs:[2ch]		; ϐ̃AhXE
	xor	ax,ax
	xor	di,di
#loop0:	inc	di			; 2 byte zero ꏊT
	cmp	es:[di-1],ax
	jne	#loop0
	inc	di
	cmp	word ptr es:[di],0001h
	jne	#exit
	inc	di
	inc	di
	mov	ax,es
	mov	ds,ax
	mov	si,di

	;
	;	write kc.com's path
	;
	push	cs
	pop	es
	mov	di,offset msms_f20_path
	mov	bx,di
#loop1:	lodsb
	stosb
	cmp	al,"\"
	jne	#next1
	mov	bx,di			; bx = Ō "\" ̎̕w
#next1:	or	al,al
	jne	#loop1
	mov	byte ptr es:[bx],0	; "\" ̎ 0 
#exit:	pop	es
	pop	ds
	ret
set_path		endp


;==============================================================================
;==============================================================================
;	debug
;==============================================================================
;==============================================================================
if debug
	include \obj\testcom.inc
endif


;==============================================================================
;==============================================================================
;	const
;==============================================================================
;==============================================================================
mes_usa		label	byte
db "msms_f20 v4.5a : substisute for msms.exe v4.5 Copyright(c)KENJI 1995.1-",CR,LF
db "usage : msms_f20 inputfilename outputfilename",CR,LF
db "$"
kenji_windiw_id	db	"KenjiWindowV2.0",0


msms_value0	db	"select def you use for changing",0
		db	"[0] no.0  def ( msmsf200.def ) ",0
		db	"[1] no.1  def ( msmsf201.def ) ",0
		db	"[2] no.2  def ( msmsf202.def ) ",0
		db	"[3] no.3  def ( msmsf203.def ) ",0
		db	"[4] no.4  def ( msmsf204.def ) ",0
		db	"[5] no.5  def ( msmsf205.def ) ",0
		db	"[6] no.6  def ( msmsf206.def ) ",0
		db	"[7] no.7  def ( msmsf207.def ) ",0
		db	"[8] no.8  def ( msmsf208.def ) ",0
		db	"[9] no.9  def ( msmsf209.def ) ",0,0


def_tbl		dw	def_name0
		dw	def_name1
		dw	def_name2
		dw	def_name3
		dw	def_name4
		dw	def_name5
		dw	def_name6
		dw	def_name7
		dw	def_name8
		dw	def_name9
def_name0	db	"msmsf200.def",0
def_name1	db	"msmsf201.def",0
def_name2	db	"msmsf202.def",0
def_name3	db	"msmsf203.def",0
def_name4	db	"msmsf204.def",0
def_name5	db	"msmsf205.def",0
def_name6	db	"msmsf206.def",0
def_name7	db	"msmsf207.def",0
def_name8	db	"msmsf208.def",0
def_name9	db	"msmsf209.def",0


error_data	dw	dos_err_mes1,kwin_err_mes1
		dw	dos_err_mes2,kwin_err_mes2
		dw	dos_err_mes3,kwin_err_mes3
		dw	dos_err_mes4,kwin_err_mes4
		dw	dos_err_mes5,kwin_err_mes5
		dw	dos_err_mes6,kwin_err_mes6
		dw	dos_err_mes7,kwin_err_mes7
		dw	dos_err_mes8,kwin_err_mes8

dos_err_mes1  db "err0001:IvVُł",cr,lf,"$"
kwin_err_mes1 db "msms_f20.com err01:tB^[G[@@@@@@@",0
	      db "IvVُł",0,0
dos_err_mes2  db "err02:lُł",cr,lf,"$"
kwin_err_mes2 db "msms_f20.com err02:tB^[G[@@@@@@@",0
	      db "lُł",0,0
dos_err_mes3  db "err03:̓t@CƏo̓t@Cw肵ĉ",cr,lf,"$"
kwin_err_mes3 db "msms_f20.com err03:tB^[G[@@@@@@@",0
	      db "̓t@CƏo̓t@Cw肵ĉ",0,0
dos_err_mes4  db "err04:t@Cǂݍ߂܂",cr,lf,"$"
kwin_err_mes4 db "msms_f20.com err04:tB^[G[@@@@@@@",0
	      db "t@Cǂݍ߂܂",0,0
dos_err_mes5  db "err05:t@C߂܂",cr,lf,"$"
kwin_err_mes5 db "msms_f20.com err05:tB^[G[@@@@@@@",0
	      db "t@C߂܂",0,0
dos_err_mes6  db "err06:msms.exe ̉Ŏsĉ",cr,lf,"$"
kwin_err_mes6 db "msms_f20.com err06:tB^[G[@@@@@@@",0
	      db "msms.exe ̉Ŏsĉ",0,0
dos_err_mes7  db "err07:l͂̓rŏI܂",cr,lf,"$"
kwin_err_mes7 db "msms_f20.com err07:tB^[G[@@@@@@@",0
	      db "l͂̓rŏI܂",0,0
dos_err_mes8  db "err08:.def t@Cǂݍ߂܂",cr,lf,"$"
kwin_err_mes8 db "msms_f20.com err08:tB^[G[@@@@@@@",0
	      db ".def t@Cǂݍ߂܂",0,0

;==============================================================================
;==============================================================================
;	bss
;==============================================================================
;==============================================================================
InputFileName	db	FileNameSize dup(?)
OutputFileName	db	FileNameSize dup(?)
filename	db	FileNameSize dup(?)

int2fh_number	db	?			; int2fh ĂԂƂ ah ̔ԍ

write_size	dw	?			; PxɏރTCY
msdrv4_buffer	db	msdrv4_size dup(?)	; ϊobt@[
msdrv4_buffer2	db	?			; ϊobt@[
def_buffer	db	16*1024 dup(?)


;==============================================================================
;==============================================================================
;	data
;==============================================================================
;==============================================================================
filename_type	db	0			; ɏEt@C̎
						;   0 = InputFileName
						;   1 = OutputFileName

value0_data	dw	?			; value0 ( t )
value0_flag	db	0			; value0 R}hCŐ
						; 肵
						;   0 = ݒ肵ĂȂ
						;   1 = R}hCŐݒ

read_handle	dw	0			; ǂݍ hendle
write_handle	dw	0			;  hendle


msms_f20_path	db FileNameLength DUP(0); tmp t@C̃pX

code	ends
	end	start
