;
;	MSP.COM
;
;	music player for msdrv4.exe (fm/midi driver)
;		programed by kenji
;
;[tasm ver6.0]
;tasm /jJUMPS /m4 msp;
;tlink /t msp.obj,msp.com
;
;[optasm]
;optasm msp;
;optlink msp.exe msp.com;
;
;[masm ver6.0]
;ml /AT msms_f00.asm
;
;AZu̒
;΋ -128 ` 127 ͈͊ÕWvgpĂ܂BLȊÕAZu
;gpꍇ͋CtĉB
;
;=============================================================================
;=============================================================================
;	define
;=============================================================================
;=============================================================================
vec_msdrv	equ	61h		; fm/midi xN^[ԍ
vec_msp		equ	63h		; pcm 䊄荞݃xN^[ԍ


debug		equ	1
cr		equ	0dh
lf		equ	0ah
ssg_buffer_size	equ	256*(16+12)
opn_buffer_size	equ	256*(48+12)

FileNameSize	equ	128
msp_read_buffer_size equ 1024


code	segment
	assume cs:code,ds:code
	.186
;=============================================================================
;=============================================================================
;	PSP
;=============================================================================
;=============================================================================
	org	2ch
envseg	dw	?			;environment segment
	org	80h
argc	db	?			;size of command
argv	db	127 dup (?)		;command line


;=============================================================================
;=============================================================================
;	program
;=============================================================================
;=============================================================================
start		proc	near
;
;	main
;
	cld
	mov	[flag_ms],0
	mov	[flag_ssg],0
	mov	[flag_opn],0
	mov	[flag_se],0
	mov	[flag_sef],0
	mov	[play_flag],0
	mov	[stop_flag],0
	mov	[fadein_flag],0
	mov	[fadeout_flag],0
	mov	[effect_flag],0
	mov	[midia_volume_flag],0
	mov	[midib_volume_flag],0
	mov	[ssg_volume_flag],0
	mov	[opn_volume_flag],0
	mov	[rhy_volume_flag],0
	mov	[opl_volume_flag],0
	mov	[set_midia_flag],0
	mov	[set_midib_flag],0
	mov	[set_118_mode_flag],0
	mov	[set_irq_number_flag],0
	mov	[pcm_flag],0
	mov	[flag_msp],0

	;
	;	get option and file name
	;
	mov	si,offset argv
main_loop0:
	lodsb
	cmp	al,cr
	je	main_next0
	cmp	al,"/"
	je	main_option
	cmp	al,"-"
	je	main_option
	cmp	al," "
	jbe	main_loop0

	mov	di,offset FileName
	dec	si
main_loop1:
	lodsb
	stosb
	cmp	al," "
	ja	main_loop1
	dec	di
	dec	si
	xor	al,al
	stosb
	call	set_filename
	jmp	main_loop0


	;
	;	option check
	;
main_option:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"P"
	je	main_option_p
	cmp	al,"S"
	je	main_option_s
	cmp	al,"F"
	je	main_option_f
	cmp	al,"V"
	je	main_option_v
	cmp	al,"E"
	je	main_option_e
	cmp	al,"C"
	je	main_option_c
	cmp	al,"M"
	je	main_option_m
	cmp	al,"N"
	je	main_option_n
	cmp	al,"A"
	je	main_option_a
	jmp	error_0004


	;
	;	play
	;
main_option_p:
	mov	[play_flag],1
	jmp	main_loop0


	;
	;	stop
	;
main_option_s:
	mov	[stop_flag],1
	jmp	main_loop0


	;
	;	fade-in / fade-out
	;
main_option_f:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"I"
	je	main_option_fi
	cmp	al,"O"
	je	main_option_fo
	jmp	error_0004


	;
	;	fade-in
	;
main_option_fi:
	mov	[fadein_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	mov	[fadein_data],ax
	jmp	main_loop0


	;
	;	fade-out
	;
main_option_fo:
	mov	[fadeout_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	mov	[fadeout_data],ax
	jmp	main_loop0


main_option_e:
	mov	[effect_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	mov	[effect_data],ax
	jmp	main_loop0


main_option_c:
	mov	[pcm_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	or	ah,ah
	jne	error_0004
	mov	[pcm_data],al
	mov	[pcm_volume],255
	mov	[pcm_pan],128
	cmp	byte ptr ds:[si],","	; volume
	jne	main_option_c_exit
	inc	si
	call	get_dec
	jc	error_0004
	cmp	ax,255
	ja	error_0004
	mov	[pcm_volume],al
	cmp	byte ptr ds:[si],","	; pan
	jne	main_option_c_exit
	inc	si
	call	get_dec
	jc	error_0004
	cmp	ax,255
	ja	error_0004
	mov	[pcm_pan],al
main_option_c_exit:
	jmp	main_loop0


	;
	;	volume
	;
main_option_v:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"A"
	je	main_option_va
	cmp	al,"B"
	je	main_option_vb
	cmp	al,"S"
	je	main_option_vs
	cmp	al,"O"
	je	main_option_vo
	cmp	al,"R"
	je	main_option_vr
	cmp	al,"L"
	je	main_option_vl
	jmp	error_0004


	;
	;	midi-a volume
	;
main_option_va:
	mov	[midia_volume_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,127
	ja	error_0004
	mov	[midia_volume_data],al
	jmp	main_loop0


	;
	;	midi-b volume
	;
main_option_vb:
	mov	[midib_volume_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,127
	ja	error_0004
	mov	[midib_volume_data],al
	jmp	main_loop0


	;
	;	ssg volume
	;
main_option_vs:
	mov	[ssg_volume_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,127
	ja	error_0004
	mov	[ssg_volume_data],al
	jmp	main_loop0


	;
	;	opn volume
	;
main_option_vo:
	mov	[opn_volume_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,127
	ja	error_0004
	mov	[opn_volume_data],al
	jmp	main_loop0


	;
	;	rhy volume
	;
main_option_vr:
	mov	[rhy_volume_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,127
	ja	error_0004
	mov	[rhy_volume_data],al
	jmp	main_loop0


	;
	;	opl volume
	;
main_option_vl:
	mov	[opl_volume_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,127
	ja	error_0004
	mov	[opl_volume_data],al
	jmp	main_loop0


	;
	;	midi optopn
	;
main_option_m:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"A"
	je	main_option_ma
	cmp	al,"B"
	je	main_option_mb
	jmp	error_0004


main_option_ma:
	mov	[set_midia_flag],1
	call	get_dec
	jc	error_0004
	mov	[set_midia_number],ax
	mov	[set_midia_dataport],-1
	mov	[set_midia_statport],-1
	cmp	byte ptr ds:[si],","	; data port
	jne	main_option_ma_exit
	inc	si
	cmp	byte ptr ds:[si],","
	je	main_option_ma_next0
	call	get_hex
	jc	error_0004
	mov	[set_midia_dataport],ax
	cmp	byte ptr ds:[si],","	; stat port
	jne	main_option_ma_exit
main_option_ma_next0:
	inc	si
	cmp	byte ptr ds:[si]," "
	jbe	main_option_ma_exit
	call	get_hex
	jc	error_0004
	mov	[set_midia_statport],ax
main_option_ma_exit:
	jmp	main_loop0


main_option_mb:
	mov	[set_midib_flag],1
	call	get_dec
	jc	error_0004
	mov	[set_midib_number],ax
	mov	[set_midib_dataport],-1
	mov	[set_midib_statport],-1
	cmp	byte ptr ds:[si],","	; data port
	jne	main_option_mb_exit
	inc	si
	cmp	byte ptr ds:[si],","
	je	main_option_mb_next0
	call	get_hex
	jc	error_0004
	mov	[set_midib_dataport],ax
	cmp	byte ptr ds:[si],","	; stat port
	jne	main_option_mb_exit
main_option_mb_next0:
	inc	si
	cmp	byte ptr ds:[si]," "
	jbe	main_option_mb_exit
	call	get_hex
	jc	error_0004
	mov	[set_midib_statport],ax
main_option_mb_exit:
	jmp	main_loop0


	;
	;	nec118
	;
main_option_n:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"M"
	je	main_option_nm
	jmp	error_0004


	;
	;	set 118 mode
	;
main_option_nm:
	mov	[set_118_mode_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	cmp	ax,1
	ja	error_0004
	mov	[set_118_mode_data],al
	jmp	main_loop0


	;
	;	system
	;
main_option_a:
	lodsb
	cmp	al," "
	jbe	error_0004
	and	al,11011111b		; ->啶
	cmp	al,"I"
	je	main_option_ai
	jmp	error_0004


	;
	;	set irq number
	;
main_option_ai:
	mov	[set_irq_number_flag],1
	call	get_dec
	jc	error_0004
	or	dx,dx
	jne	error_0004
	mov	[set_irq_number_data],ax
	jmp	main_loop0


	;
	;	main
	;
main_next0:
	mov	al,[flag_ms]
	or	al,[flag_ssg]
	or	al,[flag_opn]
	or	al,[flag_se]
	or	al,[flag_sef]
	or	al,[play_flag]
	or	al,[stop_flag]
	or	al,[fadein_flag]
	or	al,[fadeout_flag]
	or	al,[effect_flag]
	or	al,[midia_volume_flag]
	or	al,[midib_volume_flag]
	or	al,[ssg_volume_flag]
	or	al,[opn_volume_flag]
	or	al,[rhy_volume_flag]
	or	al,[opl_volume_flag]
	or	al,[set_midia_flag]
	or	al,[set_midib_flag]
	or	al,[set_118_mode_flag]
	or	al,[set_irq_number_flag]
	or	al,[pcm_flag]
	or	al,[flag_msp]
	je	usage

	call	check_msdrv		; check that msdrv exist
	jc	error_0002

	cmp	[pcm_flag],0		; msp @\gꍇ msp Kv
	je	main_pcm_flag_next0
	call	check_msp		; check that msp(=pcm driver) exist
	jc	error_0005
main_pcm_flag_next0:

	cmp	[flag_msp],0		; msp @\gꍇ msp Kv
	je	main_flag_msp_next0
	call	check_msp		; check that msp(=pcm driver) exist
	jnc	main_flag_msp_next0
	cmp	[flag_msp],2
	je	error_0005
	mov	[flag_msp],0
main_flag_msp_next0:

	mov	dx,cs
	mov	ds,dx
	call	play_msdrv
	mov	ax,4c00h		; exit to dos
	int	21h


error_0002:
	mov	ax,0002
	jmp	error_main


error_0004:
	mov	ax,0004
	jmp	error_main


error_0005:
	mov	ax,0005
	jmp	error_main


usage:	mov	dx,offset mes_usa	; usage
	jmp	exit
start		endp
;-----------------------------------------------------------------------------
exit		proc	near
;
;	exit
;
	mov	ah,09h
	int	21h
	mov	ax,04c01h		; error exit
	int	21h
exit		endp
;-----------------------------------------------------------------------------
get_dec		proc	near
;
;	get dec
;
;(out)	carry = 0 : ok
;	dx:ax = number
;
;	carry =	1 : error
;
	push	bx
	push	cx
	push	di
	xor	dx,dx
	xor	ax,ax
	xor	bl,bl			; bl = flag
get_dec_loop:
	mov	bh,ds:[si]
	cmp	bh,cr
	JE	get_dec_exit
	sub	bh,"0"			; ic case number
	jc	get_dec_exit
	cmp	bh,9
	ja	get_dec_exit
	inc	si
	mov	bl,1			; bl = flag ( 1 = on )


	sal	ax,1			; dx:ax = dx:ax * 10
	rcl	dx,1
	jc	get_dec_overflow
	mov	cx,ax
	mov	di,dx
	sal	ax,1
	rcl	dx,1
	jc	get_dec_overflow
	sal	ax,1
	rcl	dx,1
	jc	get_dec_overflow
	add	ax,cx
	add	dx,di
	jc	get_dec_overflow


	xor	cx,cx			; dx:ax = dx:ax + bh
	mov	cl,bh
	add	ax,cx
	jnc	get_dec_next
	add	dx,1
	jc	get_dec_overflow
get_dec_next:


	mov	cx,dx
	jmp	get_dec_loop
get_dec_exit:
	sub	bl,1			; carry = 0
	pop	di
	pop	cx
	pop	bx
	ret

get_dec_overflow:
	pop	di
	pop	cx
	pop	bx
	stc
	ret

get_dec		endp
;-----------------------------------------------------------------------------
get_hex		proc	near
;
;	get dec
;
;(out)	carry = 0 : ok
;	ax    = number
;
;	carry =	1 : error
;	bl    = error code ( 0 = illegal number / 1 = overflow )
;
	push	bx
	xor	ax,ax
	xor	bl,bl			; bl = flag
get_hex_loop:
	mov	bh,ds:[si]
	cmp	bh,cr
	JE	get_hex_exit
	cmp	bh,"0"			; ic case number
	jb	get_hex_exit
	cmp	bh,"9"
	jbe	get_hex_set_number
	cmp	bh,"A"			; ic case number
	jb	get_hex_exit
	cmp	bh,"F"
	jbe	get_hex_set_hex
	cmp	bh,"a"			; ic case number
	jb	get_hex_exit
	cmp	bh,"f"
	ja	get_hex_exit
	and	bh,11011111b
get_hex_set_hex:
	sub	bh,"A"-"0"-10
get_hex_set_number:
	sub	bh,"0"
	inc	si
	mov	bl,1			; bl = flag ( 1 = on )
	sal	ax,4
	or	al,bh
	jmp	get_hex_loop
get_hex_exit:
	sub	bl,1			; carry = 0
	pop	bx
	ret

get_hex		endp
;------------------------------------------------------------------------------
error_main		proc	near
;
;	error main
;
;(in)	ax = error code
;
	mov	bx,offset mes_err_tbl
error_main_loop0:
	cmp	[bx],ax
	je	error_main_ok
	add	bx,4
	cmp	bx,offset mes_err_end
	jb	error_main_loop0
	mov	dx,offset mes_err0001
	jmp	error_main_exit
error_main_ok:
	mov	dx,[bx+2]
error_main_exit:
	jmp	exit
error_main		endp
;------------------------------------------------------------------------------
set_filename	proc	near
;
;	t@C͂ĐU蕪
;
;(in)	[FileName] = filename ( asciizero )
;
	push	ax
	push	cx
	push	si
	mov	si,offset FileName
	cmp	byte ptr ds:[si],0
	je	set_filename_error
set_filename_loop0:
	lodsb
	or	al,al
	je	set_filename_ms		; gq̎w肪Ƃ
	cmp	al,"."
	jne	set_filename_loop0
	mov	byte ptr ds:[si-1],0

	;
	;	gq]
	;
	mov	di,offset FileExt
set_filename_loop1:
	lodsb
	call	set_filename_sub
	stosb
	or	al,al
	jne	set_filename_loop1

	;
	;	gq`FbN
	;
	mov	si,offset FileExt
	mov	cx,offset file_ms_ext_end - offset file_ms_ext
	mov	di,offset file_ms_ext
	repe	cmpsb
	jz	set_filename_ms

	mov	si,offset FileExt
	mov	cx,offset file_msf_ext_end - offset file_msf_ext
	mov	di,offset file_msf_ext
	repe	cmpsb
	jz	set_filename_msf

	mov	si,offset FileExt
	mov	cx,offset file_ssg_ext_end - offset file_ssg_ext
	mov	di,offset file_ssg_ext
	repe	cmpsb
	jz	set_filename_ssg

	mov	si,offset FileExt
	mov	cx,offset file_opn_ext_end - offset file_opn_ext
	mov	di,offset file_opn_ext
	repe	cmpsb
	jz	set_filename_opn

	mov	si,offset FileExt
	mov	cx,offset file_se_ext_end - offset file_se_ext
	mov	di,offset file_se_ext
	repe	cmpsb
	jz	set_filename_se

	mov	si,offset FileExt
	mov	cx,offset file_sef_ext_end - offset file_sef_ext
	mov	di,offset file_sef_ext
	repe	cmpsb
	jz	set_filename_sef

	mov	si,offset FileExt
	mov	cx,offset file_msp_ext_end - offset file_msp_ext
	mov	di,offset file_msp_ext
	repe	cmpsb
	jz	set_filename_msp

set_filename_error:
	mov	ax,0003
	jmp	error_main

set_filename_exit:
	pop	si
	pop	cx
	pop	ax
	ret


	;
	;	.ms
	;
set_filename_ms:
	mov	bx,offset file_ms_ext
set_filename_ms_next0:
	mov	di,offset FileName_ms
	mov	[flag_ms],2
	call	set_filename_set
	cmp	[flag_ssg],2		; ssg t@C`FbN
	je	set_filename_ms_next1
	mov	bx,offset file_ssg_ext
	mov	di,offset FileName_ssg
	mov	[flag_ssg],1
	call	set_filename_set
set_filename_ms_next1:
	cmp	[flag_opn],2		; opn t@C`FbN
	je	set_filename_ms_next2
	mov	bx,offset file_opn_ext
	mov	di,offset FileName_opn
	mov	[flag_opn],1
	call	set_filename_set
set_filename_ms_next2:
	cmp	[flag_se],2		; se t@C`FbN
	je	set_filename_ms_next3
	mov	bx,offset file_se_ext
	mov	di,offset FileName_se
	mov	[flag_se],1
	call	set_filename_set
set_filename_ms_next3:
	cmp	[flag_sef],2		; sef t@C`FbN
	je	set_filename_ms_next4
	mov	bx,offset file_sef_ext
	mov	di,offset FileName_sef
	mov	[flag_sef],1
	call	set_filename_set
set_filename_ms_next4:
	cmp	[flag_msp],2		; msp t@C`FbN
	je	set_filename_ms_next5
	mov	bx,offset file_msp_ext
	mov	di,offset FileName_msp
	mov	[flag_msp],1
	call	set_filename_set
set_filename_ms_next5:
	jmp	set_filename_exit


	;
	;	.msf
	;
set_filename_msf:
	mov	bx,offset file_msf_ext
	jmp	set_filename_ms_next0


	;
	;	.ssg
	;
set_filename_ssg:
	mov	bx,offset file_ssg_ext
	mov	di,offset FileName_ssg
	mov	[flag_ssg],2
	call	set_filename_set
	jmp	set_filename_exit


	;
	;	.opn
	;
set_filename_opn:
	mov	bx,offset file_opn_ext
	mov	di,offset FileName_opn
	mov	[flag_opn],2
	call	set_filename_set
	jmp	set_filename_exit


	;
	;	.se
	;
set_filename_se:
	mov	bx,offset file_se_ext
	mov	di,offset FileName_se
	mov	[flag_se],2
	call	set_filename_set
	jmp	set_filename_exit


	;
	;	.sef
	;
set_filename_sef:
	mov	bx,offset file_sef_ext
	mov	di,offset FileName_sef
	mov	[flag_sef],2
	call	set_filename_set
	jmp	set_filename_exit


	;
	;	.msp
	;
set_filename_msp:
	mov	bx,offset file_msp_ext
	mov	di,offset FileName_msp
	mov	[flag_msp],2
	call	set_filename_set
	jmp	set_filename_exit


set_filename_set:
;
;	t@Cݒ肷
;
;(in)	di = ݐ
;	bx = gqւ̃|C^[
;
	mov	si,offset FileName
set_filename_set_loop0:
	lodsb
	stosb
	cmp	al," "
	ja	set_filename_set_loop0
	dec	di
	mov	al,"."
	stosb
set_filename_set_loop1:
	mov	al,[bx]
	inc	bx
	stosb
	cmp	al," "
	ja	set_filename_set_loop1
	xor	al,al
	dec	di
	stosb
	ret


set_filename_sub:
;
;	̏ꍇA啶ɂBȊOȂe
;
;(in)	al = ank moji
;
;(out)	al = ank moji
;
	cmp	al,"a"
	jb	set_filename_sub_next0
	cmp	al,"z"
	ja	set_filename_sub_next0
	sub	al,"a"-"A"
set_filename_sub_next0:
	ret


set_filename	endp
;==============================================================================
;==============================================================================
;	msdrv program
;==============================================================================
;==============================================================================
check_msdrv	proc	near
;
;	msdrv 풓Ă邩
;
;(out)	carry = off : msdrv 풓Ă
;	carry = on  : msdrv 풓ĂȂ
;
	pusha
	push	ds
	push	es
	MOV	AX,3500H+VEC_msdrv	;荞݃xN^[E
	INT	21H			;drFaw荞݃xN^[
	mov	di,bx
	inc	di
	inc	di
	MOV	SI,CS
	MOV	DS,SI
	MOV	SI,OFFSET msdrv_TSRID	;crFrhNvOAhX
	MOV	CX,5
	REPE	CMPSB			; ؏풓
	pop	es
	pop	ds
	popa
	jne	check_msdrv_error
	clc
	RET
check_msdrv_error:
	stc
	ret

msdrv_TSRID	db	'MsDRV'
check_msdrv	endp
;------------------------------------------------------------------------------
check_msp	proc	near
;
;	msp 풓Ă邩
;
;(out)	carry = off : msp 풓Ă
;	carry = on  : msp 풓ĂȂ
;
	pusha
	push	ds
	push	es
	MOV	AX,3500H+vec_msp	;荞݃xN^[E
	INT	21H			;drFaw荞݃xN^[
	mov	di,bx
	inc	di
	inc	di
	MOV	SI,CS
	MOV	DS,SI
	MOV	SI,OFFSET msp_tsrid	;crFrhNvOAhX
	MOV	CX,7
	REPE	CMPSB			; ؏풓
	pop	es
	pop	ds
	popa
	jne	check_msp_error
	clc
	RET
check_msp_error:
	stc
	ret

msp_TSRID	db	'PCMmiho'
check_msp	endp
;------------------------------------------------------------------------------
play_msdrv	proc	near
;
;	msdrv ŉt
;
	pusha
	push	es


	;
	;	midi-a volume
	;
	cmp	[midia_volume_flag],0
	je	midia_volume_exit
	mov	dl,[midia_volume_data]
	mov	ax,0901h
	int	VEC_msdrv
midia_volume_exit:


	;
	;	midi-b volume
	;
	cmp	[midib_volume_flag],0
	je	midib_volume_exit
	mov	dl,[midib_volume_data]
	mov	ax,0902h
	int	VEC_msdrv
midib_volume_exit:


	;
	;	ssg volume
	;
	cmp	[ssg_volume_flag],0
	je	ssg_volume_exit
	mov	dl,[ssg_volume_data]
	mov	ax,0903h
	int	VEC_msdrv
ssg_volume_exit:


	;
	;	opn volume
	;
	cmp	[opn_volume_flag],0
	je	opn_volume_exit
	mov	dl,[opn_volume_data]
	mov	ax,0904h
	int	VEC_msdrv
opn_volume_exit:


	;
	;	rhythm volume
	;
	cmp	[rhy_volume_flag],0
	je	rhy_volume_exit
	mov	dl,[rhy_volume_data]
	mov	ax,0905h
	int	VEC_msdrv
rhy_volume_exit:


	;
	;	opl volume
	;
	cmp	[opl_volume_flag],0
	je	opl_volume_exit
	mov	dl,[opl_volume_data]
	mov	ax,0906h
	int	VEC_msdrv
opl_volume_exit:


	;
	;	set midia
	;
	cmp	[set_midia_flag],0
	je	set_midia_exit
	mov	ax,1900h
	mov	cx,[set_midia_number]
	mov	bx,[set_midia_dataport]
	mov	dx,[set_midia_statport]
	int	vec_msdrv
set_midia_exit:


	;
	;	set midib
	;
	cmp	[set_midib_flag],0
	je	set_midib_exit
	mov	ax,1901h
	mov	cx,[set_midib_number]
	mov	bx,[set_midib_dataport]
	mov	dx,[set_midib_statport]
	int	vec_msdrv
set_midib_exit:


	;
	;	set 118 mode
	;
	cmp	[set_118_mode_flag],0
	je	#set_118_mode_exit
	mov	ax,0f001h
	mov	dl,[set_118_mode_data]
	int	vec_msdrv
#set_118_mode_exit:


	;
	;	set irq number
	;
	cmp	[set_irq_number_flag],0
	je	set_irq_number_exit
	mov	ah,17h
	mov	bx,[set_irq_number_data]
	int	vec_msdrv
set_irq_number_exit:


	;
	;	fadeout_flag ŋȃtF[hAEg
	;
	cmp	[fadeout_flag],0
	je	fadeout_flag_next
	mov	dx,[fadeout_data]
	mov	ax,02201h		; ȃXgbv
	int	VEC_msdrv
fadeout_flag_next:


	;
	;	soubd effect
	;
	cmp	[effect_flag],0
	je	effect_flag_next
	mov	bx,[effect_data]
	mov	ah,040h
	int	vec_msdrv
effect_flag_next:


	;
	;	soubd pcm
	;
	cmp	[pcm_flag],0
	je	pcm_flag_next
	mov	al,[pcm_data]
	mov	ah,02h
	mov	bl,[pcm_volume]
	mov	bh,[pcm_pan]
	int	vec_msp
pcm_flag_next:


	;
	;	stop_flag ŋȃXgbv
	;
	cmp	[stop_flag],0
	je	stop_flag_next
	mov	ax,02200h		; ȃXgbv
	int	VEC_msdrv
stop_flag_next:


	;
	;	.ms file  load ȂȃXgbv
	;
	cmp	[flag_ms],0
	je	play_msdrv_next0
	mov	ax,02200h		; ȃXgbv
	int	VEC_msdrv
play_msdrv_next0:


	;
	;	.ssg file  load
	;
	cmp	[flag_ssg],0
	je	play_msdrv_ssg_exit
	mov	ax,02020h
	int	VEC_msdrv
	mov	word ptr [ssg_buff_pointer],di
	mov	word ptr [ssg_buff_pointer+2],es
	mov	[ssg_buff_max],cx
	mov	ax,3d00h			; open file
	mov	dx,offset FileName_ssg
	int	21h
	jnc	play_msdrv_ssg_next0
	cmp	[flag_ssg],1
	je	play_msdrv_ssg_exit
	jmp	error_2000
play_msdrv_ssg_next0:
	mov	bx,ax
	mov	ax,4202h		; size check
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_2000
	mov	[ssg_file_size_high],dx
	mov	[ssg_file_size_low],ax
	mov	ax,4200h
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_2000
	mov	ah,3fh			; read
	mov	cx,ssg_buffer_size
	mov	dx,offset ssg_buffer
	int	21h
	jc	error_2000
	mov	ah,3eh			; close handle
	int	21h
	mov	si,offset ssg_buffer
	call	convert_ssg
	jc	error_2001
	call	trans_ssg
	mov	dx,offset mes_ssg
	mov	ah,09h
	int	21h
	mov	di,offset FileName_ssg
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf
play_msdrv_ssg_exit:


	;
	;	.opn file  load
	;
	cmp	[flag_opn],0
	je	play_msdrv_opn_exit
	mov	ax,02030h
	int	VEC_msdrv
	mov	word ptr [opn_buff_pointer],di
	mov	word ptr [opn_buff_pointer+2],es
	mov	[opn_buff_max],cx
	mov	ax,3d00h			; open file
	mov	dx,offset FileName_opn
	int	21h
	jnc	play_msdrv_opn_next0
	cmp	[flag_opn],1
	je	play_msdrv_opn_exit
	jmp	error_3000
play_msdrv_opn_next0:
	mov	bx,ax
	mov	ax,4202h		; size check
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_3000
	mov	[opn_file_size_high],dx
	mov	[opn_file_size_low],ax
	mov	ax,4200h
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_3000
 	mov	ah,3fh			; read
 	mov	cx,opn_buffer_size
 	mov	dx,offset opn_buffer
 	int	21h
 	jc	error_3000
 	mov	ah,3eh			; close handle
 	int	21h
 	mov	si,offset opn_buffer
 	call	convert_opn
	jc	error_3001
	call	trans_opn
	mov	dx,offset mes_opn
	mov	ah,09h
	int	21h
	mov	di,offset FileName_opn
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf
play_msdrv_opn_exit:


	;
	;	.se file  load
	;
	cmp	[flag_se],0
	je	play_msdrv_se_exit
	mov	ah,48h
	int	VEC_msdrv
	mov	word ptr [se_buff_pointer],di
	mov	word ptr [se_buff_pointer+2],es
	mov	[se_buff_size_high],cx
	mov	[se_buff_size_low],ax
	mov	ax,3d00h		; open file
	mov	dx,offset FileName_se
	int	21h
	jnc	play_msdrv_se_next0
	cmp	[flag_se],1
	je	play_msdrv_se_exit
	jmp	error_4000
play_msdrv_se_next0:
	mov	bx,ax
	mov	ax,4202h		; size check
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_4000
	cmp	[se_buff_size_high],dx
	ja	play_msdrv_se_next1
	jb	error_4002
	cmp	[se_buff_size_low],ax
	jb	error_4002
play_msdrv_se_next1:
	mov	ax,4200h
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_4000
 	mov	ah,3fh			; read
	mov	cx,[se_buff_size_low]
	push	ds
 	lds	dx,[se_buff_pointer]
 	int	21h
	pop	ds
 	jc	error_4000
 	mov	ah,3eh			; close handle
 	int	21h
	mov	dx,offset mes_se
	mov	ah,09h
	int	21h
	mov	di,offset FileName_se
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf
play_msdrv_se_exit:


	;
	;	.sef file  load
	;
	cmp	[flag_sef],0
	je	play_msdrv_sef_exit
	mov	ah,48h
	int	VEC_msdrv
	mov	word ptr [se_buff_pointer],di
	mov	word ptr [se_buff_pointer+2],es
	mov	[se_buff_size_high],cx
	mov	[se_buff_size_low],ax
	mov	ax,3d00h		; open file
	mov	dx,offset FileName_sef
	int	21h
	jnc	play_msdrv_sef_next0
	cmp	[flag_sef],1
	je	play_msdrv_sef_exit
	jmp	error_4000
play_msdrv_sef_next0:
	mov	bx,ax
	mov	ax,4202h		; size check
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_4000
	cmp	[se_buff_size_high],dx
	ja	play_msdrv_sef_next1
	jb	error_4002
	cmp	[se_buff_size_low],ax
	jb	error_4002
play_msdrv_sef_next1:
	mov	ax,4200h
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_4000
 	mov	ah,3fh			; read
	mov	cx,[se_buff_size_low]
	push	ds
 	lds	dx,[se_buff_pointer]
 	int	21h
	pop	ds
 	jc	error_4000
 	mov	ah,3eh			; close handle
 	int	21h
	mov	dx,offset mes_sef
	mov	ah,09h
	int	21h
	mov	di,offset FileName_sef
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf
play_msdrv_sef_exit:


	;
	;	.msp file  load
	;
	cmp	[flag_msp],0
	je	play_msdrv_msp_exit
	mov	ax,3d00h			; open file
	mov	dx,offset FileName_msp
	int	21h
	jnc	play_msdrv_msp_next0
	cmp	[flag_msp],1
	je	play_msdrv_msp_exit
	jmp	error_5000
play_msdrv_msp_next0:
	mov	[msp_file_handle],ax
	call	read_msp
	jc	error_5000
	mov	ah,3eh			; close handle
	mov	bx,[msp_file_handle]
	int	21h
	mov	dx,offset mes_msp
	mov	ah,09h
	int	21h
	mov	di,offset FileName_msp
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf
play_msdrv_msp_exit:


	cmp	[flag_ms],0
	je	play_msdrv_play_exit

	;
	;	ȃf[^[ւ̃|C^[ƃTCYE
	;
	mov	ax,02000h
	int	VEC_msdrv
	mov	word ptr [music_buff_pointer],di
	mov	word ptr [music_buff_pointer+2],es
	mov	[music_buff_size_high],dx
	mov	[music_buff_size_low],cx

	;
	;	.ms file read ( 64kb ȏΉ )
	;
	mov	ax,3d00h
	mov	dx,offset FileName_ms
	int	21h
	jc	error_1000
	mov	bx,ax
	mov	ax,4202h		; size check
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_1000
	mov	[music_data_size_high],dx
	mov	[music_data_size_low],ax

	cmp	[music_buff_size_high],dx
	ja	size_ok
	jb	error_1001
	cmp	[music_buff_size_low],ax
	jb	error_1001
size_ok:

	mov	ax,4200h
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	error_1000
	mov	cx,[music_data_size_low]; read

	push	ds

	mov	dx,word ptr cs:[music_buff_pointer]
	mov	ax,dx
	and	dx,000fh
	shr	ax,4
	add	ax,word ptr cs:[music_buff_pointer+2]
	mov	ds,ax

load_ms_loop0:
	mov	cx,8000h
	mov	ah,3fh
	int	21h
	jc	error_1000
	cmp	ax,8000h		; 8000h ȉH ( ȉȂI )
	jb	load_ms_next1
	mov	ax,ds
	add	ax,8000h/10h
	mov	ds,ax
	jmp	load_ms_loop0
load_ms_next1:

	pop	ds
	mov	ah,3eh			; close handle
	int	21h
	mov	dx,offset mes_ms
	mov	ah,09h
	int	21h
	mov	di,offset FileName_ms
	push	ds
	pop	es
	call	print_file_name
	call	print_cr_lf

	;
	;	ȃX^[g
	;
	mov	ax,2100H
	int	VEC_msdrv
play_msdrv_play_exit:


	;
	;	play_flag ŋȃX^[g
	;
	cmp	[play_flag],0
	je	play_flag_next
	mov	ax,2100H
	int	VEC_msdrv
play_flag_next:


	;
	;	fadein_flag ŋ fade-in
	;
	cmp	[fadein_flag],0
	je	fadein_flag_next
	mov	dx,[fadein_data]
	mov	ax,2101H
	int	VEC_msdrv
fadein_flag_next:


	pop	es
	popa
	clc
	ret


	;
	;	.ms file open error
	;
error_1000:
	mov	ax,1000
	jmp	error_main


	;
	;	.ms size over
	;
error_1001:
	mov	ah,3eh			;close handle
	int	21h
	mov	ax,1001
	jmp	error_main


	;
	;	.ssg file open error
	;
error_2000:
	mov	ax,2000
	jmp	error_main


	;
	;	unknown .ssg file
	;
error_2001:
	mov	ax,2001
	jmp	error_main


	;
	;	.opn file open error
	;
error_3000:
	mov	ax,3000
	jmp	error_main


	;
	;	unknown .opn file
	;
error_3001:
	mov	ax,3001
	jmp	error_main


	;
	;	.se/sef file read error
	;
error_4000:
	mov	ax,4000
	jmp	error_main


	;
	;	illegal .se/sef file
	;
error_4001:
	mov	ax,4001
	jmp	error_main


	;
	;	.se/sef size over
	;
error_4002:
	mov	ax,4002
	jmp	error_main


	;
	;	.msp file read error
	;
error_5000:
	mov	ax,5000
	jmp	error_main


play_msdrv	endp
;------------------------------------------------------------------------------
print_file_name		proc	near
;
;	file name \
;
;(in)	es:di = filename
;
	mov	dx,di
	xor	al,al
	mov	cx,FileNameSize
	repne	scasb
	jne	print_file_name_ret
	dec	di
	mov	byte ptr es:[di],"$"
	mov	ah,09h
	int	21h
	mov	byte ptr es:[di],0
print_file_name_ret:
	ret
print_file_name		endp
;------------------------------------------------------------------------------
print_cr_lf		proc	near
;
;	print cr lf
;
	mov	dl,cr
	mov	ah,06h
	int	21h
	mov	dl,lf
	mov	ah,06h
	int	21h
	ret
print_cr_lf		endp
;-----------------------------------------------------------------------------
;	ssg
;-----------------------------------------------------------------------------
convert_ssg		proc	near
;
;	convert ssg
;
;	o[W ssg t@C̏ꍇAo[Wɍv悤ɃR
;	o[g
;
;	iQj@o[W ssg t@C = edits.exe ō쐬 ssg t@C
;	@@@@ʏÃ[`͕Kv܂
;
;(in)	ds:si = ssg data
;
	cmp	[ssg_file_size_high],0
	jne	convert_ssg_error
	cmp	[ssg_file_size_low],256*(16+12)
	je	convert_ssg_exit

	;
	;	fmdrv3  ssg t@CH
	;
	cmp	[ssg_file_size_low],256*(10+12)
	jne	convert_ssg_error
	push	ds
	pop	es

	;
	;	name data
	;
	push	si
	mov	di,si
	add	si,256*(10+12)-1
	add	di,256*(16+12)-1
	mov	cx,256*12
	std
	rep	movsb
	cld
	pop	si

	;
	;	program data
	;
	push	si
	mov	cx,256
	mov	di,si
	add	si,(256)*10-1
	add	di,(256)*16-1
convert_ssg_loop0:
	push	cx
	std
	xor	al,al
	mov	cx,16-10
	rep	stosb
	mov	cx,10
	rep	movsb
	cld
	pop	cx
	loop	convert_ssg_loop0
	pop	si

	;
	;	AR convert
	;
	push	si
	mov	cx,256
convert_ssg_loop1:
	mov	al,[di+9]		;`q
	and	al,00011111B
	add	al,8
	cmp	al,31
	jbe	convert_ssg_next1
	mov	al,31
convert_ssg_next1:
	mov	[di+9],al
	loop	convert_ssg_loop1
	pop	si

convert_ssg_exit:
	clc
	ret

convert_ssg_error:
	stc
	ret
convert_ssg		endp
;-----------------------------------------------------------------------------
trans_ssg		proc	near
;
;	trans ssg
;
	;
	;	ssg program data
	;
	mov	si,offset ssg_buffer
	les	di,[ssg_buff_pointer]
	mov	ax,16
	mov	cx,[ssg_buff_max]
	mul	cx
	mov	cx,ax
	rep	movsb

	;
	;	ssg program name
	;
	cmp	[ssg_buff_max],256
	jne	trans_ssg_ret
	mov	cx,256*12
	rep	movsb
trans_ssg_ret:
	ret
trans_ssg		endp
;-----------------------------------------------------------------------------
;	opn
;-----------------------------------------------------------------------------
convert_opn		proc	near
;
;	convert opn
;
;	o[W opn t@C̏ꍇAo[Wɍv悤ɃR
;	o[g
;
;	iQj@o[W opn t@C = edits.exe ō쐬 opn t@C
;	@@@@ʏÃ[`͕Kv܂
;
;(in)	ds:si = opn data
;
	cmp	[opn_file_size_high],0
	jne	convert_opn_error
	cmp	[opn_file_size_low],256*(48+12)
	je	convert_opn_exit

	;
	;	fmdrv3  opn t@CH
	;
	cmp	[opn_file_size_low],256*(36+12)
	jne	convert_opn_error
	push	ds
	pop	es

	;
	;	name data
	;
	push	si
	mov	di,si
	add	si,256*(36+12)-1
	add	di,256*(48+12)-1
	mov	cx,256*12
	std
	rep	movsb
	cld
	pop	si

	;
	;	program data
	;
	push	si
	mov	cx,256
	mov	di,si
	add	si,(256)*36-1
	add	di,(256)*48-1
convert_opn_loop0:
	push	cx
	std
	xor	al,al
	mov	cx,48-36
	rep	stosb
	mov	cx,36
	rep	movsb
	cld
	pop	cx
	loop	convert_opn_loop0
	pop	si


convert_opn_exit:
	clc
	ret

convert_opn_error:
	stc
	ret
convert_opn		endp
;-----------------------------------------------------------------------------
trans_opn		proc	near
;
;	trans opn
;
	;
	;	opn program data
	;
	mov	si,offset opn_buffer
	les	di,[opn_buff_pointer]
	mov	ax,48
	mov	cx,[opn_buff_max]
	mul	cx
	mov	cx,ax
	rep	movsb

	;
	;	opn program name
	;
	cmp	[opn_buff_max],256
	jne	trans_opn_ret
	mov	cx,256*12
	rep	movsb
trans_opn_ret:
	ret
trans_opn		endp
;-----------------------------------------------------------------------------
;	msp
;-----------------------------------------------------------------------------
read_msp		proc	near
;
;	read msp
;
;(in)	[msp_file_handle] = file handle
;
;(out)	carry = off: success
;		on : error
;
	mov	ah,01h			; stop pcm
	int	vec_msp

	mov	ah,00h			; get pcm version
	int	vec_msp
	cmp	bh,0
	je	read_msp_main
	cmp	bh,1
	je	read_msp_emb
read_msp_error:
	stc
	ret


;
;	main memory
;
read_msp_main:
	mov	ah,10h
	int	vec_msp
	mov	[pcm_buffer_size],cx
	mov	[pcm_buffer_handle_or_seg],es
	cmp	cx,0
	je	read_msp_error

	;
	;	size check
	;
	xor	cx,cx			; set end
	xor	dx,dx
	mov	bx,[msp_file_handle]
	mov	ax,4202h
	int	21h
	jc	read_msp_error
	mov	si,ax
	mov	di,dx
	mov	ax,1024
	mul	[pcm_buffer_size]
	cmp	di,dx
	ja	read_msp_error
	jb	read_msp_main_next0
	cmp	si,ax
	ja	read_msp_error
read_msp_main_next0:
	xor	cx,cx			; set top
	xor	dx,dx
	mov	ax,4200h
	int	21h
	jc	read_msp_error

	;
	;	trans data
	;
	mov	bx,[msp_file_handle]
	xor	dx,dx
	mov	di,[pcm_buffer_handle_or_seg]
read_msp_main_loop0:
	push	ds
	mov	ah,3fh
	mov	cx,8000h
	mov	ds,di
	int	21h
	pop	ds
	jc	read_msp_error
	add	di,8000h/16
	cmp	ax,8000h
	je	read_msp_main_loop0
read_msp_main_next1:
	clc
	ret



;
;	emb ( Ɍ xms memory  read )
;
read_msp_emb:
	mov	ax,4300h		; xmsdriver ̑݃`FbN
	int	2fh
	cmp	al,80h
	jne	read_msp_error
	mov	ax,4310h		; xmsdriver ̃Gg[E
	int	2fh
	mov	word ptr [lpfn_xms],bx
	mov	word ptr [lpfn_xms+2],es

	mov	ah,10h			; ݎgp emb nhE
	int	vec_msp
	mov	[pcm_buffer_size],cx
	mov	[pcm_buffer_handle_or_seg],dx
	cmp	cx,0
	je	read_msp_error


	;
	;	size check
	;
	xor	cx,cx			; set end
	xor	dx,dx
	mov	bx,[msp_file_handle]
	mov	ax,4202h
	int	21h
	jc	read_msp_error
	mov	si,ax
	mov	di,dx
	mov	ax,1024
	mul	[pcm_buffer_size]
	cmp	di,dx
	ja	read_msp_error
	jb	read_msp_emb_next0
	cmp	si,ax
	ja	read_msp_error
read_msp_emb_next0:
	xor	cx,cx			; set top
	xor	dx,dx
	mov	ax,4200h
	int	21h
	jc	read_msp_error


	;
	;	trans data
	;
	xor	di,di
	xor	bp,bp
read_msp_emb_loop0:
	mov	ah,3fh
	mov	dx,offset msp_read_buffer
	mov	bx,[msp_file_handle]
	mov	cx,msp_read_buffer_size
	int	21h
	jc	read_msp_error
	or	ax,ax
	je	read_msp_emb_next1

	inc	ax
	and	ax,0fffeh
	mov	word ptr [movelength],ax
	mov	word ptr [movelength+2],0

	mov	[sourcehandle],0
	mov	word ptr [sourceoffset],offset msp_read_buffer
	mov	word ptr [sourceoffset+2],cs

	mov	ax,[pcm_buffer_handle_or_seg]
	mov	[desthandle],ax
	mov	word ptr [destoffset],di
	mov	word ptr [destoffset+2],bp

	mov	ah,0bh			; move emb memory
	mov	si,offset movelength
	call	[lpfn_xms]
	cmp	ax,0
	je	read_msp_error
	mov	ax,word ptr [movelength]
	add	di,ax
	adc	bp,0
	cmp	ax,msp_read_buffer_size
	je	read_msp_emb_loop0
read_msp_emb_next1:

	mov	ah,13h			; init pcm
	int	vec_msp

	clc
	ret


read_msp		endp
;==============================================================================
;==============================================================================
;	debug program
;==============================================================================
;==============================================================================
if debug
	include \obj\testcom.inc
endif


;==============================================================================
;==============================================================================
;	const data area
;==============================================================================
;==============================================================================
mes_usa		label	byte
db "MsP v4.5a for MsDRV4.5 Copyright(c)KENJI 1995.1-",CR,LF
db "usage : msp [options...] [file[.ms]] [file.ssg] [file.opn] [file.se]",CR,LF
db "	/P		play ( .ms file ǂݍݎ͎w肵ȂĂ play ܂ )",cr,lf
db "	/S		stop",cr,lf
db "	/En		sound effect",cr,lf
db "	/Cn[,vol[,pan]]	sound pcm ( n = 0 - 255 )",cr,lf
db "	/FIn		fade in ( n = m second )",cr,lf
db "	/FOn		fade out ( n = m second )",cr,lf
db "	/VAn		set midi-a volume ( 0 - 127 )",cr,lf
db "	/VBn		set midi-b volume ( 0 - 127 )",cr,lf
db "	/VSn		set ssg volume ( 0 - 127 )",cr,lf
db "	/VOn		set opn volume ( 0 - 127 )",cr,lf
db "	/VRn		set rhythm volume ( 0 - 127 )",cr,lf
db "	/VLn		set opl volume ( 0 - 127 )",cr,lf
db "	/MA0		midi-A none",CR,LF
db "	/MA1[,data,stat]midi-A mpu-98",CR,LF
db "	/MA2		midi-A rs-midi",CR,LF
db "	/MA3		midi-A rs-midi port b",CR,LF
db "	/MA128[,data,stat]midi-A super-mpu port a",CR,LF
db "	/MA129[,data,stat]midi-A super-mpu port b",CR,LF
db "	/MB0		midi-B none",CR,LF
db "	/MB1[,data,stat]midi-B mpu-98",CR,LF
db "	/MB2		midi-B rs-midi",CR,LF
db "	/MB3		midi-B rs-midi port b",CR,LF
db "	/MB128[,data,stat]midi-B super-mpu port a",CR,LF
db "	/MB129[,data,stat]midi-B super-mpu port b",CR,LF
db "	/NM1		118-opna ƂĎgp",cr,lf
db "	/NM0		118-opl ƂĎgp",cr,lf
db "	/AIn		select irq ( 0:tmer0 2:vsync 256:opn 257:mouse )",cr,lf
db "$"

mes_ok	 db "tJn܂",cr,lf,"$"

mes_err_tbl	dw	0002,offset mes_err0002
		dw	0003,offset mes_err0003
		dw	0004,offset mes_err0004
		dw	0005,offset mes_err0005
		dw	1000,offset mes_err1000
		dw	1001,offset mes_err1001
		dw	2000,offset mes_err2000
		dw	2001,offset mes_err2001
		dw	3000,offset mes_err3000
		dw	3001,offset mes_err3001
		dw	4000,offset mes_err4000
		dw	4001,offset mes_err4001
		dw	4002,offset mes_err4002
		dw	5000,offset mes_err5000
mes_err_end	label	word

mes_err0001 db "err0001:error",cr,lf,"$"
mes_err0002 db "err0002:MsDRV 풓Ă܂",cr,lf,"$"
mes_err0003 db "err0003:gqُł",cr,lf,"$"
mes_err0004 db "err0004:command line error",cr,lf,"$"
mes_err0005 db "err0005:msp ( pcm driver ) 풓Ă܂",cr,lf,"$"
mes_err1000 db "err1000:.ms/msf file read error",cr,lf,"$"
mes_err1001 db "err1001:.ms/msf size over",cr,lf,"$"
mes_err2000 db "err2000:.ssg file read error",cr,lf,"$"
mes_err2001 db "err2001:illegal .ssg file",cr,lf,"$"
mes_err3000 db "err3000:.opn file read error",cr,lf,"$"
mes_err3001 db "err3001:illegal .opn file",cr,lf,"$"
mes_err4000 db "err4000:.se/sef file read error",cr,lf,"$"
mes_err4001 db "err4001:illegal .se/sef file",cr,lf,"$"
mes_err4002 db "err4002:.se/sef size over",cr,lf,"$"
mes_err5000 db "err5000:.msp file read error",cr,lf,"$"


mes_ms	db "music file = $"
mes_ssg	db "ssg file = $"
mes_opn	db "opn file = $"
mes_se	db "se file = $"
mes_sef	db "sef file = $"
mes_msp	db "msp file = $"


file_ms_ext	db	"MS",0
file_ms_ext_end		label	byte

file_msf_ext	db	"MSF",0
file_msf_ext_end	label	byte

file_ssg_ext	db	"SSG",0
file_ssg_ext_end	label	byte

file_opn_ext	db	"OPN",0
file_opn_ext_end	label	byte

file_se_ext	db	"SE",0
file_se_ext_end		label	byte

file_sef_ext	db	"SEF",0
file_sef_ext_end	label	byte

file_msp_ext	db	"MSP",0
file_msp_ext_end	label	byte


;==============================================================================
;==============================================================================
;	data area
;==============================================================================
;==============================================================================


;==============================================================================
;==============================================================================
;	bss data area
;==============================================================================
;==============================================================================
FileName	db	FileNameSize dup(?)
FileExt		db	FileNameSize dup(?)
FileName_ms	db	FileNameSize dup(?)
FileName_ssg	db	FileNameSize dup(?)
FileName_opn	db	FileNameSize dup(?)
FileName_se	db	FileNameSize dup(?)
FileName_sef	db	FileNameSize dup(?)
FileName_msp	db	FileNameSize dup(?)
flag_ms		db	?			; 0 = .ms file  load Ȃ
						; 2 = .ms file  load 
flag_ssg	db	?			; 0 = .ssg file  load Ȃ
						; 1 = .ssg file  load 
						;      read error `FbN
						; 2 = .ssg file  load 
						;      read error `FbN
flag_opn	db	?			; 0 = .opn file  load Ȃ
						; 1 = .opn file  load 
						;      read error `FbN
						; 2 = .opn file  load 
						;      read error `FbN
flag_se		db	?			; 0 = .se file  load Ȃ
						; 1 = .se file  load 
						;      read error `FbN
						; 2 = .se file  load 
						;      read error `FbN
flag_sef	db	?			; 0 = .sef file  load Ȃ
						; 1 = .sef file  load 
						;      read error `FbN
						; 2 = .sef file  load 
						;      read error `FbN
play_flag	db	?			;  start 
stop_flag	db	?			;  stop 
fadein_flag	db	?			;  fadein 
fadein_data	dw	?
fadeout_flag	db	?			;  fadeout 
fadeout_data	dw	?
effect_flag	db	?			; effect 炷
effect_data	dw	?
midia_volume_flag db	?			; midi-a {[ݒ肷
midia_volume_data db	?			; midi-a {[
midib_volume_flag db	?			; midi-b {[ݒ肷
midib_volume_data db	?			; midi-b {[
ssg_volume_flag	db	?			; ssg {[ݒ肷
ssg_volume_data	db	?			; ssg {[
opn_volume_flag	db	?			; opn {[ݒ肷
opn_volume_data	db	?			; opl {[
rhy_volume_flag	db	?			; rhythm {[ݒ肷
rhy_volume_data	db	?			; rhythm {[
opl_volume_flag	db	?			; opl {[ݒ肷
opl_volume_data	db	?			; opl {[
set_midia_flag	db	?			; midi-a ̐ݒ
set_midia_number dw	?			; midi-a ̐ݒ
set_midia_dataport dw	?			; midi-a ̐ݒ
set_midia_statport dw	?			; midi-a ̐ݒ
set_midib_flag	db	?			; midi-b ̐ݒ
set_midib_number dw	?			; midi-b ̐ݒ
set_midib_dataport dw	?			; midi-b ̐ݒ
set_midib_statport dw	?			; midi-b ̐ݒ
set_118_mode_flag db	?			; 118 mode ̐ݒ
set_118_mode_data db	?			; 118 mode ̐ݒ
set_irq_number_flag db	?			; irq number ݒ肷
set_irq_number_data dw	?			; irq number

pcm_flag	db	?			; pcm 炷
pcm_data	db	?
pcm_volume	db	?
pcm_pan		db	?
flag_msp	db	?			; 0 = .pcm file  load Ȃ
						; 1 = .pcm file  load 
						;      read error `FbN
						; 2 = .pcm file  load 
						;      read error `FbN


music_buff_pointer	dd	?		; music buff ̃AhX
music_buff_size_low	dw	?		; music buff ̑傫
music_buff_size_high	dw	?
music_data_size_low	dw	?		; music data ̃t@CTCY
music_data_size_high	dw	?


ssg_buff_pointer	dd	?		; ssg buffer ̃AhX
ssg_buff_max		dw	?		; max program
ssg_file_size_low	dw	?		; ssg file ̃TCY
ssg_file_size_high	dw	?
ssg_buffer		db ssg_buffer_size dup(?); 񂱂ɓǂݍ


opn_buff_pointer	dd	?		; opn buffer ̃AhX
opn_buff_max		dw	?		; max program
opn_file_size_low	dw	?		; opn file ̃TCY
opn_file_size_high	dw	?
opn_buffer		db opn_buffer_size dup(?); 񂱂ɓǂݍ


se_buff_pointer		dd	?		; se buffer ̃AhX
se_buff_size_low	dw	?		; se buffer ̃TCY
se_buff_size_high	dw	?


movelength		dd	?		
sourcehandle		dw	?		
sourceoffset		dd	?		
desthandle		dw	?		
destoffset		dd	?		
lpfn_xms		dd	?		; xms driver  entry address
msp_file_handle		dw	?		; msp  file handle
pcm_buffer_size		dw	?		; buffer size ( kbyte P )
pcm_buffer_handle_or_seg dw	?		; handle or segment
msp_read_buffer	db msp_read_buffer_size dup(?)	; read buffer


code	ends
	end	start
