;
;	MSMIXSB.COM
;
;	music player for msdrv4.exe (fm/midi driver)
;		programed by kenji
;
;[tasm ver6.0]
;tasm /jJUMPS /m4 MSMIXSB;
;tlink /t MSMIXSB.obj,MSMIXSB.com
;
;[optasm]
;optasm MSMIXSB;
;optlink MSMIXSB.exe MSMIXSB.com;
;
;[masm ver6.0]
;ml /AT msms_f00.asm
;
;AZu̒
;΋ -128 ` 127 ͈͊ÕWvgpĂ܂BLȊÕAZu
;gpꍇ͋CtĉB
;
;=============================================================================
;=============================================================================
;	define
;=============================================================================
;=============================================================================
VEC_MsDRV	EQU	61H		; FM/MIDI xN^[ԍ


cr		equ	0dh
lf		equ	0ah
debug		equ	1
FileNameSize	equ	128
ssg_buffer_size	equ	256*(16+12)
opn_buffer_size	equ	256*(48+12)


code	segment
	assume cs:code,ds:code
	.186
;=============================================================================
;=============================================================================
;	PSP
;=============================================================================
;=============================================================================
	org	2ch
envseg	dw	?			;environment segment
	org	80h
argc	db	?			;size of command
argv	db	127 dup (?)		;command line


;=============================================================================
;=============================================================================
;	program
;=============================================================================
;=============================================================================
start		proc	near
;
;	main
;
	mov	dx,offset mes_right	; right
	mov	ah,09h
	int	21h
	call	check_msdrv		; if stay msdrv
	mov	ax,0002
	jc	error_main

	mov	ah,0h			; check msdrv version
	int	vec_msdrv
	cmp	ax,0403h
	mov	ax,0003
	jb	error_main

	mov	ah,14h			; if sb16 exist
	int	vec_msdrv
	cmp	ax,0
	mov	ax,0004
	je	error_main


	cld

	;
	;	get option
	;
	mov	si,offset argv
main_loop0:
	lodsb
	cmp	al,cr
	je	main_next0
	cmp	al,"/"
	je	main_loop0
	cmp	al,"-"
	je	main_loop0
	cmp	al," "
	jbe	main_loop0

	cmp	al,"?"			; ?
	jne	main_next1
	call	option_h
	jmp	main_loop0
main_next1:

	mov	di,offset option_data

main_loop1:
	cmp	byte ptr ds:[di],0
	je	illegal_option
	push	ax
	push	si
main_loop2:
	and	al,11011111b		; lower -> upper
	cmp	al,ds:[di]
	jne	searh_next
	lodsb
	inc	di
	cmp	byte ptr ds:[di],0
	jne	main_loop2
	dec	si
	pop	ax
	pop	ax
	call	ds:[di+1]
	jmp	main_loop0

searh_next:				; search next
	inc	di
	cmp	byte ptr ds:[di],0
	jne	searh_next
	add	di,3

	pop	si
	pop	ax
	jmp	main_loop1


illegal_option:
	mov	ax,0005
	jmp	error_main


main_next0:
	call	print_help
	mov	ax,4c00h		; exit to dos
	int	21h


start		endp
;-----------------------------------------------------------------------------
option_h	proc	near
;
;	help
;
	mov	[usage_flag],1
	mov	dx,offset mes_usage
	mov	ah,09h
	int	21h
	ret
option_h	endp
;-----------------------------------------------------------------------------
option_v	proc	near
;
;	݂̃~LT[̏Ԃ\
;
	mov	[usage_flag],1
	call	print_all_value
	ret
option_v	endp
;-----------------------------------------------------------------------------
option_q	proc	near
;
;	ȍ~̕\} ( q- ) / ȍ~̕\s ( q+ )
;
	mov	[usage_flag],1
	lodsb
	cmp	al,"+"
	je	option_q_next0
	cmp	al,"-"
	je	option_q_next1
	mov	ax,0005
	jmp	error_main
option_q_next0:
	mov	[print_flag],1
	ret
option_q_next1:
	mov	[print_flag],0
	ret
option_q	endp
;-----------------------------------------------------------------------------
option_r	proc	near
;
;	~LT[
;
	mov	[usage_flag],1
	mov	ah,81h			; reset ct1745
	mov	dl,00h
	int	vec_msdrv
	cmp	[print_flag],0
	je	option_r_exit
	mov	dx,offset init_mixer
	mov	ah,09h
	int	21h
option_r_exit:
	ret
option_r	endp
;-----------------------------------------------------------------------------
option_m	proc	near
;
;	}X^[{[ݒ
;
	mov	[usage_flag],1
	mov	bl,30h
	mov	cl,31h
	call	set_stereo_volume
	call	print_value_m
	ret
option_m	endp
;-----------------------------------------------------------------------------
option_voice	proc	near
;
;	voice {[ݒ
;
	mov	[usage_flag],1
	mov	bl,32h
	mov	cl,33h
	call	set_stereo_volume
	call	print_value_voice
	ret
option_voice	endp
;-----------------------------------------------------------------------------
option_midi	proc	near
;
;	midi {[ݒ
;
	mov	[usage_flag],1
	mov	bl,34h
	mov	cl,35h
	call	set_stereo_volume
	call	print_value_midi
	ret
option_midi	endp
;-----------------------------------------------------------------------------
option_cd	proc	near
;
;	cd {[ݒ
;
	mov	[usage_flag],1
	mov	bl,36h
	mov	cl,37h
	call	set_stereo_volume
	call	print_value_cd
	ret
option_cd	endp
;-----------------------------------------------------------------------------
option_line	proc	near
;
;	line {[ݒ
;
	mov	[usage_flag],1
	mov	bl,38h
	mov	cl,39h
	call	set_stereo_volume
	call	print_value_line
	ret
option_line	endp
;-----------------------------------------------------------------------------
option_mic	proc	near
;
;	mix {[ݒ
;
	mov	[usage_flag],1
	cmp	byte ptr ds:[si],":"
	jne	option_mic_next0
	inc	si
option_mic_next0:
	call	get_dec
	jnc	option_mic_next1
option_mic_error:
	mov	ax,0006
	jmp	error_main
option_mic_next1:
	mov	dh,al

	mov	ah,81h			; set mic volume left
	mov	dl,3bh
	int	vec_msdrv

	call	print_value_mic
	ret
option_mic	endp
;-----------------------------------------------------------------------------
option_treble	proc	near
;
;	treble {[ݒ
;
	mov	[usage_flag],1
	mov	bl,44h
	mov	cl,45h
	call	set_stereo_volume
	call	print_value_treble
	ret
option_treble	endp
;-----------------------------------------------------------------------------
option_bass	proc	near
;
;	bass {[ݒ
;
	mov	[usage_flag],1
	mov	bl,46h
	mov	cl,47h
	call	set_stereo_volume
	call	print_value_bass
	ret
option_bass	endp
;-----------------------------------------------------------------------------
option_agc	proc	near
;
;	agc
;
	mov	[usage_flag],1
	call	get_on_off
	jnc	option_agc_next0
	mov	ax,0006
	jmp	error_main
option_agc_next0:

	xor	al,0001b
	mov	dh,al
	mov	ah,81h			; agc
	mov	dl,43h
	int	vec_msdrv
	call	print_value_agc
	ret
option_agc	endp
;-----------------------------------------------------------------------------
option_ipgain	proc	near
;
;	input gain ̐ݒ
;
	mov	[usage_flag],1
	mov	bl,3fh
	mov	cl,40h
	call	set_stereo_gain
	call	print_value_ipgain
	ret
option_ipgain	endp
;-----------------------------------------------------------------------------
option_opgain	proc	near
;
;	output gain ̐ݒ
;
	mov	[usage_flag],1
	mov	bl,41h
	mov	cl,42h
	call	set_stereo_gain
	call	print_value_opgain
	ret
option_opgain	endp
;-----------------------------------------------------------------------------
option_opsw	proc	near
;
;	output mixer switches ̐ݒ
;
	mov	[usage_flag],1
	mov	bl,00011111b
	mov	dl,3ch
	call	set_switch
	call	print_value_opsw
	ret
option_opsw	endp
;-----------------------------------------------------------------------------
option_iplsw	proc	near
;
;	intput mixer left switches ̐ݒ
;
	mov	[usage_flag],1
	mov	bl,01111111b
	mov	dl,3dh
	call	set_switch
	call	print_value_iplsw
	ret
option_iplsw	endp
;-----------------------------------------------------------------------------
option_iprsw	proc	near
;
;	intput mixer right switches ̐ݒ
;
	mov	[usage_flag],1
	mov	bl,01111111b
	mov	dl,3eh
	call	set_switch
	call	print_value_iprsw
	ret
option_iprsw	endp
;-----------------------------------------------------------------------------
set_stereo_volume	proc	near
;
;	get stereo volume
;
;(in)	ds:si = pointer to command line
;	bl    = ct1745 left address
;	cl    = ct1745 right address
;
	cmp	byte ptr ds:[si],":"
	jne	set_stereo_volume_next0
	inc	si
set_stereo_volume_next0:


	call	get_dec
	jnc	set_stereo_volume_next1
set_stereo_volume_error:
	mov	ax,0006
	jmp	error_main
set_stereo_volume_next1:
	mov	bh,al
	mov	ch,al

	cmp	byte ptr ds:[si],","
	jne	set_stereo_volume_next2
	inc	si
	call	get_dec
	jc	set_stereo_volume_error
	mov	ch,al
set_stereo_volume_next2:

	mov	ah,81h			; set master volume left
	mov	dx,bx
	int	vec_msdrv

set_stereo_volume_right_next0:
	mov	ah,81h			; set master volume right
	mov	dx,cx
	int	vec_msdrv

	ret
set_stereo_volume	endp
;-----------------------------------------------------------------------------
set_stereo_gain	proc	near
;
;	get stereo gain
;
;(in)	ds:si = pointer to command line
;	bl    = ct1745 left address
;	cl    = ct1745 right address
;
	cmp	byte ptr ds:[si],":"
	jne	set_stereo_gain_next0
	inc	si
set_stereo_gain_next0:
	call	get_dec
	jnc	set_stereo_gain_next1
set_stereo_gain_error:
	mov	ax,0006
	jmp	error_main
set_stereo_gain_next1:
	call	set_stereo_gain_check
	jc	set_stereo_gain_error
	mov	bh,al
	mov	ch,al

	cmp	byte ptr ds:[si],","
	jne	set_stereo_gain_next2
	inc	si
	call	get_dec
	jc	set_stereo_gain_error
	call	set_stereo_gain_check
	jc	set_stereo_gain_error
	mov	ch,al
set_stereo_gain_next2:

	mov	ah,81h			; set master volume left
	mov	dx,bx
	int	vec_msdrv

	mov	ah,81h			; set master volume right
	mov	dx,cx
	int	vec_msdrv

	ret


set_stereo_gain_check:
	cmp	al,1
	jne	set_stereo_gain_check_next1
	mov	al,00000000b
	ret
set_stereo_gain_check_next1:

	cmp	al,2
	jne	set_stereo_gain_check_next2
	mov	al,01000000b
	ret
set_stereo_gain_check_next2:

	cmp	al,4
	jne	set_stereo_gain_check_next4
	mov	al,10000000b
	ret
set_stereo_gain_check_next4:

	cmp	al,8
	jne	set_stereo_gain_error
	mov	al,11000000b
	ret

set_stereo_gain	endp
;-----------------------------------------------------------------------------
set_switch		proc	near
;
;	set switch
;
;(in)	bl = mask
;	dl = mixer address
;
	mov	ah,80h				; get data
	mov	al,dl
	int	vec_msdrv
	mov	dh,al

set_switch_loop0:
	mov	di,offset matching_data
	mov	bh,00000001b

	cmp	byte ptr ds:[si],":"
	jne	set_switch_loop1
	inc	si
set_switch_loop1:
	cmp	byte ptr ds:[di],0
	je	set_switch_exit
	push	si

	test	bl,bh
	je	set_switch_loop3

set_switch_loop2:
	lodsb
	and	al,11011111b			; lower -> upper
	cmp	al,ds:[di]
	je	set_switch_next0

set_switch_loop3:				; search next
	inc	di
	cmp	byte ptr ds:[di],0
	jne	set_switch_loop3
	inc	di
	pop	si
	sal	bh,1
	jmp	set_switch_loop1

set_switch_next0:
	inc	di
	cmp	byte ptr ds:[di],0
	jne	set_switch_loop2
	pop	ax
	call	get_on_off
	jnc	set_switch_next1
	mov	ax,0006
	jmp	error_main
set_switch_next1:
	dec	ax				; on
	jne	set_switch_next2
	or	dh,bh
	jmp	set_switch_loop0
set_switch_next2:				; off
	mov	al,bh
	not	al
	and	dh,al
	jmp	set_switch_loop0
set_switch_exit:

	mov	ah,81h				; set data
	int	vec_msdrv
	ret
set_switch		endp
;-----------------------------------------------------------------------------
get_on_off	proc	near
;
;	get on/off
;
;(in)	ds:si = pointer to command line
;
;(out)	carry = 0 : ok
;		ax = 0:off
;		     1:on
;
;	carry =	1 : error
;
	cmp	byte ptr ds:[si],":"
	jne	get_on_off_next0
	inc	si
get_on_off_next0:

	cmp	byte ptr ds:[si],"+"
	jne	get_on_off_next1
	inc	si
	mov	ax,1
	clc
	ret
get_on_off_next1:

	cmp	byte ptr ds:[si],"-"
	jne	get_on_off_next2
	inc	si
	xor	ax,ax
	clc
	ret
get_on_off_next2:


	cmp	byte ptr ds:[si],"1"
	jne	get_on_off_next3
	inc	si
	mov	ax,1
	clc
	ret
get_on_off_next3:


	cmp	byte ptr ds:[si],"0"
	jne	get_on_off_next4
	inc	si
	xor	ax,ax
	clc
	ret
get_on_off_next4:


	mov	al,ds:[si]
	and	al,11011111b
	cmp	al,"O"
	jne	get_on_off_next5
	mov	al,ds:[si+1]
	and	al,11011111b
	cmp	al,"F"
	jne	get_on_off_next5
	mov	al,ds:[si+2]
	and	al,11011111b
	cmp	al,"F"
	jne	get_on_off_next5
	add	si,3
	xor	ax,ax
	clc
	ret
get_on_off_next5:


	mov	al,ds:[si]
	and	al,11011111b
	cmp	al,"O"
	jne	get_on_off_next6
	mov	al,ds:[si+1]
	and	al,11011111b
	cmp	al,"N"
	jne	get_on_off_next6
	inc	si
	inc	si
	mov	ax,1
	clc
	ret
get_on_off_next6:
	stc
	ret

get_on_off	endp
;-----------------------------------------------------------------------------
get_dec		proc	near
;
;	get dec
;
;(in)	ds:si = pointer to command line
;
;(out)	carry = 0 : ok
;		ax = number
;
;	carry =	1 : error
;
	push	bx
	push	cx
	push	dx
	push	di
	xor	dx,dx
	xor	ax,ax
	xor	bl,bl			; bl = flag
get_dec_loop:
	mov	bh,ds:[si]
	cmp	bh,cr
	je	get_dec_exit
	sub	bh,"0"			; ic case number
	jc	get_dec_exit
	cmp	bh,9
	ja	get_dec_exit
	inc	si
	mov	bl,1			; bl = flag ( 1 = on )


	sal	ax,1			; dx:ax = dx:ax * 10
	rcl	dx,1
	jc	get_dec_overflow
	mov	cx,ax
	mov	di,dx
	sal	ax,1
	rcl	dx,1
	jc	get_dec_overflow
	sal	ax,1
	rcl	dx,1
	jc	get_dec_overflow
	add	ax,cx
	add	dx,di
	jc	get_dec_overflow


	xor	cx,cx			; dx:ax = dx:ax + bh
	mov	cl,bh
	add	ax,cx
	jnc	get_dec_next
	add	dx,1
	jc	get_dec_overflow
get_dec_next:


	mov	cx,dx
	jmp	get_dec_loop
get_dec_exit:
	or	dx,dx
	jne	get_dec_overflow
	or	ah,ah
	jne	get_dec_overflow
	sub	bl,1			; carry = 0
	pop	di
	pop	dx
	pop	cx
	pop	bx
	ret

get_dec_overflow:
	pop	di
	pop	dx
	pop	cx
	pop	bx
	stc
	ret

get_dec		endp
;------------------------------------------------------------------------------
error_main		proc	near
;
;	error main
;
;(in)	ax = error code
;
	cmp	[print_flag],0
	je	error_main_exit
	mov	bx,offset mes_err_tbl
error_main_loop0:
	cmp	[bx],ax
	je	error_main_ok
	add	bx,4
	cmp	bx,offset mes_err_end
	jb	error_main_loop0
	mov	dx,offset mes_err0001
	jmp	error_main_exit
error_main_ok:
	mov	dx,[bx+2]
error_main_exit:
	mov	ah,09h
	int	21h
	mov	ax,04c01h		; error exit
	int	21h
error_main		endp
;-----------------------------------------------------------------------------
;	print
;-----------------------------------------------------------------------------
print_help		proc	near
;
;	usage \
;
	cmp	[print_flag],0
	je	print_help_ret
	cmp	[usage_flag],1
	je	print_help_ret
	mov	[usage_flag],1
	mov	dx,offset mes_usage
	mov	ah,09h
	int	21h
print_help_ret:
	ret
print_help		endp
;-----------------------------------------------------------------------------
print_all_value		proc	near
;
;	print all value
;
	call	print_value_m
	call	print_value_voice
	call	print_value_midi
	call	print_value_cd
	call	print_value_line
	call	print_value_mic
	call	print_value_treble
	call	print_value_bass
	call	print_value_agc
	call	print_value_ipgain
	call	print_value_opgain
	call	print_value_opsw
	call	print_value_iplsw
	call	print_value_iprsw
	ret
print_all_value		endp
;-----------------------------------------------------------------------------
print_value_volume_stereo	proc	near
;
;	print volume ( stereo )
;
;(in)	dx = pointer to string
;	cl = left value
;	ch = right value
;
	push	si
	mov	ah,09h
	int	21h
	mov	si,offset value_volune_stereo
	mov	di,offset strbuff
print_value_volume_stereo_loop0:
	lodsb
	mov	ds:[di],al
	inc	di
	cmp	al,"$"
	jne	print_value_volume_stereo_loop0

	xor	bx,bx
	mov	bl,cl
	shr	bx,4
	mov	[bx+strbuff+8],"O"

	xor	bx,bx
	mov	bl,ch
	shr	bx,4
	mov	[bx+strbuff+34],"O"

	;
	;	print message
	;
	mov	dx,offset strbuff
	mov	ah,09h
	int	21h
	pop	si
	ret
print_value_volume_stereo	endp
;-----------------------------------------------------------------------------
print_value_volume_mono	proc	near
;
;	print volume ( mono )
;
;(in)	dx = pointer to string
;	cl = value
;
	push	si
	mov	ah,09h
	int	21h
	mov	si,offset value_volune_mono
	mov	di,offset strbuff
print_value_volume_mono_loop0:
	lodsb
	mov	ds:[di],al
	inc	di
	cmp	al,"$"
	jne	print_value_volume_mono_loop0

	xor	bx,bx
	mov	bl,cl
	shr	bx,4
	mov	[bx+strbuff+8],"O"

	;
	;	print message
	;
	mov	dx,offset strbuff
	mov	ah,09h
	int	21h
	pop	si
	ret
print_value_volume_mono	endp
;-----------------------------------------------------------------------------
print_gain		proc	near
;
;	print gain
;
;(in)	dx = pointer to string
;	cl = left gain
;	ch = right gain
;
	cmp	[print_flag],0
	je	short print_gain_ret
	push	si
	mov	ah,09h
	int	21h
	mov	si,offset value_gain
	mov	di,offset strbuff
print_gain_loop0:
	lodsb
	mov	ds:[di],al
	inc	di
	cmp	al,"$"
	jne	print_gain_loop0

	shr	cl,6
	mov	al,1
	sal	al,cl
	add	al,"0"
	mov	[strbuff+7],al
	mov	cl,ch
	shr	cl,6
	mov	al,1
	sal	al,cl
	add	al,"0"
	mov	[strbuff+33],al

	;
	;	print message
	;
	mov	dx,offset strbuff
	mov	ah,09h
	int	21h
	pop	si
print_gain_ret:
	ret
print_gain		endp
;-----------------------------------------------------------------------------
print_switch		proc	near
;
;	print switch
;
;(in)	dx = pointer to string
;	al = switch data
;	ah = switch mask
;
	cmp	[print_flag],0
	je	short print_switch_ret
	push	ax
	mov	ah,09h
	int	21h
	pop	ax

	;
	;	midil
	;
	test	ah,01000000b
	je	print_switch_midil_next0
	mov	dx,offset print_switch_midil
	test	al,01000000b
	call	print_switch_sub
	jmp	print_switch_midil_exit
print_switch_midil_next0:
	push	ax
	mov	dx,offset print_switch_midi_non
	mov	ah,09h
	int	21h
	pop	ax
print_switch_midil_exit:


	;
	;	midir
	;
	test	ah,00100000b
	je	print_switch_midir_next0
	mov	dx,offset print_switch_midir
	test	al,00100000b
	call	print_switch_sub
	jmp	print_switch_midir_exit
print_switch_midir_next0:
	push	ax
	mov	dx,offset print_switch_midi_non
	mov	ah,09h
	int	21h
	pop	ax
print_switch_midir_exit:


	;
	;	linel
	;
	mov	dx,offset print_switch_linel
	test	al,00010000b
	call	print_switch_sub


	;
	;	liner
	;
	mov	dx,offset print_switch_liner
	test	al,00001000b
	call	print_switch_sub


	;
	;	cdl
	;
	mov	dx,offset print_switch_cdl
	test	al,00000100b
	call	print_switch_sub


	;
	;	cdr
	;
	mov	dx,offset print_switch_cdr
	test	al,00000010b
	call	print_switch_sub


	;
	;	mic
	;
	mov	dx,offset print_switch_mic
	test	al,00000001b
	call	print_switch_sub


	;
	;	cr, lf
	;
	mov	dl,cr
	mov	ah,02h
	int	21h
	mov	dl,lf
	mov	ah,02h
	int	21h
print_switch_ret:
	ret


print_switch_sub:
	push	ax
	pushf
	mov	ah,09h
	int	21h
	popf
	mov	dx,offset print_switch_on
	jne	print_switch_sub_next0
	mov	dx,offset print_switch_off
print_switch_sub_next0:
	mov	ah,09h
	int	21h
	pop	ax
	ret

print_switch		endp
;-----------------------------------------------------------------------------
print_value_m		proc	near
;
;	print master volume
;
	cmp	[print_flag],0
	je	short print_value_m_ret
	mov	ax,8030h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8031h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_m
	call	print_value_volume_stereo
print_value_m_ret:
	ret
print_value_m		endp
;-----------------------------------------------------------------------------
print_value_voice	proc	near
;
;	print voice volume
;
	cmp	[print_flag],0
	je	short print_value_voice_ret
	mov	ax,8032h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8033h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_voice
	call	print_value_volume_stereo
print_value_voice_ret:
	ret
print_value_voice	endp
;-----------------------------------------------------------------------------
print_value_midi	proc	near
;
;	print midi volume
;
	cmp	[print_flag],0
	je	short print_value_midi_ret
	mov	ax,8034h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8035h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_midi
	call	print_value_volume_stereo
print_value_midi_ret:
	ret
print_value_midi	endp
;-----------------------------------------------------------------------------
print_value_cd		proc	near
;
;	print cd volume
;
	cmp	[print_flag],0
	je	short print_value_cd_ret
	mov	ax,8036h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8037h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_cd
	call	print_value_volume_stereo
print_value_cd_ret:
	ret
print_value_cd		endp
;-----------------------------------------------------------------------------
print_value_line	proc	near
;
;	print line volume
;
	cmp	[print_flag],0
	je	short print_value_line_ret
	mov	ax,8038h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8039h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_line
	call	print_value_volume_stereo
print_value_line_ret:
	ret
print_value_line	endp
;-----------------------------------------------------------------------------
print_value_mic		proc	near
;
;	print mic volume
;
	cmp	[print_flag],0
	je	short print_value_mix_ret
	mov	ax,803Ah
	int	vec_msdrv
	mov	cl,al
	mov	dx,offset value_mic
	call	print_value_volume_mono
print_value_mix_ret:
	ret
print_value_mic		endp
;-----------------------------------------------------------------------------
print_value_treble	proc	near
;
;	print treble volume
;
	cmp	[print_flag],0
	je	short print_value_treble_ret
	mov	ax,8044h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8045h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_treble
	call	print_value_volume_stereo
print_value_treble_ret:
	ret
print_value_treble	endp
;-----------------------------------------------------------------------------
print_value_bass	proc	near
;
;	print bass volume
;
	cmp	[print_flag],0
	je	short print_value_bass_ret
	mov	ax,8046h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8047h
	int	vec_msdrv
	mov	ch,al
	mov	dx,offset value_bass
	call	print_value_volume_stereo
print_value_bass_ret:
	ret
print_value_bass	endp
;-----------------------------------------------------------------------------
print_value_agc		proc	near
;
;	print agc
;
	cmp	[print_flag],0
	je	short print_value_agc_ret
	mov	ax,8043h
	int	vec_msdrv
	mov	dx,offset value_agc_on
	test	al,0001b
	je	print_value_agc_next0
	mov	dx,offset value_agc_off
print_value_agc_next0:
	mov	ah,09h
	int	21h
print_value_agc_ret:
	ret
print_value_agc		endp
;-----------------------------------------------------------------------------
print_value_ipgain	proc	near
;
;	print input gain
;
	cmp	[print_flag],0
	je	short print_value_ipgain_ret
	mov	dx,offset value_ipgain
	mov	ax,803fh
	int	vec_msdrv
	mov	cl,al
	mov	ax,8040h
	int	vec_msdrv
	mov	ch,al
	call	print_gain
print_value_ipgain_ret:
	ret
print_value_ipgain	endp
;-----------------------------------------------------------------------------
print_value_opgain	proc	near
;
;	print output gain
;
	cmp	[print_flag],0
	je	short print_value_opgain_ret
	mov	dx,offset value_opgain
	mov	ax,8041h
	int	vec_msdrv
	mov	cl,al
	mov	ax,8042h
	int	vec_msdrv
	mov	ch,al
	call	print_gain
print_value_opgain_ret:
	ret
print_value_opgain	endp
;-----------------------------------------------------------------------------
print_value_opsw	proc	near
;
;	print output switch
;
	cmp	[print_flag],0
	je	short print_value_opsw_ret
	mov	dx,offset value_opsw
	mov	ax,803Ch
	int	vec_msdrv
	mov	ah,00011111b
	call	print_switch
print_value_opsw_ret:
	ret
print_value_opsw	endp
;-----------------------------------------------------------------------------
print_value_iplsw	proc	near
;
;	print input left switch
;
	cmp	[print_flag],0
	je	short print_value_iplsw_ret
	mov	dx,offset value_iplsw
	mov	ax,803dh
	int	vec_msdrv
	mov	ah,01111111b
	call	print_switch
print_value_iplsw_ret:
	ret
print_value_iplsw	endp
;-----------------------------------------------------------------------------
print_value_iprsw	proc	near
;
;	print input right switch
;
	cmp	[print_flag],0
	je	short print_value_iprsw_ret
	mov	dx,offset value_iprsw
	mov	ax,803eh
	int	vec_msdrv
	mov	ah,01111111b
	call	print_switch
print_value_iprsw_ret:
	ret
print_value_iprsw	endp


;==============================================================================
;==============================================================================
;	msdrv program
;==============================================================================
;==============================================================================
check_msdrv	proc	near
;
;	msdrv 풓Ă邩
;
;(out)	carry = off : msdrv 풓Ă
;	carry = on  : msdrv 풓ĂȂ
;
	pusha
	push	ds
	push	es
	MOV	AX,3500H+VEC_msdrv	;荞݃xN^[E
	INT	21H			;drFaw荞݃xN^[
	mov	di,bx
	inc	di
	inc	di
	MOV	SI,CS
	MOV	DS,SI
	MOV	SI,OFFSET msdrv_TSRID	;crFrhNvOAhX
	MOV	CX,5
	REPE	CMPSB			; ؏풓
	pop	es
	pop	ds
	popa
	jne	check_msdrv_error
	clc
	RET
check_msdrv_error:
	stc
	ret

msdrv_TSRID	db	'MsDRV'
check_msdrv	endp
;==============================================================================
;==============================================================================
;	test program
;==============================================================================
;==============================================================================
if debug
	include \obj\testcom.inc
endif


;==============================================================================
;==============================================================================
;	bss
;==============================================================================
;==============================================================================
strbuff		db	256 dup(?)

;==============================================================================
;==============================================================================
;	data area
;==============================================================================
;==============================================================================
usage_flag		db	0	; usage \
print_flag		db	1	; print flag

;==============================================================================
;==============================================================================
;	const data area
;==============================================================================
;==============================================================================
mes_right	label	byte
db "MSMIXSB v4.5a : mixer for MsDRV4.5 + SoundBlaster16/98",cr,lf
db " Copyright(c)KENJI 1995.1- all rights reserved. programed by KENJI.",cr,lf,"$"
mes_usage	label	byte
db "usage : MSMIXSB [command...]",CR,LF
db "V                     print mixer status",cr,lf
db "Q- / Q+               print off / on",cr,lf
db "R                     initialize mixer",cr,lf
db "Ml[,r]                set master volume                (l,r=0-255)",cr,lf
db "VOCl[,r]              set voice volume                 (l,r=0-255)",cr,lf
db "MIDIl[,r]             set midi volume                  (l,r=0-255)",cr,lf
db "CDl[,r]               set cd volume                    (l,r=0-255)",cr,lf
db "LINEl[,r]             set line volume                  (l,r=0-255)",cr,lf
db "MICm                  set mic volume                     (m=0-255)",cr,lf
db "TREBLEl[,r]           set treble volume                (l,r=0-255)",cr,lf
db "BASSl[,r]             set bass volume                  (l,r=0-255)",cr,lf
db "AGC{on|off}           microphone automatic gain control",cr,lf
db "IPGAINl,[r]           set input gain                 (l,r=1,2,4,8)",cr,lf
db "OPGAINl,[r]           set input gain                 (l,r=1,2,4,8)",cr,lf
db "OPSWmatching{+|-}...  set output mixer switches       (+=on,-=off)",cr,lf
db "                      matching:linel,liner,cdl,cdr,mic",cr,lf
db "IPLSWmatching{+|-}... set input mixer left switches   (+=on,-=off)",cr,lf
db "                      matching:midil,midir,linel,liner,cdl,cdr,mic",cr,lf
db "IPRSWmatching{+|-}... set input mixer right switches  (+=on,-=off)",cr,lf
db "$"

mes_err_tbl	dw	0002,offset mes_err0002
		dw	0003,offset mes_err0003
		dw	0004,offset mes_err0004
		dw	0005,offset mes_err0005
		dw	0006,offset mes_err0006
mes_err_end	label	word

mes_err0001 db "err0001:error",cr,lf,"$"
mes_err0002 db "err0002:MsDRV does not stay",cr,lf,"$"
mes_err0003 db "err0003:need MsDRV ver4.5",cr,lf,"$"
mes_err0004 db "err0004:SoundBlaster16/98 does not exist",cr,lf,"$"
mes_err0005 db "err0005:illegal option",cr,lf,"$"
mes_err0006 db "err0006:illegal value",cr,lf,"$"



value_volune_stereo	label	byte
	db "  left <---------------->  right <---------------->",cr,lf,"$"
value_volune_mono	label	byte
	db "       <---------------->",cr,lf,"$"
value_gain		label	byte
	db "  left                     right  ",cr,lf,"$"

init_mixer		db	"initialized mixer",cr,lf,"$"

print_switch_on		db	"+ $"
print_switch_off	db	"- $"
print_switch_midil	db	"MIDIL$"
print_switch_midir	db	"MIDIR$"
print_switch_midi_non	db	"       $"
print_switch_linel	db	"LINEL$"
print_switch_liner	db	"LINER$"
print_switch_cdl	db	"CDL$"
print_switch_cdr	db	"CDR$"
print_switch_mic	db	"MIC$"

value_m		db	"M:     $"
value_voice	db	"VOC:   $"
value_midi	db	"MIDI:  $"
value_cd	db	"CD:    $"
value_line	db	"LINE:  $"
value_mic	db	"MIC:   $"
value_treble	db	"TREBLE:$"
value_bass	db	"BASS:  $"
value_agc_on	db	"AGC:     ON",cr,lf,"$"
value_agc_off	db	"AGC:     OFF",cr,lf,"$"
value_ipgain	db	"IPGAIN:$"
value_opgain	db	"OPGAIN:$"
value_opsw	db	"OPSW:    $"
value_iplsw	db	"IPLSW:   $"
value_iprsw	db	"IPRSW:   $"


option_data	label	byte
		db	"IPRSW",0
		dw	option_iprsw
		db	"IPLSW",0
		dw	option_iplsw
		db	"OPSW",0
		dw	option_opsw
		db	"OPGAIN",0
		dw	option_opgain
		db	"IPGAIN",0
		dw	option_ipgain
		db	"AGC",0
		dw	option_agc
		db	"VOC",0
		dw	option_voice
		db	"MIDI",0
		dw	option_midi
		db	"CD",0
		dw	option_cd
		db	"LINE",0
		dw	option_line
		db	"MIC",0
		dw	option_mic
		db	"TREBLE",0
		dw	option_treble
		db	"BASS",0
		dw	option_bass
		db	"H",0
		dw	option_h
		db	"V",0
		dw	option_v
		db	"Q",0
		dw	option_q
		db	"R",0
		dw	option_r
		db	"M",0
		dw	option_m
		db	0


matching_data	db	"MIC",0
		db	"CDR",0
		db	"CDL",0
		db	"LINER",0
		db	"LINEL",0
		db	"MIDIR",0
		db	"MIDIL",0
		db	0


code	ends
	end	start
