/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.RetParam;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.Value;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlRPCParse {
    public String firstTagGet(String src) {
        String ret = "";
        String regex = "<.+?>";
        Pattern p = Pattern.compile(regex);
        if (src != null) {
            Matcher m = p.matcher(src);
            if (m.find()) {
                String strFull = m.group();
                ret = strFull.substring(m.start() + 1, m.end() - 1);
            }
        } else {
            ret = null;
        }
        return ret;
    }

    public String[] innerXMLget(String src) {
        String[] retS = new String[]{null, null, null};
        String regex = "<.+?>";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(src);
        if (m.find()) {
            retS[0] = src.substring(m.start() + 1, m.end() - 1);
            int cutStart = m.end();
            int cutEnd = -1;
            int mCount = 0;
            regex = String.valueOf(retS[0]) + ">";
            p = Pattern.compile(regex);
            m = p.matcher(src);
            while (m.find()) {
                if (src.substring(m.start() - 1, m.start()).equals("/")) {
                    if (--mCount != 0) continue;
                    if (m.end() + 1 != src.length()) {
                        retS[2] = src.substring(m.end() + 0, src.length());
                    }
                    cutEnd = m.start() - 2;
                    break;
                }
                ++mCount;
            }
            retS[1] = cutEnd != -1 ? src.substring(cutStart, cutEnd) : null;
        }
        return retS;
    }

    public RetParam getXML(String src) {
        Matcher m;
        Pattern p;
        String regex;
        RetParam temp = null;
        String type = null;
        String[] inXML = this.innerXMLget(src);
        temp = new RetParam();
        temp.tagName = inXML[0];
        temp.innerXML = inXML[1];
        temp.outerXML = inXML[2];
        inXML = null;
        if (temp.tagName.equals("methodName")) {
            temp.value = new Value();
            temp.value.value = temp.innerXML;
        }
        if (temp.tagName.equals("params") && temp.innerXML != null) {
            regex = "<param>";
            p = Pattern.compile(regex);
            m = p.matcher(temp.innerXML);
            int paramCount = 0;
            while (m.find()) {
                ++paramCount;
            }
            if (paramCount > 1) {
                temp.params = new RetParam[paramCount];
                String tempSrc = temp.innerXML;
                int i = 0;
                while (i < paramCount) {
                    String[] retParam = this.innerXMLget(tempSrc);
                    temp.params[i] = this.getXML(retParam[1]);
                    tempSrc = retParam[2];
                    ++i;
                }
            }
        }
        if (temp.tagName.equals("value") && temp.innerXML != null) {
            type = this.firstTagGet(temp.innerXML);
            if (type.equals("i4") || type.equals("int") || type.equals("boolean") || type.equals("string") || type.equals("double") || type.equals("dateTime.iso8601") || type.equals("base64")) {
                temp.value = this.getValue(temp.innerXML);
                return temp;
            }
            type = null;
        } else if (temp.tagName.equals("array") && temp.innerXML != null) {
            type = this.firstTagGet(temp.innerXML);
            if (type.equals("data")) {
                inXML = this.innerXMLget(temp.innerXML);
                if (inXML[1].equals("")) {
                    temp.innerXML = null;
                    temp.tagName = "empty";
                } else {
                    while ("value".equals((inXML = this.innerXMLget(inXML[1]))[0]) && type != null) {
                        Value[] arrayTemp;
                        String[] arrayXML = this.innerXMLget(inXML[1]);
                        if (arrayXML[0].equals("i4") || arrayXML[0].equals("int") || arrayXML[0].equals("boolean") || arrayXML[0].equals("string") || arrayXML[0].equals("double") || arrayXML[0].equals("dateTime.iso8601") || arrayXML[0].equals("base64")) {
                            if (temp.array != null) {
                                arrayTemp = temp.array;
                                temp.array = new Value[arrayTemp.length + 1];
                                System.arraycopy(arrayTemp, 0, temp.array, 0, arrayTemp.length);
                                arrayTemp = null;
                            } else {
                                temp.array = new Value[1];
                            }
                            int a = temp.array.length - 1;
                            temp.array[a] = new Value();
                            temp.array[a] = this.getValue(inXML[1]);
                        } else if (arrayXML[0].equals("struct")) {
                            if (temp.array != null) {
                                arrayTemp = temp.array;
                                temp.array = new Value[arrayTemp.length + 1];
                                System.arraycopy(arrayTemp, 0, temp.array, 0, arrayTemp.length);
                                arrayTemp = null;
                            } else {
                                temp.array = new Value[1];
                            }
                            int a = temp.array.length - 1;
                            temp.array[a] = new Value();
                            temp.array[a].values = this.getStructs("<struct>" + arrayXML[1] + "</struct>");
                        }
                        inXML[1] = inXML[2];
                        if (inXML[1] != null) continue;
                    }
                    temp.innerXML = null;
                }
            }
        } else if (temp.tagName.equals("struct") && temp.innerXML != null) {
            temp.structs = this.getStructs("<struct>" + temp.innerXML + "</struct>");
            temp.innerXML = null;
        } else if (temp.tagName.equals("fault") && temp.innerXML != null) {
            temp.child = this.getXML(temp.innerXML);
            return temp;
        }
        regex = "<.+?>";
        p = Pattern.compile(regex);
        if (temp.innerXML != null && (m = p.matcher(temp.innerXML)).find()) {
            temp.child = this.getXML(temp.innerXML);
        }
        if (temp.outerXML != null && (m = p.matcher(temp.outerXML)).find()) {
            temp.brother = this.getXML(temp.outerXML);
        }
        return temp;
    }

    public Value[] getStructs(String src) {
        Value[] retV = null;
        String type = this.firstTagGet(src);
        if ("struct".equals(type)) {
            String[] member = this.innerXMLget(src);
            int retC = -1;
            while ("member".equals(type = this.firstTagGet(member[1])) && type != null) {
                if (retV != null) {
                    Value[] temp = retV;
                    retV = new Value[temp.length + 1];
                    System.arraycopy(temp, 0, retV, 0, temp.length);
                    retC = temp.length;
                    temp = null;
                } else {
                    retV = new Value[1];
                    retC = 0;
                }
                member = this.innerXMLget(member[1]);
                retV[retC] = new Value();
                String regex = "<name>.+?</name>";
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(member[1]);
                if (m.find()) {
                    retV[retC].name = member[1].substring(m.start() + 6, m.end() - 7);
                }
                if ((m = (p = Pattern.compile(regex = "<value>.+?</value>")).matcher(member[1])).find()) {
                    String[] get = this.innerXMLget(member[1].substring(m.start() + 7, m.end() - 8));
                    if (get[0].equals("array")) {
                        regex = "<array>.+?</array>";
                        p = Pattern.compile(regex);
                        m = p.matcher(member[1]);
                        if (m.find()) {
                            String[] inArray = this.innerXMLget(member[1].substring(m.start() + 7, m.end() - 8));
                            retV[retC].type = get[0];
                            if (inArray[0].equals("data")) {
                                if (inArray[1].equals("") || inArray[1].equals("<value></value>")) {
                                    retV[retC].value = "empty";
                                    retV[retC].values = null;
                                } else {
                                    retV[retC].value = null;
                                    retV[retC].values = this.getArray(inArray[1]);
                                }
                            }
                        }
                    } else if (get[0].equals("struct")) {
                        if (get[0] != null) {
                            retV[retC].type = get[0];
                        }
                        if (get[1] != null) {
                            retV[retC].value = get[1];
                        }
                        if ((m = (p = Pattern.compile(regex = "<struct>.+?</struct>")).matcher(member[1])).find()) {
                            String[] inStruct = this.innerXMLget("<struct>" + member[1].substring(m.start() + 8));
                            retV[retC].values = this.getStructs("<struct>" + inStruct[1] + "</struct>");
                        }
                    } else {
                        retV[retC].type = get[0];
                        retV[retC].value = get[1];
                    }
                }
                member[1] = member[2];
                if (member[1] != null) continue;
            }
        }
        return retV;
    }

    private Value[] getArray(String src) {
        RetParam temp = new RetParam();
        String[] inXML = new String[3];
        inXML[1] = src;
        while ("value".equals((inXML = this.innerXMLget(inXML[1]))[0])) {
            int a;
            String[] arrayXML = this.innerXMLget(inXML[1]);
            if (arrayXML[0].equals("i4") || arrayXML[0].equals("int") || arrayXML[0].equals("boolean") || arrayXML[0].equals("string") || arrayXML[0].equals("double") || arrayXML[0].equals("dateTime.iso8601") || arrayXML[0].equals("base64")) {
                if (temp.array != null) {
                    Value[] arrayTemp = temp.array;
                    temp.array = new Value[arrayTemp.length + 1];
                    System.arraycopy(arrayTemp, 0, temp.array, 0, arrayTemp.length);
                    arrayTemp = null;
                } else {
                    temp.array = new Value[1];
                }
                a = temp.array.length - 1;
                temp.array[a] = new Value();
                temp.array[a] = this.getValue(inXML[1]);
            } else if (arrayXML[0].equals("struct")) {
                if (temp.array != null) {
                    Value[] arrayTemp = temp.array;
                    temp.array = new Value[arrayTemp.length + 1];
                    System.arraycopy(arrayTemp, 0, temp.array, 0, arrayTemp.length);
                    arrayTemp = null;
                } else {
                    temp.array = new Value[1];
                }
                a = temp.array.length - 1;
                temp.array[a] = new Value();
                temp.array[a].values = this.getStructs("<struct>" + arrayXML[1] + "</struct>");
            }
            inXML[1] = inXML[2];
            if (inXML[1] == null) break;
            temp.innerXML = null;
        }
        return temp.array;
    }

    public Value getValue(String src) {
        Value retV = new Value();
        String type = this.firstTagGet(src);
        if (type.equals("i4") || type.equals("int") || type.equals("boolean") || type.equals("string") || type.equals("double") || type.equals("dateTime.iso8601") || type.equals("base64")) {
            retV.type = type;
            String regex = ">.+?<";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(src);
            if (m.find()) {
                retV.value = src.substring(m.start() + 1, m.end() - 1);
            }
            regex = null;
            p = null;
            m = null;
            type = null;
        }
        return retV;
    }

    public synchronized Value[] returnMethodCalls(RetParam rp) {
        int i;
        if (rp == null) {
            return null;
        }
        Value[] ret = null;
        Value rValue = null;
        if (rp.child != null && rp.child.brother != null) {
            rValue = this.returnValues(rp.child.brother);
        }
        Value[] rArray = null;
        if (rp.child != null && rp.child.brother != null) {
            rArray = this.returnArray(rp.child.brother);
        }
        Value[] rStruct = null;
        if (rp.child != null && rp.child.brother != null) {
            rStruct = this.returnStruct(rp.child.brother);
        }
        Value[] rFault = null;
        if (rp.child != null && rp.child.brother != null) {
            rFault = this.returnFault(rp.child.brother);
        }
        Value[] rParams = null;
        if (rp.child != null && rp.child.brother != null) {
            rParams = this.returnParams(rp.child.brother);
        }
        if (rValue != null) {
            ret = new Value[]{rValue};
            if (rParams != null && rParams.length > 1) {
                ret = null;
                ret = rParams;
            }
        } else if (rArray != null) {
            ret = rArray;
        } else if (rStruct != null) {
            ret = rStruct;
        } else if (rFault != null) {
            ret = rFault;
        }
        String mes = "";
        if (rValue != null && StartUp.debugF) {
            mes = String.valueOf(mes) + "Response : value\n\t" + StartUp.tool.getCleanText(rValue.value, false) + this.returnTypeString(rValue.type) + "\n";
        }
        if (rParams != null && StartUp.debugF) {
            mes = String.valueOf(mes) + "Response : params\n";
            i = 0;
            while (i < rParams.length) {
                if (rParams[i] != null && rParams[i].value != null) {
                    mes = String.valueOf(mes) + "\t" + i + " : " + StartUp.tool.getCleanText(rParams[i].value, false) + this.returnTypeString(rParams[i].type) + "\n";
                }
                ++i;
            }
        }
        if (rArray != null && StartUp.debugF) {
            mes = String.valueOf(mes) + "Response : array\n";
            i = 0;
            while (i < rArray.length) {
                if (rArray[i].value != null) {
                    mes = String.valueOf(mes) + "\t" + i + " : " + StartUp.tool.getCleanText(rArray[i].value, false) + this.returnTypeString(rArray[i].type) + "\n";
                } else if (rArray[i].values != null) {
                    int ii = 0;
                    while (ii < rArray[i].values.length) {
                        mes = String.valueOf(mes) + "\t" + i + "-" + ii + " : " + rArray[i].values[ii].name + " : " + StartUp.tool.getCleanText(rArray[i].values[ii].value, false) + this.returnTypeString(rArray[i].values[ii].type) + "\n";
                        ++ii;
                    }
                }
                ++i;
            }
            if (rArray[0].name != null) {
                mes = String.valueOf(mes) + "\tEmpty array!\n";
            }
        }
        if (rStruct != null && StartUp.debugF) {
            mes = String.valueOf(mes) + "Response : struct\n";
            i = 0;
            while (i < rStruct.length) {
                mes = String.valueOf(mes) + "\t" + i + " :  ";
                mes = rStruct[i].name != null ? String.valueOf(mes) + rStruct[i].name + "  :  " : String.valueOf(mes) + "<<No name>> : ";
                mes = rStruct[i].value != null ? String.valueOf(mes) + StartUp.tool.getCleanText(rStruct[i].value, false) : String.valueOf(mes) + "<<No value>> : ";
                mes = rStruct[i].type != null ? String.valueOf(mes) + this.returnTypeString(rStruct[i].type) + "\n" : String.valueOf(mes) + "<<No type>>\n";
                if (rStruct[i].values != null) {
                    mes = String.valueOf(mes) + this.returnInnerStruct(rStruct[i].values, "\t\t" + i + " >");
                }
                ++i;
            }
        }
        rStruct = null;
        if (rp.child != null && rp.child.brother != null && rp.child.brother.child != null && rp.child.brother.child.brother != null) {
            rStruct = this.returnStruct(rp.child.brother.child.brother);
        }
        if (rStruct != null && StartUp.debugF) {
            mes = String.valueOf(mes) + "Response : struct\n";
            i = 0;
            while (i < rStruct.length) {
                mes = String.valueOf(mes) + "\t" + i + " :  ";
                mes = rStruct[i].name != null ? String.valueOf(mes) + rStruct[i].name + "  :  " : String.valueOf(mes) + "<<No name>> : ";
                mes = rStruct[i].value != null ? String.valueOf(mes) + StartUp.tool.getCleanText(rStruct[i].value, false) : String.valueOf(mes) + "<<No value>> : ";
                mes = rStruct[i].type != null ? String.valueOf(mes) + this.returnTypeString(rStruct[i].type) + "\n" : String.valueOf(mes) + "<<No type>>\n";
                if (rStruct[i].values != null) {
                    mes = String.valueOf(mes) + this.returnInnerStruct(rStruct[i].values, "\t\t" + i + " >");
                }
                ++i;
            }
        }
        if (rFault != null && StartUp.debugF) {
            mes = String.valueOf(mes) + "Response : fault\n";
            i = 0;
            while (i < rFault.length) {
                mes = String.valueOf(mes) + "\t" + i + " :  " + rFault[i].name + "  :  " + StartUp.tool.getCleanText(rFault[i].value, false) + this.returnTypeString(rFault[i].type) + "\n";
                ++i;
            }
        }
        if (ret != null) {
            ret[0].debugMessage = mes;
        }
        rValue = null;
        rArray = null;
        rStruct = null;
        rFault = null;
        mes = null;
        return ret;
    }

    public Value[] returnParams(RetParam rp) {
        if (rp == null) {
            return null;
        }
        Value[] ret = null;
        if (rp.tagName.equals("params") && rp.params != null) {
            ret = new Value[rp.params.length];
            int i = 0;
            while (i < rp.params.length) {
                ret[i] = rp.params[i].value;
                ++i;
            }
        } else if (rp.child != null) {
            ret = this.returnParams(rp.child);
        } else if (rp.brother != null) {
            ret = this.returnParams(rp.brother);
        }
        return ret;
    }

    private Value[] addValues(Value[] vs) {
        Value[] ret;
        Value[] temp = vs;
        if (vs != null) {
            ret = new Value[temp.length + 1];
            System.arraycopy(temp, 0, ret, 0, temp.length);
            temp = null;
        } else {
            ret = new Value[1];
        }
        return ret;
    }

    public Value returnValues(RetParam rp) {
        Value ret = null;
        if (rp.tagName.equals("value") && rp.value != null) {
            ret = rp.value;
        } else if (rp.child != null) {
            ret = this.returnValues(rp.child);
        }
        return ret;
    }

    public Value[] returnStruct(RetParam rp) {
        Value[] ret = null;
        if (rp.tagName.equals("struct") && rp.structs != null) {
            ret = rp.structs;
        } else if (rp.child != null) {
            ret = this.returnStruct(rp.child);
        }
        return ret;
    }

    public Value[] returnArray(RetParam rp) {
        Value[] ret = null;
        if (rp.tagName.equals("empty")) {
            ret = new Value[]{new Value()};
            ret[0].value = "empty";
            ret[0].type = "String";
            ret[0].name = "empty";
        } else if (rp.tagName.equals("array") && rp.array != null) {
            ret = rp.array;
        } else if (rp.child != null) {
            ret = this.returnArray(rp.child);
        }
        return ret;
    }

    public Value[] returnFault(RetParam rp) {
        Value[] ret = null;
        if (rp.tagName.equals("fault") && rp.child != null) {
            ret = this.returnStruct(rp.child);
        } else if (rp.child != null) {
            ret = this.returnFault(rp.child);
        }
        return ret;
    }

    public String returnMethodName(RetParam rp) {
        String ret = null;
        if (rp.tagName.equals("methodName") && rp.innerXML != null) {
            ret = rp.innerXML;
        } else if (rp.child != null) {
            ret = this.returnMethodName(rp.child);
        }
        return ret;
    }

    public boolean chkMethodResponse(RetParam rp) {
        boolean ret = false;
        if (rp.tagName.equals("methodResponse")) {
            ret = true;
        } else if (rp.child != null) {
            ret = this.chkMethodResponse(rp.child);
        }
        return ret;
    }

    public boolean chkMethodCall(RetParam rp) {
        boolean ret = false;
        if (rp.tagName.equals("methodCall")) {
            ret = true;
        } else if (rp.child != null) {
            ret = this.chkMethodCall(rp.child);
        }
        return ret;
    }

    public void showParam(RetParam xml, String sp) {
        if (xml.tagName != null) {
            System.out.println(String.valueOf(sp) + " tag:" + xml.tagName);
        }
        if (xml.array != null) {
            int i = 0;
            while (i < xml.array.length) {
                System.out.println(String.valueOf(sp) + " ---------- Array " + i + "----------");
                if (xml.array[i].value != null) {
                    System.out.println(String.valueOf(sp) + " \u25b8Array " + i + " Value : " + xml.array[i].value + " ( " + xml.array[i].type + " )");
                } else if (xml.array[i].values != null) {
                    int ii = 0;
                    while (ii < xml.array[i].values.length) {
                        System.out.println(String.valueOf(sp) + " \u25b8Array " + i + " Struct " + ii + " : " + xml.array[i].values[ii].name + " >> " + xml.array[i].values[ii].value + " ( " + xml.array[i].values[ii].type + " )");
                        ++ii;
                    }
                }
                ++i;
            }
        }
        if (xml.child != null) {
            this.showParam(xml.child, String.valueOf(sp) + ">");
        }
    }

    public RetParam responseRead(String src) {
        String regex = "\r\n|\n";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(src);
        src = m.replaceAll("");
        regex = "<\\?.+?\\?>";
        p = Pattern.compile(regex);
        m = p.matcher(src);
        if (m.find()) {
            src = src.substring(m.end(), src.length());
        }
        RetParam ret = this.getXML(src);
        ret.typeName = this.returnMethodName(ret);
        return ret;
    }

    private String returnTypeString(String src) {
        String ret = "";
        if (src.equals("boolean") || src.equals("i4") || src.equals("int") || src.equals("base64")) {
            ret = "  ( " + src + " )  ";
        }
        return ret;
    }

    private String returnInnerStruct(Value[] v, String spacer) {
        String ret = "";
        if (v != null) {
            int i = 0;
            while (i < v.length) {
                ret = String.valueOf(ret) + spacer + " " + i + " : ";
                ret = v[i].name != null ? String.valueOf(ret) + v[i].name + "  :  " : String.valueOf(ret) + "<<No name>> : ";
                ret = v[i].value != null ? String.valueOf(ret) + v[i].value : String.valueOf(ret) + "<<No value>> : ";
                ret = v[i].type != null ? String.valueOf(ret) + this.returnTypeString(v[i].type) + "\n" : String.valueOf(ret) + "<<No type>>\n";
                if (v[i].values != null) {
                    ret = String.valueOf(ret) + this.returnInnerStruct(v[i].values, String.valueOf(spacer) + " " + i + " >");
                }
                ++i;
            }
        }
        return String.valueOf(ret) + "\n";
    }
}

