/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.resXML;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLParser {
    SVCMainThread svc;

    public XMLParser(SVCMainThread s) {
        this.svc = s;
        s = null;
    }

    public String showResValue(resXML x, String head) {
        int i;
        String ret = "";
        if (x.value != null || x.type != null || x.name != null) {
            ret = String.valueOf(head) + " : [" + x.name + "] " + x.value + " <" + x.type + ">";
        }
        if (x.chkArray) {
            i = 0;
            while (i < x.array.length) {
                ret = this.showResValue(x.array[i], String.valueOf(head) + " - array[" + i + "]");
                ++i;
            }
        }
        if (x.chkStruct) {
            i = 0;
            while (i < x.struct.length) {
                ret = this.showResValue(x.struct[i], String.valueOf(head) + " - struct[" + i + "]");
                ++i;
            }
        }
        return ret;
    }

    public String showResXML(resXML x) {
        if (x == null) {
            return "";
        }
        String ret = "";
        if (x.param != null) {
            int i = 0;
            while (i < x.param.length) {
                ret = String.valueOf(ret) + "\t" + this.showResValue(x.param[i], "param[" + i + "]");
                ++i;
            }
        }
        return ret;
    }

    public String showResXML(resXML x, int num) {
        if (x == null) {
            return "";
        }
        if (!StartUp.debugDedi) {
            return "";
        }
        String ret = "";
        if (x.param != null) {
            ret = String.valueOf(ret) + "\t[ WritePoint " + num + " ]\n";
            int i = 0;
            while (i < x.param.length) {
                ret = String.valueOf(ret) + "\t" + this.showResValue(x.param[i], "param[" + i + "]");
                ++i;
            }
        }
        return ret;
    }

    public String showResValueDeb(resXML x, String head) {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ret = "";
        if (x.value != null || x.type != null || x.name != null) {
            ret = String.valueOf(head) + " : [" + x.name + "] " + x.value + " <" + x.type + ">";
        }
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (x.chkArray && x.array != null) {
            int i = 0;
            while (i < x.array.length) {
                ret = this.showResValueDeb(x.array[i], String.valueOf(head) + " - array[" + i + "]");
                ++i;
            }
        }
        if (x.chkStruct && x.struct != null) {
            int i = 0;
            while (i < x.struct.length) {
                ret = this.showResValueDeb(x.struct[i], String.valueOf(head) + " - struct[" + i + "]");
                ++i;
            }
        }
        return ret;
    }

    public String showResXMLDeb(resXML x) {
        if (x == null) {
            return "";
        }
        String ret = "";
        if (x.param != null) {
            int i = 0;
            while (i < x.param.length) {
                ret = String.valueOf(ret) + "\t" + this.showResValueDeb(x.param[i], "param[" + i + "]");
                ++i;
            }
        }
        return ret;
    }

    public String[] retTargetXML(String xml, String target) {
        String[] ret = new String[]{null, null};
        if (xml == null || target == null) {
            return ret;
        }
        String regex = "(?i)<" + target + ">";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(xml);
        if (m.find()) {
            int cutStart = m.end();
            int cutEnd = -1;
            int mCount = 0;
            regex = "(?i)" + target + ">";
            p = Pattern.compile(regex);
            m = p.matcher(xml);
            while (m.find()) {
                if (xml.substring(m.start() - 1, m.start()).equals("/")) {
                    if (--mCount != 0) continue;
                    if (m.end() + 1 != xml.length()) {
                        ret[1] = xml.substring(m.end(), xml.length());
                    }
                    cutEnd = m.start() - 2;
                    break;
                }
                ++mCount;
            }
            ret[0] = cutEnd != -1 ? xml.substring(cutStart, cutEnd) : null;
        }
        return ret;
    }

    public String ret1stTAG(String xml) {
        String ret = null;
        if (xml == null) {
            return ret;
        }
        String regex = "<.+?>";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(xml);
        if (m.find()) {
            ret = xml.substring(m.start() + 1, m.end() - 1);
        }
        return ret;
    }

    public String getMethodName(String xml) {
        String ret = null;
        String chkTarget = this.retTargetXML(xml, "methodCall")[0];
        if (chkTarget != null) {
            ret = this.retTargetXML(chkTarget, "methodName")[0];
        }
        return ret;
    }

    public resXML getParams(String xml) {
        resXML ret = new resXML();
        String chkTarget = this.retTargetXML(xml, "params")[0];
        if (chkTarget != null) {
            ret = this.getParam(chkTarget);
        }
        return ret;
    }

    public resXML getParam(String xml) {
        resXML ret = new resXML();
        if (xml == null) {
            return ret;
        }
        String[] chkTarget = new String[]{null, xml};
        while ((chkTarget = this.retTargetXML(chkTarget[1], "param"))[0] != null) {
            if (chkTarget[0] != null) {
                ret.addParam(this.getValue(this.retTargetXML(chkTarget[0], "value")[0]));
            }
            if (chkTarget[1] != null) continue;
        }
        return ret;
    }

    public String getName(String xml) {
        String ret = null;
        String chkTarget = this.retTargetXML(xml, "name")[0];
        if (chkTarget != null) {
            ret = this.retTargetXML(chkTarget, "name")[0];
        }
        return ret;
    }

    public resXML getMember(String xml) {
        String tag;
        resXML ret = new resXML();
        if (xml == null) {
            return ret;
        }
        String[] chk = new String[]{null, xml};
        String name = null;
        while ((chk = this.retTargetXML(chk[1], tag = this.ret1stTAG(chk[1])))[0] != null) {
            if (tag.equals("name")) {
                name = chk[0];
            }
            if (tag.equals("value")) {
                ret = this.getValue(chk[0]);
            }
            if (chk[1] != null) continue;
        }
        ret.name = name;
        name = null;
        chk = null;
        return ret;
    }

    public resXML getValue(String xml) {
        resXML ret = new resXML();
        if (xml == null) {
            return ret;
        }
        String tag = this.ret1stTAG(xml);
        if (tag.equals("i4") || tag.equals("int") || tag.equals("boolean") || tag.equals("string") || tag.equals("double") || tag.equals("dateTime.iso8601") || tag.equals("base64")) {
            ret.type = tag;
            if (ret.type != null) {
                ret.value = this.retTargetXML(xml, ret.type)[0];
            }
        } else if (tag.equals("array")) {
            ret.copyArray(this.getArray((String)this.retTargetXML((String)xml, (String)"array")[0]).array);
        } else if (tag.equals("struct")) {
            ret.copyStruct(this.getStruct((String)this.retTargetXML((String)xml, (String)"struct")[0]).struct);
        }
        return ret;
    }

    public resXML getArray(String xml) {
        resXML ret = new resXML();
        if (xml == null) {
            return ret;
        }
        if (this.ret1stTAG(xml).equals("data")) {
            String[] data = this.retTargetXML(xml, "data");
            data[1] = data[0];
            while ((data = this.retTargetXML(data[1], "value"))[0] != null) {
                if (data[0] != null) {
                    ret.addArray(this.getValue(data[0]));
                }
                if (data[1] != null) continue;
            }
        }
        return ret;
    }

    public resXML getStruct(String xml) {
        resXML ret = new resXML();
        if (xml == null) {
            return ret;
        }
        String[] member = new String[]{null, xml};
        while ((member = this.retTargetXML(member[1], "member"))[0] != null) {
            String chkTAG = this.ret1stTAG(member[0]);
            if (chkTAG.equals("name") || chkTAG.equals("value") || chkTAG.equals("name")) {
                ret.addStruct(this.getMember(member[0]));
            }
            if (member[1] != null) continue;
        }
        member = null;
        return ret;
    }
}

