/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.ParamClass;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLcheckerThread
extends Thread {
    private String target;
    private boolean loop;
    private boolean chk;
    public boolean locMux = false;
    public boolean special = false;
    private ParamClass[] header;
    private ParamClass[] deps;
    private SVCMainThread svc;

    public URLcheckerThread(SVCMainThread s) {
        this.svc = s;
        s = null;
        this.target = "";
        this.loop = false;
        this.chk = false;
    }

    public URLcheckerThread(SVCMainThread s, String file) {
        this.svc = s;
        s = null;
        this.target = "";
        this.loop = false;
        this.chk = false;
        if (!file.startsWith(this.svc.cdc.mapRootDir)) {
            file = String.valueOf(this.svc.cdc.mapRootDir) + file;
        }
        this.target = this.readFile(file);
    }

    public URLcheckerThread() {
        this.target = "";
        this.loop = false;
        this.chk = false;
    }

    public boolean getCheck() {
        if (this.special) {
            this.chk = this.svc.cdc.nowCM.forceMusicSet[7].equals("false");
            return this.chk;
        }
        this.loop = true;
        this.chk = false;
        if (this.target == null) {
            return false;
        }
        if (this.target.length() < 15) {
            return false;
        }
        this.start();
        int count = 0;
        while (this.loop) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (++count <= 2000) continue;
            this.chk = false;
            break;
        }
        this.target = null;
        return this.chk;
    }

    public boolean getCheck(String tar) {
        this.target = tar;
        this.loop = true;
        this.chk = false;
        this.start();
        while (this.loop) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.target = null;
        return this.chk;
    }

    @Override
    public void run() {
        this.chk = false;
        String temp = this.target.substring(7, 14);
        if (!temp.equals("loda.jp")) {
            try {
                URL url = new URL(this.target);
                InputStream in = url.openStream();
                URLConnection urlConnection = url.openConnection();
                urlConnection.connect();
                long fileSize = urlConnection.getContentLength();
                this.chk = fileSize >= 150000L;
                urlConnection = null;
                in.close();
                in = null;
                url = null;
            }
            catch (MalformedURLException e) {
                this.chk = false;
            }
            catch (FileNotFoundException e) {
                this.chk = false;
            }
            catch (IOException e) {
                this.chk = false;
            }
        }
        temp = null;
        this.loop = false;
    }

    public String[] readOGGhead(String fileName) {
        if (!fileName.toLowerCase().substring(fileName.length() - 3).equals("ogg")) {
            return null;
        }
        String[] rets = null;
        File targetFile = new File(fileName);
        try {
            FileInputStream fileStream = new FileInputStream(targetFile);
            BufferedInputStream bufferStream = new BufferedInputStream(fileStream);
            int size = fileStream.available();
            byte[] buffer = new byte[size];
            int len = bufferStream.read(buffer);
            String ret = new String(buffer, "UTF-8");
            String regex = "\\x00[^\\x00]+=[^\\x00]+\\x00";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(ret.substring(0, 500));
            while (m.find()) {
                if (rets == null) {
                    rets = new String[2];
                }
                String temp = m.group().replaceAll("\\x00", "");
                temp = temp.substring(0, temp.length() - 1);
                StartUp.print("vorbis header : " + temp);
                if (temp.length() > 6) {
                    if (temp.substring(0, 7).equals("ARTIST=")) {
                        rets[0] = temp.replaceAll("ARTIST=", "");
                    } else if (temp.substring(0, 7).equals("artist=")) {
                        rets[0] = temp.replaceAll("artist=", "");
                    }
                }
                if (temp.length() > 5) {
                    if (temp.substring(0, 6).equals("TITLE=")) {
                        rets[1] = temp.replaceAll("TITLE=", "");
                    } else if (temp.substring(0, 6).equals("title=")) {
                        rets[1] = temp.replaceAll("title=", "");
                    }
                }
                temp = null;
            }
            bufferStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rets;
    }

    private String readFile(String fileName) {
        String retURL = null;
        this.header = null;
        this.deps = null;
        File targetFile = new File(fileName);
        try {
            FileInputStream fileStream = new FileInputStream(targetFile);
            BufferedInputStream bufferStream = new BufferedInputStream(fileStream);
            int size = fileStream.available();
            byte[] buffer = new byte[size];
            int len = bufferStream.read(buffer);
            String ret = new String(buffer, "UTF-8");
            String head = "";
            String regex = "<header.+</header>";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(ret);
            if (m.find()) {
                head = m.group();
                head = head.replaceAll("mapstyle=\"\"", "");
                head = head.replaceAll("mod=\"\"", "");
            }
            regex = "<deps>.+?</deps>";
            p = Pattern.compile(regex);
            m = p.matcher(head);
            String depsText = "";
            if (m.find()) {
                depsText = m.group();
                depsText = depsText.replace("<deps>", "");
                depsText = depsText.replace("</deps>", "");
                head = m.replaceAll("");
                head = head.replace("</header>", "");
            }
            this.header = this.getParams(head);
            if (this.header == null) {
                return retURL;
            }
            this.deps = this.getParams(depsText);
            if (this.deps != null) {
                int i = 0;
                while (i < this.deps.length) {
                    if (this.deps[i] != null && this.deps[i].params != null) {
                        int pi = 0;
                        while (pi < this.deps[i].params.length) {
                            if (this.svc.cdc.tmVersion == 1) {
                                regex = "ChallengeMusics";
                            } else if (this.svc.cdc.tmVersion == 2) {
                                regex = "Media\\\\Musics";
                            }
                            p = Pattern.compile(regex);
                            m = p.matcher(this.deps[i].params[pi].value);
                            if (m.find()) {
                                if (this.deps[i].params.length > 1) {
                                    retURL = this.deps[i].params[pi + 1].value;
                                    this.locMux = true;
                                    this.special = false;
                                } else {
                                    this.special = true;
                                }
                            }
                            ++pi;
                        }
                    }
                    ++i;
                }
            }
            bufferStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retURL;
    }

    private ParamClass[] getParams(String head) {
        ParamClass[] header = null;
        String[] target = null;
        String regex = "<.+?>";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(head);
        while (m.find()) {
            if (target == null) {
                target = new String[]{m.group()};
                continue;
            }
            String[] copy = new String[target.length + 1];
            System.arraycopy(target, 0, copy, 0, target.length);
            target = null;
            target = new String[copy.length];
            System.arraycopy(copy, 0, target, 0, copy.length);
            target[target.length - 1] = m.group();
            copy = null;
        }
        if (target != null) {
            header = new ParamClass[target.length];
            int i = 0;
            while (i < target.length) {
                regex = "<.+? ";
                p = Pattern.compile(regex);
                m = p.matcher(target[i]);
                if (m.find()) {
                    String src = m.group();
                    String param = m.replaceAll("");
                    header[i] = new ParamClass(src, param);
                    src = null;
                    param = null;
                }
                ++i;
            }
        }
        target = null;
        regex = null;
        p = null;
        m = null;
        head = null;
        return header;
    }
}

