/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.FileControl;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.UPnPMultiCaster;
import hir.westfield.tm.UPnPPortMappingData;
import hir.westfield.tm.UPnPSocketCaster;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UPnPThread
extends Thread
implements ActionListener,
WindowListener {
    public String localHostAddress;
    public String rootdeviceAddress;
    public String controlURL;
    public String baseURL;
    public String serviceType;
    public String scpdURL;
    private String windowType;
    public String urlFront;
    public String urlRear;
    private String[] xmlTag;
    private String[] xmlValue;
    private String[] httpRes;
    public String stringAddAction;
    public String stringDelAction;
    public String stringMapEntry;
    public String stringPortMappingIndex;
    public String stringRemoteHost;
    public String stringExternalPort;
    public String stringProtocol;
    public String stringInternalPort;
    public String stringInternalClient;
    public String stringEnabled;
    public String stringPortMappingDescription;
    public String stringLeaseDuration;
    public UPnPPortMappingData[] openPort;
    private final int limitSet = 600;
    private FileControl upnpOpen;
    public JList addressList;
    public JScrollPane addressPane;
    public int listIndex;
    private JButton selectAddress;
    private boolean selectLoop;
    private boolean retBoolean;
    public String xmlStart;
    private String xmlEnd;
    public boolean finished;
    public boolean dispose;
    public boolean startOK;
    private String borderNormal = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";

    public void UPnpThread() {
        this.windowType = "";
        this.localHostAddress = null;
        this.rootdeviceAddress = null;
        this.controlURL = null;
        this.baseURL = null;
        this.serviceType = null;
        this.scpdURL = null;
        this.urlFront = null;
        this.urlRear = null;
        this.httpRes = null;
        this.stringAddAction = null;
        this.stringDelAction = null;
        this.stringMapEntry = null;
        this.stringPortMappingIndex = null;
        this.stringRemoteHost = null;
        this.stringExternalPort = null;
        this.stringProtocol = null;
        this.stringInternalPort = null;
        this.stringInternalClient = null;
        this.stringEnabled = null;
        this.stringPortMappingDescription = null;
        this.stringLeaseDuration = null;
        this.openPort = null;
        this.upnpOpen = null;
        this.dispose = false;
        this.finished = true;
        this.startOK = false;
    }

    public void setXML() {
        this.xmlStart = "";
        this.xmlStart = String.valueOf(this.xmlStart) + "<?xml version=\"1.0\"?>\r\n";
        this.xmlStart = String.valueOf(this.xmlStart) + "<SOAP-ENV:Envelope xmlns:SOAP-ENV:=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n";
        this.xmlStart = String.valueOf(this.xmlStart) + "<SOAP-ENV:Body>\r\n";
        this.xmlEnd = "";
        this.xmlEnd = String.valueOf(this.xmlEnd) + "</SOAP-ENV:Body>\r\n";
        this.xmlEnd = String.valueOf(this.xmlEnd) + "</SOAP-ENV:Envelope>\r\n";
        this.xmlStart = "";
        this.xmlStart = String.valueOf(this.xmlStart) + "<?xml version=\"1.0\"?>\r\n";
        this.xmlStart = String.valueOf(this.xmlStart) + "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n";
        this.xmlStart = String.valueOf(this.xmlStart) + "<s:Body>\r\n";
        this.xmlEnd = "";
        this.xmlEnd = String.valueOf(this.xmlEnd) + "</s:Body>\r\n";
        this.xmlEnd = String.valueOf(this.xmlEnd) + "</s:Envelope>\r\n";
    }

    public boolean connect(boolean b) {
        this.setXML();
        boolean chk = this.checkUPnPfile();
        if (chk) {
            chk = this.readUPnPfile();
            if (!this.setPortMappingEntry()) {
                chk = false;
            }
            if (!this.setNowMapping()) {
                chk = false;
            }
            if (this.openPort != null) {
                chk = this.allPortClose();
            }
        }
        if (!chk) {
            chk = true;
            if (!this.getLocalHostAddress()) {
                chk = false;
                this.printH("getLocalHostAddress : false");
            } else if (!this.getRouterAddress()) {
                chk = false;
                this.printH("getRouterAddress : false");
            } else if (!this.getRootDeviceControl()) {
                chk = false;
                this.printH("getRootDeviceControl : false");
            }
            if (!this.setPortMappingEntry()) {
                chk = false;
                this.printH("setPortMappingEntry : false");
            }
        }
        if (chk) {
            chk = this.setUPnPfile();
        }
        return chk;
    }

    public boolean connect() {
        this.setXML();
        boolean chk = this.checkUPnPfile();
        if (chk) {
            chk = this.readUPnPfile();
            if (!this.setPortMappingEntry()) {
                chk = false;
            }
            if (!this.setNowMapping()) {
                chk = false;
            }
            if (this.openPort != null && !this.openPortUpdate()) {
                chk = false;
            }
        }
        if (!chk) {
            chk = true;
            if (!this.getLocalHostAddress()) {
                chk = false;
                this.printH("getLocalHostAddress : false");
            } else if (!this.getRouterAddress()) {
                chk = false;
                this.printH("getRouterAddress : false");
            } else if (!this.getRootDeviceControl()) {
                chk = false;
                this.printH("getRootDeviceControl : false");
            }
            if (!this.setPortMappingEntry()) {
                chk = false;
                this.printH("setPortMappingEntry : false");
            }
        }
        if (chk) {
            chk = this.setUPnPfile();
        }
        return chk;
    }

    public boolean getLocalHostAddress() {
        this.printH("getLocalHostAddress Start \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        String[] localAddress = null;
        this.retBoolean = true;
        try {
            InetAddress[] ias;
            ArrayList<String> l = new ArrayList<String>();
            InetAddress ia = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = ias = InetAddress.getAllByName(ia.getHostName());
            int n = ias.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress i = inetAddressArray[n2];
                String tempA = i.getHostAddress();
                String[] splitA = tempA.split(":");
                if (splitA.length < 2) {
                    l.add(tempA);
                }
                tempA = null;
                splitA = null;
                ++n2;
            }
            if (l.size() > 0) {
                localAddress = new String[l.size()];
                localAddress = l.toArray(localAddress);
            }
        }
        catch (UnknownHostException l) {
            // empty catch block
        }
        if (localAddress == null) {
            this.retBoolean = false;
            return this.retBoolean;
        }
        if (localAddress.length > 1) {
            this.windowType = "AddressSelect";
            JFrame listSelecter = StartUp.tool.getJFrame(300, 155, "Select use address", false, "dispose");
            listSelecter.addWindowListener(this);
            StartUp.tool.setCenter(listSelecter);
            JPanel mainPanel = StartUp.tool.getJPanel(300, 155, "center", 0, 10);
            this.addressList = new JList<String>(localAddress);
            this.addressPane = new JScrollPane();
            this.addressPane.getViewport().setView(this.addressList);
            StartUp.tool.size(this.addressPane, 250, 70);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 0) {
                        int index = UPnPThread.this.addressList.locationToIndex(e.getPoint());
                        UPnPThread.this.listSingleSelected(index);
                        UPnPThread.this.listIndex = index;
                        UPnPThread.this.selectAddress.setEnabled(true);
                    }
                    boolean temp = !UPnPThread.this.addressList.isSelectionEmpty();
                    if (UPnPThread.this.selectAddress != null) {
                        UPnPThread.this.selectAddress.setEnabled(temp);
                    }
                }
            };
            this.addressList.addMouseListener(mouseListener);
            mainPanel.add(this.addressPane);
            this.selectAddress = this.getButton("Use selected address", "useAddress", 200, 25);
            this.selectAddress.setEnabled(false);
            mainPanel.add(this.selectAddress);
            listSelecter.add(mainPanel);
            listSelecter.setVisible(true);
            this.selectLoop = true;
            while (this.selectLoop) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.localHostAddress = localAddress[this.listIndex];
            listSelecter.setVisible(false);
            mainPanel.removeAll();
            this.addressPane = null;
            this.addressList = null;
            this.selectAddress = null;
            mouseListener = null;
            Object var2_2 = null;
        } else {
            this.localHostAddress = (String)localAddress[0];
        }
        this.printH("address : " + this.localHostAddress + " / " + this.retBoolean);
        this.printH("getLocalHostAddress Finish \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        this.windowType = "";
        return this.retBoolean;
    }

    private void listSingleSelected(int id) {
        if (!this.addressList.isSelectionEmpty() && this.addressList.getMinSelectionIndex() != this.addressList.getMaxSelectionIndex()) {
            this.addressList.clearSelection();
            this.addressList.setSelectedIndex(id);
        }
    }

    private JButton getButton(String title, String command, int x, int y) {
        JButton ret = new JButton(title);
        ret.addActionListener(this);
        ret.setActionCommand(command);
        ret.setPreferredSize(new Dimension(x, y));
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("useAddress")) {
            this.selectLoop = false;
        }
        if (cmd.equals("useRouter")) {
            this.selectLoop = false;
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if ("AddressSelect".equals(this.windowType)) {
            this.retBoolean = false;
            this.selectLoop = false;
        } else if ("RouterSelect".equals(this.windowType)) {
            this.retBoolean = false;
            this.selectLoop = false;
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public boolean getRouterAddress() {
        this.printH("getRouterAddress Start \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        this.retBoolean = true;
        if (this.localHostAddress == null) {
            this.retBoolean = false;
            return this.retBoolean;
        }
        String[] routerAddress = null;
        UPnPMultiCaster mc = null;
        String msg = "";
        int sendCount = 0;
        try {
            block17: {
                do {
                    mc = new UPnPMultiCaster("239.255.255.250", 1900, this.localHostAddress);
                    msg = String.valueOf(msg) + "M-SEARCH * HTTP/1.1\r\n";
                    msg = String.valueOf(msg) + "HOST: 239.255.255.250:1900\r\n";
                    msg = String.valueOf(msg) + "ST: upnp:rootdevice\r\n";
                    msg = String.valueOf(msg) + "MAN: \"ssdp:discover\"\r\n";
                    msg = String.valueOf(msg) + "MX: 3\r\n";
                    msg = String.valueOf(msg) + "\r\n";
                    mc.send(msg, 1000);
                    try {
                        Thread.sleep(1150L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (mc.res == null || !mc.finished) continue;
                    this.retBoolean = true;
                    break block17;
                } while (++sendCount <= 10);
                this.retBoolean = false;
            }
            if (!this.retBoolean) {
                return this.retBoolean;
            }
            int i = 0;
            while (i < mc.res.length) {
                if (mc.res[i] != null) {
                    String add = mc.res[i].getValue("location");
                    String regex = "(?i).xml";
                    Pattern p = Pattern.compile(regex);
                    Matcher m = p.matcher(add);
                    if (m.find()) {
                        routerAddress = this.addStringArray(routerAddress, add);
                    }
                }
                if (routerAddress == null) {
                    this.retBoolean = false;
                    return this.retBoolean;
                }
                if (routerAddress.length > 1) {
                    this.windowType = "RouterSelect";
                    JFrame listSelecter = StartUp.tool.getJFrame(300, 155, "Select use Router", false, "dispose");
                    listSelecter.addWindowListener(this);
                    StartUp.tool.setCenter(listSelecter);
                    JPanel mainPanel = StartUp.tool.getJPanel(300, 155, "center", 0, 10);
                    this.addressList = new JList<String>(routerAddress);
                    this.addressPane = new JScrollPane();
                    this.addressPane.getViewport().setView(this.addressList);
                    StartUp.tool.size(this.addressPane, 250, 70);
                    MouseAdapter mouseListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 0) {
                                int index = UPnPThread.this.addressList.locationToIndex(e.getPoint());
                                UPnPThread.this.listSingleSelected(index);
                                UPnPThread.this.listIndex = index;
                                UPnPThread.this.selectAddress.setEnabled(true);
                            }
                            boolean temp = !UPnPThread.this.addressList.isSelectionEmpty();
                            if (UPnPThread.this.selectAddress != null) {
                                UPnPThread.this.selectAddress.setEnabled(temp);
                            }
                        }
                    };
                    this.addressList.addMouseListener(mouseListener);
                    mainPanel.add(this.addressPane);
                    this.selectAddress = this.getButton("Use selected Router", "useRouter", 200, 25);
                    this.selectAddress.setEnabled(false);
                    mainPanel.add(this.selectAddress);
                    listSelecter.add(mainPanel);
                    listSelecter.setVisible(true);
                    this.selectLoop = true;
                    while (this.selectLoop) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.rootdeviceAddress = routerAddress[this.listIndex];
                    listSelecter.setVisible(false);
                    mainPanel.removeAll();
                    this.addressPane = null;
                    this.addressList = null;
                    this.selectAddress = null;
                    mouseListener = null;
                    listSelecter = null;
                } else {
                    this.rootdeviceAddress = (String)routerAddress[0];
                }
                ++i;
            }
            msg = null;
            mc.print("Selected router address" + this.rootdeviceAddress);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String[] temp = this.urlSplit(this.rootdeviceAddress);
        if (temp != null) {
            this.urlFront = temp[0];
            this.urlRear = temp[1];
            temp = null;
        }
        this.printH("getRouterAddress Finish \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        return this.retBoolean;
    }

    private String[] addStringArray(String[] src, String add) {
        String[] ret;
        if (src == null) {
            ret = new String[]{add};
        } else {
            if (add.equals(src[src.length - 1])) {
                add = null;
                Object ret2 = null;
                return src;
            }
            ret = new String[src.length + 1];
            System.arraycopy(src, 0, ret, 0, src.length);
            ret[src.length] = add;
        }
        src = null;
        add = null;
        return ret;
    }

    public String[] urlSplit(String src) {
        String[] ret = null;
        String front = src;
        String rear = "";
        String regex = "(?i)http://";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(front);
        if (m.find()) {
            front = front.substring(m.end());
        } else {
            regex = null;
        }
        p = null;
        m = null;
        regex = "^[^/]*/";
        p = Pattern.compile(regex);
        m = p.matcher(front);
        if (m.find()) {
            ret = new String[2];
            ret[1] = front.substring(m.end() - 1);
            ret[0] = front.substring(0, m.end() - 1);
        } else {
            regex = null;
            p = null;
            m = null;
            regex = "^[^\\\\]*\\\\";
            p = Pattern.compile(regex);
            m = p.matcher(front);
            if (m.find()) {
                ret = new String[2];
                ret[1] = front.substring(m.end() - 1);
                ret[0] = front.substring(0, m.end() - 1);
            }
        }
        return ret;
    }

    public String[] getSplitEasyXML(String src) {
        String[] ret = null;
        if (src == null) {
            return null;
        }
        String temp = src;
        String regex = "^[^<]*<[^>]*>";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(temp);
        if (m.find()) {
            String tag = temp.substring(m.start() + 1, m.end() - 1);
            String value = "";
            int innerStart = m.end();
            regex = null;
            p = null;
            m = null;
            regex = "</" + tag + ">";
            p = Pattern.compile(regex);
            m = p.matcher(temp);
            value = m.find() ? (innerStart > m.start() ? "" : temp.substring(innerStart, m.start())) : "NoValue.";
            ret = new String[]{tag, value};
        } else {
            ret = new String[]{src};
        }
        return ret;
    }

    private void addXMLResult(String[] add) {
        if (add == null) {
            return;
        }
        if (add.length == 1) {
            if (!add[0].equals("")) {
                int tar = -1;
                if (this.httpRes == null) {
                    this.httpRes = new String[1];
                    tar = 0;
                } else {
                    tar = this.httpRes.length;
                    String[] temp = new String[tar];
                    System.arraycopy(this.httpRes, 0, temp, 0, tar);
                    this.httpRes = null;
                    this.httpRes = new String[tar + 1];
                    System.arraycopy(temp, 0, this.httpRes, 0, tar);
                    temp = null;
                }
                this.httpRes[tar] = add[0];
            }
        } else {
            int tar = -1;
            if (this.xmlTag == null) {
                this.xmlTag = new String[1];
                this.xmlValue = new String[1];
                tar = 0;
            } else {
                tar = this.xmlTag.length;
                String[] tempT = new String[tar];
                System.arraycopy(this.xmlTag, 0, tempT, 0, tar);
                String[] tempV = new String[tar];
                System.arraycopy(this.xmlValue, 0, tempV, 0, tar);
                this.xmlTag = null;
                this.xmlTag = new String[tar + 1];
                System.arraycopy(tempT, 0, this.xmlTag, 0, tar);
                this.xmlValue = null;
                this.xmlValue = new String[tar + 1];
                System.arraycopy(tempV, 0, this.xmlValue, 0, tar);
                tempT = null;
                tempV = null;
            }
            this.xmlTag[tar] = add[0];
            this.xmlValue[tar] = add[1];
        }
        add = null;
    }

    private String[] splitURL(String src) {
        String[] ret = null;
        String temp = src;
        String regex = "(?i)http://";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(src);
        if (m.find()) {
            temp = src.substring(m.end());
        }
        regex = null;
        p = null;
        m = null;
        regex = "^[^/]*/";
        p = Pattern.compile(regex);
        m = p.matcher(temp);
        if (m.find()) {
            ret = new String[2];
            ret[1] = temp.substring(m.end() - 1);
            ret[0] = temp.substring(0, m.end() - 1);
        } else {
            regex = null;
            p = null;
            m = null;
            regex = "^[^\\\\]*\\\\";
            p = Pattern.compile(regex);
            m = p.matcher(temp);
            if (m.find()) {
                ret = new String[2];
                ret[1] = temp.substring(m.end() - 1);
                ret[0] = temp.substring(0, m.end() - 1);
            }
        }
        return ret;
    }

    public boolean getRootDeviceControl() {
        this.printH("getRootDeviceControl Start \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        this.retBoolean = true;
        this.xmlTag = null;
        this.xmlValue = null;
        if (this.urlFront == null) {
            this.retBoolean = false;
            return this.retBoolean;
        }
        if (this.urlRear == null) {
            this.retBoolean = false;
            return this.retBoolean;
        }
        this.getHTTPsend(this.urlFront, this.urlRear, 250);
        if (this.xmlTag != null && this.xmlValue != null) {
            int i = 0;
            while (i < this.xmlTag.length) {
                if (this.xmlTag[i] != null) {
                    String regex = "(?i)serviceType";
                    Pattern p = Pattern.compile(regex);
                    Matcher m = p.matcher(this.xmlTag[i]);
                    boolean chk = false;
                    if (m.find()) {
                        regex = null;
                        p = null;
                        m = null;
                        regex = "(?i)WANPPPConnection";
                        p = Pattern.compile(regex);
                        m = p.matcher(this.xmlValue[i]);
                        if (m.find()) {
                            chk = true;
                            this.serviceType = this.xmlValue[i];
                        } else {
                            regex = null;
                            p = null;
                            m = null;
                            regex = "(?i)WANIPConnection";
                            p = Pattern.compile(regex);
                            m = p.matcher(this.xmlValue[i]);
                            if (m.find()) {
                                chk = true;
                                this.serviceType = this.xmlValue[i];
                            }
                        }
                    }
                    if (chk && this.controlURL == null) {
                        int ti = i;
                        while (!this.xmlTag[ti].startsWith("/")) {
                            regex = null;
                            p = null;
                            m = null;
                            regex = "(?i)controlURL";
                            p = Pattern.compile(regex);
                            m = p.matcher(this.xmlTag[ti]);
                            if (m.find()) {
                                this.controlURL = this.xmlValue[ti];
                                break;
                            }
                            ++ti;
                        }
                        ti = i;
                        while (!this.xmlTag[ti].startsWith("/")) {
                            regex = null;
                            p = null;
                            m = null;
                            regex = "(?i)SCPDURL";
                            p = Pattern.compile(regex);
                            m = p.matcher(this.xmlTag[ti]);
                            if (m.find()) {
                                this.scpdURL = this.xmlValue[ti];
                                break;
                            }
                            ++ti;
                        }
                    }
                    regex = null;
                    p = null;
                    m = null;
                }
                ++i;
            }
            if (this.controlURL == null) {
                this.retBoolean = false;
                return this.retBoolean;
            }
            if (!this.controlURL.startsWith("/")) {
                String[] tempURL = this.splitURL(this.controlURL);
                if (tempURL != null) {
                    this.baseURL = tempURL[0];
                    this.controlURL = tempURL[1];
                    Object var1_2 = null;
                }
            } else {
                this.baseURL = this.urlFront;
            }
        }
        this.printH("[ controlURL : " + this.controlURL + " ] [ scpdURL : " + this.scpdURL + " ] [ baseURL : " + this.baseURL + " ] ");
        this.printH("getRootDeviceControl Finish \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        return this.retBoolean;
    }

    private boolean getHTTPsend(String ip, String get, int to) {
        if (ip == null || get == null) {
            return false;
        }
        this.xmlTag = null;
        this.xmlValue = null;
        this.httpRes = null;
        String[] temp = ip.split(":");
        String send = "";
        send = String.valueOf(send) + "GET " + get + " HTTP/1.1\r\n";
        send = String.valueOf(send) + "Host: " + temp[0] + ":" + temp[1] + "\r\n";
        send = String.valueOf(send) + "Connection: Close\r\n\r\n";
        this.printH("Send - HTTP : " + StartUp.tool.replaceLF(send, " "));
        UPnPSocketCaster sc = new UPnPSocketCaster(temp[0], Integer.parseInt(temp[1]), send, to);
        while (!sc.finished) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sc.res != null) {
            int i = 0;
            while (i < sc.res.length) {
                if (sc.res[i].result != null) {
                    int ii = 0;
                    while (ii < sc.res[i].result.length) {
                        this.addXMLResult(this.getSplitEasyXML(sc.res[i].result[ii]));
                        ++ii;
                    }
                }
                ++i;
            }
        } else {
            return false;
        }
        sc = null;
        send = null;
        temp = null;
        return true;
    }

    public void printH(String s) {
        if (!StartUp.debugF) {
            return;
        }
        if (StartUp.debugUPnP) {
            System.out.println(s);
        }
        s = null;
    }

    public boolean setPortMappingEntry() {
        this.printH("setPortMappingEntry Start \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        this.retBoolean = true;
        this.xmlTag = null;
        this.xmlValue = null;
        this.stringAddAction = "AddPortMapping";
        this.stringDelAction = "DeletePortMapping";
        this.stringMapEntry = "GetGenericPortMappingEntry";
        this.stringPortMappingIndex = "NewPortMappingIndex";
        this.stringRemoteHost = "NewRemoteHost";
        this.stringExternalPort = "NewExternalPort";
        this.stringProtocol = "NewProtocol";
        this.stringInternalPort = "NewInternalPort";
        this.stringInternalClient = "NewInternalClient";
        this.stringEnabled = "NewEnabled";
        this.stringPortMappingDescription = "NewPortMappingDescription";
        this.stringLeaseDuration = "NewLeaseDuration";
        if (this.urlFront == null) {
            this.retBoolean = true;
            return this.retBoolean;
        }
        if (this.scpdURL == null) {
            this.retBoolean = true;
            return this.retBoolean;
        }
        this.getHTTPsend(this.urlFront, this.scpdURL, 250);
        if (this.xmlTag != null && this.xmlValue != null) {
            int endPoint = this.xmlTag.length;
            int readPoint = 0;
            while (readPoint < endPoint) {
                String tempTag = this.xmlTag[readPoint];
                if (tempTag.toLowerCase().equals("action")) {
                    ++readPoint;
                    while (readPoint < endPoint) {
                        tempTag = this.xmlTag[readPoint];
                        if (tempTag.toLowerCase().equals("/action")) break;
                        if (tempTag.toLowerCase().equals("name")) {
                            if (this.chkEntryString(this.xmlValue[readPoint], this.stringAddAction)) {
                                this.stringAddAction = this.xmlValue[readPoint];
                                ++readPoint;
                                while (readPoint < endPoint) {
                                    if (tempTag.toLowerCase().equals("name")) {
                                        String tempValue = this.xmlValue[readPoint];
                                        if (this.chkEntryString(tempValue, this.stringRemoteHost)) {
                                            this.stringRemoteHost = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringExternalPort)) {
                                            this.stringExternalPort = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringProtocol)) {
                                            this.stringProtocol = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringInternalPort)) {
                                            this.stringInternalPort = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringInternalClient)) {
                                            this.stringInternalClient = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringEnabled)) {
                                            this.stringEnabled = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringPortMappingDescription)) {
                                            this.stringPortMappingDescription = tempValue;
                                        } else if (this.chkEntryString(tempValue, this.stringLeaseDuration)) {
                                            this.stringLeaseDuration = tempValue;
                                        }
                                    }
                                    ++readPoint;
                                }
                            } else if (this.chkEntryString(this.xmlValue[readPoint], this.stringDelAction)) {
                                this.stringDelAction = this.xmlValue[readPoint];
                            } else if (this.chkEntryString(this.xmlValue[readPoint], this.stringMapEntry)) {
                                this.stringMapEntry = this.xmlValue[readPoint];
                                ++readPoint;
                                while (readPoint < endPoint) {
                                    if (tempTag.toLowerCase().equals("name") && this.chkEntryString(this.xmlValue[readPoint], this.stringPortMappingIndex)) {
                                        this.stringPortMappingIndex = this.xmlValue[readPoint];
                                    }
                                    ++readPoint;
                                }
                            }
                        }
                        ++readPoint;
                    }
                }
                ++readPoint;
            }
        }
        this.printH("setPortMappingEntry Finish \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        return this.retBoolean;
    }

    private boolean chkEntryString(String src, String target) {
        boolean ret = false;
        String regex = "^(?i)" + target;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(src);
        if (m.find()) {
            ret = true;
        }
        return ret;
    }

    public boolean setNowMapping() {
        if (this.urlFront == null || this.controlURL == null || this.serviceType == null) {
            return false;
        }
        int n = 0;
        this.openPort = null;
        while (true) {
            String[] dat = this.getMappingInfo(n);
            ++n;
            if (dat == null) break;
            this.openPort = this.addPortMappingDataArray(this.openPort, new UPnPPortMappingData(dat));
            dat = null;
        }
        if (this.openPort != null) {
            this.printH(String.valueOf(this.openPort.length) + " -----------------------------------------------------------------------------------------------------");
            int i = 0;
            while (i < this.openPort.length) {
                this.printH("port : " + this.openPort[i].externalPort + "  [ " + this.openPort[i].protocol + " ]");
                ++i;
            }
        }
        return true;
    }

    public boolean setOpenPort(int port) {
        if (this.localHostAddress == null) {
            return false;
        }
        if (port < 1025 || port > 65535) {
            return false;
        }
        UPnPPortMappingData pmd = new UPnPPortMappingData();
        pmd.remoteHost = "";
        pmd.externalPort = port;
        pmd.protocol = "TCP";
        pmd.internalPort = port;
        pmd.internalClient = this.localHostAddress;
        pmd.enabled = false;
        pmd.portMappingDescription = "TMSL control (TCP)";
        pmd.leaseDuration = 600;
        boolean ret = false;
        ret = this.openPortMapping(pmd);
        pmd = null;
        if (ret) {
            UPnPPortMappingData pmdU = new UPnPPortMappingData();
            pmdU.remoteHost = "";
            pmdU.externalPort = port;
            pmdU.protocol = "UDP";
            pmdU.internalPort = port;
            pmdU.internalClient = this.localHostAddress;
            pmdU.enabled = false;
            pmdU.portMappingDescription = "TMSL control (UDP)";
            pmdU.leaseDuration = 600;
            ret = this.openPortMapping(pmdU);
            pmdU = null;
        }
        return ret;
    }

    private boolean addPortMappingData(UPnPPortMappingData pmd) {
        int tar = -1;
        if (this.openPort != null) {
            int i = 0;
            while (i < this.openPort.length) {
                if (this.openPort[i] != null && this.openPort[i].externalPort == pmd.externalPort && this.openPort[i].protocol.equals(pmd.protocol)) {
                    return true;
                }
                ++i;
            }
        }
        this.openPort = this.addPortMappingDataArray(this.openPort, pmd);
        return true;
    }

    private UPnPPortMappingData[] addPortMappingDataArray(UPnPPortMappingData[] src, UPnPPortMappingData tar) {
        if (tar == null) {
            return src;
        }
        UPnPPortMappingData[] ret = null;
        int n = -1;
        if (src == null) {
            ret = new UPnPPortMappingData[1];
            n = 0;
        } else {
            n = src.length;
            ret = new UPnPPortMappingData[n + 1];
            System.arraycopy(src, 0, ret, 0, n);
        }
        if (n > -1) {
            ret[n] = new UPnPPortMappingData(tar);
        }
        src = null;
        tar = null;
        return ret;
    }

    private UPnPPortMappingData[] deletePortMappingDataArray(UPnPPortMappingData[] src, UPnPPortMappingData tar) {
        UPnPPortMappingData[] ret = null;
        if (src == null) {
            return null;
        }
        if (tar == null) {
            return src;
        }
        int len = src.length;
        int i = 0;
        while (i < len) {
            if (src[i].externalPort != tar.externalPort || !src[i].protocol.equals(tar.protocol)) {
                ret = this.addPortMappingDataArray(ret, tar);
            }
            ++i;
        }
        return ret;
    }

    public boolean openPortUpdate() {
        if (this.openPort == null) {
            this.setNowMapping();
            if (this.openPort == null) {
                return false;
            }
        }
        int i = 0;
        while (i < this.openPort.length) {
            this.printH(String.valueOf(i) + " / " + this.openPort.length + " : " + this.openPortMapping(this.openPort[i]));
            ++i;
        }
        return true;
    }

    public boolean allPortClose() {
        if (this.openPort == null) {
            this.setNowMapping();
            if (this.openPort == null) {
                return false;
            }
        }
        int len = this.openPort.length;
        UPnPPortMappingData[] temp = new UPnPPortMappingData[len];
        System.arraycopy(this.openPort, 0, temp, 0, len);
        int i = 0;
        while (i < temp.length) {
            this.closePortMapping(temp[i]);
            ++i;
        }
        temp = null;
        this.openPort = null;
        return true;
    }

    public boolean closePortMapping(UPnPPortMappingData pmd) {
        if (this.urlFront == null || this.controlURL == null || this.serviceType == null) {
            return false;
        }
        String tempIP = this.getSOAPIP();
        String action = this.serviceType + "#" + this.stringDelAction;
        String xml = this.xmlStart;
        xml = String.valueOf(xml) + "<m:" + this.stringDelAction + " xmlns:m=\"" + this.serviceType + "\">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringRemoteHost + ">" + pmd.remoteHost + "</" + this.stringRemoteHost + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringExternalPort + ">" + pmd.externalPort + "</" + this.stringExternalPort + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringProtocol + ">" + pmd.protocol + "</" + this.stringProtocol + ">\r\n";
        xml = String.valueOf(xml) + "</m:" + this.stringDelAction + ">\r\n";
        xml = String.valueOf(xml) + this.xmlEnd;
        boolean ret = false;
        if (this.postSOAPsend(tempIP, this.controlURL, xml, action, 250)) {
            ret = this.checkHTTPOK();
        }
        if (ret) {
            this.openPort = this.deletePortMappingDataArray(this.openPort, pmd);
        }
        return ret;
    }

    public boolean openPortMapping(UPnPPortMappingData pmd) {
        if (this.urlFront == null || this.controlURL == null || this.serviceType == null) {
            return false;
        }
        String tempIP = this.getSOAPIP();
        String action = this.serviceType + "#" + this.stringAddAction;
        String xml = this.xmlStart;
        xml = String.valueOf(xml) + "<m:" + this.stringAddAction + " xmlns:m=\"" + this.serviceType + "\">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringRemoteHost + ">" + pmd.remoteHost + "</" + this.stringRemoteHost + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringExternalPort + ">" + pmd.externalPort + "</" + this.stringExternalPort + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringProtocol + ">" + pmd.protocol + "</" + this.stringProtocol + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringInternalPort + ">" + pmd.internalPort + "</" + this.stringInternalPort + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringInternalClient + ">" + pmd.internalClient + "</" + this.stringInternalClient + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringEnabled + ">" + StartUp.tool.retBooleanInt(pmd.enabled) + "</" + this.stringEnabled + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringPortMappingDescription + ">" + pmd.portMappingDescription + "</" + this.stringPortMappingDescription + ">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringLeaseDuration + ">" + pmd.leaseDuration + "</" + this.stringLeaseDuration + ">\r\n";
        xml = String.valueOf(xml) + "</m:" + this.stringAddAction + ">\r\n";
        xml = String.valueOf(xml) + this.xmlEnd;
        boolean ret = false;
        if (this.postSOAPsend(tempIP, this.controlURL, xml, action, 250)) {
            ret = this.checkHTTPOK();
        }
        if (ret) {
            this.addPortMappingData(pmd);
        }
        return ret;
    }

    private String[] getMappingInfo(int tar) {
        if (this.urlFront == null || this.controlURL == null || this.serviceType == null) {
            return null;
        }
        boolean ret = false;
        String[] retS = null;
        String tempIP = this.getSOAPIP();
        String action = this.serviceType + "#" + this.stringMapEntry;
        String xml = this.xmlStart;
        xml = String.valueOf(xml) + "<m:" + this.stringMapEntry + " xmlns:m=\"" + this.serviceType + "\">\r\n";
        xml = String.valueOf(xml) + "<" + this.stringPortMappingIndex + ">" + tar + "</" + this.stringPortMappingIndex + ">\r\n";
        xml = String.valueOf(xml) + "</m:" + this.stringMapEntry + ">\r\n";
        if (this.postSOAPsend(tempIP, this.controlURL, xml = String.valueOf(xml) + this.xmlEnd, action, 250)) {
            ret = this.checkHTTPOK();
        }
        if (ret && this.xmlTag != null) {
            retS = new String[8];
            int i = 0;
            while (i < this.xmlTag.length) {
                if (!this.xmlValue[i].equals("NoValue.")) {
                    if (this.xmlTag[i].toLowerCase().equals("newremotehost")) {
                        retS[0] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newexternalport")) {
                        retS[1] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newprotocol")) {
                        retS[2] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newinternalport")) {
                        retS[3] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newinternalclient")) {
                        retS[4] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newenabled")) {
                        retS[5] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newportmappingdescription")) {
                        retS[6] = this.xmlValue[i];
                    } else if (this.xmlTag[i].toLowerCase().equals("newleaseduration")) {
                        retS[7] = this.xmlValue[i];
                    }
                }
                ++i;
            }
        }
        xml = null;
        action = null;
        tempIP = null;
        return retS;
    }

    private String getSOAPIP() {
        String tempIP;
        if (this.baseURL != null) {
            tempIP = this.baseURL;
        } else {
            tempIP = this.urlFront;
            this.baseURL = this.urlFront;
        }
        tempIP = tempIP.replaceAll("/", "");
        tempIP = tempIP.replaceAll("(?i)http:", "");
        return tempIP;
    }

    private boolean checkHTTPOK() {
        if (this.httpRes == null) {
            return false;
        }
        boolean ret = false;
        int i = 0;
        while (i < this.httpRes.length) {
            if (this.httpRes[i].startsWith("http") || this.httpRes[i].startsWith("HTTP") || this.httpRes[i].startsWith("Http")) {
                this.printH("HTTP : " + this.httpRes[i]);
                String regex = "(?i)200 ok";
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(this.httpRes[i]);
                ret = m.find();
                regex = null;
                p = null;
                m = null;
            }
            ++i;
        }
        return ret;
    }

    public boolean getGlobalIP() {
        if (this.urlFront == null || this.controlURL == null || this.serviceType == null) {
            return false;
        }
        String tempIP = this.getSOAPIP();
        String action = this.serviceType + "#GetExternalIPAddress";
        String xml = "";
        xml = String.valueOf(xml) + this.xmlStart;
        xml = String.valueOf(xml) + "<m:GetExternalIPAddress xmlns:m=\"" + this.serviceType + "\"></m:GetExternalIPAddress>\r\n";
        xml = String.valueOf(xml) + "</SOAP-ENV:Body>\r\n";
        xml = String.valueOf(xml) + "</SOAP-ENV:Envelope>\r\n";
        boolean ret = false;
        if (this.postSOAPsend(tempIP, this.controlURL, xml, action, 250)) {
            ret = this.checkHTTPOK();
        }
        if (this.xmlTag != null) {
            int i = 0;
            while (i < this.xmlTag.length) {
                String tempL = null;
                String tempR = null;
                if (this.xmlTag[i] != null) {
                    tempL = this.xmlTag[i];
                }
                if (this.xmlValue[i] != null) {
                    tempR = this.xmlValue[i];
                }
                tempL = null;
                tempR = null;
                ++i;
            }
        }
        xml = null;
        action = null;
        tempIP = null;
        return ret;
    }

    private boolean postSOAPsend(String ip, String post, String xml, String action, int to) {
        if (ip == null || post == null || xml == null || action == null) {
            return false;
        }
        this.xmlTag = null;
        this.xmlValue = null;
        this.httpRes = null;
        String[] temp = ip.split(":");
        int len = -1;
        try {
            len = xml.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (len < 1) {
            return false;
        }
        String send = "";
        send = String.valueOf(send) + "POST " + post + " HTTP/1.1\r\n";
        send = String.valueOf(send) + "SOAPAction: \"" + action + "\"\r\n";
        send = String.valueOf(send) + "Host: " + temp[0] + ":" + temp[1] + "\r\n";
        send = String.valueOf(send) + "Content-Length: " + len + "\r\n";
        send = String.valueOf(send) + "Content-Type: text/xml; charset=\"utf-8\"\r\n";
        send = String.valueOf(send) + "Connection: Close\r\n";
        send = String.valueOf(send) + "\r\n";
        send = String.valueOf(send) + xml;
        this.printH("Send - SOAP \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\r\n" + send + "\r\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 Send - SOAP");
        UPnPSocketCaster sc = new UPnPSocketCaster(temp[0], Integer.parseInt(temp[1]), send, to);
        while (!sc.finished) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sc.res != null) {
            int i = 0;
            while (i < sc.res.length) {
                if (sc.res[i].result != null) {
                    int ii = 0;
                    while (ii < sc.res[i].result.length) {
                        this.addXMLResult(this.getSplitEasyXML(sc.res[i].result[ii]));
                        this.printH("SOAP Result : " + sc.res[i].result[ii]);
                        ++ii;
                    }
                }
                ++i;
            }
        } else {
            this.printH("SOAP Result : null");
            return false;
        }
        sc = null;
        send = null;
        temp = null;
        return true;
    }

    private boolean checkUPnPfile() {
        if (StartUp.cdc == null) {
            return false;
        }
        if (StartUp.cdc.workFolder == null) {
            return false;
        }
        boolean ret = false;
        FileControl upnp = new FileControl(StartUp.cdc.workFolder, "upnpOpen.txt");
        if (upnp.fileCheck) {
            ret = true;
            this.upnpOpen = new FileControl(StartUp.cdc.workFolder, "upnpOpen.txt");
        } else {
            ret = false;
        }
        upnp = null;
        return ret;
    }

    private boolean setUPnPfile() {
        if (this.upnpOpen == null) {
            if (StartUp.cdc == null) {
                return false;
            }
            if (StartUp.cdc.workFolder == null) {
                return false;
            }
            this.upnpOpen = new FileControl(StartUp.cdc.workFolder, "upnpOpen.txt");
        }
        String[] temp = new String[]{this.localHostAddress, this.rootdeviceAddress, this.controlURL, this.baseURL, this.serviceType, this.scpdURL, this.urlFront, this.urlRear};
        this.upnpOpen.setTextData(temp);
        temp = null;
        return this.upnpOpen.makeTextFile();
    }

    public boolean deleteUPnPfile() {
        if (this.upnpOpen == null) {
            if (StartUp.cdc == null) {
                return false;
            }
            if (StartUp.cdc.workFolder == null) {
                return false;
            }
            this.upnpOpen = new FileControl(StartUp.cdc.workFolder, "upnpOpen.txt");
        }
        if (this.upnpOpen.fileCheck) {
            if (this.upnpOpen.delete()) {
                this.printH("UPnP file delete.");
            } else {
                this.printH("UPnP file delete fault...");
            }
        }
        return true;
    }

    private boolean readUPnPfile() {
        if (this.upnpOpen == null) {
            if (StartUp.cdc == null) {
                return false;
            }
            if (StartUp.cdc.workFolder == null) {
                return false;
            }
            this.upnpOpen = new FileControl(StartUp.cdc.workFolder, "upnpOpen.txt");
        }
        this.upnpOpen.readTextData();
        if (this.upnpOpen.dataText.length < 8) {
            return false;
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[0])) {
            this.localHostAddress = this.upnpOpen.dataText[0];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[1])) {
            this.rootdeviceAddress = this.upnpOpen.dataText[1];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[2])) {
            this.controlURL = this.upnpOpen.dataText[2];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[3])) {
            this.baseURL = this.upnpOpen.dataText[3];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[4])) {
            this.serviceType = this.upnpOpen.dataText[4];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[5])) {
            this.scpdURL = this.upnpOpen.dataText[5];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[6])) {
            this.urlFront = this.upnpOpen.dataText[6];
        }
        if (!this.chkTextNULL(this.upnpOpen.dataText[7])) {
            this.urlRear = this.upnpOpen.dataText[7];
        }
        return true;
    }

    private boolean chkTextNULL(String src) {
        if (src == null) {
            return true;
        }
        return src.equals("null") || src.equals("NULL");
    }

    @Override
    public void run() {
        this.finished = false;
        this.dispose = false;
        int count = 0;
        do {
            if (++count > 600 / 2) {
                count = 0;
                this.openPortUpdate();
                this.printH("UPnP Time UPDATE!!");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!this.dispose);
        this.allPortClose();
        this.deleteUPnPfile();
        this.finished = true;
    }
}

