/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.StartUp;
import hir.westfield.tm.UPnPCastResult;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class UPnPMultiCaster
extends Thread {
    private InetAddress groupIP;
    private MulticastSocket socket;
    private int port;
    private String ipAddress;
    private String localHostAddress;
    public boolean loopEnd = false;
    public boolean finished = false;
    public UPnPCastResult[] res = null;
    private int timeOut;

    public UPnPMultiCaster(String ip, int portN, String niAddres) throws IOException {
        this.port = portN;
        this.ipAddress = ip;
        this.localHostAddress = niAddres;
        this.groupIP = InetAddress.getByName(ip);
        this.socket = new MulticastSocket();
        this.socket.setTimeToLive(1);
        this.setNI();
        this.print("");
        this.print("Construct - MultiCaster - " + ip + ":" + portN);
        this.print("interface : " + this.socket.getNetworkInterface());
        this.print("TTL : " + this.socket.getTimeToLive());
        this.start();
    }

    public void print(String s) {
        if (!StartUp.debugF) {
            return;
        }
        if (StartUp.debugUPnP) {
            System.out.println(s);
        }
        s = null;
    }

    private void setNI() {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getByName(this.localHostAddress));
            InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName(this.ipAddress), this.port);
            this.socket.joinGroup(socketAddress, ni);
            this.socket.setNetworkInterface(ni);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeNI() {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getByName(this.localHostAddress));
            InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName(this.ipAddress), this.port);
            this.socket.leaveGroup(socketAddress, ni);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(String msg, int to) throws IOException {
        this.timeOut = to;
        this.res = null;
        this.print("Send - MultiCaster : " + StartUp.tool.replaceLF(msg, " "));
        byte[] temp = msg.getBytes("UTF-8");
        DatagramPacket hi = new DatagramPacket(temp, temp.length, this.groupIP, this.port);
        this.socket.setSoTimeout(this.timeOut);
        this.socket.send(hi);
        hi = null;
        msg = null;
        temp = null;
    }

    @Override
    public void run() {
        this.finished = false;
        byte[] buf = new byte[1000];
        DatagramPacket recv = new DatagramPacket(buf, buf.length);
        try {
            this.socket.setSoTimeout(this.timeOut);
            this.socket.receive(recv);
            this.addRes(recv);
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buf = null;
        recv = null;
        this.removeNI();
        this.finished = true;
    }

    private void addRes(DatagramPacket recv) {
        int tar = 0;
        if (this.res == null) {
            this.res = new UPnPCastResult[1];
            tar = 0;
        } else {
            tar = this.res.length;
            UPnPCastResult[] temp = new UPnPCastResult[tar];
            System.arraycopy(this.res, 0, temp, 0, tar);
            this.res = null;
            this.res = new UPnPCastResult[tar + 1];
            System.arraycopy(temp, 0, this.res, 0, tar);
            Object var3_3 = null;
        }
        this.res[tar] = new UPnPCastResult(recv);
        this.res[tar].resPrint();
        recv = null;
    }
}

