/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.StartUp;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UPnPCastResult {
    public String[] result;
    public String[] resName;
    public String[] resValue;
    public byte[] resByte;
    public DatagramPacket recvPacket;

    public UPnPCastResult(DatagramPacket recv) {
        try {
            this.recvPacket = recv;
            this.resByte = null;
            this.resByte = new byte[recv.getLength()];
            System.arraycopy(recv.getData(), 0, this.resByte, 0, recv.getLength());
            this.result = null;
            String[] temp = StartUp.tool.splitLFT(new String(this.resByte, "UTF-8"));
            if (temp != null) {
                int i = 0;
                while (i < temp.length) {
                    this.addResult(temp[i]);
                    ++i;
                }
            }
            this.readResult();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public UPnPCastResult(byte[] src) {
        try {
            this.recvPacket = null;
            this.resByte = null;
            this.resByte = new byte[src.length];
            System.arraycopy(src, 0, this.resByte, 0, src.length);
            this.result = null;
            String[] temp = StartUp.tool.splitLFT(new String(this.resByte, "UTF-8"));
            if (temp != null) {
                int i = 0;
                while (i < temp.length) {
                    this.addResult(temp[i]);
                    ++i;
                }
            }
            this.readResult();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void addResult(String dat) {
        if (dat == null) {
            return;
        }
        if (dat.equals("")) {
            return;
        }
        if (this.result == null) {
            this.result = new String[1];
            this.result[0] = dat;
        } else {
            int len = this.result.length;
            String[] temp = new String[len];
            System.arraycopy(this.result, 0, temp, 0, len);
            this.result = null;
            this.result = new String[len + 1];
            System.arraycopy(temp, 0, this.result, 0, len);
            this.result[len] = dat;
            Object var3_3 = null;
        }
        dat = null;
    }

    public void print(String s) {
        if (!StartUp.debugF) {
            return;
        }
        if (StartUp.debugUPnP) {
            System.out.println(s);
        }
        s = null;
    }

    public void resPrint() {
        if (this.recvPacket != null) {
            this.print("recv : \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500" + this.recvPacket.getLength());
        }
        if (this.recvPacket == null) {
            this.print("byte : \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500" + this.resByte.length);
        }
        if (this.result != null) {
            int i = 0;
            while (i < this.result.length) {
                this.print(this.result[i]);
                ++i;
            }
        }
        if (this.recvPacket != null) {
            this.print("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 : recv");
        }
        if (this.recvPacket == null) {
            this.print("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 : byte");
        }
    }

    private void readResult() {
        this.resName = null;
        this.resValue = null;
        if (this.result == null) {
            return;
        }
        int len = this.result.length;
        this.resName = new String[len];
        this.resValue = new String[len];
        int i = 0;
        while (i < len) {
            if (this.result[i] != null) {
                String temp = this.result[i];
                String regex = "^[^:]*:";
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(temp);
                if (m.find()) {
                    int last = m.end();
                    this.resName[i] = temp.substring(0, last - 1);
                    String temp2 = temp.substring(last);
                    while (temp.startsWith(" ")) {
                        temp2 = temp2.substring(1);
                    }
                    this.resValue[i] = temp2;
                    temp2 = null;
                } else {
                    this.resName[i] = temp;
                }
                m = null;
                p = null;
                regex = null;
                Object var3_3 = null;
            }
            ++i;
        }
    }

    public String getValue(String target) {
        String ret = null;
        if (this.resName != null && this.resValue != null) {
            int i = 0;
            while (i < this.resName.length) {
                if (this.resName[i] != null) {
                    String temp = this.resName[i];
                    String regex = "(?i)" + target;
                    Pattern p = Pattern.compile(regex);
                    Matcher m = p.matcher(temp);
                    if (m.find() && this.resValue[i] != null) {
                        ret = this.resValue[i];
                    }
                    m = null;
                    p = null;
                    regex = null;
                    temp = null;
                    if (ret != null) break;
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean splitEasyXML() {
        boolean ret = true;
        if (this.result == null) {
            return false;
        }
        this.resName = null;
        this.resValue = null;
        int i = 0;
        while (i < this.result.length) {
            String temp = this.result[i];
            String regex = "^[^<]*<[^>]*>";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(temp);
            if (m.find()) {
                String tag = temp.substring(m.start() + 1, m.end() - 1);
                String value = "";
                int innerStart = m.end();
                regex = null;
                p = null;
                m = null;
                regex = "</" + tag + ">";
                p = Pattern.compile(regex);
                m = p.matcher(temp);
                if (m.find()) {
                    value = innerStart > m.start() ? "" : temp.substring(innerStart, m.start());
                }
                this.addXMLdata(tag, value);
                StartUp.print(String.valueOf(tag) + " : " + value);
            }
            ++i;
        }
        return ret;
    }

    private void addXMLdata(String tag, String value) {
        int tar = -1;
        if (this.resName == null || this.resValue == null) {
            this.resName = new String[1];
            this.resValue = new String[1];
            tar = 0;
        } else {
            tar = this.resName.length;
            String[] tempN = new String[this.resName.length];
            System.arraycopy(this.resName, 0, tempN, 0, this.resName.length);
            String[] tempV = new String[this.resValue.length];
            System.arraycopy(this.resValue, 0, tempV, 0, this.resValue.length);
            this.resName = null;
            this.resName = new String[tempN.length + 1];
            System.arraycopy(tempN, 0, this.resName, 0, tempN.length);
            this.resValue = null;
            this.resValue = new String[tempV.length + 1];
            System.arraycopy(tempV, 0, this.resValue, 0, tempV.length);
        }
        this.resName[tar] = tag;
        this.resValue[tar] = value;
    }
}

