/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.DBranking;
import hir.westfield.tm.FileControl;
import hir.westfield.tm.MapCell;
import hir.westfield.tm.ParamsClass;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.Value;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Calendar;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ToolClass {
    public boolean access = true;
    public ImageIcon playIcon = this.getImageIcon("image/playArrow.png");
    public ImageIcon nextIcon;
    public ImageIcon useIcon;
    public ImageIcon dirIcon;
    public ImageIcon dirUPIcon;
    public ImageIcon heavyIcon;
    public ImageIcon reqIcon;
    public ImageIcon splashTMSL;
    public ImageIcon againIcon;
    public JLabel playLabel = new JLabel(this.playIcon);
    public JLabel nextLabel;
    public JLabel useLabel;
    public JLabel dirLabel;
    public JLabel dirUPLabel;
    public JLabel heavyLabel;
    public JLabel reqLabel;
    public JLabel splashLabel;
    public JLabel againLabel;

    public ToolClass() {
        this.nextIcon = this.getImageIcon("image/nextBox.png");
        this.nextLabel = new JLabel(this.nextIcon);
        this.useIcon = this.getImageIcon("image/useBox.png");
        this.useLabel = new JLabel(this.useIcon);
        this.dirIcon = this.getImageIcon("image/directory.png");
        this.dirLabel = new JLabel(this.dirIcon);
        this.dirUPIcon = this.getImageIcon("image/directoryUP.png");
        this.dirUPLabel = new JLabel(this.dirUPIcon);
        this.heavyIcon = this.getImageIcon("image/heavyBox.png");
        this.heavyLabel = new JLabel(this.heavyIcon);
        this.reqIcon = this.getImageIcon("image/reqButton.png");
        this.reqLabel = new JLabel(this.reqIcon);
        this.splashTMSL = this.getImageIcon("image/splashTMSL.png");
        this.splashLabel = new JLabel(this.splashTMSL);
        this.againIcon = this.getImageIcon("image/againBox.png");
        this.againLabel = new JLabel(this.againIcon);
    }

    public JLabel getIconPlay() {
        return new JLabel(this.playIcon);
    }

    public JLabel getIconNext() {
        return new JLabel(this.nextIcon);
    }

    public JLabel getIconReq() {
        return new JLabel(this.reqIcon);
    }

    public JLabel getIconAgain() {
        return new JLabel(this.againIcon);
    }

    public String getCleanColorText(String src) {
        if (src == null) {
            return "";
        }
        String ret = src;
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "");
        return ret;
    }

    public String getGrayColorText(String src) {
        if (src == null) {
            return "";
        }
        String ret = src;
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "\\$555");
        ret = ret.replaceAll("\\$z", "\\$z\\$555");
        ret = "$555" + ret;
        return ret;
    }

    public String getSetColorText(String src, String tar) {
        if (src == null) {
            return "";
        }
        String ret = src;
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "\\$" + tar);
        ret = ret.replaceAll("\\$z", "\\$z\\$" + tar);
        ret = "$" + tar + ret;
        return ret;
    }

    public String getLightGrayColorText(String src) {
        if (src == null) {
            return "";
        }
        String ret = src;
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "\\$999");
        ret = ret.replaceAll("\\$z", "\\$z\\$999");
        ret = "$999" + ret;
        return ret;
    }

    public String getBlackColorText(String src) {
        if (src == null) {
            return "";
        }
        String ret = src;
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "\\$000");
        ret = ret.replaceAll("\\$z", "\\$z\\$000");
        ret = "$000" + ret;
        return ret;
    }

    public String getCleanTextSP(String src, boolean chk) {
        if (src == null) {
            return "";
        }
        String ret = this.getCleanText(src, chk);
        ret = ret.replace(" ", "");
        ret = ret.replaceAll("\\$[a-fA-F0-9].[a-fA-F0-9]", "");
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9]", "");
        ret = ret.replaceAll("\\$[a-fA-F0-9]", "");
        return ret;
    }

    public String getCleanText(String src, boolean chk) {
        if (src == null) {
            return "";
        }
        String ret = src;
        ret = ret.replace("$t", "");
        ret = ret.replace("$T", "");
        ret = ret.replace("$i", "");
        ret = ret.replace("$I", "");
        ret = ret.replace("$s", "");
        ret = ret.replace("$S", "");
        ret = ret.replace("$w", "");
        ret = ret.replace("$W", "");
        ret = ret.replace("$n", "");
        ret = ret.replace("$N", "");
        ret = ret.replace("$m", "");
        ret = ret.replace("$M", "");
        ret = ret.replace("$g", "");
        ret = ret.replace("$G", "");
        ret = ret.replace("$z", "");
        ret = ret.replace("$Z", "");
        ret = ret.replace("$o", "");
        ret = ret.replace("$O", "");
        ret = ret.replace("$h", "");
        ret = ret.replace("$H", "");
        ret = ret.replace("&gt;", ">");
        ret = ret.replace("&lt;", "<");
        ret = ret.replace("&amp;", "&");
        ret = ret.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "");
        String lastURL = "";
        String tempR = "";
        Pattern p = Pattern.compile("(?i)\\$l.*\\$l");
        Matcher m = p.matcher(ret);
        while (m.find()) {
            String tempUrl = ret.substring(m.start() + 2, m.end() - 2);
            Pattern pp = Pattern.compile("\\[.*\\]");
            Matcher mm = pp.matcher(tempUrl);
            if (mm.find()) {
                lastURL = String.valueOf(lastURL) + " , URL > " + tempUrl.substring(mm.start() + 1, mm.end() - 1);
                tempUrl = tempUrl.replaceAll("\\[.*\\]", "");
            } else {
                lastURL = String.valueOf(lastURL) + " , URL > " + tempUrl;
                tempUrl = "";
            }
            if (m.start() > 0) {
                tempR = String.valueOf(tempR) + ret.substring(0, m.start());
            }
            tempR = String.valueOf(tempR) + tempUrl;
            if (m.end() < ret.length() - 1) {
                tempR = String.valueOf(tempR) + ret.substring(m.end());
            }
            tempUrl = null;
            pp = null;
            mm = null;
        }
        if (!tempR.equals("")) {
            ret = tempR;
        }
        ret = ret.replaceAll("\\$l", "");
        ret = ret.replaceAll("\\$L", "");
        if (chk) {
            ret = String.valueOf(ret) + lastURL;
        }
        lastURL = null;
        tempR = null;
        p = null;
        m = null;
        return ret;
    }

    public String getDateText() {
        Calendar cal1 = Calendar.getInstance();
        int year = cal1.get(1);
        int month = cal1.get(2) + 1;
        String mon = "";
        if (month == 1) {
            mon = "Jan.";
        } else if (month == 2) {
            mon = "Feb.";
        } else if (month == 3) {
            mon = "Mar.";
        } else if (month == 4) {
            mon = "Apr.";
        } else if (month == 5) {
            mon = "May";
        } else if (month == 6) {
            mon = "Jun.";
        } else if (month == 7) {
            mon = "Jul.";
        } else if (month == 8) {
            mon = "Aug.";
        } else if (month == 9) {
            mon = "Sep.";
        } else if (month == 10) {
            mon = "Oct.";
        } else if (month == 11) {
            mon = "Nov.";
        } else if (month == 12) {
            mon = "Dec.";
        }
        int day = cal1.get(5);
        String ret = mon + day + " " + year;
        String hour = "00" + cal1.get(11);
        String minute = "00" + cal1.get(12);
        String second = "00" + cal1.get(13);
        ret = String.valueOf(ret) + " - " + hour.substring(hour.length() - 2) + ":" + minute.substring(minute.length() - 2) + ":" + second.substring(second.length() - 2);
        cal1 = null;
        mon = null;
        hour = null;
        minute = null;
        second = null;
        return ret;
    }

    public String getTimeText(long t) {
        int ori = Math.round(t / 1000L);
        int s = ori % 60;
        String ss = "00" + s;
        ss = ss.substring(ss.length() - 2);
        int m = (ori /= 60) % 60;
        String mm = "00" + m;
        mm = mm.substring(mm.length() - 2);
        int h = ori / 60;
        String ret = "";
        if (h > 0) {
            ret = String.valueOf(ret) + h + " h ";
        }
        if (m > 0) {
            ret = String.valueOf(ret) + mm + " min ";
        }
        ret = String.valueOf(ret) + ss + " sec";
        mm = null;
        ss = null;
        return ret;
    }

    public String getTimeText(long t, boolean b) {
        String ms;
        if (t == -1L) {
            t = 0L;
        }
        if (b) {
            ms = "000" + t % 1000L;
            ms = "." + ms.substring(ms.length() - 3);
            if (StartUp.cdc.tmVersion == 1) {
                ms = ms.substring(0, 3);
            }
        } else {
            ms = " sec";
        }
        int ori = b ? (int)(t / 1000L) : Math.round(t / 1000L);
        int s = ori % 60;
        String ss = "00" + s;
        ss = ss.substring(ss.length() - 2);
        int m = (ori /= 60) % 60;
        String mm = "00" + m;
        mm = mm.substring(mm.length() - 2);
        int h = ori / 60;
        String ret = "";
        if (h > 0) {
            ret = String.valueOf(ret) + h;
            ret = b ? String.valueOf(ret) + ":" : String.valueOf(ret) + " h ";
        }
        if (m > 0 || h > 0) {
            ret = String.valueOf(ret) + mm;
            ret = b ? String.valueOf(ret) + "'" : String.valueOf(ret) + " min ";
        }
        ret = String.valueOf(ret) + ss + ms;
        mm = null;
        ss = null;
        ms = null;
        return ret;
    }

    public String getCloseTimeText(int t, boolean b) {
        int ori = t;
        int s = ori % 60;
        String ss = "" + s;
        int m = (int)Math.round((double)ori / 60.0);
        String mm = "" + m;
        String ret = "";
        ret = b ? String.valueOf(ret) + mm + " minute" : String.valueOf(ret) + ss + " second";
        return ret;
    }

    public String getPlaceStringZERO(int p) {
        String ret = "" + p;
        boolean b = false;
        b = p < 10 ? true : !ret.substring(ret.length() - 2, 1).equals("1");
        ret = b ? (ret.substring(ret.length() - 1).equals("1") ? String.valueOf(ret) + "st" : (ret.substring(ret.length() - 1).equals("2") ? String.valueOf(ret) + "nd" : (ret.substring(ret.length() - 1).equals("3") ? String.valueOf(ret) + "rd" : String.valueOf(ret) + "th"))) : String.valueOf(ret) + "th";
        if (p < 1) {
            ret = "-";
        }
        return ret;
    }

    public String getPlaceString(int p) {
        String ret = "" + p;
        boolean b = false;
        b = p < 10 ? true : !ret.substring(ret.length() - 2, 1).equals("1");
        ret = b ? (ret.substring(ret.length() - 1).equals("1") ? String.valueOf(ret) + "st" : (ret.substring(ret.length() - 1).equals("2") ? String.valueOf(ret) + "nd" : (ret.substring(ret.length() - 1).equals("3") ? String.valueOf(ret) + "rd" : String.valueOf(ret) + "th"))) : String.valueOf(ret) + "th";
        return ret;
    }

    public void size(Component c, int x, int y) {
        c.setPreferredSize(new Dimension(x, y));
    }

    public JComboBox getJComboBox(int x, int y, String ... s) {
        JComboBox<String> ret = new JComboBox<String>(s);
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        return ret;
    }

    public ButtonGroup getButtonGroup(JRadioButton[] c) {
        ButtonGroup ret = new ButtonGroup();
        int i = 0;
        while (i < c.length) {
            ret.add(c[i]);
            ++i;
        }
        return ret;
    }

    public JRadioButton getJRadioButton(String mes, int x, int y, boolean b) {
        JRadioButton ret = new JRadioButton();
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        ret.setText(mes);
        ret.setSelected(b);
        return ret;
    }

    public JTextArea getJTextArea(String mes, int x, int y) {
        JTextArea ret = new JTextArea();
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        ret.setText(mes);
        return ret;
    }

    public JTextArea getJTextArea(String mes, int x, int y, boolean b) {
        JTextArea ret = this.getJTextArea(mes, x, y);
        if (b) {
            ret.setBorder(new EtchedBorder(1));
        } else {
            ret.setBorder(new EtchedBorder(0));
        }
        return ret;
    }

    public JScrollPane getJScrollPane(Component c, int x, int y, boolean b) {
        JScrollPane ret = new JScrollPane(c);
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        if (b) {
            ret.setVerticalScrollBarPolicy(22);
            ret.setHorizontalScrollBarPolicy(32);
        }
        return ret;
    }

    public JScrollPane getJScrollPane(Component c, int x, int y, boolean bx, boolean by) {
        JScrollPane ret = new JScrollPane(c);
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        if (by) {
            ret.setVerticalScrollBarPolicy(22);
        }
        if (bx) {
            ret.setHorizontalScrollBarPolicy(32);
        }
        return ret;
    }

    public JScrollPane getJScrollPane(int x, int y, boolean bx, boolean by) {
        JScrollPane ret = new JScrollPane();
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        if (by) {
            ret.setVerticalScrollBarPolicy(22);
        }
        if (bx) {
            ret.setHorizontalScrollBarPolicy(32);
        }
        return ret;
    }

    public JLabel getJLabel(String mes, int x, int y) {
        JLabel ret = new JLabel();
        this.size(ret, x, y);
        ret.setText(mes);
        return ret;
    }

    public JTextField getTextField(String text, int x, int y) {
        JTextField ret = new JTextField();
        this.size(ret, x, y);
        ret.setText(text);
        return ret;
    }

    public JPanel getJPanel(int x, int y, String lay, int lx, int ly) {
        JPanel ret = new JPanel();
        if (x != -1 && y != -1) {
            this.size(ret, x, y);
        }
        FlowLayout fl = null;
        if (lay.equals("left")) {
            fl = new FlowLayout(0, lx, ly);
        }
        if (lay.equals("right")) {
            fl = new FlowLayout(2, lx, ly);
        }
        if (lay.equals("center")) {
            fl = new FlowLayout(1, lx, ly);
        }
        if (fl != null) {
            ret.setLayout(fl);
            fl = null;
        }
        return ret;
    }

    public JPanel getJPanel(int x, int y, String lay, int lx, int ly, String border) {
        JPanel ret = this.getJPanel(x, y, lay, lx, ly);
        if (!border.equals("")) {
            if (border.equals("RAISED")) {
                ret.setBorder(new EtchedBorder(0));
            } else if (border.equals("LOWERED")) {
                ret.setBorder(new EtchedBorder(1));
            } else {
                ret.setBorder(new TitledBorder(new EtchedBorder(), border));
            }
        } else {
            ret.setBorder(new TitledBorder(new EtchedBorder(), border));
        }
        return ret;
    }

    public JFrame getJFrame(int x, int y, String title, boolean resize, String type) {
        JFrame ret = new JFrame();
        if (x != -1 && y != -1) {
            ret.setSize(new Dimension(x, y));
        }
        ret.setTitle(title);
        ret.setResizable(resize);
        if (type != null) {
            if ((type = type.toLowerCase()).equals("no")) {
                ret.setDefaultCloseOperation(0);
            }
            if (type.equals("hide")) {
                ret.setDefaultCloseOperation(1);
            }
            if (type.equals("dispose")) {
                ret.setDefaultCloseOperation(2);
            }
            if (type.equals("exit") || type.equals("")) {
                ret.setDefaultCloseOperation(3);
            }
        }
        title = null;
        type = null;
        return ret;
    }

    public void setBorderTitle(JPanel jp, String title) {
        TitledBorder temp = new TitledBorder(new EtchedBorder(), title);
        jp.setBorder(temp);
        temp = null;
        jp = null;
        title = null;
    }

    public JCheckBox getJCheckBox(String mes) {
        JCheckBox ret = null;
        ret = !mes.equals("") ? new JCheckBox(mes) : new JCheckBox();
        return ret;
    }

    public JCheckBox getJCheckBox(String mes, int x, int y) {
        JCheckBox ret = this.getJCheckBox(mes);
        this.size(ret, x, y);
        return ret;
    }

    public int getBooleanNumber(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public boolean getBoolean(String b) {
        boolean ret = false;
        if (b.equals("true") || b.equals("TRUE") || b.equals("True") || b.equals("1")) {
            ret = true;
        }
        return ret;
    }

    public String getBooleanString(JCheckBox cb) {
        String temp = "";
        temp = cb.isSelected() ? "true" : "false";
        return temp;
    }

    public String getBooleanString(boolean b, String type) {
        String temp = "";
        temp = b ? ("int".equals(type) ? "1" : "true") : ("int".equals(type) ? "0" : "false");
        return temp;
    }

    public boolean matchChk(String src, String type) {
        if (src == null) {
            return type.equals("null");
        }
        if (src.equals("")) {
            return false;
        }
        if (src.equals("-")) {
            return false;
        }
        String temp = src.replaceAll("-", "");
        if (temp.equals("")) {
            temp = null;
            return false;
        }
        temp = null;
        String regex = "";
        if (type.equals("int")) {
            regex = "^-*[0-9]+$";
        }
        if (type.equals("double")) {
            regex = "^-*[0-9.]+$";
        }
        if (type.equals("array")) {
            regex = ".&&.";
        }
        if (type.equals("boolean")) {
            regex = "(?i)^[0-1]$|true|false";
        }
        if (type.equals("null")) {
            regex = "(?i)null";
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(src);
        return m.find();
    }

    public String getRepJTF(JTextField jt) {
        String temp = jt.getText();
        temp = temp.replace(">", "&gt;");
        temp = temp.replace("<", "&lt;");
        jt = null;
        return temp;
    }

    public double returnFixDoubleA(double src, int tar) {
        double ret = src;
        if (tar < 1) {
            ret = (int)Math.floor(ret);
            return ret;
        }
        int multi = 1;
        int i = 0;
        while (i < tar) {
            multi *= 10;
            ++i;
        }
        ret *= (double)multi;
        ret = (int)Math.floor(ret);
        return ret /= (double)multi;
    }

    public String returnNickString(String s) {
        String nick = s;
        nick = nick.replaceAll("\"", "\u201d");
        nick = nick.replaceAll("<", "\uff1c");
        nick = nick.replaceAll(">", "\uff1e");
        nick = nick.replaceAll("&lt;", "\uff1c");
        nick = nick.replaceAll("&gt;", "\uff1e");
        nick = nick.replaceAll("&quot;", "\u201d");
        nick = nick.replaceAll("&amp;", "\uff06");
        nick = nick.replaceAll("&nbsp;", " ");
        String ret = nick.replaceAll("&copy;", "\u00a9");
        s = null;
        nick = null;
        return ret;
    }

    public String returnXMLString(String s) {
        String xml = s;
        xml = xml.replace("\n", "");
        xml = xml.replace("\r", "");
        xml = xml.replace("\t", "");
        xml = xml.replace(">", "&gt;");
        xml = xml.replace("<", "&lt;");
        s = null;
        return xml;
    }

    public int getInteger(String src) {
        int ret = -1;
        if (this.matchChk(src, "int")) {
            ret = Integer.parseInt(src);
        }
        return ret;
    }

    public int retBooleanInt(boolean b) {
        int ret = 0;
        ret = b ? 1 : 0;
        return ret;
    }

    public String[] splitLFT(String s) {
        String regex = "\r\n|\n|\t";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        s = m.replaceAll("-@-");
        String[] ret = s.split("-@-");
        s = null;
        return ret;
    }

    public String[] splitLF(String s) {
        String regex = "\r\n|\n";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        s = m.replaceAll("-@-");
        String[] ret = s.split("-@-");
        s = null;
        return ret;
    }

    public String deleteLF(String s) {
        String regex = "\r\n|\n";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        s = m.replaceAll("");
        return s;
    }

    public String replaceLF(String src, String mod) {
        String regex = "\r\n|\n";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(src);
        src = m.replaceAll(mod);
        return src;
    }

    public void setCenter(JFrame jfr) {
        Dimension paneSize = jfr.getSize();
        Dimension screenSize = jfr.getToolkit().getScreenSize();
        jfr.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public void setWindowPosition(JFrame jfr, int[] pos) {
        if (pos == null || jfr == null) {
            return;
        }
        Dimension paneSize = jfr.getSize();
        Dimension screenSize = jfr.getToolkit().getScreenSize();
        int maxX = screenSize.width - paneSize.width;
        int maxY = screenSize.height - paneSize.height;
        if (pos[0] < 0 || pos[1] < 0 || pos[0] > maxX || pos[1] > maxY) {
            this.setCenter(jfr);
        } else {
            jfr.setLocation(pos[0], pos[1]);
        }
    }

    public void SetParentCenter(JFrame par, JFrame chi) {
        Dimension parSize = par.getSize();
        Dimension chiSize = chi.getSize();
        Point pos = par.getLocationOnScreen();
        chi.setLocation(pos.x + (parSize.width - chiSize.width) / 2, pos.y + (parSize.height - chiSize.height) / 2);
        parSize = null;
        chiSize = null;
        pos = null;
    }

    public URL getClassURL(String tar) {
        URL url = this.getClass().getClassLoader().getResource(tar);
        return url;
    }

    public ImageIcon getImageIcon(String tar) {
        String imageFileName = tar;
        URL imageUrl = this.getClass().getClassLoader().getResource(imageFileName);
        Image image = imageUrl != null ? new ImageIcon(imageUrl).getImage() : new ImageIcon(imageFileName).getImage();
        return new ImageIcon(image);
    }

    public boolean chkTM1title(String listTitle) {
        boolean ret = listTitle.equals("nations") || listTitle.equals("united");
        return ret;
    }

    public boolean chkTM2title(String listTitle) {
        boolean ret = !listTitle.equals("nations") && !listTitle.equals("united");
        return ret;
    }

    public boolean loadDataChk(String[] src, String[] tar) {
        boolean ret = src.length <= tar.length;
        return ret;
    }

    public int returnStringCount(String s) {
        if (s == null) {
            return -1;
        }
        double count = 0.0;
        double scaleA = 1.0;
        String ss = s.replaceAll("\\$[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]", "");
        ss = ss.replaceAll("\\$[hH]\\[.*\\]", "");
        ss = ss.replaceAll("\\$h", "");
        ss = ss.replaceAll("\\$[lL]\\[.*\\]", "");
        ss = ss.replaceAll("\\$l", "");
        ss = ss.replace("$t", "");
        ss = ss.replace("$i", "");
        ss = ss.replace("$s", "");
        ss = ss.replace("$g", "");
        char[] chars = ss.toCharArray();
        double point = 0.35;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            boolean n = false;
            boolean w = false;
            boolean o = false;
            if (c == '$') {
                if (++i >= chars.length) break;
                c = chars[i];
                if (c == 'm') {
                    scaleA = 1.0;
                } else if (c == 'M') {
                    scaleA = 1.0;
                } else if (c == 'z') {
                    scaleA = 1.0;
                } else if (c == 'Z') {
                    scaleA = 1.0;
                } else if (c == 'n') {
                    if (!n) {
                        scaleA -= point;
                        n = true;
                    } else {
                        scaleA += point;
                        n = false;
                    }
                } else if (c == 'N') {
                    if (!n) {
                        scaleA -= point;
                        n = true;
                    } else {
                        scaleA += point;
                        n = false;
                    }
                } else if (c == 'w') {
                    if (!w) {
                        scaleA += point;
                        w = true;
                    } else {
                        scaleA -= point;
                        w = false;
                    }
                } else if (c == 'W') {
                    if (!w) {
                        scaleA += point;
                        w = true;
                    } else {
                        scaleA -= point;
                        w = false;
                    }
                } else if (c == 'o') {
                    if (!o) {
                        scaleA += point;
                        o = true;
                    } else {
                        scaleA -= point;
                        o = false;
                    }
                } else if (c == 'O') {
                    if (!o) {
                        scaleA += point;
                        o = true;
                    } else {
                        scaleA -= point;
                        o = false;
                    }
                } else if (c == '$') {
                    count += 1.0 * scaleA;
                }
            } else {
                double scaleB = 1.0;
                if (c >= '!' && c <= '~' || c == '\u00a5' || c == '\u203e' || c >= '\uff21' && c <= '\uff3a' || c >= '\uff10' && c <= '\uff5a' || c == '\u044f' || c == ' ' || c == '\u03af' || c == '\u0442' || c == '\u0454' || c == '\u05d0' || c >= '\u00aa' && c <= '\u00f0' || c >= '\u093a' && c <= '\u094f') {
                    scaleB = 1.0;
                    count += scaleB * scaleA;
                } else {
                    scaleB = 2.0;
                    if (c <= '\u0fff') {
                        scaleB = 1.0;
                    }
                    count += scaleB * scaleA;
                }
            }
            ++i;
        }
        return (int)Math.ceil(count);
    }

    public int returnStringCount(String s, boolean b) {
        if (s == null) {
            return -1;
        }
        String ss = this.getCleanText(s, true);
        char[] chars = ss.toCharArray();
        int count = 0;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c <= '~' || c == '\u00a5' || c == '\u203e' || c >= '\uff61' && c <= '\uff9f') {
                ++count;
            } else {
                ++count;
                ++count;
            }
            ++i;
        }
        Pattern p = Pattern.compile("\\$o");
        Matcher m = p.matcher(s);
        if (m.find()) {
            count = StartUp.cdc.tmVersion == 2 ? (int)Math.round((double)count * 1.25) : (int)Math.round((double)count * 1.5);
        }
        p = null;
        p = Pattern.compile("\\$w");
        m = null;
        m = p.matcher(s);
        if (m.find()) {
            count = (int)Math.round((double)count * 1.5);
        }
        m = null;
        p = null;
        chars = null;
        return count;
    }

    public boolean chkFault(Value[] src) {
        boolean ret = false;
        if (src == null) {
            ret = false;
            return ret;
        }
        if (src[0].name != null && src[0].name.equals("faultCode")) {
            StartUp.printDEBUG("faultCode : " + src[0].value);
            StartUp.printDEBUG("faultString : " + src[1].value);
            ret = true;
        }
        return ret;
    }

    public String getMiliTODate(long l) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(l);
        String ret = "";
        int year = cal1.get(1);
        int month = cal1.get(2) + 1;
        String mon = "0" + month;
        mon = mon.substring(mon.length() - 2);
        int dayInt = cal1.get(5);
        String day = "0" + dayInt;
        day = day.substring(day.length() - 2);
        ret = year + "-" + mon + "-" + day;
        mon = null;
        day = null;
        String hour = "00" + cal1.get(11);
        String minute = "00" + cal1.get(12);
        String second = "00" + cal1.get(13);
        ret = String.valueOf(ret) + " " + hour.substring(hour.length() - 2) + ":" + minute.substring(minute.length() - 2) + ":" + second.substring(second.length() - 2);
        cal1 = null;
        mon = null;
        hour = null;
        minute = null;
        second = null;
        return ret;
    }

    public String getNowDate(boolean b) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(System.currentTimeMillis());
        String ret = "";
        int year = cal1.get(1);
        int month = cal1.get(2) + 1;
        String mon = "0" + month;
        mon = mon.substring(mon.length() - 2);
        int dayInt = cal1.get(5);
        String day = "0" + dayInt;
        day = day.substring(day.length() - 2);
        ret = year + mon + day;
        mon = null;
        day = null;
        if (b) {
            String hour = "00" + cal1.get(11);
            String minute = "00" + cal1.get(12);
            String second = "00" + cal1.get(13);
            ret = String.valueOf(ret) + hour.substring(hour.length() - 2) + minute.substring(minute.length() - 2) + second.substring(second.length() - 2);
            hour = null;
            minute = null;
            second = null;
        }
        cal1 = null;
        mon = null;
        return ret;
    }

    public int getChkInt(String src) {
        if (src == null) {
            return -1;
        }
        int ret = 0;
        ret = this.matchChk(src, "int") ? Integer.parseInt(src) : -1;
        src = null;
        return ret;
    }

    public String[] addArray(String[] origin, String add) {
        String[] ret = null;
        int len = 0;
        if (origin == null) {
            ret = new String[1];
            len = 0;
        } else {
            len = origin.length;
            ret = new String[len + 1];
            System.arraycopy(origin, 0, ret, 0, len);
            origin = null;
        }
        ret[len] = add;
        add = null;
        return ret;
    }

    public String[] getNowDateTime() {
        String[] ret = null;
        ret = new String[3];
        Calendar cal1 = Calendar.getInstance();
        int year = cal1.get(1);
        int month = cal1.get(2) + 1;
        String mon = "";
        if (month == 1) {
            mon = "Jan.";
        } else if (month == 2) {
            mon = "Feb.";
        } else if (month == 3) {
            mon = "Mar.";
        } else if (month == 4) {
            mon = "Apr.";
        } else if (month == 5) {
            mon = "May";
        } else if (month == 6) {
            mon = "Jun.";
        } else if (month == 7) {
            mon = "Jul.";
        } else if (month == 8) {
            mon = "Aug.";
        } else if (month == 9) {
            mon = "Sep.";
        } else if (month == 10) {
            mon = "Oct.";
        } else if (month == 11) {
            mon = "Nov.";
        } else if (month == 12) {
            mon = "Dec.";
        }
        int day = cal1.get(5);
        ret[0] = String.valueOf(mon) + day + " " + year;
        String hour = "00" + cal1.get(11);
        String minute = "00" + cal1.get(12);
        String second = "00" + cal1.get(13);
        ret[1] = String.valueOf(hour.substring(hour.length() - 2)) + ":" + minute.substring(minute.length() - 2) + ":" + second.substring(second.length() - 2);
        String mili = "000" + cal1.get(14);
        ret[2] = mili.substring(mili.length() - 3);
        cal1 = null;
        mon = null;
        hour = null;
        minute = null;
        second = null;
        mili = null;
        return ret;
    }

    public String getJarConfig() {
        String ret = "";
        try {
            JarFile jarFile;
            ZipEntry entry;
            String targetFile = System.getProperty("java.class.path");
            String[] tempT = targetFile.split(";");
            if (tempT.length > 1) {
                targetFile = tempT[1];
            }
            if ((entry = (jarFile = new JarFile(targetFile)).getEntry("image/config.txt")) != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
                String text = reader.readLine();
                ret = text;
                while (text != null) {
                    text = reader.readLine();
                    if (text == null) continue;
                    ret = text;
                }
                reader.close();
            } else {
                ret = "";
            }
            entry = null;
            jarFile.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return ret;
    }

    public int getSetLaps(SVCMainThread svc) {
        if (svc == null) {
            return -1;
        }
        int setLaps = 1;
        if (svc.currentGameInfo != null) {
            String nowMode = this.getModeString(svc.currentGameInfo.gameMode).toLowerCase();
            int newLaps = 0;
            if (nowMode.startsWith("round") || nowMode.startsWith("team")) {
                setLaps = svc.nowMapInfo != null ? svc.nowMapInfo.lapCount : 1;
                if (svc.nowMapInfo.lapRace) {
                    newLaps = svc.currentGameInfo.roundForcedLaps;
                }
            } else if (nowMode.startsWith("lap")) {
                if (svc.nowMapInfo != null) {
                    setLaps = svc.nowMapInfo.lapCount;
                }
                newLaps = svc.currentGameInfo.lapsNbLaps;
            }
            if (newLaps != 0) {
                setLaps = newLaps;
            }
        }
        if (setLaps == 0) {
            setLaps = 1;
        }
        return setLaps;
    }

    public int getPlayerNumberFromID(SVCMainThread s, int id) {
        if (id < 0) {
            return -1;
        }
        int ret = -1;
        if (s.players == null) {
            return -1;
        }
        int i = 0;
        while (i < s.players.length) {
            if (s.players[i] != null && !s.players[i].disConnect && s.players[i].playerID == id) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    public int getNumberFromLogin(SVCMainThread s, String login) {
        if (login == null) {
            return -1;
        }
        int ret = -1;
        if (s.players != null) {
            int i = 0;
            while (i < s.players.length) {
                if (s.players[i] != null && s.players[i].login != null && s.players[i].login.equals(login)) {
                    ret = i;
                    break;
                }
                ++i;
            }
        }
        if (ret == -1 && login.startsWith(s.cdc.nowCM.serverAccount)) {
            ret = -99;
        }
        login = null;
        s = null;
        return ret;
    }

    public int getPlayerNumberFromLogin(SVCMainThread s, String login) {
        return this.getNumberFromLogin(s, login);
    }

    public int getModeNumber(String mode) {
        int ret = 0;
        mode = mode.toLowerCase();
        if (StartUp.cdc.tmVersion == 1) {
            if (mode.startsWith("round")) {
                ret = 0;
            } else if (mode.startsWith("timeattack")) {
                ret = 1;
            } else if (mode.startsWith("team")) {
                ret = 2;
            } else if (mode.startsWith("lap")) {
                ret = 3;
            } else if (mode.startsWith("cup")) {
                ret = 5;
            } else if (mode.startsWith("stunt")) {
                ret = 4;
            } else if (mode.startsWith("exlaps")) {
                ret = 3;
            }
        } else if (StartUp.cdc.tmVersion == 2) {
            if (mode.startsWith("script")) {
                ret = 0;
            } else if (mode.startsWith("round")) {
                ret = 1;
            } else if (mode.startsWith("timeattack")) {
                ret = 2;
            } else if (mode.startsWith("team")) {
                ret = 3;
            } else if (mode.startsWith("lap")) {
                ret = 4;
            } else if (mode.startsWith("cup")) {
                ret = 5;
            } else if (mode.startsWith("stunt")) {
                ret = 6;
            } else if (mode.startsWith("exlaps")) {
                ret = 4;
            }
        }
        return ret;
    }

    public String getModeString(int mode) {
        String ret = "";
        if (StartUp.cdc.tmVersion == 1) {
            if (mode == 0) {
                ret = "Rounds";
            } else if (mode == 1) {
                ret = "TimeAttack";
            } else if (mode == 2) {
                ret = "Team";
            } else if (mode == 3) {
                ret = "Laps";
            } else if (mode == 4) {
                ret = "Stunts";
            } else if (mode == 5) {
                ret = "Cup";
            }
        } else if (StartUp.cdc.tmVersion == 2) {
            if (mode == 0) {
                ret = "Script";
            } else if (mode == 1) {
                ret = "Rounds";
            } else if (mode == 2) {
                ret = "TimeAttack";
            } else if (mode == 3) {
                ret = "Team";
            } else if (mode == 4) {
                ret = "Laps";
            } else if (mode == 5) {
                ret = "Cup";
            } else if (mode == 6) {
                ret = "Stunts";
            }
        }
        return ret;
    }

    public String getNowModeString(SVCMainThread s) {
        String ret = "";
        if (s == null) {
            return ret;
        }
        if (s.currentGameInfo == null) {
            return ret;
        }
        if (s.currentGameInfo.modeString == null) {
            return ret;
        }
        ret = s.currentGameInfo.modeString;
        if (s.runLapEX) {
            ret = "LapEX";
        } else if (s.exRound) {
            ret = "RoundEX";
        } else if (s.exTAFin) {
            ret = "TA EX-Count-";
        } else if (s.exTAFinPT) {
            ret = "TA EX-Point-";
        } else if (s.exTATeam) {
            ret = "TA EX-Team-";
        }
        return ret;
    }

    public DBranking getNowRank(String login, DBranking[] tar) {
        DBranking ret = null;
        int i = 0;
        while (i < tar.length) {
            if (tar[i].login.equals(login)) {
                ret = new DBranking(tar[i]);
                i = tar.length;
                break;
            }
            ++i;
        }
        tar = null;
        return ret;
    }

    public String retReplace(String src) {
        String ret = src.replace(">", "&gt;");
        ret = ret.replace("<", "&lt;");
        src = null;
        return ret;
    }

    public MapCell[] addMapCell(SVCMainThread svc, MapCell[] src, MapCell mc) {
        if (mc == null) {
            return src;
        }
        MapCell[] temp = null;
        if (src != null) {
            temp = new MapCell[src.length + 1];
            System.arraycopy(src, 0, temp, 0, src.length);
        } else {
            temp = new MapCell[1];
        }
        temp[temp.length - 1] = new MapCell(svc, mc);
        return temp;
    }

    public String retScoreBackImageURL(SVCMainThread svc, int rank, int i) {
        String img = i % 2 == 0 ? svc.ml.image.scoreEvenBack : svc.ml.image.scoreOddBack;
        if (rank == 1) {
            img = svc.ml.image.score1stBack;
        } else if (rank == 2) {
            img = svc.ml.image.score2ndBack;
        } else if (rank == 3) {
            img = svc.ml.image.score3rdBack;
        }
        return img;
    }

    public boolean checkString(String src, String tar) {
        Pattern p = Pattern.compile("@");
        Matcher m = p.matcher(src);
        return m.find();
    }

    public int hex2int(String s) {
        int ret = 0;
        try {
            ret = Integer.parseInt(s, 16);
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public String getHTMLEscape(String src) {
        String ret = src;
        ret = ret.replaceAll("&", "&amp;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("'", "&#39;");
        src = null;
        return ret;
    }

    public String getHTMLEscapeFake(String src) {
        String ret = this.getCleanText(src, false);
        ret = ret.replaceAll("&lt;", "\uff1c");
        ret = ret.replaceAll("&gt;", "\uff1e");
        ret = ret.replaceAll("&amp;", "\uff06");
        ret = ret.replaceAll("&quot;", "\u201d");
        ret = ret.replaceAll("&#39;", "\u2019");
        src = null;
        return ret;
    }

    public String getTABFakeHTML(String src) {
        String ret = src;
        ret = ret.replaceAll("&#009;", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        src = null;
        return ret;
    }

    public String inputLinePartition(String src) {
        String ret = src;
        ret = ret.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\" \\?>", "\n\t<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        ret = ret.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "\n\t<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ret = ret.replaceAll("<methodResponse>", "\n\t<methodResponse>");
        ret = ret.replaceAll("<params><param><value>", "\n\t<params><param><value>");
        ret = ret.replaceAll("<array>", "\n\t<array>");
        ret = ret.replaceAll("</array>", "\n\t</array>");
        ret = ret.replaceAll("<data><value>", "\n\t<data><value>");
        ret = ret.replaceAll("</value></data>", "\n\t</value></data>");
        ret = ret.replaceAll("<struct>", "\n\t<struct>");
        ret = ret.replaceAll("</struct>", "\n\t</struct>");
        ret = ret.replaceAll("<member>", "\n\t<member>");
        ret = ret.replaceAll("</value><value>", "\n\t</value>\n\t<value>");
        ret = ret.replaceAll("</value></param></params>", "\n\t</value></param></params>");
        ret = ret.replaceAll("</methodResponse>", "\n\t</methodResponse>");
        src = null;
        return ret;
    }

    public int getPlayersNumberFromParam(SVCMainThread svc, Value[] param) {
        int pl = -1;
        if (svc.players != null) {
            int i = 0;
            while (i < svc.players.length) {
                if (svc.players[i] != null && param[1].value.equals(svc.players[i].login)) {
                    pl = i;
                    break;
                }
                ++i;
            }
        }
        return pl;
    }

    public int chkPlayersCount(SVCMainThread svc) {
        int ret = 0;
        if (svc.players == null) {
            return ret;
        }
        int i = 0;
        while (i < svc.players.length) {
            if (svc.players[i] != null && svc.players[i].connect) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public boolean checkUseSQL(SVCMainThread s) {
        if (s == null) {
            return false;
        }
        return this.getBoolean(s.cdc.nowCM.dbAccess[0]);
    }

    public void useSQLset(SVCMainThread s, boolean b) {
        if (s != null) {
            if (s.svReactionThread != null && s.svReactionThread.mySQL != null && s.svReactionThread.mySQL.sqlUse != null) {
                s.cdc.nowCM.dbAccess[0] = "" + b;
                s.svReactionThread.mySQL.sqlPanelState();
                s.svReactionThread.mySQL.sqlUse.setSelected(b);
            }
            if (s.dbThread != null) {
                int i = 0;
                while (i < s.dbThread.dbQueue.length) {
                    s.dbThread.dbQueue[i] = null;
                    ++i;
                }
                i = 0;
                while (i < s.dbThread.dbQueueFast.length) {
                    s.dbThread.dbQueueFast[i] = null;
                    ++i;
                }
            }
        }
    }

    public void setRCBDebug(SVCMainThread s, ParamsClass pc, boolean chk) {
        if (chk) {
            this.setRCBDebugFC(s.completeRCB, pc.methodName);
        } else {
            this.setRCBDebugFC(s.incompleteRCB, pc.methodName);
        }
    }

    private void setRCBDebugFC(FileControl fc, String add) {
        boolean chk = true;
        if (fc.dataText != null) {
            int i = 0;
            while (i < fc.dataText.length) {
                if (fc.dataText[i] != null && fc.dataText[i].equals(add)) {
                    chk = false;
                    break;
                }
                ++i;
            }
        }
        if (chk) {
            fc.dataText = this.addStringArray(fc.dataText, add);
            if (!fc.directoryCheck) {
                fc.makeDirectory();
            }
            fc.makeTextFile();
        }
    }

    public String[] addStringArray(String[] src, String add) {
        int tar = -1;
        String[] ret = null;
        if (src == null) {
            ret = new String[1];
            tar = 0;
        } else {
            tar = src.length;
            ret = new String[tar + 1];
            System.arraycopy(src, 0, ret, 0, tar);
        }
        ret[tar] = add;
        return ret;
    }

    public Value[] addValueArray(Value[] src, Value add) {
        Value[] ret = null;
        int tar = -1;
        if (src == null) {
            ret = new Value[1];
            tar = 0;
        } else {
            tar = src.length;
            ret = new Value[tar + 1];
            System.arraycopy(src, 0, ret, 0, tar);
        }
        ret[tar] = new Value(add);
        return ret;
    }

    public Value[] copyValueArray(Value[] src) {
        return src;
    }

    public MapCell[] copyMapCellArray(MapCell[] src) {
        return src;
    }

    public DBranking[] copyDBrankingArray(DBranking[] src) {
        return src;
    }

    public MapCell[] addMapCellArray(MapCell[] src, MapCell add) {
        MapCell[] ret = null;
        int tar = -1;
        if (src == null) {
            ret = new MapCell[1];
            tar = 0;
        } else {
            tar = src.length;
            ret = new MapCell[tar + 1];
            System.arraycopy(src, 0, ret, 0, tar);
        }
        ret[tar] = new MapCell(add);
        return ret;
    }

    public String setSQLNickName(String src) {
        String ret = src;
        ret = ret.replaceAll("%", "\\%");
        ret = ret.replaceAll("_", "\\_");
        ret = ret.replaceAll("'", "''");
        ret = ret.replaceAll("\\\\", "\\\\\\\\");
        return ret;
    }

    public int[] getTargetStringInt(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 25) {
            s = String.valueOf(s) + "                              ";
        }
        char[] chars = s.toCharArray();
        int[] ret = new int[25];
        int i = 0;
        while (i < 25) {
            if (chars.length > i) {
                ret[i] = chars[i];
            }
            ++i;
        }
        return ret;
    }

    public int[] addInteger(int[] src, int set) {
        int[] ret;
        int tar = 0;
        if (src == null) {
            ret = new int[1];
            tar = 0;
        } else {
            ret = new int[src.length + 1];
            tar = src.length;
            System.arraycopy(src, 0, ret, 0, tar);
            src = null;
        }
        ret[tar] = set;
        return ret;
    }
}

