/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.ConfigMemory;
import hir.westfield.tm.ControlDataClass;
import hir.westfield.tm.FileControl;
import hir.westfield.tm.MainFrameListener;
import hir.westfield.tm.RemoteOption;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.UPnPThread;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StartingMenu
extends Thread
implements ActionListener,
ItemListener {
    public JFrame mainFrame;
    private JPanel mainPanel;
    private JPanel addPanel;
    private int listIndex;
    private String[] initData;
    private String[] listFileName;
    private JScrollPane serverPane;
    private JButton addServer;
    private JButton modServer;
    private JButton delServer;
    private JButton runServer;
    private JButton runController;
    private JButton exitSystem;
    private JCheckBox[] debugCB;
    private int deleteSelect;
    public RemoteOption ro;
    private JList serverList;
    private ControlDataClass cdc;

    public StartingMenu(JFrame jf, JPanel jp, ControlDataClass c) {
        this.mainFrame = jf;
        this.mainPanel = jp;
        this.cdc = c;
        jf = null;
        jp = null;
        c = null;
        this.mainFrame.setVisible(false);
        this.mainPanel.removeAll();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new MainFrameListener());
        this.mainFrame.setTitle(String.valueOf(StartUp.mainTitle) + StartUp.verString);
        if (StartUp.debugF) {
            this.mainFrame.setSize(new Dimension(400, 300));
        } else {
            this.mainFrame.setSize(new Dimension(400, 260));
        }
        this.listIndex = -99;
        if (this.cdc.configData.dataText[19].equals("0")) {
            this.initData = new String[0];
            this.listFileName = new String[0];
        } else {
            int listCount = Integer.parseInt(this.cdc.configData.dataText[19]);
            this.initData = new String[listCount];
            this.listFileName = new String[listCount];
            int i = 0;
            while (i < listCount) {
                String[] tempSplit = this.cdc.configData.dataText[20 + i].split("&");
                this.initData[i] = tempSplit[0];
                this.listFileName[i] = tempSplit[1];
                ++i;
            }
        }
        this.serverList = new JList<String>(this.initData);
        this.serverPane = new JScrollPane();
        this.serverPane.getViewport().setView(this.serverList);
        StartUp.tool.size(this.serverPane, 250, 100);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 1) {
                    index = StartingMenu.this.serverList.locationToIndex(e.getPoint());
                    StartingMenu.this.listSingleSelected(index);
                    StartingMenu.this.listIndex = index;
                } else if (e.getClickCount() == 2) {
                    index = StartingMenu.this.serverList.locationToIndex(e.getPoint());
                    StartingMenu.this.listSingleSelected(index);
                }
                boolean temp = !StartingMenu.this.serverList.isSelectionEmpty();
                if (StartingMenu.this.runServer != null) {
                    StartingMenu.this.runServer.setEnabled(temp);
                }
                if (StartingMenu.this.runController != null) {
                    StartingMenu.this.runController.setEnabled(true);
                }
                if (StartingMenu.this.modServer != null) {
                    StartingMenu.this.modServer.setEnabled(temp);
                }
                if (StartingMenu.this.delServer != null) {
                    StartingMenu.this.delServer.setEnabled(temp);
                }
            }
        };
        this.serverList.addMouseListener(mouseListener);
        this.addPanel = StartUp.debugF ? StartUp.tool.getJPanel(400, 300, "center", 0, 5) : StartUp.tool.getJPanel(400, 260, "center", 0, 5);
        JPanel p1st = StartUp.tool.getJPanel(270, 100, "left", 10, 0);
        p1st.add(this.serverPane);
        JPanel p2nd = StartUp.tool.getJPanel(130, 100, "left", 0, 5);
        this.addServer = this.getButton("Add server", "add", 120, 25);
        this.modServer = this.getButton("Modify server", "mod", 120, 25);
        this.delServer = this.getButton("Delete server", "del", 120, 25);
        p2nd.add(this.addServer);
        p2nd.add(this.modServer);
        p2nd.add(this.delServer);
        JPanel p3rd = StartUp.tool.getJPanel(300, 75, "center", 0, 10);
        this.runServer = this.getButton("Start server", "run", 200, 30);
        this.runServer.setEnabled(false);
        this.exitSystem = this.getButton("Exit", "exit", 200, 25);
        p3rd.add(this.runServer);
        p3rd.add(this.exitSystem);
        JPanel p4th = StartUp.tool.getJPanel(300, 65, "center", 0, 5, "Remote controller");
        this.runController = this.getButton("Start Only controller", "runController", 250, 25);
        this.runController.setEnabled(true);
        p4th.add(this.runController);
        JPanel p5th = null;
        if (StartUp.debugF) {
            p5th = StartUp.tool.getJPanel(390, 40, "center", 0, 0);
            this.debugCB = new JCheckBox[7];
            this.debugCB[0] = StartUp.tool.getJCheckBox("Debuger", 390, 20);
            this.debugCB[0].setSelected(true);
            this.debugCB[1] = StartUp.tool.getJCheckBox("Message", 80, 20);
            this.debugCB[1].setSelected(StartUp.debugDEBUG);
            this.debugCB[2] = StartUp.tool.getJCheckBox("DB", 45, 20);
            this.debugCB[2].setSelected(StartUp.debugDB);
            this.debugCB[3] = StartUp.tool.getJCheckBox("XML", 50, 20);
            this.debugCB[3].setSelected(StartUp.debugXML);
            this.debugCB[4] = StartUp.tool.getJCheckBox("Method", 70, 20);
            this.debugCB[4].setSelected(StartUp.debugResult);
            this.debugCB[5] = StartUp.tool.getJCheckBox("Callback", 75, 20);
            this.debugCB[5].setSelected(StartUp.debugMethod);
            this.debugCB[6] = StartUp.tool.getJCheckBox("Dedi", 50, 20);
            this.debugCB[6].setSelected(StartUp.debugDedi);
            int i = 0;
            while (i < this.debugCB.length) {
                this.debugCB[i].addItemListener(this);
                p5th.add(this.debugCB[i]);
                ++i;
            }
        }
        this.addPanel.add(p1st);
        this.addPanel.add(p2nd);
        this.addPanel.add(p3rd);
        this.addPanel.add(p4th);
        if (StartUp.debugF) {
            this.addPanel.add(p5th);
        }
        boolean temp = !this.serverList.isSelectionEmpty();
        if (this.runServer != null) {
            this.runServer.setEnabled(temp);
        }
        if (this.runController != null) {
            this.runController.setEnabled(true);
        }
        if (this.modServer != null) {
            this.modServer.setEnabled(temp);
        }
        if (this.delServer != null) {
            this.delServer.setEnabled(temp);
        }
        this.mainPanel.add(this.addPanel);
        this.mainFrame.add(this.mainPanel);
        this.mainFrame.pack();
        this.mainFrame.setResizable(false);
        this.SetShowWindow();
        this.mainFrame.setVisible(true);
    }

    @Override
    public void run() {
        StartUp.printDEBUG("[StartingMenu] run");
    }

    private JButton getButton(String title, String command) {
        JButton ret = new JButton(title);
        ret.addActionListener(this);
        ret.setActionCommand(command);
        ret.setPreferredSize(new Dimension(75, 20));
        return ret;
    }

    private JButton getButton(String title, String command, int x, int y) {
        JButton ret = this.getButton(title, command);
        ret.setPreferredSize(new Dimension(x, y));
        return ret;
    }

    private void listSingleSelected(int id) {
        if (!this.serverList.isSelectionEmpty() && this.serverList.getMinSelectionIndex() != this.serverList.getMaxSelectionIndex()) {
            this.serverList.clearSelection();
            this.serverList.setSelectedIndex(id);
        }
    }

    private void SetShowWindow() {
        int[] pos = new int[2];
        pos[0] = -1;
        if (StartUp.tool.matchChk(this.cdc.configData.dataText[0], "int")) {
            pos[0] = Integer.parseInt(this.cdc.configData.dataText[0]);
        }
        pos[1] = -1;
        if (StartUp.tool.matchChk(this.cdc.configData.dataText[1], "int")) {
            pos[1] = Integer.parseInt(this.cdc.configData.dataText[1]);
        }
        StartUp.tool.setWindowPosition(this.mainFrame, pos);
        this.mainFrame.setVisible(true);
        this.mainFrame.validate();
    }

    public void startingMenuCloser() {
        StartUp.print("[StartingMenu] position save");
        Point pos = StartUp.sMenu.mainFrame.getLocationOnScreen();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode dm = ge.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = dm.getWidth();
        int displayHeight = dm.getHeight();
        this.cdc.configData.dataText[0] = pos.x > -1 && pos.x <= displayWidth ? String.valueOf(pos.x) : "-1";
        this.cdc.configData.dataText[1] = pos.y > -1 && pos.y <= displayHeight ? String.valueOf(pos.y) : "-1";
        this.cdc.configData.makeTextFile();
        this.mainFrame.setVisible(false);
        this.addPanel.removeAll();
        this.addPanel = null;
        this.initData = null;
        this.listFileName = null;
        this.serverPane = null;
        this.addServer = null;
        this.modServer = null;
        this.delServer = null;
        this.runServer = null;
        this.runController = null;
        this.exitSystem = null;
        this.mainPanel.removeAll();
        this.mainPanel.validate();
        StartUp.sMenuClose = true;
    }

    private boolean deleteListElement() {
        int tempCount = Integer.parseInt(StartUp.cdc.configData.dataText[19]);
        String[] tempSplit = StartUp.cdc.configData.dataText[20 + this.listIndex].split("&");
        File targetFile = new File(tempSplit[1]);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        StartUp.cdc.configData.cutTextData(20 + this.listIndex);
        StartUp.cdc.configData.dataText[19] = "" + (tempCount - 1);
        StartUp.cdc.configData.makeTextFile();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        StartUp.printDEBUG("[StartingMenu] Button - " + cmd);
        if (cmd.equals("add")) {
            this.startingMenuCloser();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StartUp.mainState = 2;
        } else if (cmd.equals("exit")) {
            this.startingMenuCloser();
            StartUp.mainState = -1;
        } else if (cmd.equals("del")) {
            int deleteSelect = JOptionPane.showConfirmDialog(this.mainFrame, "[ " + this.initData[this.listIndex] + " ] is deleted. Are you sure ?");
            while (deleteSelect == -1) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (deleteSelect > -1) {
                if (deleteSelect == 0 && this.deleteListElement()) {
                    this.startingMenuCloser();
                    StartUp.mainState = 3;
                }
                deleteSelect = -1;
            }
        } else if (cmd.equals("mod")) {
            this.startingMenuCloser();
            StartUp.sMenuListIndex = this.listIndex;
            try {
                Thread.sleep(100L);
            }
            catch (Exception deleteSelect) {
                // empty catch block
            }
            StartUp.mainState = 4;
        } else if (cmd.equals("run") || cmd.equals("runController") && this.listIndex > -99) {
            StartUp.sMenuListIndex = this.listIndex;
            String[] tempSplit = StartUp.cdc.configData.dataText[20 + this.listIndex].split("&");
            FileControl fc = new FileControl(tempSplit[1]);
            if (!fc.fileCheck) {
                JOptionPane.showMessageDialog(null, "Failed to read the configuration file.\nIt will delete the target configuration file.");
                if (this.deleteListElement()) {
                    this.startingMenuCloser();
                    StartUp.mainState = 3;
                }
            } else {
                fc.readTextData();
                StartUp.cdc.configFileName = tempSplit[1];
                StartUp.cdc.nowCM = new ConfigMemory();
                StartUp.cdc.nowCM.loadText(fc.dataText);
                fc = null;
                Pattern p = Pattern.compile("\\\\");
                Matcher m = p.matcher(StartUp.cdc.nowCM.serverFileLocation);
                int tempEnd = 0;
                while (m.find()) {
                    tempEnd = m.end();
                }
                StartUp.cdc.serverFolder = StartUp.cdc.nowCM.serverFileLocation.substring(0, tempEnd);
                if (StartUp.tool.chkTM1title(StartUp.cdc.nowCM.gameTitle)) {
                    StartUp.cdc.tmVersion = 1;
                } else if (StartUp.tool.chkTM2title(StartUp.cdc.nowCM.gameTitle)) {
                    StartUp.cdc.tmVersion = 2;
                }
                if (cmd.equals("run")) {
                    this.startingMenuCloser();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StartUp.mainState = 5;
                } else if (cmd.equals("runController")) {
                    FileControl upnp = new FileControl(StartUp.cdc.workFolder, "upnpOpen.txt");
                    if (upnp.fileCheck && this.setUPnP() && StartUp.upnpControl.startOK) {
                        StartUp.upnpControl.start();
                    }
                    upnp = null;
                    this.startingMenuCloser();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StartUp.mainState = 7;
                }
            }
        } else if (cmd.equals("runController")) {
            StartUp.cdc.nowCM = new ConfigMemory();
            StartUp.cdc.configFileName = null;
            this.ro = new RemoteOption(this);
        }
    }

    private boolean setUPnP() {
        boolean ret = true;
        JFrame jf = StartUp.tool.getJFrame(300, 100, "UPnP setting", false, "no");
        StartUp.tool.setCenter(jf);
        JPanel jp = StartUp.tool.getJPanel(300, 100, "center", 0, 0);
        jp.add(new JLabel("UPnP start setting ..."));
        jf.add(jp);
        jf.setVisible(true);
        this.mainFrame.setVisible(false);
        StartUp.upnpControl = new UPnPThread();
        if (StartUp.upnpControl.connect(true)) {
            int port = this.cdc.nowCM.serverPort;
            if (!StartUp.upnpControl.setOpenPort(port)) {
                this.mainFrame.setVisible(true);
                JOptionPane.showMessageDialog(this.mainFrame, "UPnP devices can not be found.");
                ret = false;
            } else {
                port = this.cdc.nowCM.p2pPort;
                if (!StartUp.upnpControl.setOpenPort(port)) {
                    this.mainFrame.setVisible(true);
                    JOptionPane.showMessageDialog(this.mainFrame, "UPnP devices can not be found.");
                    ret = false;
                } else {
                    StartUp.upnpControl.startOK = true;
                    ret = true;
                }
            }
        } else {
            this.mainFrame.setVisible(true);
            JOptionPane.showMessageDialog(this.mainFrame, "UPnP devices can not be found.");
            ret = false;
        }
        jf.add(jp);
        jf.setVisible(false);
        jp = null;
        jf = null;
        this.mainFrame.setVisible(true);
        return ret;
    }

    public void closeRemoteOption(boolean b) {
        if (this.ro != null) {
            this.ro = null;
        }
        if (b) {
            this.startingMenuCloser();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StartUp.mainState = 7;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.debugCB[0]) {
            StartUp.debugF = this.debugCB[0].isSelected();
            int i = 1;
            while (i < this.debugCB.length) {
                this.debugCB[i].setEnabled(StartUp.debugF);
                ++i;
            }
        } else if (e.getItemSelectable() == this.debugCB[1]) {
            StartUp.debugDEBUG = this.debugCB[1].isSelected();
        } else if (e.getItemSelectable() == this.debugCB[2]) {
            StartUp.debugDB = this.debugCB[2].isSelected();
        } else if (e.getItemSelectable() == this.debugCB[3]) {
            StartUp.debugXML = this.debugCB[3].isSelected();
        } else if (e.getItemSelectable() == this.debugCB[4]) {
            StartUp.debugResult = this.debugCB[4].isSelected();
        } else if (e.getItemSelectable() == this.debugCB[5]) {
            StartUp.debugMethod = this.debugCB[5].isSelected();
        } else if (e.getItemSelectable() == this.debugCB[6]) {
            StartUp.debugDedi = this.debugCB[6].isSelected();
        }
    }
}

