/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.SVCSSPlayerListCell;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.ToolClass;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SVCSSPlayerPanel
extends JPanel
implements ActionListener {
    public JPanel playerListPanel;
    public JButton[] playerButton;
    private SVCMainThread svc;

    public SVCSSPlayerPanel(SVCMainThread s) {
        this.svc = s;
        s = null;
        ToolClass tool = StartUp.tool;
        this.setPreferredSize(new Dimension(467, 340));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBorder(new TitledBorder(new EtchedBorder(), "Connecting player list"));
        this.playerListPanel = new JPanel();
        this.playerListPanel.setLayout(new FlowLayout(0, 0, 0));
        this.playerListPanel.setBackground(Color.LIGHT_GRAY);
        JScrollPane playerScrollPane = new JScrollPane(this.playerListPanel);
        playerScrollPane.setPreferredSize(new Dimension(455, 240));
        this.add(new SVCSSPlayerListCell(this.svc, true));
        this.add(playerScrollPane);
        JPanel plButton = tool.getJPanel(455, 39, "center", 0, 6);
        this.playerButton = new JButton[3];
        JPanel plB1 = tool.getJPanel(151, 25, "center", 0, 1);
        this.playerButton[0] = this.getButton("Kick", "kickPL", 100, 23);
        plB1.add(this.playerButton[0]);
        JPanel plB2 = tool.getJPanel(151, 25, "center", 0, 1);
        this.playerButton[1] = this.getButton("Ban", "banPL", 100, 23);
        plB2.add(this.playerButton[1]);
        JPanel plB3 = tool.getJPanel(151, 25, "center", 0, 1);
        this.playerButton[2] = this.getButton("Set to Blacklist", "blackPL", 120, 23);
        plB3.add(this.playerButton[2]);
        plButton.add(plB1);
        plButton.add(plB2);
        plButton.add(plB3);
        this.add(plButton);
        this.setButtonState();
    }

    public void setButtonState() {
        int c = 0;
        if (this.svc.players != null) {
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null && this.svc.players[i].cell != null && this.svc.players[i].cell.chk.isSelected()) {
                    ++c;
                }
                ++i;
            }
        }
        if (c == 0) {
            this.playerButton[0].setEnabled(false);
            this.playerButton[1].setEnabled(false);
            this.playerButton[2].setEnabled(false);
        } else {
            this.playerButton[0].setEnabled(true);
            this.playerButton[1].setEnabled(true);
            this.playerButton[2].setEnabled(true);
        }
    }

    public void setPlayerList() {
        this.playerListPanel.removeAll();
        if (this.svc.players != null) {
            int ysize = this.svc.players.length * 26;
            if (ysize < 221) {
                ysize = 221;
            }
            JPanel inner = StartUp.tool.getJPanel(452, ysize + 1, "left", 0, 1);
            inner.setBackground(Color.LIGHT_GRAY);
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null) {
                    inner.add(this.svc.players[i].cell);
                }
                ++i;
            }
            this.playerListPanel.add(inner);
        } else {
            int ysize = 221;
            JPanel inner = StartUp.tool.getJPanel(452, ysize + 1, "left", 0, 1);
            inner.setBackground(Color.LIGHT_GRAY);
            this.playerListPanel.add(inner);
        }
        this.playerListPanel.validate();
    }

    private JButton getButton(String title, String command) {
        JButton ret = new JButton(title);
        ret.addActionListener(this);
        ret.setActionCommand(command);
        ret.setPreferredSize(new Dimension(75, 20));
        return ret;
    }

    private JButton getButton(String title, String command, int x, int y) {
        JButton ret = this.getButton(title, command);
        ret.setPreferredSize(new Dimension(x, y));
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        StartUp.printDEBUG("[SVCSSPlayerPanel] Button - " + cmd);
        if ("blackPL".equals(cmd)) {
            if (this.svc.players == null) {
                cmd = null;
                ae = null;
                return;
            }
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i].cell.chk.isSelected()) {
                    this.svc.sendMethod(true, "BlackList", this.svc.players[i].login);
                }
                ++i;
            }
            if (this.svc.bbListThread != null) {
                this.svc.bbListThread.blackUpdate = true;
            }
        } else if ("banPL".equals(cmd)) {
            if (this.svc.players == null) {
                cmd = null;
                ae = null;
                return;
            }
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i].cell.chk.isSelected()) {
                    this.svc.sendMethod(true, "Ban", this.svc.players[i].login, "Server administrator banned you");
                }
                ++i;
            }
            if (this.svc.bbListThread != null) {
                this.svc.bbListThread.banUpdate = true;
            }
            this.svc.svInfoThread.playerPanel.setPlayerList();
        } else if ("kickPL".equals(cmd)) {
            if (this.svc.players == null) {
                cmd = null;
                ae = null;
                return;
            }
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i].cell.chk.isSelected()) {
                    this.svc.sendMethod(true, "Kick", this.svc.players[i].login, "Server administrator kicked you");
                }
                ++i;
            }
            this.svc.svInfoThread.playerPanel.setPlayerList();
        }
    }
}

