/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.Value;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class SVCSSPlayerListCell
extends JPanel
implements ItemListener {
    public String login;
    public String nickName;
    public String cleanNick;
    public int playerID;
    public int teamID;
    public boolean isSpectator;
    public boolean isOfficial;
    public int ladderRank;
    public JCheckBox chk;
    public JLabel nick;
    public JLabel id;
    public JLabel team;
    public JLabel state;
    public JLabel ladder;
    public Color defaultColor;
    public JPanel chkCell;
    public JPanel nickCell;
    public JPanel loginCell;
    public JPanel teamCell;
    public JPanel stateCell;
    public JPanel ladderCell;
    private SVCMainThread svc;

    public SVCSSPlayerListCell(SVCMainThread s, Value[] v) {
        this.svc = s;
        s = null;
        if (v == null) {
            this.setNull();
            return;
        }
        this.login = v[0].value;
        this.nickName = v[1].value;
        this.cleanNick = StartUp.tool.getCleanText(this.nickName, false);
        this.playerID = Integer.parseInt(v[2].value);
        this.teamID = Integer.parseInt(v[3].value);
        this.isSpectator = v[4].value.equals("1");
        this.isOfficial = v[5].value.equals("1");
        this.ladderRank = Integer.parseInt(v[6].value);
        this.cellSetting();
    }

    public SVCSSPlayerListCell(SVCMainThread s) {
        this.svc = s;
        s = null;
        this.setNull();
    }

    private void setNull() {
        this.login = "";
        this.nickName = "";
        this.cleanNick = "";
        this.playerID = -1;
        this.teamID = -1;
        this.isSpectator = false;
        this.isOfficial = false;
        this.ladderRank = -1;
        this.cellSetting();
    }

    public void cellSetting() {
        this.defaultColor = this.getBackground();
        this.setPreferredSize(new Dimension(452, 25));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.chkCell = new JPanel();
        this.chkCell.setLayout(new FlowLayout(0, 0, 0));
        this.chkCell.setBorder(new EtchedBorder(0));
        this.chkCell.setPreferredSize(new Dimension(25, 25));
        this.chk = new JCheckBox();
        this.chk.addItemListener(this);
        this.chkCell.add(this.chk);
        this.nickCell = new JPanel();
        this.nickCell.setLayout(new FlowLayout(1, 0, 0));
        this.nickCell.setBorder(new EtchedBorder(0));
        this.nickCell.setPreferredSize(new Dimension(135, 25));
        this.nick = new JLabel(this.cleanNick);
        this.nickCell.add(this.nick);
        this.loginCell = new JPanel();
        this.loginCell.setLayout(new FlowLayout(1, 0, 0));
        this.loginCell.setBorder(new EtchedBorder(0));
        this.loginCell.setPreferredSize(new Dimension(90, 25));
        this.id = new JLabel(this.login);
        this.loginCell.add(this.id);
        this.teamCell = new JPanel();
        this.teamCell.setLayout(new FlowLayout(1, 0, 0));
        this.teamCell.setBorder(new EtchedBorder(0));
        this.teamCell.setPreferredSize(new Dimension(45, 25));
        this.team = new JLabel("");
        if (this.teamID == -1) {
            this.team.setText("-");
        } else if (this.teamID == 0) {
            this.team.setText("Blue");
        } else if (this.teamID == 1) {
            this.team.setText("Red");
        }
        this.teamCell.add(this.team);
        this.stateCell = new JPanel();
        this.stateCell.setLayout(new FlowLayout(1, 0, 0));
        this.stateCell.setBorder(new EtchedBorder(0));
        this.stateCell.setPreferredSize(new Dimension(75, 25));
        this.state = this.isSpectator ? new JLabel("Watching") : new JLabel("Playing");
        this.stateCell.add(this.state);
        this.ladderCell = new JPanel();
        this.ladderCell.setLayout(new FlowLayout(1, 0, 0));
        this.ladderCell.setBorder(new EtchedBorder(0));
        this.ladderCell.setPreferredSize(new Dimension(80, 25));
        this.ladder = new JLabel("" + this.ladderRank);
        this.ladderCell.add(this.ladder);
        this.add(this.chkCell);
        this.add(this.nickCell);
        this.add(this.loginCell);
        this.add(this.teamCell);
        this.add(this.stateCell);
        this.add(this.ladderCell);
    }

    public SVCSSPlayerListCell(SVCMainThread s, boolean b) {
        this.svc = s;
        s = null;
        this.setPreferredSize(new Dimension(452, 30));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.chkCell = new JPanel();
        this.chkCell.setLayout(new FlowLayout(0, 0, 0));
        this.chkCell.setBorder(new EtchedBorder(1));
        this.chkCell.setPreferredSize(new Dimension(25, 25));
        this.nickCell = new JPanel();
        this.nickCell.setLayout(new FlowLayout(1, 0, 0));
        this.nickCell.setBorder(new EtchedBorder(1));
        this.nickCell.setPreferredSize(new Dimension(135, 25));
        this.nickCell.add(new JLabel("Nick Name"));
        this.loginCell = new JPanel();
        this.loginCell.setLayout(new FlowLayout(1, 0, 0));
        this.loginCell.setBorder(new EtchedBorder(1));
        this.loginCell.setPreferredSize(new Dimension(90, 25));
        this.loginCell.add(new JLabel("Login Account"));
        this.teamCell = new JPanel();
        this.teamCell.setLayout(new FlowLayout(1, 0, 0));
        this.teamCell.setBorder(new EtchedBorder(1));
        this.teamCell.setPreferredSize(new Dimension(45, 25));
        this.teamCell.add(new JLabel("Team"));
        this.stateCell = new JPanel();
        this.stateCell.setLayout(new FlowLayout(1, 0, 0));
        this.stateCell.setBorder(new EtchedBorder(1));
        this.stateCell.setPreferredSize(new Dimension(75, 25));
        this.stateCell.add(new JLabel("State"));
        this.ladderCell = new JPanel();
        this.ladderCell.setLayout(new FlowLayout(1, 0, 0));
        this.ladderCell.setBorder(new EtchedBorder(1));
        this.ladderCell.setPreferredSize(new Dimension(80, 25));
        this.ladderCell.add(new JLabel("Ladder Rank"));
        this.add(this.chkCell);
        this.add(this.nickCell);
        this.add(this.loginCell);
        this.add(this.teamCell);
        this.add(this.stateCell);
        this.add(this.ladderCell);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.chengeBackground(Color.white);
            if (this.svc.svInfoThread.playerPanel != null) {
                this.svc.svInfoThread.playerPanel.setButtonState();
            }
        } else if (e.getStateChange() == 2) {
            this.chengeBackground(this.defaultColor);
            if (this.svc.svInfoThread.playerPanel != null) {
                this.svc.svInfoThread.playerPanel.setButtonState();
            }
        }
    }

    public void chengeBackground(Color c) {
        if (this.chkCell != null) {
            this.chkCell.setBackground(c);
        }
        if (this.nickCell != null) {
            this.nickCell.setBackground(c);
        }
        if (this.loginCell != null) {
            this.loginCell.setBackground(c);
        }
        if (this.teamCell != null) {
            this.teamCell.setBackground(c);
        }
        if (this.stateCell != null) {
            this.stateCell.setBackground(c);
        }
        if (this.ladderCell != null) {
            this.ladderCell.setBackground(c);
        }
    }
}

