/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.StructClass;
import hir.westfield.tm.ToolClass;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SVCSSInfoPanel
extends JPanel {
    public JLabel publishedIp;
    public JLabel serverPort;
    public JLabel p2pPort;
    public JLabel serverLogin;
    public JLabel downRate;
    public JLabel upRate;
    public JLabel isDedicated;
    private SVCMainThread svc;

    public SVCSSInfoPanel(SVCMainThread s) {
        this.svc = s;
        s = null;
        ToolClass tool = StartUp.tool;
        this.setPreferredSize(new Dimension(310, 180));
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setBorder(new TitledBorder(new EtchedBorder(), "System Infomation"));
        JPanel[] mlLeftCell = new JPanel[7];
        JPanel[] mlRightCell = new JPanel[7];
        int i = 0;
        while (i < 7) {
            mlLeftCell[i] = tool.getJPanel(125, 20, "right", 0, 0);
            mlRightCell[i] = tool.getJPanel(161, 20, "left", 0, 0);
            ++i;
        }
        mlLeftCell[0].add(new JLabel("Published address : "));
        this.publishedIp = new JLabel("No data.");
        mlRightCell[0].add(this.publishedIp);
        mlLeftCell[1].add(new JLabel("Server port : "));
        this.serverPort = new JLabel("No data.");
        mlRightCell[1].add(this.serverPort);
        mlLeftCell[2].add(new JLabel("P2P port : "));
        this.p2pPort = new JLabel("No data.");
        mlRightCell[2].add(this.p2pPort);
        mlLeftCell[3].add(new JLabel("Server login account : "));
        this.serverLogin = new JLabel("No data.");
        mlRightCell[3].add(this.serverLogin);
        mlLeftCell[4].add(new JLabel("Download rate : "));
        this.downRate = new JLabel("No data.");
        mlRightCell[4].add(this.downRate);
        mlLeftCell[5].add(new JLabel("Upload rate : "));
        this.upRate = new JLabel("No data.");
        mlRightCell[5].add(this.upRate);
        mlLeftCell[6].add(new JLabel("Server type : "));
        this.isDedicated = new JLabel("No data.");
        mlRightCell[6].add(this.isDedicated);
        i = 0;
        while (i < 7) {
            this.add(mlLeftCell[i]);
            this.add(mlRightCell[i]);
            ++i;
        }
    }

    public void infoUpdate(StructClass sc) {
        if (sc == null) {
            return;
        }
        if (sc.member == null) {
            return;
        }
        if (this.svc.cdc.tmVersion == 1) {
            if (sc.member.length > 0) {
                this.publishedIp.setText(sc.member[0].value);
            }
            if (sc.member.length > 1) {
                this.serverPort.setText(sc.member[1].value);
            }
            if (sc.member.length > 2) {
                this.p2pPort.setText(sc.member[2].value);
            }
            if (sc.member.length > 3) {
                this.serverLogin.setText(sc.member[3].value);
            }
            this.downRate.setText("No data.");
            this.upRate.setText("No data.");
            this.isDedicated.setText("No data.");
        } else if (this.svc.cdc.tmVersion == 2) {
            if (sc.member.length > 0) {
                this.publishedIp.setText(sc.member[0].value);
            }
            if (sc.member.length > 1) {
                this.serverPort.setText(sc.member[1].value);
            }
            if (sc.member.length > 2) {
                this.p2pPort.setText(sc.member[2].value);
            }
            if (sc.member.length > 4) {
                this.serverLogin.setText(sc.member[4].value);
            }
            if (sc.member.length > 6) {
                this.downRate.setText(String.valueOf(sc.member[6].value) + " kbps");
            }
            if (sc.member.length > 7) {
                this.upRate.setText(String.valueOf(sc.member[7].value) + " kbps");
            }
            String temp = "";
            if (sc.member.length > 9) {
                temp = sc.member[9].value.equals("1") ? "Dedicated Server" : "Remote connecting Server";
            }
            this.isDedicated.setText(temp);
            Object var2_2 = null;
        }
    }
}

