/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.RCBBeginChallenge;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.SVCMapAddListPanel;
import hir.westfield.tm.SVCMapThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.Value;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SVCMapAddThread
extends Thread
implements WindowListener {
    private SVCMainThread svc;
    public JPanel panel;
    public JFrame mainFrame;
    public SVCMapAddListPanel list;
    public boolean dispose;
    public boolean finish = false;
    private boolean mapListUpdate = false;
    private JLabel readPlace;
    private Value[] queueArray;
    private int writePoint;
    private int readPoint;
    private boolean windowSave = false;
    public SVCMapThread parent;

    public SVCMapAddThread(SVCMainThread s, SVCMapThread smt) {
        this.svc = s;
        this.parent = smt;
        s = null;
        smt = null;
        this.dispose = false;
        this.mainFrame = new JFrame();
        this.mainFrame.setResizable(false);
        this.mainFrame.setTitle("Map Files Addition Control");
        this.mainFrame.setSize(new Dimension(800, 600));
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.addWindowListener(this);
        int showX = Integer.parseInt(this.svc.cdc.configData.dataText[6]);
        int showY = Integer.parseInt(this.svc.cdc.configData.dataText[7]);
        if (showX == -1 || showY == -1) {
            StartUp.tool.setCenter(this.mainFrame);
        } else {
            this.mainFrame.setLocation(showX, showY);
        }
        if (this.svc.cdc.addTargetDir == null) {
            this.svc.cdc.addTargetDir = this.svc.cdc.mapRootDir;
        }
        this.panel = StartUp.tool.getJPanel(790, 536, "left", 5, 0);
        JPanel p1st = StartUp.tool.getJPanel(790, 55, "center", 0, 0, "Map Loading Directory");
        this.readPlace = new JLabel(this.parent.targetFolder);
        p1st.add(this.readPlace);
        this.panel.add(p1st);
        this.list = new SVCMapAddListPanel(this.svc, this);
        this.panel.add(this.list);
        this.mainFrame.add(this.panel);
        this.queueArray = new Value[1000];
        int i = 0;
        while (i < 1000) {
            this.queueArray[i] = null;
            ++i;
        }
        this.writePoint = 0;
        this.readPoint = 0;
    }

    public void addQueue(Value[] v, String m) {
        int tar = this.writePoint++;
        if (this.writePoint >= 1000) {
            this.writePoint = 0;
        }
        if (this.queueArray[tar] == null) {
            this.queueArray[tar] = v != null ? new Value(v) : new Value();
            if (this.queueArray[tar] != null) {
                this.queueArray[tar].method = m;
            }
        } else {
            this.addQueue(v, m);
        }
        v = null;
    }

    private void retRemoveMapList(String tar) {
        String met = "";
        if (this.svc.cdc.tmVersion == 1) {
            met = "RemoveChallengeList";
        } else if (this.svc.cdc.tmVersion == 2) {
            met = "RemoveMapList";
        }
        this.svc.sendMethod(false, met, tar);
        met = null;
    }

    private void retRemoveMap(String tar) {
        String met = "";
        if (this.svc.cdc.tmVersion == 1) {
            met = "RemoveChallenge";
        } else if (this.svc.cdc.tmVersion == 2) {
            met = "RemoveMap";
        }
        this.svc.sendMethod(false, met, tar);
        met = null;
    }

    private void retAddMapList(String tar) {
        String met = "";
        if (this.svc.cdc.tmVersion == 1) {
            met = "AddChallengeList";
        } else if (this.svc.cdc.tmVersion == 2) {
            met = "AddMapList";
        }
        this.svc.sendMethod(false, met, tar);
        met = null;
    }

    public void retAddMap(String tar) {
        String met = "";
        if (this.svc.cdc.tmVersion == 1) {
            met = "AddChallenge";
        } else if (this.svc.cdc.tmVersion == 2) {
            met = "AddMap";
        }
        this.svc.sendMethod(false, met, tar);
        met = null;
    }

    public void retChooseNextMap(String tar) {
        String met = "";
        if (this.svc.cdc.tmVersion == 1) {
            met = "ChooseNextChallenge";
        } else if (this.svc.cdc.tmVersion == 2) {
            met = "ChooseNextMap";
        }
        this.svc.sendMethod(false, met, tar);
        met = null;
    }

    public void saveWindowPosition() {
        if (this.mainFrame != null && !this.windowSave) {
            this.windowSave = true;
            int setX = 6;
            int setY = 7;
            Point pos = this.mainFrame.getLocationOnScreen();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            DisplayMode dm = ge.getDefaultScreenDevice().getDisplayMode();
            int displayWidth = dm.getWidth();
            int displayHeight = dm.getHeight();
            this.svc.cdc.configData.dataText[setX] = pos.x > -1 && pos.x <= displayWidth ? String.valueOf(pos.x) : "-1";
            this.svc.cdc.configData.dataText[setY] = pos.y > -1 && pos.y <= displayHeight ? String.valueOf(pos.y) : "-1";
        }
    }

    public void otherMapFileAdding() {
        if (this.svc.cdc.mapRootDir == null) {
            JOptionPane.showMessageDialog(null, "It failed to add the file.\nAdditional file please do manually.");
            return;
        }
        File copySrc = null;
        boolean accept = true;
        String errorMes = "";
        JFileChooser filechooser = new JFileChooser();
        filechooser.addChoosableFileFilter(new FileNameExtensionFilter("TrackMania MAP File ( .Gbx )", "Gbx"));
        int selected = filechooser.showOpenDialog(null);
        if (selected == 0) {
            String tempTime;
            String fileName;
            copySrc = filechooser.getSelectedFile();
            String destDir = null;
            if (!this.svc.cdc.nowCM.mapImportFolder[0].equals("")) {
                if (this.svc.cdc.nowCM.mapImportFolder[0].startsWith(this.svc.cdc.mapRootDir)) {
                    File tempF = new File(this.svc.cdc.nowCM.mapImportFolder[0]);
                    if (!tempF.exists()) {
                        this.svc.cdc.nowCM.mapImportFolder[0] = "";
                    }
                } else {
                    this.svc.cdc.nowCM.mapImportFolder[0] = "";
                }
            }
            if (this.svc.cdc.nowCM.mapImportFolder[0].equals("")) {
                destDir = String.valueOf(this.svc.cdc.mapRootDir) + "TMSL - AddMaps";
                File targetDirectory = new File(destDir);
                if (!targetDirectory.exists()) {
                    if (!targetDirectory.mkdirs()) {
                        JOptionPane.showMessageDialog(null, "It failed to generate the file copy folder.\n" + destDir);
                        accept = false;
                    } else {
                        this.svc.cdc.nowCM.mapImportFolder[0] = destDir;
                    }
                }
            } else {
                destDir = this.svc.cdc.nowCM.mapImportFolder[0];
            }
            File copyDest = null;
            String lastString = ".Gbx";
            if (this.svc.cdc.tmVersion == 2) {
                lastString = ".Map.Gbx";
            }
            do {
                tempTime = "" + System.currentTimeMillis();
            } while ((copyDest = new File(fileName = String.valueOf(destDir) + "\\map-" + tempTime.substring(tempTime.length() - 5) + lastString)).exists());
            lastString = null;
            if (copySrc != null && copyDest != null) {
                try {
                    this.copyTransfer(copySrc.toString(), copyDest.toString());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "It failed to file copy.\n" + copyDest.toString());
                    accept = false;
                }
                String targetFile = copyDest.toString();
                String regex = this.svc.cdc.mapRootDir.replaceAll("\\\\", "\\.");
                targetFile = targetFile.replaceAll(regex, "");
                RCBBeginChallenge mapData = null;
                String met = "";
                if (this.svc.cdc.tmVersion == 1) {
                    met = "GetChallengeInfo";
                } else if (this.svc.cdc.tmVersion == 2) {
                    met = "GetMapInfo";
                }
                mapData = new RCBBeginChallenge(this.svc.sendMethod(true, met, targetFile), this.svc.cdc.tmVersion);
                if (mapData.len < 0) {
                    String env = null;
                    if (this.svc.cdc.tmVersion == 1) {
                        env = this.svc.titleID;
                        if (!env.equals("United")) {
                            env = "Nations";
                        }
                    } else if (this.svc.cdc.tmVersion == 2) {
                        Pattern p;
                        Matcher m;
                        env = this.svc.titleID.substring(2);
                        if (this.svc.titleID.equalsIgnoreCase("RPG@tmrpg")) {
                            env = "RPG@tmrpg";
                        }
                        if (this.svc.titleID.equalsIgnoreCase("Trackmania_2@nadeolabs")) {
                            env = "3way";
                        }
                        String envWhere = "";
                        if (env.equals("Stadium")) {
                            envWhere = "Stadium";
                        }
                        if (env.equals("Canyon")) {
                            envWhere = "Canyon";
                        }
                        if (env.equals("Valley")) {
                            envWhere = "Valley";
                        }
                        if (env.equals("RPG@tmrpg")) {
                            envWhere = "Stadium";
                        }
                        if (env.equals("3way")) {
                            envWhere = "Stadium|Canyon|Valley";
                        }
                        if (env.equals("United")) {
                            envWhere = "Bay|Coast|Speed|Island|Rally|Alpine|Stadium";
                        }
                        if (env.equals("Nations")) {
                            envWhere = "Stadium";
                        }
                        if ((m = (p = Pattern.compile(mapData.env)).matcher(envWhere)).find()) {
                            accept = true;
                        } else {
                            accept = false;
                            errorMes = "environment is different from the current server configuration.\n";
                        }
                    }
                } else {
                    accept = false;
                    errorMes = "File is not in the correct Map file.\n";
                    if (copyDest != null) {
                        copyDest.delete();
                    }
                }
            } else {
                accept = false;
            }
            if (!accept) {
                JOptionPane.showMessageDialog(null, "It failed to read the file.\n" + errorMes + copyDest.toString());
            }
        }
    }

    public void copyTransfer(String srcPath, String destPath) throws IOException {
        FileChannel srcChannel = new FileInputStream(srcPath).getChannel();
        FileChannel destChannel = new FileOutputStream(destPath).getChannel();
        try {
            srcChannel.transferTo(0L, srcChannel.size(), destChannel);
        }
        finally {
            srcChannel.close();
            destChannel.close();
        }
    }

    @Override
    public void run() {
        StartUp.printDEBUG("[SVCMapAddThread] - run start");
        this.svc.mainFrame.setVisible(false);
        this.mainFrame.setVisible(true);
        this.list.showFileList(this.parent.targetFolder);
        while (!this.dispose) {
            String method;
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.queueArray[this.readPoint] == null) continue;
            Value[] param = null;
            if (this.queueArray[this.readPoint].values != null) {
                param = new Value[this.queueArray[this.readPoint].values.length];
                System.arraycopy(this.queueArray[this.readPoint].values, 0, param, 0, this.queueArray[this.readPoint].values.length);
            }
            if ((method = this.queueArray[this.readPoint].method).startsWith("TrackMania.")) {
                method = method.replace("TrackMania.", "");
            }
            StartUp.printDEBUG("[SVCMapThread] Method : " + method);
            this.queueArray[this.readPoint] = null;
            ++this.readPoint;
            if (this.readPoint >= 1000) {
                this.readPoint = 0;
            }
            if (method.equals("MapAdd")) {
                if (!this.mapListUpdate) {
                    this.mapListUpdate = true;
                    this.list.selectedFileAdding();
                    this.parent.addQueue(null, "ShowNewMapList");
                    this.mapListUpdate = false;
                    this.list.buttonChk = false;
                    this.dispose = true;
                }
            } else if (method.equals("otherMapAdd")) {
                if (!this.mapListUpdate) {
                    this.mapListUpdate = true;
                    this.otherMapFileAdding();
                    this.parent.addQueue(null, "ShowNewMapList");
                    this.mapListUpdate = false;
                    this.list.buttonChk = false;
                    this.dispose = true;
                }
            } else if (method.startsWith("Jump")) {
                String target = method.substring(4);
                this.parent.targetFolder = target;
                this.readPlace.setText(this.parent.targetFolder);
                this.list.showFileList(this.parent.targetFolder);
                target = null;
                this.list.clickOK = true;
            }
            param = null;
            Object var2_3 = null;
        }
        this.saveWindowPosition();
        this.svc.mainFrame.setVisible(true);
        this.mainFrame.setVisible(false);
        this.finish = true;
        this.parent.addQueue(null, "closeAddMapPanel");
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.saveWindowPosition();
        this.dispose = true;
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

