/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;

public class SVCGameModeClass {
    public int targetMode;
    public String targetModeText;
    public boolean autoTime;
    public int timeLimit;
    public int timeLimitMultiple;
    public int timeLimitMax;
    public int timeLimitMin;
    public int synchStart;
    public int timeOut;
    public int timeOutMultiple;
    public int timeOutMax;
    public int finishPoint;
    public boolean useNewRule;
    public int finishWinRound;
    public int roundMaxPoint;
    public int cupFinishPoint;
    public int cupNextMap;
    public int forcedLap;
    public int[] customPoints;
    public String pointString;
    public int roundPassCar;
    public boolean roundAutoPass;
    public int lapRaceLap;
    public int lapFinalists;
    public boolean lapKO2ndLap;
    public boolean lapHandi;
    public boolean roundEx;
    public boolean lapEx;
    public boolean timeExFinish;
    public boolean timeExFinPt;
    public boolean timeExTeam;
    public boolean showOpponents;
    public boolean disableRespawn;
    public boolean disableHorns;
    public int chatTime;
    public int warmUpCount;
    public boolean again;
    private String spMethod;
    private boolean readNextFile = false;
    private SVCMainThread svc;

    public SVCGameModeClass(SVCMainThread s) {
        this.svc = s;
        s = null;
        this.init();
    }

    public void init() {
        this.targetMode = 0;
        this.targetModeText = null;
        this.timeLimit = 300000;
        this.timeLimitMultiple = 1;
        this.timeLimitMax = 0;
        this.timeLimitMin = 0;
        this.synchStart = 0;
        this.timeOut = 15000;
        this.timeOutMultiple = 1;
        this.timeOutMax = 0;
        this.finishPoint = 1;
        this.useNewRule = false;
        this.finishWinRound = 3;
        this.roundMaxPoint = 25;
        this.cupFinishPoint = 25;
        this.cupNextMap = 3;
        this.autoTime = false;
        this.forcedLap = 0;
        this.roundPassCar = 2;
        this.roundAutoPass = false;
        this.lapRaceLap = 5;
        this.lapFinalists = 2;
        this.lapKO2ndLap = true;
        this.lapHandi = false;
        this.roundEx = false;
        this.lapEx = false;
        this.timeExFinish = false;
        this.timeExFinPt = false;
        this.timeExTeam = false;
        this.showOpponents = false;
        this.disableRespawn = false;
        this.disableHorns = false;
        this.chatTime = 15000;
        this.warmUpCount = 0;
        this.again = false;
    }

    public boolean readNextMapFile() {
        int tar = this.svc.againMap ? this.svc.nowMapNumber : this.svc.nextMapNumber;
        if (this.svc.reserveMapList == null) {
            return false;
        }
        if (this.svc.reserveMapList[tar] == null) {
            return false;
        }
        if (this.svc.reserveMapList[tar].fileName == null) {
            return false;
        }
        String temp = this.svc.reserveMapList[tar].fileName;
        if (!temp.startsWith(StartUp.cdc.mapRootDir)) {
            temp = String.valueOf(StartUp.cdc.mapRootDir) + temp;
        }
        this.svc.getMapFileInfo.addQueue(temp);
        while (!this.svc.getMapFileInfo.readed) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private int getNextMapGoldTime() {
        int time = 360000;
        if (this.readNextFile) {
            time = this.svc.nextMapDetail.gold;
            if (this.svc.nextMapDetail.nblaps > 0) {
                time /= this.svc.nextMapDetail.nblaps;
            }
        }
        return time;
    }

    private String getTimeLimit() {
        int time = 0;
        if (this.autoTime) {
            time = this.getNextMapGoldTime() * this.timeLimitMultiple;
            if (time < this.timeLimitMin) {
                time = this.timeLimitMin > 5000 ? this.timeLimitMin : 5000;
            }
            if (time > this.timeLimitMax && this.timeLimitMax > 5000) {
                time = this.timeLimitMax;
            }
        } else {
            time = this.timeLimit;
        }
        return "" + time;
    }

    private String getTimeOut() {
        int time = 0;
        if (this.autoTime) {
            time = this.getNextMapGoldTime() * this.timeOutMultiple;
            if (time > this.timeOutMax && this.timeOutMax > 5000) {
                time = this.timeOutMax;
            }
        } else {
            time = this.timeOut;
        }
        return "" + time;
    }

    private void commonUpdate() {
        if (this.targetModeText == null) {
            return;
        }
        int s = this.showOpponents ? 1 : 0;
        this.svc.sendMethod(false, "SetForceShowAllOpponents", "" + s);
        this.svc.sendMethod(false, "SetDisableRespawn", "" + this.disableRespawn);
        if (this.svc.cdc.tmVersion == 2) {
            this.svc.sendMethod(false, "DisableHorns", "" + this.disableHorns);
        }
        this.svc.sendMethod(false, "SetChatTime", "" + this.chatTime);
        this.svc.sendMethod(false, this.spMethod, "" + this.warmUpCount);
    }

    public void sendTimeUpdate() {
        this.readNextFile = false;
        this.readNextFile = this.readNextMapFile();
        if (this.targetModeText == null) {
            return;
        }
        if (this.autoTime) {
            String mode = this.targetModeText.toLowerCase();
            if (mode.startsWith("timeattack")) {
                this.svc.sendMethod(false, "SetTimeAttackLimit", this.getTimeLimit());
            } else if (mode.startsWith("round") || mode.startsWith("team") || mode.startsWith("lap") || mode.startsWith("cup")) {
                this.svc.sendMethod(false, "SetFinishTimeout", this.getTimeOut());
            }
        }
    }

    public void sendUpdate() {
        if (this.targetModeText == null) {
            return;
        }
        this.svc.readyLapEX = false;
        String mode = this.targetModeText.toLowerCase();
        this.spMethod = "SetAllWarmUpDuration";
        if (!mode.startsWith("script")) {
            if (mode.startsWith("round")) {
                this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
                this.svc.sendMethod(false, "SetFinishTimeout", this.getTimeOut());
                this.svc.sendMethod(false, "SetRoundForcedLaps", "" + this.forcedLap);
                this.svc.sendMethod(false, "SetRoundPointsLimit", "" + this.finishPoint);
                this.svc.sendMethod(false, "SetUseNewRulesRound", "" + this.useNewRule);
                this.svc.sendMethod(false, "SetRoundCustomPoints", this.pointString);
            } else if (mode.startsWith("timeattack")) {
                this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
                this.svc.sendMethod(false, "SetTimeAttackLimit", this.getTimeLimit());
                this.svc.sendMethod(false, "SetTimeAttackSynchStartPeriod", "" + this.synchStart);
            } else if (mode.startsWith("team")) {
                this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
                this.svc.sendMethod(false, "SetFinishTimeout", this.getTimeOut());
                this.svc.sendMethod(false, "SetTeamPointsLimit", "" + this.finishWinRound);
                this.svc.sendMethod(false, "SetMaxPointsTeam", "" + this.roundMaxPoint);
                this.svc.sendMethod(false, "SetUseNewRulesTeam", "" + this.useNewRule);
            } else if (mode.startsWith("lap")) {
                if (this.svc.svMapThread.setOnlyLaps()) {
                    this.svc.svMapThread.addQueue(null, "ShowNewMapList");
                    this.svc.ml.showNextMapName();
                    this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
                    this.svc.tempGetMapList();
                    this.svc.sendMethod(false, "SetLapsTimeLimit", "" + this.timeLimit);
                    this.svc.sendMethod(false, "SetFinishTimeout", this.getTimeOut());
                    this.svc.sendMethod(false, "SetNbLaps", "" + this.forcedLap);
                }
            } else if (mode.startsWith("cup")) {
                this.spMethod = "SetCupWarmUpDuration";
                this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
                this.svc.sendMethod(false, "SetCupPointsLimit", "" + this.cupFinishPoint);
                String met = "SetCupRoundsPerChallenge";
                if (this.svc.cdc.tmVersion == 2) {
                    met = "SetCupRoundsPerMap";
                }
                this.svc.sendMethod(false, met, "" + this.cupNextMap);
                met = null;
                if (this.pointString != null) {
                    this.svc.sendMethod(false, "SetRoundCustomPoints", this.pointString);
                }
            } else if (mode.startsWith("stunt")) {
                this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
            } else if (mode.startsWith("exlaps") && this.svc.svMapThread.setOnlyLaps()) {
                this.svc.svMapThread.addQueue(null, "ShowNewMapList");
                this.svc.ml.showNextMapName();
                this.svc.sendMethod(false, "SetGameMode", "" + this.targetMode);
                this.svc.tempGetMapList();
                this.svc.sendMethod(false, "SetLapsTimeLimit", "0");
                this.svc.sendMethod(false, "SetFinishTimeout", this.getTimeOut());
                this.svc.readyLapEX = true;
            }
        }
        this.commonUpdate();
        this.svc.nextGameInfo = null;
        if (this.again) {
            this.svc.svGameSetThread.addQueue(null, "AgainGameInfo");
        } else {
            this.svc.svGameSetThread.addQueue(null, "NextGameInfo");
        }
    }
}

