/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.GameInfoState;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.ToolClass;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SVCGSStatePanel
extends JPanel {
    private JPanel currentPanel;
    private JPanel nextPanel;
    private SVCMainThread svc;

    public SVCGSStatePanel(SVCMainThread s) {
        this.svc = s;
        s = null;
        this.setPreferredSize(new Dimension(780, 300));
        this.setLayout(new FlowLayout(1, 0, 0));
        this.currentPanel = StartUp.tool.getJPanel(390, 300, "center", 0, 0, "Current game state");
        this.nextPanel = StartUp.tool.getJPanel(390, 300, "center", 0, 0, "Next game state");
        this.add(this.currentPanel);
        this.add(this.nextPanel);
    }

    public void setCurrentGameInfo(int playNow) {
        if (this.svc.currentGameInfo == null) {
            this.svc.currentGameInfo = new GameInfoState(this.svc.sendMethod(true, "GetCurrentGameInfo"));
        }
        this.currentPanel.removeAll();
        this.currentPanel.add(this.setGameInfoPanel(this.svc.currentGameInfo, playNow));
        this.validate();
    }

    public void setNextGameInfo(int nextSet) {
        if (this.svc.reserveMapList != null) {
            if (this.svc.nextGameInfo == null) {
                this.svc.nextGameInfo = new GameInfoState(this.svc.sendMethod(true, "GetNextGameInfo"));
            }
            this.nextPanel.removeAll();
            this.nextPanel.add(this.setGameInfoPanel(this.svc.nextGameInfo, nextSet));
            this.validate();
        } else {
            this.nextPanel.removeAll();
            this.nextPanel.add(new JPanel());
            this.validate();
        }
        this.svc.ml.showNextMapName();
    }

    public void setAgainGameInfo(int againSet) {
        if (this.svc.nextGameInfo == null) {
            this.svc.nextGameInfo = new GameInfoState(this.svc.sendMethod(true, "GetCurrentGameInfo"));
        }
        this.nextPanel.removeAll();
        this.nextPanel.add(this.setGameInfoPanel(this.svc.nextGameInfo, againSet));
        this.validate();
    }

    public JPanel setGameInfoPanel(GameInfoState gis, int tarMap) {
        ToolClass tool = StartUp.tool;
        JPanel ret = tool.getJPanel(382, 269, "left", 0, 0);
        if (tarMap < 0) {
            return ret;
        }
        if (this.svc.reserveMapList == null) {
            tool = null;
            return ret;
        }
        JPanel[] left = new JPanel[10];
        JPanel[] right = new JPanel[10];
        int xLeft = 191;
        int xRight = 382 - xLeft;
        int i = 0;
        while (i < left.length) {
            left[i] = tool.getJPanel(xLeft, 22, "right", 0, 1);
            right[i] = tool.getJPanel(xRight, 22, "left", 0, 1);
            ++i;
        }
        int col = 0;
        String temp = "";
        temp = this.svc.reserveMapList != null ? tool.getCleanText(this.svc.reserveMapList[tarMap].name, false) : "";
        left[col].add(new JLabel("Map Name : "));
        right[col].add(new JLabel(temp));
        temp = this.svc.reserveMapList != null ? this.svc.reserveMapList[tarMap].author : "";
        left[++col].add(new JLabel("Author : "));
        right[col].add(new JLabel(temp));
        temp = this.svc.reserveMapList != null ? tool.getTimeText(this.svc.reserveMapList[tarMap].goldTime, true) : "";
        left[++col].add(new JLabel("Gold time : "));
        right[col].add(new JLabel(temp));
        ++col;
        temp = "";
        if (gis != null) {
            temp = StartUp.tool.getModeString(gis.gameMode);
            left[col].add(new JLabel("Game mode : "));
            right[col].add(new JLabel(temp));
            left[++col].add(new JLabel("Chat time : "));
            right[col].add(new JLabel(tool.getTimeText(gis.chatTime)));
            ++col;
            if (temp.equals("Rounds")) {
                left[col].add(new JLabel("Round finish Point : "));
                right[col].add(new JLabel(String.valueOf(gis.roundPointLimit) + " pt"));
                ++col;
            }
            if (temp.equals("Rounds")) {
                left[col].add(new JLabel("Forced lap count : "));
                right[col].add(new JLabel(String.valueOf(gis.roundForcedLaps) + " laps"));
                ++col;
            }
            if (temp.equals("Rounds")) {
                left[col].add(new JLabel("Rounds Use New Rules : "));
                right[col].add(new JLabel("" + gis.roundNewRule));
                ++col;
            }
            if (temp.equals("Rounds")) {
                left[col].add(new JLabel("Finish time out : "));
                right[col].add(new JLabel(tool.getTimeText(gis.finishTimeOut)));
                ++col;
            }
            if (temp.equals("TimeAttack")) {
                left[col].add(new JLabel("Synch Start Period : "));
                right[col].add(new JLabel(tool.getTimeText(gis.timeAttackSynch)));
                ++col;
            }
            if (temp.equals("TimeAttack")) {
                left[col].add(new JLabel("Time limit : "));
                right[col].add(new JLabel(tool.getTimeText(gis.timeAttackLimit)));
                ++col;
            }
            if (temp.equals("Team")) {
                left[col].add(new JLabel("Round finish wins : "));
                right[col].add(new JLabel("" + gis.teamPointLimit));
                ++col;
            }
            if (temp.equals("Team")) {
                left[col].add(new JLabel("Round's max point : "));
                right[col].add(new JLabel(String.valueOf(gis.teamMaxPoint) + " pt"));
                ++col;
            }
            if (temp.equals("Team")) {
                left[col].add(new JLabel("Team Use New Rules : "));
                right[col].add(new JLabel("" + gis.teamNewRule));
                ++col;
            }
            if (temp.equals("Team")) {
                left[col].add(new JLabel("Finish time out : "));
                right[col].add(new JLabel(tool.getTimeText(gis.finishTimeOut)));
                ++col;
            }
            if (temp.equals("Laps")) {
                left[col].add(new JLabel("Forced lap count : "));
                right[col].add(new JLabel(String.valueOf(gis.lapsNbLaps) + " laps"));
                ++col;
            }
            if (temp.equals("Laps")) {
                left[col].add(new JLabel("Time limit : "));
                right[col].add(new JLabel(tool.getTimeText(gis.lapsTimeLimit)));
                ++col;
            }
            if (temp.equals("Laps")) {
                left[col].add(new JLabel("Finish time out : "));
                right[col].add(new JLabel(tool.getTimeText(gis.finishTimeOut)));
                ++col;
            }
        }
        int i2 = 0;
        while (i2 < left.length) {
            if (left[i2] != null) {
                ret.add(left[i2]);
                ret.add(right[i2]);
            }
            ++i2;
        }
        return ret;
    }
}

