/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.StartUp;
import hir.westfield.tm.StartingMenu;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RemoteOption
implements ActionListener,
WindowListener {
    private JFrame mainFrame;
    private JPanel mainPanel;
    private JTextField port;
    private JLabel error;
    private StartingMenu parent;

    public RemoteOption(StartingMenu sm) {
        this.parent = sm;
        sm = null;
        this.mainFrame = this.setMainFrame();
        this.mainPanel = new JPanel();
        this.mainFrame.add(this.mainPanel);
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setVisible(true);
        this.parent.mainFrame.setVisible(false);
        JPanel upper = StartUp.tool.getJPanel(450, 30, "center", 0, 5);
        JLabel label = new JLabel("XML-RPC Port number : ");
        upper.add(label);
        this.port = StartUp.tool.getTextField("", 75, 23);
        upper.add(this.port);
        JPanel middle = StartUp.tool.getJPanel(450, 25, "center", 0, 0);
        this.error = new JLabel("");
        this.error.setForeground(Color.RED);
        middle.add(this.error);
        JPanel under = StartUp.tool.getJPanel(450, 35, "center", 50, 5);
        JButton ok = new JButton("Start");
        ok.addActionListener(this);
        ok.setActionCommand("start");
        ok.setPreferredSize(new Dimension(125, 21));
        under.add(ok);
        JButton no = new JButton("Cancel");
        no.addActionListener(this);
        no.setActionCommand("cancel");
        no.setPreferredSize(new Dimension(125, 21));
        under.add(no);
        this.mainPanel.add(upper);
        this.mainPanel.add(middle);
        this.mainPanel.add(under);
    }

    private JFrame setMainFrame() {
        JFrame ret = new JFrame();
        ret.setResizable(false);
        ret.setTitle(String.valueOf(StartUp.mainTitle) + StartUp.verString + "  - XML-RPC setting -");
        ret.setSize(new Dimension(500, 140));
        ret.setDefaultCloseOperation(2);
        ret.addWindowListener(this);
        StartUp.tool.setCenter(ret);
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("cancel")) {
            this.parent.mainFrame.setVisible(true);
            this.mainFrame.dispose();
            this.parent.closeRemoteOption(false);
        } else if (cmd.equals("start")) {
            this.error.setText("");
            String temp = this.port.getText();
            if (StartUp.tool.matchChk(temp, "int")) {
                int pn = Integer.parseInt(temp);
                if (pn > 1023 && pn < 65536) {
                    StartUp.cdc.nowCM.xmlrpcPort = pn;
                    this.parent.mainFrame.setVisible(true);
                    this.mainFrame.dispose();
                    this.parent.closeRemoteOption(true);
                } else {
                    this.error.setText("Please set a 1024 - 65535.");
                }
            } else {
                this.error.setText("Please set a Port number.");
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.parent.mainFrame.setVisible(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.parent.closeRemoteOption(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

