/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.DBcontrolQueue;
import hir.westfield.tm.DBcontrolThread;
import hir.westfield.tm.SVCMusicAddListPanel;
import hir.westfield.tm.SVCMusicMainPanel;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.ToolClass;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MusicCell
extends JPanel
implements ItemListener,
DocumentListener,
ActionListener {
    public String fileName = null;
    public String title = null;
    public String artist = null;
    public boolean request = false;
    public int useCount = 0;
    public String originFile = null;
    public boolean playNow = false;
    public boolean playNext = false;
    public boolean playReq = false;
    public boolean playList = false;
    public JCheckBox chk;
    public JPanel chkCell;
    public JCheckBox reqChk;
    public JPanel reqChkPanel;
    public JTextField titleText;
    public JPanel titlePanel;
    public JTextField artistText;
    public JPanel artistPanel;
    public JLabel fileText;
    public JPanel filePanel;
    public JLabel countText;
    public JPanel countPanel;
    public JButton updateDB;
    public JPanel buttonPanel;
    public JPanel playChkPanel;
    public JLabel playChkLabel;
    public SVCMusicMainPanel nowList = null;
    public SVCMusicAddListPanel dbList = null;
    public boolean topBar = false;
    public boolean reserved = false;
    private String[] buttonTexts;
    private JButton[] buttons;
    private boolean pushButton = false;

    public MusicCell(MusicCell mc, SVCMusicMainPanel mp) {
        this.nowList = mp;
        mp = null;
        this.fileName = mc.fileName;
        this.title = mc.title;
        this.artist = mc.artist;
        this.request = mc.request;
        this.useCount = mc.useCount;
        this.originFile = mc.originFile;
        this.playNow = mc.playNow;
        this.playNext = mc.playNext;
        this.playReq = mc.playReq;
        this.playList = mc.playList;
        this.setPanels(true);
        mc = null;
    }

    public MusicCell(MusicCell mc) {
        this.dbList = null;
        this.fileName = mc.fileName;
        this.title = mc.title;
        this.artist = mc.artist;
        this.request = mc.request;
        this.useCount = mc.useCount;
        this.originFile = mc.originFile;
        this.playNow = mc.playNow;
        this.playNext = mc.playNext;
        this.playReq = mc.playReq;
        this.playList = mc.playList;
        this.setPanels(true);
        mc = null;
    }

    public MusicCell(String[] src, SVCMusicMainPanel mp) {
        this.nowList = mp;
        mp = null;
        this.musicCellSet(src);
        src = null;
    }

    public MusicCell(String[] src, SVCMusicAddListPanel mp) {
        this.dbList = mp;
        mp = null;
        this.musicCellSet(src);
        src = null;
    }

    public MusicCell(String[] src) {
        this.musicCellSet(src);
        src = null;
    }

    public void musicCellSet(String[] src) {
        ToolClass tool = StartUp.tool;
        this.fileName = src[0];
        this.title = src[1];
        this.artist = src[2];
        this.request = src[3].equals("1");
        this.useCount = 0;
        if (tool.matchChk(src[4], "int")) {
            this.useCount = Integer.parseInt(src[4]);
        }
        this.originFile = src[5];
        this.setPanels(true);
        tool = null;
    }

    public MusicCell(boolean b, SVCMusicMainPanel mp) {
        this.nowList = mp;
        mp = null;
        this.topBar = true;
        this.setPanels(false);
    }

    public MusicCell(boolean b, SVCMusicAddListPanel mp) {
        this.dbList = mp;
        mp = null;
        this.topBar = true;
        this.setPanels(false);
    }

    public void setPlayChk() {
        this.playChkPanel.removeAll();
        JPanel temp = StartUp.tool.getJPanel(40, 25, "center", 0, 0, "RAISED");
        if (this.playNow) {
            temp.add(StartUp.tool.getIconPlay());
        } else if (this.playNext) {
            temp.add(StartUp.tool.getIconNext());
        } else if (this.playReq) {
            temp.add(StartUp.tool.getIconReq());
        }
        this.playChkPanel.add(temp);
        this.validate();
    }

    public void setPanels(boolean b) {
        ToolClass tool = StartUp.tool;
        String frames = "";
        frames = b ? "RAISED" : "LOWERED";
        this.chkCell = tool.getJPanel(25, 25, "left", 0, 0, frames);
        this.chk = new JCheckBox();
        this.chk.addItemListener(this);
        this.chkCell.add(this.chk);
        this.playChkPanel = b ? tool.getJPanel(40, 25, "center", 0, 0) : tool.getJPanel(40, 25, "center", 0, 0, frames);
        if (b) {
            this.setPlayChk();
        }
        this.buttons = new JButton[5];
        this.buttonTexts = new String[15];
        if (b) {
            this.reqChkPanel = tool.getJPanel(40, 25, "center", 0, 0, frames);
            this.reqChk = new JCheckBox();
            this.reqChk.setSelected(this.request);
            this.reqChk.addItemListener(this);
            this.reqChkPanel.add(this.reqChk);
        } else if (this.dbList != null) {
            this.reqChkPanel = tool.getJPanel(40, 25, "center", 0, 0);
            this.buttonTexts[0] = "Req";
            this.buttonTexts[1] = "\u25b2";
            this.buttonTexts[2] = "\u25bc";
            this.buttons[0] = this.getButton("", "Req", 40, 24);
            this.buttons[0].setMargin(new Insets(0, 0, 0, 0));
            this.reqChkPanel.add(this.buttons[0]);
        } else {
            this.reqChkPanel = tool.getJPanel(40, 25, "center", 0, 0, frames);
            this.reqChk = null;
            this.reqChkPanel.add(new JLabel("Req"));
        }
        if (b) {
            this.titlePanel = tool.getJPanel(200, 25, "center", 0, 0, frames);
            this.titleText = tool.getTextField(this.title, 194, 21);
            this.titleText.getDocument().addDocumentListener(this);
            this.titlePanel.add(this.titleText);
        } else if (this.dbList != null) {
            this.titlePanel = tool.getJPanel(200, 25, "center", 0, 0);
            this.buttonTexts[3] = "Music title";
            this.buttonTexts[4] = "Music title \u25b2";
            this.buttonTexts[5] = "Music title \u25bc";
            this.buttons[1] = this.getButton("", "MusicTitle", 200, 24);
            this.buttons[1].setMargin(new Insets(0, 0, 0, 0));
            this.titlePanel.add(this.buttons[1]);
        } else {
            this.titlePanel = tool.getJPanel(200, 25, "center", 0, 0, frames);
            this.titleText = null;
            this.titlePanel.add(new JLabel("Music title"));
        }
        if (b) {
            this.artistPanel = tool.getJPanel(100, 25, "center", 0, 0, frames);
            this.artistText = tool.getTextField(this.artist, 94, 21);
            this.artistText.getDocument().addDocumentListener(this);
            this.artistPanel.add(this.artistText);
        } else if (this.dbList != null) {
            this.artistPanel = tool.getJPanel(100, 25, "center", 0, 0);
            this.buttonTexts[6] = "Artist name";
            this.buttonTexts[7] = "Artist name\u25b2";
            this.buttonTexts[8] = "Artist name\u25bc";
            this.buttons[2] = this.getButton("", "ArtistName", 100, 24);
            this.buttons[2].setMargin(new Insets(0, 0, 0, 0));
            this.artistPanel.add(this.buttons[2]);
        } else {
            this.artistPanel = tool.getJPanel(100, 25, "center", 0, 0, frames);
            this.artistText = null;
            this.artistPanel.add(new JLabel("Artist name"));
        }
        if (b) {
            this.filePanel = tool.getJPanel(190, 25, "right", 0, 0, frames);
            this.fileText = new JLabel(this.fileName);
            this.filePanel.add(this.fileText);
        } else if (this.dbList != null) {
            this.filePanel = tool.getJPanel(190, 25, "center", 0, 0);
            this.buttonTexts[9] = "File name";
            this.buttonTexts[10] = "File name \u25b2";
            this.buttonTexts[11] = "File name \u25bc";
            this.buttons[3] = this.getButton("", "FileName", 190, 24);
            this.buttons[3].setMargin(new Insets(0, 0, 0, 0));
            this.filePanel.add(this.buttons[3]);
        } else {
            this.filePanel = tool.getJPanel(190, 25, "center", 0, 0, frames);
            this.fileText = null;
            this.filePanel.add(new JLabel("File name"));
        }
        if (b) {
            this.countPanel = tool.getJPanel(50, 25, "center", 0, 0, frames);
            this.countText = new JLabel("" + this.useCount);
            this.countPanel.add(this.countText);
        } else if (this.dbList != null) {
            this.countPanel = tool.getJPanel(50, 25, "center", 0, 0);
            this.buttonTexts[12] = "Play";
            this.buttonTexts[13] = "\u25b2";
            this.buttonTexts[14] = "\u25bc";
            this.buttons[4] = this.getButton("", "UseCount", 50, 24);
            this.buttons[4].setMargin(new Insets(0, 0, 0, 0));
            this.countPanel.add(this.buttons[4]);
        } else {
            this.countPanel = tool.getJPanel(50, 25, "center", 0, 0, frames);
            this.countText = null;
            this.countPanel.add(new JLabel("Play"));
        }
        this.buttonPanel = tool.getJPanel(95, 25, "center", 0, 0, frames);
        if (b) {
            this.updateDB = this.getButton("updateDB", "update", 89, 20);
            this.buttonPanel.add(this.updateDB);
            this.updateDB.setEnabled(false);
        } else {
            this.updateDB = null;
        }
        if (this.dbList != null) {
            this.setButtons();
        }
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setPreferredSize(new Dimension(740, 25));
        this.add(this.chkCell);
        this.add(this.playChkPanel);
        this.add(this.reqChkPanel);
        this.add(this.countPanel);
        this.add(this.titlePanel);
        this.add(this.artistPanel);
        this.add(this.filePanel);
        this.add(this.buttonPanel);
        tool = null;
        frames = null;
    }

    private void buttonState() {
        boolean a = this.reqChk.isSelected() ? !this.request : this.request;
        boolean b = !this.titleText.getText().equals(this.title);
        boolean c = !this.artistText.getText().equals(this.artist);
        if (a || b || c) {
            this.updateDB.setEnabled(true);
        } else {
            this.updateDB.setEnabled(false);
        }
    }

    private JButton getButton(String title, String command, int x, int y) {
        JButton ret = new JButton(title);
        ret.addActionListener(this);
        ret.setActionCommand(command);
        ret.setPreferredSize(new Dimension(x, y));
        return ret;
    }

    private void setColors(Color c) {
        this.chkCell.setBackground(c);
        this.reqChkPanel.setBackground(c);
        this.titlePanel.setBackground(c);
        this.artistPanel.setBackground(c);
        this.filePanel.setBackground(c);
        this.countPanel.setBackground(c);
        this.buttonPanel.setBackground(c);
    }

    public boolean chkCell(MusicCell mc) {
        boolean ret = true;
        if (!this.fileName.equals(mc.fileName)) {
            ret = false;
        }
        if (!this.title.equals(mc.title)) {
            ret = false;
        }
        if (!this.artist.equals(mc.artist)) {
            ret = false;
        }
        mc = null;
        return ret;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.reqChk) {
            this.buttonState();
        } else if (e.getItemSelectable() == this.chk) {
            boolean b = this.chk.isSelected();
            Color tempSet = b ? Color.white : StartUp.defaultColor;
            if (!this.topBar) {
                this.setColors(tempSet);
            }
            tempSet = null;
            if (this.nowList != null) {
                this.nowList.setButtonState();
            }
            if (this.dbList != null) {
                this.dbList.setButtonState();
            }
            if (this.topBar) {
                if (this.nowList != null) {
                    if (this.nowList.svc.musicList != null) {
                        int i = 0;
                        while (i < this.nowList.svc.musicList.length) {
                            this.nowList.svc.musicList[i].chk.setSelected(b);
                            ++i;
                        }
                    }
                } else if (this.dbList != null) {
                    int i = 0;
                    while (i < this.dbList.parent.dbList.length) {
                        this.dbList.parent.dbList[i].chk.setSelected(b);
                        ++i;
                    }
                }
            }
            if (this.nowList != null) {
                this.nowList.setButtonState();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.buttonState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.buttonState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = "";
        if (!this.pushButton) {
            this.pushButton = true;
            cmd = ae.getActionCommand();
        }
        if ("update".equals(cmd)) {
            boolean b;
            this.request = b = this.reqChk.isSelected();
            this.title = this.titleText.getText();
            this.artist = this.artistText.getText();
            if (this.nowList != null || this.dbList != null) {
                DBcontrolThread db = null;
                if (this.nowList != null) {
                    db = this.nowList.svc.dbThread;
                } else if (this.dbList != null) {
                    db = this.dbList.svc.dbThread;
                }
                if (db != null) {
                    DBcontrolQueue dbq = new DBcontrolQueue("musicFileUpdate");
                    dbq.title = this.title;
                    dbq.artist = this.artist;
                    dbq.filename = this.fileName;
                    dbq.request = this.request;
                    int re = db.setQueue(dbq);
                    --re;
                    dbq = null;
                }
            }
            this.buttonState();
        }
        if (cmd.equals("Req")) {
            this.orderReset(0);
            ++this.dbList.req;
            if (this.dbList.req > 2) {
                this.dbList.req = 0;
            }
            this.setButtons();
            this.dbList.sortToRefresh();
        } else if (cmd.equals("MusicTitle")) {
            this.orderReset(1);
            ++this.dbList.musicTitle;
            if (this.dbList.musicTitle > 2) {
                this.dbList.musicTitle = 0;
            }
            this.setButtons();
            this.dbList.sortToRefresh();
        } else if (cmd.equals("ArtistName")) {
            this.orderReset(2);
            ++this.dbList.artistName;
            if (this.dbList.artistName > 2) {
                this.dbList.artistName = 0;
            }
            this.setButtons();
            this.dbList.sortToRefresh();
        } else if (cmd.equals("FileName")) {
            this.orderReset(3);
            ++this.dbList.fileName;
            if (this.dbList.fileName > 2) {
                this.dbList.fileName = 0;
            }
            this.setButtons();
            this.dbList.sortToRefresh();
        } else if (cmd.equals("UseCount")) {
            this.orderReset(4);
            ++this.dbList.useCount;
            if (this.dbList.useCount > 2) {
                this.dbList.useCount = 0;
            }
            this.setButtons();
            this.dbList.sortToRefresh();
        }
    }

    private void orderReset(int c) {
        if (c != 0) {
            this.dbList.req = 0;
        }
        if (c != 1) {
            this.dbList.musicTitle = 0;
        }
        if (c != 2) {
            this.dbList.artistName = 0;
        }
        if (c != 3) {
            this.dbList.fileName = 0;
        }
        if (c != 4) {
            this.dbList.useCount = 0;
        }
    }

    public void setButtons() {
        this.buttons[0].setText(this.buttonTexts[this.dbList.req]);
        this.buttons[1].setText(this.buttonTexts[3 + this.dbList.musicTitle]);
        this.buttons[2].setText(this.buttonTexts[6 + this.dbList.artistName]);
        this.buttons[3].setText(this.buttonTexts[9 + this.dbList.fileName]);
        this.buttons[4].setText(this.buttonTexts[12 + this.dbList.useCount]);
    }
}

