/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.ControlDataClass;
import hir.westfield.tm.DBList;
import hir.westfield.tm.FileControl;
import hir.westfield.tm.MainFrameListener;
import hir.westfield.tm.StartUp;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MakeWorkFolder
extends Thread
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private JFrame mainFrame;
    private JPanel mainPanel;
    private ControlDataClass cdc;
    public boolean buttonPush = false;

    public MakeWorkFolder(JFrame jf, JPanel jp, ControlDataClass c) {
        JLabel target;
        JLabel action;
        this.mainFrame = jf;
        this.mainPanel = jp;
        this.cdc = c;
        jf = null;
        jp = null;
        c = null;
        this.mainFrame.setVisible(false);
        this.mainPanel.removeAll();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new MainFrameListener());
        this.mainFrame.setTitle(String.valueOf(StartUp.mainTitle) + " startup Setting");
        this.mainFrame.setSize(new Dimension(500, 150));
        this.ok = new JButton("Accept");
        this.ok.addActionListener(this);
        this.ok.setActionCommand("OK");
        this.ok.setPreferredSize(new Dimension(125, 23));
        this.cancel = new JButton("Cancel ( Exit )");
        this.cancel.addActionListener(this);
        this.cancel.setActionCommand("CANCEL");
        this.cancel.setPreferredSize(new Dimension(125, 23));
        if (!this.cdc.configData.directoryCheck) {
            action = new JLabel("Make a new folder for the tmsl config files.");
            target = new JLabel(this.cdc.workFolder);
        } else {
            action = new JLabel("Make a new file for the tmsl configuration.");
            String temp = "";
            if (!this.cdc.configDataCHK) {
                temp = String.valueOf(temp) + " [ config.txt ] ";
            }
            if (!this.cdc.titleDataCHK) {
                temp = String.valueOf(temp) + " [ titleList.txt ] ";
            }
            if (!this.cdc.dbListFileCHK) {
                temp = String.valueOf(temp) + " [ dbList.txt ] ";
            }
            target = new JLabel(temp);
        }
        JPanel p1 = StartUp.tool.getJPanel(500, 25, "center", 0, 0);
        p1.add(action);
        this.mainPanel.add(p1);
        JPanel p2 = StartUp.tool.getJPanel(500, 25, "center", 0, 0);
        p2.add(target);
        this.mainPanel.add(p2);
        JPanel p3 = StartUp.tool.getJPanel(500, 25, "center", 25, 0);
        p3.add(this.ok);
        p3.add(this.cancel);
        this.mainPanel.add(p3);
        this.mainFrame.add(this.mainPanel);
        this.mainFrame.setDefaultCloseOperation(3);
        StartUp.tool.setCenter(this.mainFrame);
        this.mainFrame.setVisible(true);
    }

    @Override
    public void run() {
        StartUp.print("[MakeWorkFolder] run");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("CANCEL")) {
            this.buttonPush = true;
            StartUp.print("[MakeWorkFolder] Button - cancel");
            System.exit(0);
        } else if (cmd.equals("OK")) {
            this.buttonPush = true;
            StartUp.print("[MakeWorkFolder] Button - accept");
            if (!this.cdc.configDataCHK) {
                this.cdc.configData = null;
                this.cdc.configData = new FileControl(this.cdc.workFolder, "config.txt");
                this.configMake();
            }
            if (!this.cdc.titleDataCHK) {
                this.cdc.titleData = null;
                this.cdc.titleData = new FileControl(this.cdc.workFolder, "titleList.txt");
                this.makeTitleData();
            }
            if (!this.cdc.dbListFileCHK) {
                this.cdc.dbListFile = null;
                this.cdc.dbListFile = new FileControl(this.cdc.workFolder, "dbList.txt");
                this.makeDBData();
            }
            this.mainFrame.setVisible(false);
            this.mainPanel.removeAll();
            StartUp.mwfClose = true;
            StartUp.mainState = 1;
        }
    }

    private void makeDBData() {
        if (!this.cdc.dbListFile.directoryCheck && !this.cdc.dbListFile.makeDirectory()) {
            JOptionPane.showMessageDialog(null, "Failed to new folder creation\n" + this.cdc.dbListFile.targetDirectory);
            System.exit(0);
        }
        String[] tempDB = new String[]{""};
        this.cdc.dbListFile.setTextData(tempDB);
        tempDB = null;
        if (!this.cdc.dbListFile.makeTextFile()) {
            JOptionPane.showMessageDialog(null, "Failed to configuration file creation\n" + this.cdc.dbListFile.targetFile);
            System.exit(0);
        }
        this.cdc.dbListData = new DBList(this.cdc.dbListFile.dataText);
        StartUp.print("[MakeWorkFolder] Accept make DB list data");
    }

    private void makeTitleData() {
        String[] tempTitle = new String[]{"List name & Game title & Match Setting file", "--------------------------------------------------------", "TM2 Canyon&TMCanyon&MatchSettings/TMCanyonA.txt", "TM2 Stadium&TMStadium&MatchSettings/TMStadiumA.txt", "TM2 Valley&TMValley&MatchSettings/TMValleyA.txt", "TM2 Stadium -RPG-&RPG@tmrpg&MatchSettings/TMStadiumA.txt", "TM2 3env&Trackmania_2@nadeolabs&MatchSettings/TMStadiumA.txt", "TM1 Nations&nations&MatchSettings/Nations/NationsWhite.txt", "TM1 United&united&MatchSettings/United/StadiumWhite.txt"};
        this.cdc.titleData.setTextData(tempTitle);
        if (!this.cdc.titleData.makeTextFile()) {
            JOptionPane.showMessageDialog(null, "Failed to Title data file creation\n" + this.cdc.titleData.targetFile);
            System.exit(0);
        }
        StartUp.print("[MakeWorkFolder] Accept make title data");
    }

    private void configMake() {
        if (!this.cdc.configData.directoryCheck && !this.cdc.configData.makeDirectory()) {
            JOptionPane.showMessageDialog(null, "Failed to new folder creation\n" + this.cdc.configData.targetDirectory);
            System.exit(0);
        }
        String[] tempConfig = new String[20];
        int ci = 0;
        tempConfig[ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-1";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "-";
        tempConfig[++ci] = "*****************************************************";
        tempConfig[++ci] = "0";
        ++ci;
        this.cdc.configData.setTextData(tempConfig);
        tempConfig = null;
        if (!this.cdc.configData.makeTextFile()) {
            JOptionPane.showMessageDialog(null, "Failed to configuration file creation\n" + this.cdc.configData.targetFile);
            System.exit(0);
        }
        StartUp.print("[MakeWorkFolder] Accept make config data");
    }
}

