/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.MapFileInfoClass;
import hir.westfield.tm.ParamClass;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.ToolClass;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetMapInfoThread
extends Thread {
    public ParamClass[] header;
    public ParamClass[] deps;
    public boolean urlCheck;
    private String[] queueArray;
    private int writePoint;
    private int readPoint;
    public boolean dispose = false;
    public boolean threadCheck = true;
    public boolean readed;
    public MapFileInfoClass nextMapData = null;
    private SVCMainThread svc;

    public GetMapInfoThread(SVCMainThread s) {
        this.svc = s;
        s = null;
        this.queueArray = new String[1000];
        int i = 0;
        while (i < 1000) {
            this.queueArray[i] = null;
            ++i;
        }
        this.writePoint = 0;
        this.readPoint = 0;
        this.start();
    }

    public void setTrackInfo(String file) {
        int ii;
        int i;
        this.nextMapData = new MapFileInfoClass();
        ToolClass tool = StartUp.tool;
        this.readFile(file);
        if (this.header == null && this.deps == null) {
            return;
        }
        if (this.header != null) {
            i = 0;
            while (i < this.header.length) {
                if (this.header[i] != null) {
                    String title = "";
                    if (this.header[i].name != null && (title = this.header[i].name) == null) {
                        title = "";
                    }
                    if (title.equals("ident ")) {
                        title = "identity";
                    } else if (title.equals("desc ")) {
                        title = "description";
                    }
                    ii = 0;
                    while (ii < this.header[i].params.length) {
                        String name = this.header[i].params[ii].name;
                        name = name.replaceAll(" ", "");
                        String value = tool.getCleanText(this.header[i].params[ii].value, false);
                        if ("exever".equals(name)) {
                            this.nextMapData.exever = value;
                        } else if ("exebuild".equals(name)) {
                            this.nextMapData.exebuild = value;
                        } else if ("title".equals(name)) {
                            this.nextMapData.title = value;
                        } else if ("lightmap".equals(name)) {
                            this.nextMapData.lightmap = value;
                        } else if ("uid".equals(name)) {
                            this.nextMapData.uid = value;
                        } else if ("name".equals(name)) {
                            this.nextMapData.name = value;
                        } else if ("author".equals(name)) {
                            this.nextMapData.author = value;
                        } else if ("authorzone".equals(name)) {
                            this.nextMapData.authorzone = value;
                        } else if ("envir".equals(name)) {
                            this.nextMapData.envir = value;
                        } else if ("mood".equals(name)) {
                            this.nextMapData.mood = value;
                        } else if ("maptype".equals(name)) {
                            this.nextMapData.maptype = value;
                        } else if ("validated".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.validated = Integer.parseInt(value);
                            }
                        } else if ("nblaps".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.nblaps = Integer.parseInt(value);
                            }
                        } else if ("displaycost".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.displaycost = Integer.parseInt(value);
                            }
                        } else if ("bronze".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.bronze = Integer.parseInt(value);
                            }
                        } else if ("silver".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.silver = Integer.parseInt(value);
                            }
                        } else if ("gold".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.gold = Integer.parseInt(value);
                            }
                        } else if ("authortime".equals(name)) {
                            if (StartUp.tool.matchChk(value, "int")) {
                                this.nextMapData.authortime = Integer.parseInt(value);
                            }
                        } else if ("authorscore".equals(name) && StartUp.tool.matchChk(value, "int")) {
                            this.nextMapData.authorscore = Integer.parseInt(value);
                        }
                        ++ii;
                    }
                }
                ++i;
            }
        }
        if (this.deps != null) {
            i = 0;
            while (i < this.deps.length) {
                String text = "";
                if (this.deps[i].params.length > 0) {
                    ii = 0;
                    while (ii < this.deps[i].params.length) {
                        if (this.deps[i].params[ii].name != null) {
                            String[] deco = this.svc.cdc.nowCM.mesDecoration;
                            String tempTar = this.deps[i].params[ii].name;
                            if ((tempTar = tempTar.replaceAll(" ", "")).equals("file")) {
                                String[] tempDetail;
                                String regex = "(?i)CircuitScreen";
                                Pattern p = Pattern.compile(regex);
                                Matcher m = p.matcher(this.deps[i].params[ii].value);
                                if (m.find()) {
                                    text = deco[0] + "CircuitScreen : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Advertisement")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Advertisement : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Mod")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Mod : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)ChallengeMusics")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "ChallengeMusics : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Media")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Media : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)MediaTracker")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "MediaTracker : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Media\\\\Musics")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Musics : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Media\\\\Sounds")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Sounds : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Inflatable")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Inflatable : $z$i$fff";
                                }
                                if ((m = (p = Pattern.compile(regex = "(?i)Models")).matcher(this.deps[i].params[ii].value)).find()) {
                                    text = deco[0] + "Models : $z$i$fff";
                                }
                                if (!"".equals(text) && (tempDetail = this.deps[i].params[ii].value.split("\\\\")) != null && tempDetail.length > 0) {
                                    text = String.valueOf(text) + tempDetail[tempDetail.length - 1];
                                }
                            }
                            if (tempTar.equals("url")) {
                                text = String.valueOf(text) + deco[0] + "  Loc URL : $z$i$f8f" + this.deps[i].params[ii].value;
                            }
                        }
                        ++ii;
                    }
                }
                if (!"".equals(text)) {
                    this.nextMapData.addParts(text);
                }
                text = null;
                ++i;
            }
        }
        this.svc.nextMapDetail = new MapFileInfoClass(this.nextMapData);
    }

    public void readFile(String fileName) {
        this.header = null;
        this.deps = null;
        File targetFile = new File(fileName);
        try {
            FileInputStream fileStream = new FileInputStream(targetFile);
            BufferedInputStream bufferStream = new BufferedInputStream(fileStream);
            int size = fileStream.available();
            byte[] buffer = new byte[size];
            int len = bufferStream.read(buffer);
            String ret = new String(buffer, "UTF-8");
            String head = "";
            String regex = "<header.+</header>";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(ret);
            if (m.find()) {
                head = m.group();
                head = head.replaceAll("mapstyle=\"\"", "");
                head = head.replaceAll("mod=\"\"", "");
            }
            regex = "<deps>.+?</deps>";
            p = Pattern.compile(regex);
            m = p.matcher(head);
            String depsText = "";
            if (m.find()) {
                depsText = m.group();
                depsText = depsText.replace("<deps>", "");
                depsText = depsText.replace("</deps>", "");
                head = m.replaceAll("");
                head = head.replace("</header>", "");
            }
            this.header = this.getParams(head);
            if (this.header == null) {
                bufferStream.close();
                return;
            }
            this.deps = this.getParams(depsText);
            bufferStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParamClass[] getParams(String head) {
        ParamClass[] header = null;
        String[] target = null;
        String regex = "<.+?>";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(head);
        while (m.find()) {
            if (target == null) {
                target = new String[]{m.group()};
                continue;
            }
            String[] copy = new String[target.length + 1];
            System.arraycopy(target, 0, copy, 0, target.length);
            target = null;
            target = new String[copy.length];
            System.arraycopy(copy, 0, target, 0, copy.length);
            target[target.length - 1] = m.group();
            copy = null;
        }
        if (target != null) {
            header = new ParamClass[target.length];
            int i = 0;
            while (i < target.length) {
                regex = "<.+? ";
                p = Pattern.compile(regex);
                m = p.matcher(target[i]);
                if (m.find()) {
                    String src = m.group();
                    String param = m.replaceAll("");
                    header[i] = new ParamClass(src, param);
                }
                ++i;
            }
        }
        return header;
    }

    public void addQueue(String m) {
        int tar = this.writePoint++;
        this.readed = false;
        if (this.writePoint >= 1000) {
            this.writePoint = 0;
        }
        if (this.queueArray[tar] == null) {
            this.queueArray[tar] = m;
        } else {
            this.addQueue(m);
        }
        m = null;
    }

    public String getNowQueue() {
        String ret = "NULL";
        if (this.queueArray[this.readPoint] != null) {
            ret = this.queueArray[this.readPoint];
        }
        return ret;
    }

    @Override
    public void run() {
        StartUp.printDEBUG("[GetMapInfoThread] - run start");
        while (!this.dispose) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.threadCheck) {
                this.threadCheck = true;
            }
            if (this.queueArray[this.readPoint] == null || this.svc.dbMLMaking) continue;
            String method = this.queueArray[this.readPoint];
            this.queueArray[this.readPoint] = null;
            ++this.readPoint;
            if (this.readPoint >= 1000) {
                this.readPoint = 0;
            }
            if (!"".equals(method)) {
                this.setTrackInfo(method);
                this.readed = true;
            }
            Object var1_1 = null;
        }
    }
}

