/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.ParamsClass;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.Value;

public class GameInfoState {
    public int gameMode = -1;
    public int chatTime;
    public int nbChallenge;
    public int roundPointLimit;
    public boolean roundNewRule;
    public int roundForcedLaps;
    public int timeAttackLimit;
    public int timeAttackSynch;
    public int teamPointLimit;
    public int teamMaxPoint;
    public boolean teamNewRule;
    public int lapsNbLaps;
    public int lapsTimeLimit;
    public int finishTimeOut;
    public String modeString;

    public GameInfoState(Value[] info) {
        if (info == null) {
            return;
        }
        if (info.length < 10) {
            return;
        }
        if (info.length > 0) {
            this.gameMode = Integer.parseInt(info[0].value);
        }
        if (info.length > 1) {
            this.chatTime = Integer.parseInt(info[1].value);
        }
        if (info.length > 2) {
            this.nbChallenge = Integer.parseInt(info[2].value);
        }
        if (info.length > 3) {
            this.roundPointLimit = Integer.parseInt(info[3].value);
        }
        if (info.length > 4) {
            this.roundNewRule = StartUp.tool.getBoolean(info[4].value);
        }
        if (info.length > 5) {
            this.roundForcedLaps = Integer.parseInt(info[5].value);
        }
        if (info.length > 6) {
            this.timeAttackLimit = Integer.parseInt(info[6].value);
        }
        if (info.length > 7) {
            this.timeAttackSynch = Integer.parseInt(info[7].value);
        }
        if (info.length > 8) {
            this.teamPointLimit = Integer.parseInt(info[8].value);
        }
        if (info.length > 9) {
            this.teamMaxPoint = Integer.parseInt(info[9].value);
        }
        if (info.length > 10) {
            this.teamNewRule = StartUp.tool.getBoolean(info[10].value);
        }
        if (info.length > 11) {
            this.lapsNbLaps = Integer.parseInt(info[11].value);
        }
        if (info.length > 12) {
            this.lapsTimeLimit = Integer.parseInt(info[12].value);
        }
        if (info.length > 13) {
            this.finishTimeOut = Integer.parseInt(info[13].value);
        }
        this.modeString = this.gameMode > -1 ? StartUp.tool.getModeString(this.gameMode) : "";
    }

    public GameInfoState(ParamsClass pc) {
        if (pc == null) {
            return;
        }
        if (pc.param == null) {
            return;
        }
        if (pc.param[0].struct == null) {
            return;
        }
        if (pc.param[0].struct.member == null) {
            return;
        }
        int im = 0;
        while (im < pc.param[0].struct.member.length) {
            if ("GameMode".equals(pc.param[0].struct.member[im].name)) {
                this.gameMode = pc.param[0].struct.member[im].i4;
            }
            if ("ChatTime".equals(pc.param[0].struct.member[im].name)) {
                this.chatTime = pc.param[0].struct.member[im].i4;
            }
            if ("NbChallenge".equals(pc.param[0].struct.member[im].name)) {
                this.nbChallenge = pc.param[0].struct.member[im].i4;
            }
            if ("RoundsPointsLimit".equals(pc.param[0].struct.member[im].name)) {
                this.roundPointLimit = pc.param[0].struct.member[im].i4;
            }
            if ("RoundsUseNewRules".equals(pc.param[0].struct.member[im].name)) {
                this.roundNewRule = pc.param[0].struct.member[im].bool;
            }
            if ("RoundsForcedLaps".equals(pc.param[0].struct.member[im].name)) {
                this.roundForcedLaps = pc.param[0].struct.member[im].i4;
            }
            if ("TimeAttackLimit".equals(pc.param[0].struct.member[im].name)) {
                this.timeAttackLimit = pc.param[0].struct.member[im].i4;
            }
            if ("TimeAttackSynchStartPeriod".equals(pc.param[0].struct.member[im].name)) {
                this.timeAttackSynch = pc.param[0].struct.member[im].i4;
            }
            if ("TeamPointsLimit".equals(pc.param[0].struct.member[im].name)) {
                this.teamPointLimit = pc.param[0].struct.member[im].i4;
            }
            if ("TeamMaxPoints".equals(pc.param[0].struct.member[im].name)) {
                this.teamMaxPoint = pc.param[0].struct.member[im].i4;
            }
            if ("TeamUseNewRules".equals(pc.param[0].struct.member[im].name)) {
                this.teamNewRule = pc.param[0].struct.member[im].bool;
            }
            if ("LapsNbLaps".equals(pc.param[0].struct.member[im].name)) {
                this.lapsNbLaps = pc.param[0].struct.member[im].i4;
            }
            if ("LapsTimeLimit".equals(pc.param[0].struct.member[im].name)) {
                this.lapsTimeLimit = pc.param[0].struct.member[im].i4;
            }
            if ("FinishTimeout".equals(pc.param[0].struct.member[im].name)) {
                this.finishTimeOut = pc.param[0].struct.member[im].i4;
            }
            ++im;
        }
        this.modeString = this.gameMode > -1 ? StartUp.tool.getModeString(this.gameMode) : "";
    }

    public int retTimeLimit() {
        int ret = -1;
        if (this.modeString != null && "TimeAttack".equals(this.modeString)) {
            ret = this.timeAttackLimit;
        }
        return ret;
    }
}

