/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.DBranking;
import hir.westfield.tm.ParamsClass;
import hir.westfield.tm.PlayerDataClass;
import hir.westfield.tm.ResponseGetSystemInfo;
import hir.westfield.tm.ResponseGetVersion;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;
import hir.westfield.tm.XMLParser;
import hir.westfield.tm.resXML;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DedimaniaThread
extends Thread {
    public XMLParser xmlParser;
    private boolean connectingNow = false;
    private boolean looping;
    public boolean dispose;
    private String dediURL;
    public boolean tm1Authenticate = false;
    public int maxRank = 10;
    public DBranking hostSetting = null;
    public boolean connect = false;
    public boolean timeOut = false;
    public boolean http404 = false;
    public boolean http403 = false;
    private String error;
    private String sessionID = null;
    private String toolName = "TMSL";
    private String authGame;
    private String authPath;
    private String authNation;
    private String authPackMask;
    private String serverIP;
    private String serverVer;
    private String serverBuild;
    private String authPassword;
    private boolean skipConnected;
    public DBranking[] dediQueue;
    private int queueWritePoint;
    private int queueReadPoint;
    public resXML[] dediResult;
    private int resultWritePoint;
    public DBranking[] currentMapDediRank;
    public int dediNowCount;
    public String nowDediGameMode;
    public boolean dediGetStart;
    public boolean dediUse;
    private SVCMainThread svc;
    public boolean finish = false;
    public boolean tickerBack = false;
    public String tickerHigh;
    public String tickerLow;
    public double tickerHX;
    public double tickerLX;
    public String borderBold = "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501";
    public String borderNormal = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";

    public DedimaniaThread(SVCMainThread s) {
        this.svc = s;
        s = null;
        this.skipConnected = true;
        this.xmlParser = new XMLParser(this.svc);
        this.dediUse = false;
    }

    public void connectDataInit() {
        this.dediQueue = new DBranking[1000];
        this.dediResult = new resXML[1000];
        int i = 0;
        while (i < 1000) {
            this.dediQueue[i] = null;
            this.dediResult[i] = null;
            ++i;
        }
        this.queueWritePoint = 0;
        this.queueReadPoint = 0;
        this.resultWritePoint = 0;
        if (this.svc.cdc.tmVersion == 1) {
            this.dediURL = "http://dedimania.net:8002/Dedimania";
        } else if (this.svc.cdc.tmVersion == 2) {
            this.dediURL = "http://dedimania.net:8082/Dedimania";
        }
        if (this.svc.cdc.tmVersion == 1) {
            if (this.svc.titleID.equals("United")) {
                this.authGame = "TMUF";
            } else if (this.svc.titleID.equals("Stadium")) {
                this.authGame = "TMNF";
            }
        } else if (this.svc.cdc.tmVersion == 2) {
            this.authGame = "TM2";
        }
        PlayerDataClass pdc = new PlayerDataClass(this.svc.sendMethod(true, "GetDetailedPlayerInfo", this.svc.cdc.nowCM.serverAccount));
        if (pdc == null) {
            this.authPath = "";
        } else {
            this.authPath = pdc.path;
            String[] tempNation = this.authPath.split("\\|");
            this.authNation = tempNation[tempNation.length - 1];
            tempNation = null;
            pdc = null;
        }
        ParamsClass pc = this.svc.sendMethod(true, "GetServerPackMask");
        if (pc != null) {
            if (pc.param != null) {
                this.authPackMask = pc.param[0].value.value;
                pc = null;
            } else {
                this.authPackMask = "";
            }
        }
        ResponseGetSystemInfo rgsi = new ResponseGetSystemInfo(this.svc.sendMethod(true, "GetSystemInfo"));
        this.serverIP = rgsi.check ? rgsi.publishedIP : "192.168.0.1";
        rgsi = null;
        ResponseGetVersion rgv = new ResponseGetVersion(this.svc.sendMethod(true, "GetVersion"));
        if (rgv.check) {
            this.serverVer = rgv.version;
            this.serverBuild = rgv.build;
        } else {
            this.serverVer = "";
            this.serverBuild = "";
        }
        rgv = null;
        this.looping = true;
    }

    public int setQueue(DBranking src) {
        if (!this.connect) {
            return -1;
        }
        int tar = -1;
        if (this.dediQueue != null) {
            tar = this.queueWritePoint++;
            if (this.queueWritePoint > 999) {
                this.queueWritePoint = 0;
            }
            this.dediQueue[tar] = null;
            this.dediQueue[tar] = new DBranking(src);
        }
        return tar;
    }

    private void resultClear() {
        this.error = "";
    }

    private void putAllResults() {
        if (!StartUp.debugDedi) {
            return;
        }
        this.svc.printDedi("\u3010 DedimaniaThread - Results \u3011");
        this.svc.printDedi("\terror : " + this.error);
        this.svc.printDedi("\tsessionID : " + this.sessionID);
        this.svc.printDedi("\u3010 DedimaniaThread - Condition \u3011");
        this.svc.printDedi("\tConnection : " + this.connect);
    }

    private int getNowRank(String login) {
        if (this.currentMapDediRank == null) {
            return -1;
        }
        int ret = -1;
        int i = 0;
        while (i < this.currentMapDediRank.length) {
            if (this.currentMapDediRank[i] != null && this.currentMapDediRank[i].login.equals(login)) {
                ret = this.currentMapDediRank[i].rank;
                break;
            }
            ++i;
        }
        return ret;
    }

    private int getDediDataInt(resXML[] rx, String target) {
        int ret = -1;
        int i = 0;
        while (i < rx.length) {
            if (rx[i].name.equals(target)) {
                ret = Integer.parseInt(rx[i].value);
                break;
            }
            ++i;
        }
        return ret;
    }

    private String getDediDataString(resXML[] rx, String target) {
        String ret = "";
        int i = 0;
        while (i < rx.length) {
            if (rx[i].name.equals(target)) {
                if (this.svc.cdc.tmVersion == 2 || !target.equals("Checks")) {
                    ret = rx[i].value;
                    break;
                }
                if (rx[i].array != null) {
                    ret = "";
                    int ii = 0;
                    while (ii < rx[i].array.length) {
                        if (ii != 0) {
                            ret = String.valueOf(ret) + ",";
                        }
                        ret = String.valueOf(ret) + rx[i].array[ii].value;
                        ++ii;
                    }
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    private void addDediRanking(DBranking add, boolean chat) {
        boolean update = true;
        if (this.currentMapDediRank == null) {
            this.currentMapDediRank = new DBranking[1];
            this.currentMapDediRank[0] = new DBranking(add);
            this.currentMapDediRank[0].rank = 1;
        } else {
            boolean doubleChk = false;
            int i = 0;
            while (i < this.currentMapDediRank.length) {
                if (this.currentMapDediRank[i] != null && this.currentMapDediRank[i].login.equals(add.login)) {
                    doubleChk = true;
                    if (add.fastest < this.currentMapDediRank[i].fastest) {
                        this.currentMapDediRank[i] = null;
                        this.currentMapDediRank[i] = new DBranking(add);
                        this.currentMapDediRank[i].rank = i + 1;
                        break;
                    }
                    update = false;
                    break;
                }
                ++i;
            }
            if (!doubleChk) {
                DBranking[] temp = new DBranking[this.currentMapDediRank.length];
                System.arraycopy(this.currentMapDediRank, 0, temp, 0, this.currentMapDediRank.length);
                this.currentMapDediRank = null;
                this.currentMapDediRank = new DBranking[temp.length + 1];
                System.arraycopy(temp, 0, this.currentMapDediRank, 0, temp.length);
                this.currentMapDediRank[temp.length] = new DBranking(add);
                this.currentMapDediRank[temp.length].rank = temp.length + 1;
            }
        }
        if (update) {
            this.currentMapDediRank = this.getNewStandings();
            this.setDediRankColumn();
            int nowRank = this.getNowRank(add.login);
            if (nowRank <= this.maxRank) {
                if (chat) {
                    this.setQueue(new DBranking("ShowRanking"));
                }
                if (chat) {
                    String[] deco = this.svc.cdc.nowCM.mesDecoration;
                    String mes = "";
                    if (this.svc.cdc.nowCM.dedimania[6].equals("true")) {
                        mes = String.valueOf(mes) + "$z" + add.nickname + deco[0] + deco[1] + deco[2] + StartUp.tool.getTimeText(add.fastest, true) + deco[0] + deco[3];
                        mes = String.valueOf(mes) + deco[0] + " " + this.svc.cdc.nowCM.newRecordMes[3];
                        mes = String.valueOf(mes) + deco[0] + " " + StartUp.tool.getPlaceString(nowRank);
                        mes = String.valueOf(mes) + deco[0] + " " + this.svc.cdc.nowCM.dedimania[5] + deco[0] + ".";
                        this.sendChatMessage(-1, mes);
                    }
                    deco = null;
                    mes = null;
                }
            }
        }
        add = null;
    }

    private void setDediRankColumn() {
        this.dediNowCount = 0;
        if (this.currentMapDediRank == null) {
            return;
        }
        int i = 0;
        while (i < this.currentMapDediRank.length) {
            if (this.currentMapDediRank[i] != null) {
                ++this.dediNowCount;
            }
            ++i;
        }
        if (this.dediNowCount > this.maxRank) {
            this.dediNowCount = this.maxRank;
        }
    }

    private int[] addInteger(int[] src, int set) {
        int[] ret;
        int tar = 0;
        if (src == null) {
            ret = new int[1];
            tar = 0;
        } else {
            ret = new int[src.length + 1];
            tar = src.length;
            System.arraycopy(src, 0, ret, 0, tar);
            src = null;
        }
        ret[tar] = set;
        return ret;
    }

    public DBranking[] getNewStandings() {
        if (this.currentMapDediRank == null) {
            this.setTickerText(this.currentMapDediRank);
            return null;
        }
        if (this.currentMapDediRank.length < 2) {
            this.setTickerText(this.currentMapDediRank);
            return this.currentMapDediRank;
        }
        int[] temp = new int[this.currentMapDediRank.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = i;
            ++i;
        }
        if (temp.length < 2) {
            return this.currentMapDediRank;
        }
        int l = 0;
        while (l < temp.length - 1) {
            int r = temp.length - 1;
            while (r > l) {
                int timeL;
                int timeR = this.currentMapDediRank[temp[r]].fastest;
                if (timeR < 1) {
                    timeR = 999999999;
                }
                if ((timeL = this.currentMapDediRank[temp[r - 1]].fastest) < 1) {
                    timeL = 999999999;
                }
                boolean chk = false;
                if (timeL > timeR) {
                    chk = true;
                }
                if (chk) {
                    int tL = 0;
                    int tR = 0;
                    tL = temp[r - 1];
                    temp[r - 1] = tR = temp[r];
                    temp[r] = tL;
                }
                --r;
            }
            ++l;
        }
        DBranking[] ret = new DBranking[this.currentMapDediRank.length];
        int i2 = 0;
        while (i2 < temp.length) {
            ret[i2] = new DBranking(this.currentMapDediRank[temp[i2]]);
            ret[i2].rank = i2 + 1;
            ++i2;
        }
        this.setTickerText(ret);
        temp = null;
        return ret;
    }

    public void setTickerText(DBranking[] ret) {
        String high = "";
        String low = "";
        int i = 0;
        while (i < 10) {
            String tempColor = "$fff";
            String tempNick = String.valueOf(tempColor) + "  \u3010 No record \u3011";
            String tempTime = "";
            if (ret != null && ret.length > i && ret[i] != null) {
                if (ret[i].dediPlayer) {
                    tempColor = "$ff0";
                }
                tempNick = ret[i].nickname;
                tempTime = " \u3010 " + StartUp.tool.getTimeText(ret[i].fastest, true) + " \u3011";
            }
            String tempR = tempColor;
            tempR = String.valueOf(tempR) + StartUp.tool.getPlaceString(i + 1) + "  ";
            tempR = String.valueOf(tempR) + "$z" + tempNick + " ";
            tempR = String.valueOf(tempR) + "$z" + tempColor + tempTime;
            double x = i;
            if (x > 4.0) {
                x -= 5.0;
            }
            if (x > 0.0) {
                x *= 25.6;
            }
            x -= 64.0;
            String tempX = "<label posn=\"" + ((x += 12.8) + 0.1) + " -0.05 1\" halign=\"center\" valign=\"center\" scale=\"0.6\" text=\"" + StartUp.tool.getGrayColorText(tempR) + "\" />";
            tempX = String.valueOf(tempX) + "<label posn=\"" + x + " 0 2\" halign=\"center\" valign=\"center\" scale=\"0.6\" text=\"" + tempR + "\" />";
            if (i < 5) {
                high = String.valueOf(high) + tempX;
            } else {
                low = String.valueOf(low) + tempX;
            }
            tempX = null;
            tempR = null;
            tempTime = null;
            tempNick = null;
            tempColor = null;
            ++i;
        }
        this.tickerHigh = high;
        this.tickerLow = low;
        high = null;
        low = null;
    }

    private void setDediRanking(resXML rx) {
        if (rx == null) {
            return;
        }
        if (rx.param == null) {
            return;
        }
        if (rx.param[0].array == null) {
            return;
        }
        resXML[] tar = null;
        if (this.svc.cdc.tmVersion == 1) {
            if (rx.param[0].array.length < 2) {
                return;
            }
            if (rx.param[0].array[1] == null) {
                return;
            }
            if (rx.param[0].array[1].array == null) {
                return;
            }
            if (rx.param[0].array[1].array[0] == null) {
                return;
            }
            if (rx.param[0].array[1].array[0].struct == null) {
                return;
            }
            tar = rx.param[0].array[1].array[0].struct;
        } else if (this.svc.cdc.tmVersion == 2) {
            if (rx.param[0].array[0].array == null) {
                return;
            }
            if (rx.param[0].array[0].array[0].struct == null) {
                return;
            }
            tar = rx.param[0].array[0].array[0].struct;
        }
        this.hostSetting = new DBranking();
        int arrayTarget = -1;
        int i = 0;
        while (i < tar.length) {
            String targetUID = "UId";
            if (this.svc.cdc.tmVersion == 1) {
                targetUID = "Uid";
            }
            String targetMaxRank = "ServerMaxRank";
            if (this.svc.cdc.tmVersion == 1) {
                targetMaxRank = "ServerMaxRecords";
            }
            if (tar[i].name.equals(targetUID)) {
                this.hostSetting.dediUID = tar[i].value;
            }
            if (tar[i].name.equals(targetMaxRank)) {
                this.hostSetting.dediMaxRank = Integer.parseInt(tar[i].value);
            }
            if (tar[i].name.equals("AllowedGameModes")) {
                this.hostSetting.dediGameModes = tar[i].value;
            }
            if (tar[i].name.equals("Records")) {
                arrayTarget = i;
            }
            targetUID = null;
            targetMaxRank = null;
            ++i;
        }
        tar = null;
        if (!this.hostSetting.dediUID.equals(this.svc.nowMapInfo.uID)) {
            this.hostSetting = null;
            return;
        }
        if (arrayTarget == -1) {
            this.hostSetting = null;
            return;
        }
        if (this.svc.cdc.tmVersion == 1) {
            tar = rx.param[0].array[1].array[0].struct[arrayTarget].array;
        }
        if (this.svc.cdc.tmVersion == 2) {
            tar = rx.param[0].array[0].array[0].struct[arrayTarget].array;
        }
        if (tar == null) {
            this.setQueue(new DBranking("ShowRanking"));
            return;
        }
        int max = tar.length;
        if (max > this.maxRank) {
            max = this.maxRank;
        }
        if (max == 0) {
            this.setQueue(new DBranking("ShowRanking"));
            return;
        }
        int d = 0;
        while (d < max) {
            int s = 0;
            while (s < tar.length) {
                if (tar[s].struct != null && this.getDediDataInt(tar[s].struct, "Rank") == d + 1) {
                    String[] temp;
                    temp = new String[]{"" + this.getDediDataInt(tar[s].struct, "Rank"), this.getDediDataString(tar[s].struct, "Login"), this.getDediDataString(tar[s].struct, "NickName"), "" + this.getDediDataInt(tar[s].struct, "Best"), temp[3], this.getDediDataString(tar[s].struct, "Checks")};
                    this.addDediRanking(new DBranking(temp), false);
                    temp = null;
                    break;
                }
                ++s;
            }
            ++d;
        }
        tar = null;
        if (this.dediNowCount > this.maxRank) {
            this.dediNowCount = this.maxRank;
        }
        this.currentMapDediRank = this.getNewStandings();
    }

    public void showDedimaniaRankingPersonal(String login) {
        if (this.svc.players == null) {
            return;
        }
        if (StartUp.tool.getBoolean(this.svc.cdc.nowCM.dedimania[7])) {
            this.tickerShow();
            return;
        }
        int pl = StartUp.tool.getNumberFromLogin(this.svc, login);
        if (pl == -1) {
            return;
        }
        if (this.svc.players[pl] == null) {
            return;
        }
        if (this.svc.players[pl].disConnect) {
            return;
        }
        this.svc.mlRec.showRecords(this.svc.players[pl].login, "dedi");
    }

    public void showDedimaniaRankingALL() {
        if (this.svc.players == null) {
            return;
        }
        if (StartUp.tool.getBoolean(this.svc.cdc.nowCM.dedimania[7])) {
            this.tickerShow();
            return;
        }
        int i = 0;
        while (i < this.svc.players.length) {
            if (this.svc.players[i] != null && !this.svc.players[i].disConnect) {
                this.svc.mlRec.showRecords(this.svc.players[i].login, "dedi");
            }
            ++i;
        }
    }

    public void hideDedimaniaRankingALL() {
        String xml = "";
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = String.valueOf(xml) + "<manialink id=\"13\"></manialink>";
        xml = String.valueOf(xml) + "<manialink id=\"14\"></manialink>";
        this.svc.sendML(-1, xml, 1, false);
        xml = null;
    }

    private String getTM1Authencate() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.Authenticate</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>Game</name><value><string>" + this.authGame + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.svc.cdc.nowCM.serverAccount + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Password</name><value><string>" + this.svc.cdc.nowCM.dedimania[4] + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Tool</name><value><string>" + this.toolName + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Version</name><value><string>" + StartUp.verDouble + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Nation</name><value><string>" + this.authNation + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Packmask</name><value><string>" + this.authPackMask + "</string></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private String tm1Authencate() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + this.getTM1Authencate();
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.ValidateAccount</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name><value><array><data></data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.WarningsAndTTR</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name><value><array><data></data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param>";
        xml = String.valueOf(xml) + "</params>";
        xml = String.valueOf(xml) + "</methodCall>";
        return xml;
    }

    private String getAuthenticateXML() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>Game</name><value><string>" + this.authGame + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.svc.cdc.nowCM.serverAccount + "</string></value></member>";
        if (this.svc.cdc.tmVersion == 1) {
            xml = String.valueOf(xml) + "<member><name>Password</name><value><string>" + this.svc.cdc.nowCM.dedimania[4] + "</string></value></member>";
            xml = String.valueOf(xml) + "<member><name>Nation</name><value><string>" + this.authPath + "</string></value></member>";
        } else {
            xml = String.valueOf(xml) + "<member><name>Code</name><value><string>" + this.svc.cdc.nowCM.dedimania[1] + "</string></value></member>";
            xml = String.valueOf(xml) + "<member><name>Path</name><value><string>" + this.authPath + "</string></value></member>";
        }
        xml = String.valueOf(xml) + "<member><name>Tool</name><value><string>" + this.toolName + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Version</name><value><string>" + StartUp.verDouble + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Packmask</name><value><string>" + this.authPackMask + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>ServerVersion</name><value><string>" + this.serverVer + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>ServerBuild</name><value><string>" + this.serverBuild + "</string></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private int[] getNowPlayersNumber() {
        int[] ret = new int[]{0, 0};
        if (this.svc.players == null) {
            return ret;
        }
        int i = 0;
        while (i < this.svc.players.length) {
            if (this.svc.players[i] != null && !this.svc.players[i].disConnect) {
                if (this.svc.players[i].isSpectator) {
                    ret[1] = ret[1] + 1;
                } else {
                    ret[0] = ret[0] + 1;
                }
            }
            ++i;
        }
        return ret;
    }

    private String getNextFiveUID() {
        String ret = "";
        if (this.svc.reserveMapList == null) {
            return ret;
        }
        int now = -1;
        int i = 0;
        while (i < this.svc.reserveMapList.length) {
            if (this.svc.nowMapInfo.uID.equals(this.svc.reserveMapList[i].uID)) {
                now = i;
                break;
            }
            ++i;
        }
        int next = now;
        int i2 = 0;
        while (i2 < 5) {
            if (++next >= this.svc.reserveMapList.length) {
                next = 0;
            }
            if (i2 > 0) {
                ret = String.valueOf(ret) + "/";
            }
            ret = String.valueOf(ret) + this.svc.reserveMapList[next].uID;
            ++i2;
        }
        return ret;
    }

    private String getPlayerArrayVote() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><array><data>";
        if (this.svc.players != null) {
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null && !this.svc.players[i].disConnect) {
                    String isSpec = "";
                    isSpec = this.svc.players[i].isSpectator ? "1" : "0";
                    int vote = this.svc.players[i].vote;
                    if (vote < 0) {
                        vote = 0;
                    }
                    vote = -1;
                    xml = String.valueOf(xml) + "<value><struct>";
                    xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.svc.players[i].login + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>IsSpec</name><value><boolean>" + isSpec + "</boolean></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Vote</name><value><int>" + vote + "</int></value></member>";
                    xml = String.valueOf(xml) + "</struct></value>";
                    Object var3_3 = null;
                }
                ++i;
            }
        }
        xml = String.valueOf(xml) + "</data></array></value>";
        return xml;
    }

    private String getPlayerListTM1() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><array><data>";
        if (this.svc.players != null) {
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null && !this.svc.players[i].disConnect) {
                    int isSpec = 0;
                    isSpec = this.svc.players[i].isSpectator ? 1 : 0;
                    int b = 0;
                    b = this.svc.players[i].isOfficial ? 1 : 0;
                    xml = String.valueOf(xml) + "<value><struct>";
                    xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.svc.players[i].login + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Nation</name><value><string>" + this.svc.players[i].from + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>TeamName</name><value><string>" + this.svc.players[i].teamName + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>TeamId</name><value><int>" + this.svc.players[i].teamID + "</int></value></member>";
                    xml = String.valueOf(xml) + "<member><name>IsSpec</name><value><boolean>" + isSpec + "</boolean></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Ranking</name><value><int>" + this.svc.players[i].ladderRank + "</int></value></member>";
                    xml = String.valueOf(xml) + "<member><name>IsOff</name><value><boolean>" + b + "</boolean></value></member>";
                    xml = String.valueOf(xml) + "</struct></value>";
                }
                ++i;
            }
        }
        xml = String.valueOf(xml) + "</data></array></value>";
        return xml;
    }

    private String getPlayerArrayMini() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><array><data>";
        if (this.svc.players != null) {
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null && !this.svc.players[i].disConnect) {
                    String isSpec = "";
                    isSpec = this.svc.players[i].isSpectator ? "1" : "0";
                    xml = String.valueOf(xml) + "<value><struct>";
                    xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.svc.players[i].login + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>IsSpec</name><value><boolean>" + isSpec + "</boolean></value></member>";
                    xml = String.valueOf(xml) + "</struct></value>";
                    Object var3_3 = null;
                }
                ++i;
            }
        }
        xml = String.valueOf(xml) + "</data></array></value>";
        return xml;
    }

    private String getVoteInfoXML() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>UId</name><value><string>" + this.svc.nowMapInfo.uID + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>GameMode</name><value><string>" + this.nowDediGameMode + "</string></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private String getMapInfoXML() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>UId</name><value><string>" + this.svc.nowMapInfo.uID + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Name</name><value><string>" + this.svc.nowMapInfo.name + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Environment</name><value><string>" + this.svc.nowMapInfo.env + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Author</name><value><string>" + this.svc.nowMapInfo.author + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>NbCheckpoints</name><value><int>" + this.svc.nowMapInfo.cpCount + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>NbLaps</name><value><int>" + this.svc.nowMapInfo.lapCount + "</int></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private String getServerInfoXMLtm1() {
        String xml = "";
        int[] pl = this.getNowPlayersNumber();
        int vis = this.svc.cdc.nowCM.serverVisibility;
        if (vis > 1) {
            vis = 0;
        }
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>SrvName</name><value><string>" + this.svc.cdc.nowCM.serverName + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Comment</name><value><string>" + this.svc.cdc.nowCM.serverComment + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Private</name><value><boolean>" + vis + "</boolean></value></member>";
        xml = String.valueOf(xml) + "<member><name>SrvIP</name><value><string>" + this.serverIP + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>SrvPort</name><value><string>" + this.svc.cdc.nowCM.serverPort + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>XmlrpcPort</name><value><string>" + this.svc.cdc.nowCM.xmlrpcPort + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>NumPlayers</name><value><int>" + pl[0] + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>MaxPlayers</name><value><int>" + this.svc.cdc.nowCM.playersLimit + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>NumSpecs</name><value><int>" + pl[1] + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>MaxSpecs</name><value><int>" + this.svc.cdc.nowCM.spectatorsLimit + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>LadderMode</name><value><int>" + this.svc.cdc.nowCM.ladderEnable + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>NextFiveUID</name><value><string>" + this.getNextFiveUID() + "</string></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private String getServerInfoXMLMini() {
        String xml = "";
        int[] pl = this.getNowPlayersNumber();
        int vis = this.svc.cdc.nowCM.serverVisibility;
        if (vis > 1) {
            vis = 0;
        }
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>SrvName</name><value><string>" + this.svc.cdc.nowCM.serverName + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Comment</name><value><string>" + this.svc.cdc.nowCM.serverComment + "</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>Private</name><value><boolean>" + vis + "</boolean></value></member>";
        xml = String.valueOf(xml) + "<member><name>NumPlayers</name><value><int>" + pl[0] + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>MaxPlayers</name><value><int>" + this.svc.cdc.nowCM.playersLimit + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>NumSpecs</name><value><int>" + pl[1] + "</int></value></member>";
        xml = String.valueOf(xml) + "<member><name>MaxSpecs</name><value><int>" + this.svc.cdc.nowCM.spectatorsLimit + "</int></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private String get1stXML() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params>";
        xml = String.valueOf(xml) + "<param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.Authenticate</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name><value><array><data>";
        xml = String.valueOf(xml) + this.getAuthenticateXML();
        xml = String.valueOf(xml) + "</data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "</data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.ValidateAccount</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name><value><array><data></data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.WarningsAndTTR</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name><value><array><data></data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param>";
        xml = String.valueOf(xml) + "</params>";
        xml = String.valueOf(xml) + "</methodCall>";
        return xml;
    }

    private String getPlayerPath(String login) {
        String ret = "";
        if (this.svc.players != null) {
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null && this.svc.players[i].login.equals(login)) {
                    ret = this.svc.players[i].path;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    private String getPlayerIsSpec(String login) {
        String ret = "0";
        if (this.svc.players != null) {
            int i = 0;
            while (i < this.svc.players.length) {
                if (this.svc.players[i] != null && this.svc.players[i].login.equals(login) && this.svc.players[i].isSpectator) {
                    ret = "1";
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public void playerConnectTM1(DBranking src) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + this.getTM1Authencate();
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.PlayerArrive</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.authGame + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.login + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.nickname + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.dediFrom + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.dediTeamName + "</string></value>";
        xml = String.valueOf(xml) + "<value><int>" + src.dediLadderRanking + "</int></value>";
        xml = String.valueOf(xml) + "<value><boolean>" + src.dediIsSpec + "</boolean></value>";
        xml = String.valueOf(xml) + "<value><boolean>" + src.dediIsOfficial + "</boolean></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public void playerConnect(DBranking src) {
        if (this.svc.cdc.tmVersion == 1) {
            this.playerConnectTM1(src);
            return;
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.PlayerConnect</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.sessionID + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.login + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.nickname + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.dediPath + "</string></value>";
        xml = String.valueOf(xml) + "<value><boolean>" + src.dediIsSpec + "</boolean></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public void playersDisConnectTM1(DBranking src) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + this.getTM1Authencate();
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.PlayerLeave</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.authGame + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.login + "</string></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public void playerDisConnect(DBranking src) {
        if (this.svc.cdc.tmVersion == 1) {
            this.playersDisConnectTM1(src);
            return;
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.PlayerDisconnect</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.sessionID + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + src.login + "</string></value>";
        xml = String.valueOf(xml) + "<value><string></string></value>";
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public void openSession() {
        this.nowDediGameMode = "";
        if (this.svc.currentGameInfo != null) {
            String nowMode = StartUp.tool.getNowModeString(this.svc);
            if ("Rounds".equals(nowMode)) {
                this.nowDediGameMode = "Rounds";
            } else if ("TimeAttack".equals(nowMode)) {
                this.nowDediGameMode = "TA";
            } else if ("Team".equals(nowMode)) {
                this.nowDediGameMode = "Rounds";
            } else if ("Laps".equals(nowMode)) {
                this.nowDediGameMode = "Rounds";
            } else if ("Cup".equals(nowMode)) {
                this.nowDediGameMode = "Rounds";
            }
        }
        if (this.svc.cdc.tmVersion == 1) {
            String target = "http://dedimania.net/RPC5/server.php";
            int result = this.sendDedimania(this.tm1Authencate(), target);
            this.tm1Authenticate = false;
            if (this.dediResult[result].param != null && this.dediResult[result].param[0].array != null) {
                if (this.dediResult[result].param[0].array[0].array != null && this.dediResult[result].param[0].array[0].array[0].value != null && this.dediResult[result].param[0].array[0].array[0].value.equals("1")) {
                    this.tm1Authenticate = true;
                }
                if (this.tm1Authenticate) {
                    this.connect = true;
                    this.allPlayersDBrecordShow();
                    this.setQueue(new DBranking("getChallengeRecords"));
                    this.connectingNow = false;
                }
            }
            target = null;
        } else {
            String target;
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
            xml = String.valueOf(xml) + "<methodCall>";
            xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
            xml = String.valueOf(xml) + "<params><param>";
            xml = String.valueOf(xml) + "<value><array><data>";
            xml = String.valueOf(xml) + "<value><struct>";
            xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.OpenSession</string></value></member>";
            xml = String.valueOf(xml) + "<member>";
            xml = String.valueOf(xml) + "<name>params</name>";
            xml = String.valueOf(xml) + "<value><array><data>";
            xml = String.valueOf(xml) + this.getAuthenticateXML();
            xml = String.valueOf(xml) + "</data></array></value>";
            xml = String.valueOf(xml) + "</member>";
            xml = String.valueOf(xml) + "</struct></value>";
            xml = String.valueOf(xml) + this.getWarningsTTR();
            xml = String.valueOf(xml) + "</data></array></value>";
            xml = String.valueOf(xml) + "</param></params>";
            int result = this.sendDedimania(xml = String.valueOf(xml) + "</methodCall>", target = "http://dedimania.net/RPC5/server.php");
            if (result == -1) {
                result = this.sendDedimania(xml, this.dediURL);
            }
            if (result == -1) {
                try {
                    Thread.sleep(120000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.openSession();
                return;
            }
            this.getStructValue1st(this.dediResult[result]);
            this.putAllResults();
            xml = null;
            if (this.sessionID != null) {
                this.connect = true;
                this.allPlayersDBrecordShow();
                this.setQueue(new DBranking("getChallengeRecords"));
                this.connectingNow = false;
            }
        }
    }

    public int retGameMode() {
        int ret = 0;
        ParamsClass pc = this.svc.sendMethod(true, "GetGameMode");
        if (pc != null && pc.param != null && pc.param[0].value != null) {
            ret = pc.param[0].value.i4;
        }
        pc = null;
        return ret;
    }

    public void getCurrentChallenge() {
        String mode = "" + this.retGameMode();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + this.getTM1Authencate();
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.CurrentChallenge</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.uID + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.name + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.env + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.author + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.authGame + "</string></value>";
        xml = String.valueOf(xml) + "<value><int>" + mode + "</int></value>";
        xml = String.valueOf(xml) + this.getServerInfoXMLtm1();
        xml = String.valueOf(xml) + "<value><int>" + this.maxRank + "</int></value>";
        xml = String.valueOf(xml) + this.getPlayerListTM1();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
        if (this.dediResult[result] != null) {
            this.setDediRanking(this.dediResult[result]);
        }
    }

    public void getChallengeRecords() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.GetChallengeRecords</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.sessionID + "</string></value>";
        xml = String.valueOf(xml) + this.getMapInfoXML();
        xml = String.valueOf(xml) + "<value><string>" + this.nowDediGameMode + "</string></value>";
        xml = String.valueOf(xml) + this.getServerInfoXMLMini();
        xml = String.valueOf(xml) + this.getPlayerArrayMini();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
        if (this.dediResult[result] != null) {
            this.setDediRanking(this.dediResult[result]);
        }
    }

    private void setFaultDedimania(boolean b) {
        this.svc.cdc.nowCM.dedimania[0] = "" + b;
        this.svc.svReactionThread.medal.useDedimania[0].setSelected(b);
    }

    private String getPlayerArrayTimes() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><array><data>";
        if (this.currentMapDediRank != null) {
            int fin = this.maxRank;
            if (fin > this.currentMapDediRank.length) {
                fin = this.currentMapDediRank.length;
            }
            int i = 0;
            while (i < fin) {
                if (this.currentMapDediRank[i] != null && this.currentMapDediRank[i].dediPlayer) {
                    xml = String.valueOf(xml) + "<value><struct>";
                    xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.currentMapDediRank[i].login + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Best</name><value><int>" + this.currentMapDediRank[i].fastest + "</int></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Checks</name><value><string>" + this.currentMapDediRank[i].bestcp + "</string></value></member>";
                    xml = String.valueOf(xml) + "</struct></value>";
                }
                ++i;
            }
        }
        xml = String.valueOf(xml) + "</data></array></value>";
        return xml;
    }

    private String getReplayStruct() {
        ParamsClass pc;
        String xml = "";
        String xml2 = "";
        if (this.currentMapDediRank != null && this.currentMapDediRank[0] != null && this.currentMapDediRank[0].dediPlayer && (pc = this.svc.sendMethod(true, "GetValidationReplay", this.currentMapDediRank[0].login)) != null && pc.param != null && pc.param[0].value != null && pc.param[0].value.type.equals("base64")) {
            xml2 = String.valueOf(xml2) + "<member><name>VReplay</name><value><base64>" + pc.param[0].value.value + "</base64></value></member>";
            xml2 = String.valueOf(xml2) + "<member><name>VReplayChecks</name><value><string>" + this.currentMapDediRank[0].bestcp + "</string></value></member>";
            xml2 = String.valueOf(xml2) + "<member><name>Top1GReplay</name><value><base64></base64></value></member>";
        }
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + xml2;
        xml2 = null;
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    private String arrayTimesTM1() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><array><data>";
        if (this.currentMapDediRank != null) {
            int i = 0;
            while (i < this.currentMapDediRank.length) {
                if (this.currentMapDediRank[i] != null && this.currentMapDediRank[i].dediPlayer) {
                    xml = String.valueOf(xml) + "<value><struct>";
                    xml = String.valueOf(xml) + "<member><name>Login</name><value><string>" + this.currentMapDediRank[i].login + "</string></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Best</name><value><int>" + this.currentMapDediRank[i].fastest + "</int></value></member>";
                    xml = String.valueOf(xml) + "<member><name>Checks</name><value><string>" + this.currentMapDediRank[i].bestcp + "</string></value></member>";
                    xml = String.valueOf(xml) + "</struct></value>";
                }
                ++i;
            }
        }
        xml = String.valueOf(xml) + "</data></array></value>";
        return xml;
    }

    private void endRaceTM1() {
        String mode = "" + this.retGameMode();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + this.getTM1Authencate();
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.ChallengeRaceTimes</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.uID + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.name + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.env + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.svc.nowMapInfo.author + "</string></value>";
        xml = String.valueOf(xml) + "<value><string>" + this.authGame + "</string></value>";
        xml = String.valueOf(xml) + "<value><int>" + mode + "</int></value>";
        xml = String.valueOf(xml) + "<value><int>" + this.svc.nowMapInfo.cpCount + "</int></value>";
        xml = String.valueOf(xml) + "<value><int>" + this.maxRank + "</int></value>";
        xml = String.valueOf(xml) + this.arrayTimesTM1();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    private boolean checkUpdateDedi() {
        if (this.currentMapDediRank == null) {
            return false;
        }
        int tar = this.currentMapDediRank.length;
        if (tar > this.maxRank) {
            tar = this.maxRank;
        }
        int i = 0;
        while (i < this.maxRank) {
            if (this.currentMapDediRank[i] != null && i < this.currentMapDediRank.length && this.currentMapDediRank[i].dediPlayer) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void sendChatMessage(int pl, String mes) {
        if (pl == -1) {
            this.svc.sendMethod(false, "ChatSendServerMessage", mes);
        } else {
            this.svc.sendMethod(false, "ChatSendServerMessageToId", mes, "" + this.svc.players[pl].playerID);
        }
        mes = null;
    }

    public void endRace() {
        if (this.nowDediGameMode.equals("Rounds")) {
            if (this.svc.nowMapInfo == null) {
                return;
            }
            if (this.svc.nowMapInfo.lapRace) {
                String[] deco = this.svc.cdc.nowCM.mesDecoration;
                String mes = String.valueOf(deco[0]) + "Sorry. This server is lap map's time of round mode will not be recorded on dedimania.";
                this.sendChatMessage(-1, mes);
                mes = null;
                deco = null;
                return;
            }
        }
        if (this.currentMapDediRank == null) {
            return;
        }
        if (!this.dediGetStart) {
            return;
        }
        if (!this.checkUpdateDedi()) {
            return;
        }
        if (this.svc.cdc.tmVersion == 1) {
            this.endRaceTM1();
            return;
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.SetChallengeTimes</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.sessionID + "</string></value>";
        xml = String.valueOf(xml) + this.getMapInfoXML();
        xml = String.valueOf(xml) + "<value><string>" + this.nowDediGameMode + "</string></value>";
        xml = String.valueOf(xml) + this.getPlayerArrayTimes();
        xml = String.valueOf(xml) + this.getReplayStruct();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public void getUpdateServerPlayersTM1() {
        String mode = "" + this.retGameMode();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + this.getTM1Authencate();
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.UpdateServerPlayers</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.authGame + "</string></value>";
        xml = String.valueOf(xml) + "<value><int>" + mode + "</int></value>";
        xml = String.valueOf(xml) + this.getServerInfoXMLtm1();
        xml = String.valueOf(xml) + this.getPlayerListTM1();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public void getUpdateServerPlayers() {
        if (!this.svc.inChallenge) {
            return;
        }
        if (this.svc.cdc.tmVersion == 1) {
            this.getUpdateServerPlayersTM1();
            return;
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml = String.valueOf(xml) + "<methodCall>";
        xml = String.valueOf(xml) + "<methodName>system.multicall</methodName>";
        xml = String.valueOf(xml) + "<params><param>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.UpdateServerPlayers</string></value></member>";
        xml = String.valueOf(xml) + "<member>";
        xml = String.valueOf(xml) + "<name>params</name>";
        xml = String.valueOf(xml) + "<value><array><data>";
        xml = String.valueOf(xml) + "<value><string>" + this.sessionID + "</string></value>";
        xml = String.valueOf(xml) + this.getServerInfoXMLMini();
        xml = String.valueOf(xml) + this.getVoteInfoXML();
        xml = String.valueOf(xml) + this.getPlayerArrayVote();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</member>";
        xml = String.valueOf(xml) + "</struct></value>";
        xml = String.valueOf(xml) + this.getWarningsTTR();
        xml = String.valueOf(xml) + "</data></array></value>";
        xml = String.valueOf(xml) + "</param></params>";
        xml = String.valueOf(xml) + "</methodCall>";
        int result = this.sendDedimania(xml, this.dediURL);
        xml = null;
        if (result == -1) {
            this.svc.svReactionThread.medal.useDedimania[0].setSelected(false);
            return;
        }
    }

    public String getWarningsTTR() {
        String xml = "";
        xml = String.valueOf(xml) + "<value><struct>";
        xml = String.valueOf(xml) + "<member><name>methodName</name><value><string>dedimania.WarningsAndTTR</string></value></member>";
        xml = String.valueOf(xml) + "<member><name>params</name><value><array><data></data></array></value></member>";
        xml = String.valueOf(xml) + "</struct></value>";
        return xml;
    }

    public void getStructValue1st(resXML x) {
        this.resultClear();
        if (x == null) {
            StartUp.print("Dedimania.resultXML : NULL");
            return;
        }
        if (x.param != null) {
            int i = 0;
            while (i < x.param.length) {
                this.getStructValue2nd(x.param[i]);
                ++i;
            }
        }
    }

    public void getStructValue2nd(resXML x) {
        int i;
        if (x.value != null || x.type != null || x.name != null) {
            if (x.value != null && x.name != null && x.name.equals("Error")) {
                this.error = x.value;
            }
            if (x.value != null && x.name != null && x.name.equals("SessionId")) {
                this.sessionID = x.value;
            }
        }
        if (x.chkArray) {
            i = 0;
            while (i < x.array.length) {
                this.getStructValue2nd(x.array[i]);
                ++i;
            }
        }
        if (x.chkStruct) {
            i = 0;
            while (i < x.struct.length) {
                this.getStructValue2nd(x.struct[i]);
                ++i;
            }
        }
    }

    private int sendDedimania(String xml, String target) {
        String debugResultXML;
        String resultXML;
        block18: {
            if (xml == null || target == null) {
                return -1;
            }
            if (xml.equals("") || target.equals("")) {
                return -1;
            }
            if (StartUp.testDedi) {
                return 0;
            }
            ++this.resultWritePoint;
            if (this.resultWritePoint > 999) {
                this.resultWritePoint = 0;
            }
            if (StartUp.debugDedi) {
                this.svc.printDedi("\u3010 Dedimania Sending \u3011" + this.borderBold + StartUp.tool.inputLinePartition(xml));
            }
            resultXML = "";
            debugResultXML = null;
            if (StartUp.debugDedi) {
                debugResultXML = "";
            }
            this.timeOut = false;
            this.http404 = false;
            this.http403 = false;
            try {
                URL url = new URL(target);
                char[] xmlCHR = xml.toCharArray();
                if (xmlCHR.length != -1) {
                    String inputLine;
                    HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                    urlc.setRequestMethod("POST");
                    urlc.setRequestProperty("Content-Type", "text/xml;charset=utf-8");
                    urlc.setConnectTimeout(2000);
                    urlc.setUseCaches(false);
                    urlc.setReadTimeout(8000);
                    urlc.setDoOutput(true);
                    urlc.setDoInput(true);
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(urlc.getOutputStream(), "utf-8")));
                    pw.write(xmlCHR, 0, xmlCHR.length);
                    pw.close();
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                    while ((inputLine = in.readLine()) != null) {
                        if (StartUp.debugDedi) {
                            debugResultXML = String.valueOf(debugResultXML) + inputLine;
                        }
                        resultXML = String.valueOf(resultXML) + inputLine;
                        inputLine = null;
                    }
                    in.close();
                    in = null;
                    pw = null;
                    urlc.disconnect();
                    urlc = null;
                }
                xmlCHR = null;
                url = null;
            }
            catch (MalformedURLException e) {
                System.out.println("1");
                e.printStackTrace();
                resultXML = "fault";
            }
            catch (ConnectException e) {
                System.out.println("3");
                System.out.println(e.toString());
                String err = e.toString();
                String regex = "timed.out";
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(err);
                if (m.find()) {
                    StartUp.print("Time out !");
                    this.timeOut = true;
                    resultXML = "fault";
                }
            }
            catch (IOException e) {
                System.out.println("2");
                System.out.println(e.toString());
                String err = e.toString();
                String regex = "FileNotFound";
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(err);
                if (m.find()) {
                    StartUp.print("File Not Found !");
                    this.http404 = true;
                    resultXML = "fault";
                }
                regex = null;
                p = null;
                m = null;
                regex = "HTTP.response.code.*403";
                p = Pattern.compile(regex);
                m = p.matcher(err);
                if (!m.find()) break block18;
                StartUp.print("HTTP response : 403 !");
                this.http403 = true;
                resultXML = "fault";
            }
        }
        this.dediResult[this.resultWritePoint] = null;
        this.dediResult[this.resultWritePoint] = this.xmlParser.getParams(resultXML);
        if (StartUp.debugDedi) {
            this.svc.printDedi("\u300e Dedimania Recieve \u300f" + this.borderNormal + StartUp.tool.inputLinePartition(debugResultXML));
        }
        if (this.dediResult[this.resultWritePoint] == null) {
            return -1;
        }
        if (this.chkFaultResult(this.dediResult[this.resultWritePoint])) {
            StartUp.print("Dedimania - send - result - Fault");
            return -1;
        }
        resultXML = null;
        debugResultXML = null;
        return this.resultWritePoint;
    }

    private boolean chkFaultResult(resXML rx) {
        boolean ret = false;
        if (rx == null) {
            return true;
        }
        if (rx.param == null) {
            return true;
        }
        if (rx.param[0].array != null && rx.param[0].array[0].struct != null && rx.param[0].array[0].struct[0].name != null && rx.param[0].array[0].struct[0].name.equals("faultCode")) {
            ret = true;
        }
        return ret;
    }

    public void allPlayersDBrecordShow() {
        if (this.svc.players == null) {
            return;
        }
        this.svc.records.showRecordNow();
    }

    private void setTestDediRank() {
        int d = 0;
        while (d < 10) {
            String[] temp = new String[6];
            int t = d + 1;
            temp[0] = "" + t;
            temp[1] = "test" + t;
            temp[2] = "$f00T$fffest$0ff" + t;
            temp[3] = "" + t * 20000;
            temp[4] = temp[3];
            temp[5] = "";
            this.addDediRanking(new DBranking(temp), false);
            Object var2_2 = null;
            ++d;
        }
        this.dediNowCount = 10;
        this.currentMapDediRank = this.getNewStandings();
        this.setQueue(new DBranking("ShowRanking"));
    }

    private void tickerShow() {
        if (this.svc.records != null && this.tickerBack) {
            this.svc.records.showDediTicker(this.tickerBack);
        }
        this.tickerBack = false;
    }

    @Override
    public void run() {
        this.looping = true;
        this.dispose = false;
        long beforeTime = -1L;
        while (this.looping) {
            long nowTime = System.currentTimeMillis();
            if (this.dediUse) {
                if (!this.connect) {
                    if (!this.connectingNow) {
                        if (StartUp.testDedi) {
                            this.connectDataInit();
                            this.connectingNow = false;
                            this.dediGetStart = false;
                            this.connect = true;
                            this.allPlayersDBrecordShow();
                            this.setQueue(new DBranking("getChallengeRecords"));
                        } else {
                            this.connectDataInit();
                            this.connectingNow = true;
                            this.openSession();
                            this.dediGetStart = false;
                        }
                    }
                } else {
                    long def;
                    if (beforeTime != -1L && !StartUp.testDedi && (def = nowTime - beforeTime) > 240000L) {
                        this.getUpdateServerPlayers();
                        beforeTime = System.currentTimeMillis();
                    }
                    if (this.dediQueue[this.queueReadPoint] != null) {
                        String met = this.dediQueue[this.queueReadPoint].dediThread;
                        if (met.equals("getChallengeRecords")) {
                            this.tickerBack = true;
                            this.setTickerText(null);
                            this.tickerHX = 100.0;
                            this.tickerLX = 228.0;
                            if (StartUp.testDedi) {
                                this.setTestDediRank();
                            } else {
                                if (this.svc.cdc.tmVersion == 1) {
                                    this.getCurrentChallenge();
                                } else if (this.svc.cdc.tmVersion == 2) {
                                    this.getChallengeRecords();
                                }
                                beforeTime = System.currentTimeMillis();
                            }
                            this.dediGetStart = true;
                            this.setQueue(new DBranking("ShowRanking"));
                        } else if (met.equals("addPlayerRanking")) {
                            if (this.dediGetStart && this.svc.inChallenge) {
                                this.addDediRanking(this.dediQueue[this.queueReadPoint], true);
                            }
                        } else if (met.equals("newPlayerConnect")) {
                            if (this.dediGetStart && this.svc.inChallenge) {
                                if (!this.skipConnected && !StartUp.testDedi) {
                                    this.playerConnect(this.dediQueue[this.queueReadPoint]);
                                }
                                DBranking sendTemp = new DBranking("ShowRankingOne");
                                sendTemp.login = this.dediQueue[this.queueReadPoint].login;
                                this.tickerBack = true;
                                this.setQueue(sendTemp);
                                sendTemp = null;
                            }
                        } else if (met.equals("PlayerDisConnect")) {
                            if (!this.skipConnected && !StartUp.testDedi && this.dediGetStart) {
                                this.playerDisConnect(this.dediQueue[this.queueReadPoint]);
                            }
                        } else if (met.equals("EndChallenge")) {
                            if (!StartUp.testDedi) {
                                this.endRace();
                            }
                            this.dediGetStart = false;
                        } else if (met.equals("ShowRanking")) {
                            if (this.dediGetStart) {
                                this.showDedimaniaRankingALL();
                            }
                        } else if (met.equals("ShowRankingOne") && this.dediGetStart) {
                            this.showDedimaniaRankingPersonal(this.dediQueue[this.queueReadPoint].login);
                        }
                        this.dediQueue[this.queueReadPoint] = null;
                        ++this.queueReadPoint;
                        if (this.queueReadPoint > 999) {
                            this.queueReadPoint = 0;
                        }
                    }
                }
            } else if (this.connect) {
                this.connect = false;
                this.connectingNow = false;
                this.dediGetStart = false;
                this.dediQueue = null;
                this.dediResult = null;
                this.dediQueue = new DBranking[1000];
                this.dediResult = new resXML[1000];
                int i = 0;
                while (i < 1000) {
                    this.dediQueue[i] = null;
                    this.dediResult[i] = null;
                    ++i;
                }
                this.queueWritePoint = 0;
                this.queueReadPoint = 0;
                this.resultWritePoint = 0;
                this.hideDedimaniaRankingALL();
                this.allPlayersDBrecordShow();
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.dispose) continue;
            this.looping = false;
            break;
        }
        this.xmlParser = null;
        this.finish = true;
    }
}

