/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.AutoScoreCell;
import hir.westfield.tm.AutoScoreData;
import hir.westfield.tm.AutoScoreResult;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;

public class AutoScoreThread
extends Thread {
    public AutoScoreResult scoreResult = null;
    public int[] pointArray;
    private String[] queueArray;
    private int writePoint;
    private int readPoint;
    private int counter;
    public SVCMainThread svc;
    public boolean dispose;
    public boolean showing;
    public boolean clear;
    public boolean running;
    private int nowTarget;
    public AutoScoreCell topCell;
    public int lastMax;
    public int allMax;
    public int totalMax;
    private double gamesXmore;
    private double totalXmore;
    private double gamesXomit;
    private double totalXomit;
    private double gamesCenter;

    public AutoScoreThread(SVCMainThread s) {
        int[] nArray = new int[24];
        nArray[0] = 10;
        nArray[1] = 6;
        nArray[2] = 4;
        nArray[3] = 3;
        nArray[4] = 2;
        nArray[5] = 1;
        this.pointArray = nArray;
        this.counter = -1;
        this.lastMax = -1;
        this.allMax = -1;
        this.totalMax = -1;
        this.gamesXmore = -1.0;
        this.totalXmore = -1.0;
        this.gamesXomit = -1.0;
        this.totalXomit = -1.0;
        this.gamesCenter = -1.0;
        this.svc = s;
        s = null;
        this.scoreResult = new AutoScoreResult(this);
        this.dispose = false;
        this.showing = false;
        this.clear = false;
        this.running = true;
        this.queueArray = new String[1000];
        int i = 0;
        while (i < 1000) {
            this.queueArray[i] = null;
            ++i;
        }
        this.writePoint = 0;
        this.readPoint = 0;
        this.topCell = new AutoScoreCell(this.svc, true, "", "", "", 0);
    }

    public void addQueue(String m) {
        if (!this.running) {
            return;
        }
        int tar = this.writePoint++;
        if (this.writePoint >= 1000) {
            this.writePoint = 0;
        }
        if (this.queueArray[tar] == null) {
            this.queueArray[tar] = m;
        } else {
            this.addQueue(m);
        }
        m = null;
    }

    public void clearScreen() {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = String.valueOf(xml) + "<manialink id=\"40\"></manialink>";
        xml = String.valueOf(xml) + "<manialink id=\"41\"></manialink>";
        xml = String.valueOf(xml) + "<manialink id=\"42\"></manialink>";
        xml = String.valueOf(xml) + "<manialink id=\"43\"></manialink>";
        this.svc.sendML(-1, xml, 1, false);
        xml = null;
    }

    private int addScoreArray() {
        if (this.scoreResult == null) {
            this.scoreResult = new AutoScoreResult(this);
        }
        int ret = -1;
        if (this.scoreResult.gameScore == null) {
            this.scoreResult.gameScore = new AutoScoreData[1];
            ret = 0;
        } else {
            ret = this.scoreResult.gameScore.length;
            AutoScoreData[] temp = new AutoScoreData[ret];
            System.arraycopy(this.scoreResult.gameScore, 0, temp, 0, ret);
            this.scoreResult.gameScore = null;
            this.scoreResult.gameScore = new AutoScoreData[ret + 1];
            System.arraycopy(temp, 0, this.scoreResult.gameScore, 0, ret);
        }
        this.scoreResult.gameScore[ret] = new AutoScoreData();
        return ret;
    }

    public void showBackBox(int pl) {
        if (this.svc.players == null) {
            return;
        }
        if (this.svc.players[pl] == null) {
            return;
        }
        int games = this.scoreResult.gameScore.length;
        if (games < 2) {
            this.svc.players[pl].scoreSmall = true;
        }
        if (games > 5) {
            games = 5;
        }
        boolean max = !this.svc.players[pl].scoreSmall;
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = String.valueOf(xml) + "<manialink id=\"40\">";
        if (max) {
            double xpos = (double)(games * 6 + 1 + 3 + 7) * 2.5 / 2.0;
            xml = String.valueOf(xml) + "<frame posn=\"-" + xpos + " 28.5 8\">";
            this.gamesXmore = xpos * -1.0;
            this.gamesCenter = 15.5 * (double)games / 2.0;
            xml = String.valueOf(xml) + this.svc.ml.getBoxXML(games * 6 + 1, 25.0, 0, 12);
            xpos = (double)(games * 6 + 1) * 2.5;
            xml = String.valueOf(xml) + "<frame posn=\"" + xpos + " 0 0\">";
            xml = String.valueOf(xml) + this.svc.ml.getBoxXML(3.0, 25.0, 0, 13);
            xml = String.valueOf(xml) + "</frame>";
            this.totalXmore = this.gamesXmore + ((xpos += 7.5) - 2.5);
            xml = String.valueOf(xml) + "<frame posn=\"" + xpos + " 0 0\">";
            xml = String.valueOf(xml) + this.svc.ml.getBoxXML(7.0, 25.0, 0, 14);
            xml = String.valueOf(xml) + "</frame>";
            xml = String.valueOf(xml) + "</frame>";
            if (games > 1) {
                xml = String.valueOf(xml) + "<quad posn=\"0 -27.5 8\" sizen=\"20 5\" halign=\"center\" valign=\"center\" action=\"4203\" image=\"" + this.svc.ml.image.scoreButtonOmit + "\" />";
            }
        } else {
            double xpos = 39.0;
            if (this.svc.cdc.tmVersion == 2) {
                xpos = 34.0;
            }
            xml = String.valueOf(xml) + "<frame posn=\"" + xpos + " 28.5 8\">";
            this.totalXomit = xpos;
            xml = String.valueOf(xml) + this.svc.ml.getBoxXML(8.0, 25.0, 0, 11);
            xml = String.valueOf(xml) + "</frame>";
            xml = String.valueOf(xml) + "<frame posn=\"-" + (xpos + 20.0) + " 28.5 8\">";
            this.gamesXomit = (xpos + 20.0) * -1.0;
            xml = String.valueOf(xml) + this.svc.ml.getBoxXML(8.0, 25.0, 0, 11);
            xml = String.valueOf(xml) + "</frame>";
            if (games > 1) {
                xml = String.valueOf(xml) + "<quad posn=\"0 -27.5 8\" sizen=\"20 5\" halign=\"center\" valign=\"center\" action=\"4204\" image=\"" + this.svc.ml.image.scoreButtonMore + "\" />";
            }
        }
        xml = String.valueOf(xml) + "</manialink>";
        xml = String.valueOf(xml) + "<manialink id=\"41\"></manialink>";
        xml = String.valueOf(xml) + "<manialink id=\"42\"></manialink>";
        this.svc.sendML(pl, xml, 0, false);
        xml = null;
    }

    public void showGamesScores(int pl) {
        double center;
        if (this.svc.players == null) {
            return;
        }
        if (this.svc.players[pl] == null) {
            return;
        }
        double xpos = this.svc.players[pl].scoreSmall ? this.gamesXomit : this.gamesXmore;
        boolean max = !this.svc.players[pl].scoreSmall;
        int columnTar = this.svc.players[pl].gamesScoreStart;
        int gameMax = this.scoreResult.gameScore.length;
        int gameMin = this.svc.players[pl].gamesRoundStart;
        if (!max) {
            gameMin = gameMax - 1;
        }
        if (gameMin < 0) {
            gameMin = 0;
        }
        if (gameMax - 5 > gameMin) {
            gameMax = gameMin + 5;
        }
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = String.valueOf(xml) + "<manialink id=\"41\">";
        if (gameMin > 0 && max) {
            xml = String.valueOf(xml) + "<quad posn=\"" + xpos + " 0 10\" sizen=\"3 4.5\" halign=\"center\" valign=\"center\" action=\"4205\" image=\"" + this.svc.ml.image.scoreButtonOlder + "\" />";
        }
        int t = gameMin;
        while (t < gameMax) {
            xml = String.valueOf(xml) + "<frame posn=\"" + xpos + " 28.5 9\">";
            double ypos = -2.5;
            xml = String.valueOf(xml) + "<frame posn=\"2.5 " + ypos + " 0\">";
            xml = String.valueOf(xml) + this.scoreResult.gameScore[t].headXML;
            xml = String.valueOf(xml) + "</frame>";
            ypos -= 3.5;
            if (this.scoreResult.gameScore[t].playersScore != null) {
                int i = columnTar;
                while (i < columnTar + 8) {
                    ypos -= 5.0;
                    if (i < this.scoreResult.gameScore[t].playersScore.length) {
                        xml = String.valueOf(xml) + "<frame posn=\"2.5 " + ypos + " 0\">";
                        xml = String.valueOf(xml) + this.scoreResult.gameScore[t].playersScore[i].retGameScoreXML(this.svc, i);
                    }
                    ++i;
                }
            } else {
                xml = String.valueOf(xml) + "<frame posn=\"2.5 " + (ypos -= 5.0) + " 0\">";
                xml = String.valueOf(xml) + "<quad posn=\"0 0 2\" sizen=\"15 5\" halign=\"left\" valign=\"top\" image=\"" + this.svc.ml.image.scoreEvenBack + "\" />";
                String nick = "No contest.";
                double size = 10.0;
                double dif = 0.0;
                double scale = 0.0;
                if (this.svc.cdc.tmVersion == 1) {
                    dif = 0.1;
                    scale = 0.95;
                    size = 10.0;
                } else {
                    dif = 0.1;
                    scale = 1.0;
                    size = 9.0;
                }
                xml = String.valueOf(xml) + "<label posn=\"" + (7.5 + dif) + " " + (-4.25 - dif) + " 3\" scale=\"" + scale + "\" sizen=\"" + size + " 2\" halign=\"center\" valign=\"bottom\" style=\"TextInfoSmall\" text=\"$z$555" + StartUp.tool.getGrayColorText(nick) + "\" />";
                xml = String.valueOf(xml) + "<label posn=\"7.5 -4.25 4\" scale=\"" + scale + "\" sizen=\"" + size + " 2\" halign=\"center\" valign=\"bottom\" style=\"TextInfoSmall\" text=\"$z$fff" + nick + "\" />";
                xml = String.valueOf(xml) + "</frame>";
            }
            xml = String.valueOf(xml) + "</frame>";
            xpos += 15.5;
            ++t;
        }
        if (gameMax < this.scoreResult.gameScore.length && max) {
            xml = String.valueOf(xml) + "<quad posn=\"" + (xpos + 4.0) + " 0 10\" sizen=\"3 4.5\" halign=\"center\" valign=\"center\" action=\"4206\" image=\"" + this.svc.ml.image.scoreButtonNewer + "\" />";
        }
        if (this.svc.players[pl].scoreSmall) {
            xpos = this.gamesXomit;
            center = 7.5;
        } else {
            xpos = this.gamesXmore;
            center = this.gamesCenter;
        }
        xml = String.valueOf(xml) + "<frame posn=\"" + xpos + " 28.5 9\">";
        if (columnTar > 0) {
            xml = String.valueOf(xml) + "<quad posn=\"" + (center + 2.5) + " -1.5 10\" sizen=\"4 2\" halign=\"center\" valign=\"center\" action=\"4201\" image=\"" + this.svc.ml.image.scoreUpArrow + "\" />";
        }
        if (columnTar + 8 < this.lastMax) {
            xml = String.valueOf(xml) + "<quad posn=\"" + (center + 2.5) + " -52 10\" sizen=\"4 2\" halign=\"center\" valign=\"center\" action=\"4202\" image=\"" + this.svc.ml.image.scoreDownArrow + "\" />";
        }
        xml = String.valueOf(xml) + "</frame>";
        xml = String.valueOf(xml) + "</manialink>";
        this.svc.sendML(pl, xml, 0, false);
        xml = null;
    }

    public void showTotalScores(int pl) {
        if (this.svc.players == null) {
            return;
        }
        if (this.svc.players[pl] == null) {
            return;
        }
        double xpos = this.svc.players[pl].scoreSmall ? this.totalXomit : this.totalXmore;
        int columnTar = this.svc.players[pl].totalScoreStart;
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = String.valueOf(xml) + "<manialink id=\"42\">";
        xml = String.valueOf(xml) + "<frame posn=\"" + xpos + " 28.5 9\">";
        double ypos = -2.5;
        double font = 0.6;
        if (this.svc.cdc.tmVersion == 2) {
            font = 0.7;
        }
        xml = String.valueOf(xml) + "<frame posn=\"2.5 " + ypos + " 0\">";
        xml = String.valueOf(xml) + "<quad posn=\"0 0 1\" sizen=\"15 8.5\" halign=\"left\" valign=\"top\" bgcolor=\"fff3\" />";
        xml = String.valueOf(xml) + "<quad posn=\"0 0 2\" sizen=\"15 8.5\" halign=\"left\" valign=\"top\" image=\"" + this.svc.ml.image.scoreTitleBack + "\" />";
        xml = String.valueOf(xml) + "<label posn=\"7.5 -1 4\" scale=\"" + (font - 0.05) + "\" halign=\"center\" valign=\"center\" style=\"TextCredits\" text=\"" + this.scoreResult.totalScore.mapAuthor + "\" />";
        xml = String.valueOf(xml) + this.scoreResult.totalScore.getTitleText(this.scoreResult.totalScore.mapName);
        xml = String.valueOf(xml) + "<label posn=\"7.5 -7.3 5\" sizen=\"15\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$8ff" + this.scoreResult.totalScore.gameMode + "\" />";
        xml = String.valueOf(xml) + "</frame>";
        ypos -= 3.5;
        if (this.scoreResult.totalScore.playersScore != null) {
            int i = columnTar;
            while (i < columnTar + 8) {
                ypos -= 5.0;
                if (i < this.scoreResult.totalScore.playersScore.length) {
                    xml = String.valueOf(xml) + "<frame posn=\"2.5 " + ypos + " 0\">";
                    xml = String.valueOf(xml) + this.scoreResult.totalScore.playersScore[i].retTotalScoreXML(this.svc, i);
                }
                ++i;
            }
        }
        if (columnTar > 0) {
            xml = String.valueOf(xml) + "<quad posn=\"10 -1.5 10\" sizen=\"4 2\" halign=\"center\" valign=\"center\" action=\"4211\" image=\"" + this.svc.ml.image.scoreUpArrow + "\" />";
        }
        if (columnTar + 8 < this.lastMax) {
            xml = String.valueOf(xml) + "<quad posn=\"10 -52 10\" sizen=\"4 2\" halign=\"center\" valign=\"center\" action=\"4212\" image=\"" + this.svc.ml.image.scoreDownArrow + "\" />";
        }
        xml = String.valueOf(xml) + "</frame>";
        xml = String.valueOf(xml) + "</manialink>";
        this.svc.sendML(pl, xml, 0, false);
        xml = null;
    }

    @Override
    public void run() {
        StartUp.printDEBUG("[AutoScoreThread] - run start");
        while (!this.dispose) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.clear) {
                if (this.queueArray[this.readPoint] != null) {
                    this.queueArray[this.readPoint] = null;
                    ++this.readPoint;
                    if (this.readPoint >= 1000) {
                        this.readPoint = 0;
                    }
                }
                this.showing = false;
                this.counter = -1;
                this.clearScreen();
                this.clear = false;
            }
            if (this.queueArray[this.readPoint] != null) {
                if (!this.svc.inWarmUp && StartUp.tool.getBoolean(StartUp.cdc.nowCM.mlAutoScoreShow[0])) {
                    this.counter = 0;
                    this.nowTarget = this.addScoreArray();
                    this.scoreResult.gameScore[this.nowTarget].mapName = this.svc.nowMapInfo.name;
                    this.scoreResult.gameScore[this.nowTarget].mapAuthor = this.svc.nowMapInfo.author;
                    this.scoreResult.gameScore[this.nowTarget].gameMode = StartUp.tool.getNowModeString(this.svc);
                    this.scoreResult.gameScore[this.nowTarget].setHeaderXMLGames(this.nowTarget, this.svc);
                    this.scoreResult.gameScore[this.nowTarget].setOrder(this.svc);
                    this.scoreResult.setTotalScore();
                    this.scoreResult.scoreResultSave();
                    this.svc.svASThread.addQueue(null, "ShowCells");
                    this.showing = true;
                    this.lastMax = 0;
                    if (this.scoreResult.gameScore[this.nowTarget].playersScore != null) {
                        this.lastMax = this.scoreResult.gameScore[this.nowTarget].playersScore.length;
                    }
                    this.allMax = 0;
                    int i = 0;
                    while (i < this.scoreResult.gameScore.length) {
                        if (this.scoreResult.gameScore[i].playersScore != null && this.allMax < this.scoreResult.gameScore[i].playersScore.length) {
                            this.allMax = this.scoreResult.gameScore[i].playersScore.length;
                        }
                        ++i;
                    }
                    this.totalMax = 0;
                    if (this.scoreResult.totalScore.playersScore != null) {
                        this.totalMax = this.scoreResult.totalScore.playersScore.length;
                    }
                }
                this.queueArray[this.readPoint] = null;
                ++this.readPoint;
                if (this.readPoint >= 1000) {
                    this.readPoint = 0;
                }
            }
            if (this.counter > -1) {
                ++this.counter;
                if (this.counter > 3600000) {
                    this.counter = -1;
                }
            }
            if (!StartUp.tool.getBoolean(StartUp.cdc.nowCM.mlAutoScoreShow[3]) || !this.showing || this.counter <= 2499) continue;
            this.showing = false;
            if (this.svc.players == null) continue;
            int pl = 0;
            while (pl < this.svc.players.length) {
                this.svc.players[pl].gamesScoreStart = 0;
                this.svc.players[pl].totalScoreStart = 0;
                this.svc.players[pl].gamesRoundStart = this.scoreResult.gameScore.length - 5;
                if (this.svc.players[pl].gamesRoundStart < 0) {
                    this.svc.players[pl].gamesRoundStart = 0;
                }
                this.showBackBox(pl);
                this.showGamesScores(pl);
                this.showTotalScores(pl);
                ++pl;
            }
        }
    }
}

