/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.ASPlayerScore;
import hir.westfield.tm.AutoScoreCell;
import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;

public class AutoScoreData {
    public ASPlayerScore[] playersScore = null;
    public String mapName = null;
    public String mapAuthor = null;
    public String gameMode = null;
    public boolean noContest = false;
    public AutoScoreCell cell = null;
    public String headXML;

    public AutoScoreData() {
    }

    public AutoScoreData(AutoScoreData src) {
        if (src != null) {
            if (src.mapName != null) {
                this.mapName = src.mapName;
            }
            if (src.mapAuthor != null) {
                this.mapAuthor = src.mapAuthor;
            }
            if (src.gameMode != null) {
                this.gameMode = src.gameMode;
            }
            this.noContest = src.noContest;
            if (src.playersScore != null) {
                this.playersScore = new ASPlayerScore[src.playersScore.length];
                System.arraycopy(src.playersScore, 0, this.playersScore, 0, src.playersScore.length);
            }
            this.cell = new AutoScoreCell(src.cell);
            this.headXML = src.headXML;
        }
        src = null;
    }

    public void setOrder(SVCMainThread svc) {
        this.playersScore = null;
        this.noContest = true;
        if (svc.players != null) {
            this.playersScore = new ASPlayerScore[svc.players.length];
            int[] temp = svc.getNowOrders();
            int i = 0;
            while (i < this.playersScore.length) {
                if (i < temp.length) {
                    this.playersScore[i] = new ASPlayerScore(svc, temp[i], this.gameMode);
                    this.playersScore[i].mapAuthor = this.playersScore[i].login.equals(this.mapAuthor);
                    if (this.gameMode.equals("Rounds")) {
                        this.playersScore[i].lowerText = "Round points:" + this.playersScore[i].roundPT;
                        if (this.playersScore[i].roundPT > 0) {
                            this.playersScore[i].rank = i + 1;
                            if (i < svc.asThread.pointArray.length) {
                                this.playersScore[i].point = svc.asThread.pointArray[i];
                            }
                        } else {
                            this.playersScore[i].rank = 0;
                        }
                    } else if (this.gameMode.equals("TimeAttack")) {
                        this.playersScore[i].rank = 0;
                        if (this.playersScore[i].time > 0) {
                            this.playersScore[i].rank = i + 1;
                            if (i < svc.asThread.pointArray.length) {
                                this.playersScore[i].point = svc.asThread.pointArray[i];
                            }
                            this.playersScore[i].lowerText = StartUp.tool.getTimeText(this.playersScore[i].time, true);
                        } else {
                            this.playersScore[i].lowerText = "Checkpoint passed:" + (svc.players[temp[i]].clearMaxCP + 1);
                        }
                    } else if (this.gameMode.equals("Team")) {
                        this.playersScore[i].lowerText = "Round points:" + this.playersScore[i].roundPT;
                        if (this.playersScore[i].roundPT > 0) {
                            this.playersScore[i].rank = i + 1;
                            if (i < svc.asThread.pointArray.length) {
                                this.playersScore[i].point = svc.asThread.pointArray[i];
                            }
                        } else {
                            this.playersScore[i].rank = 0;
                        }
                    } else if (this.gameMode.equals("Laps") || this.gameMode.equals("LapEX")) {
                        this.playersScore[i].rank = 0;
                        this.playersScore[i].lowerText = "Lap:" + (this.playersScore[i].lap - 1) + "   Checkpoint:" + (this.playersScore[i].maxCP + 1);
                        if (this.playersScore[i].maxCP > 0) {
                            this.playersScore[i].rank = i + 1;
                            if (i < svc.asThread.pointArray.length) {
                                this.playersScore[i].point = svc.asThread.pointArray[i];
                            }
                            if (this.playersScore[i].time > 0) {
                                this.playersScore[i].lowerText = StartUp.tool.getTimeText(this.playersScore[i].time, true);
                            }
                        }
                    } else if (!this.gameMode.equals("Stunts")) {
                        this.gameMode.equals("Cup");
                    }
                    if (this.playersScore[i].rank != 0) {
                        this.noContest = false;
                    }
                    if (StartUp.tool.getBoolean(StartUp.cdc.nowCM.mlAutoScoreShow[1]) && this.playersScore[i].mapAuthor) {
                        this.playersScore[i].point = 0;
                    }
                }
                ++i;
            }
            temp = null;
        }
        if (this.noContest || this.playersScore == null) {
            int p = 0;
            if (this.playersScore != null) {
                p = this.playersScore.length;
            }
            this.cell = new AutoScoreCell(svc, false, this.mapName, this.mapAuthor, "No winner.", p);
        } else {
            this.cell = new AutoScoreCell(svc, false, this.mapName, this.mapAuthor, this.playersScore[0].nickName, this.playersScore.length);
        }
    }

    public void setHeaderXMLGames(int no, SVCMainThread svc) {
        String mode = "$i$ff0" + StartUp.tool.getPlaceString(no + 1) + " Game   $i- " + this.gameMode + " -";
        String title = "$z$fff" + this.mapName;
        title = title.replaceAll("\"", "\u201d");
        title = title.replaceAll("'", "\u2019");
        String author = "Author:" + this.mapAuthor;
        double font = 0.6;
        if (svc.cdc.tmVersion == 2) {
            font = 0.7;
        }
        this.headXML = "";
        this.headXML = String.valueOf(this.headXML) + "<quad posn=\"0 0 1\" sizen=\"15 8.5\" halign=\"left\" valign=\"top\" bgcolor=\"fff3\" />";
        this.headXML = String.valueOf(this.headXML) + "<quad posn=\"0 0 2\" sizen=\"15 8.5\" halign=\"left\" valign=\"top\" image=\"" + svc.ml.image.scoreTitleBack + "\" />";
        this.headXML = String.valueOf(this.headXML) + "<label posn=\"7.5 -1 4\" scale=\"" + (font - 0.05) + "\" halign=\"center\" valign=\"center\" style=\"TextCredits\" text=\"" + mode + "\" />";
        this.headXML = String.valueOf(this.headXML) + this.getTitleText(title);
        this.headXML = String.valueOf(this.headXML) + "<label posn=\"7.55 -7.35 4\" sizen=\"15\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$444" + author + "\" />";
        this.headXML = String.valueOf(this.headXML) + "<label posn=\"7.5 -7.3 5\" sizen=\"15\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$8ff" + author + "\" />";
    }

    public String getTitleText(String title) {
        String ret = "";
        int chkS = StartUp.tool.returnStringCount(title);
        double dif = 0.0;
        double scale = 0.0;
        double size = 0.0;
        if (chkS < 27) {
            dif = 0.1;
            scale = 1.0;
            size = 14.0;
        } else if (chkS < 32) {
            dif = 0.085;
            scale = 0.9;
            size = 16.0;
        } else if (chkS < 36) {
            dif = 0.07;
            scale = 0.8;
            size = 18.0;
        } else {
            dif = 0.055;
            scale = 0.7;
            size = 21.0;
        }
        ret = String.valueOf(ret) + "<label posn=\"" + (7.5 + dif) + " " + (-4.0 - dif) + " 4\" scale=\"" + scale + "\" sizen=\"" + size + " 2.75\" halign=\"center\" valign=\"center\" style=\"TextCredits\" text=\"" + StartUp.tool.getGrayColorText(title) + "\" />";
        ret = String.valueOf(ret) + "<label posn=\"7.5 -4 5\" scale=\"" + scale + "\" sizen=\"" + size + " 2.75\" halign=\"center\" valign=\"center\" style=\"TextCredits\" text=\"" + title + "\" />";
        title = null;
        return ret;
    }
}

