/*
 * Decompiled with CFR 0.152.
 */
package hir.westfield.tm;

import hir.westfield.tm.SVCMainThread;
import hir.westfield.tm.StartUp;

public class ASPlayerScore {
    public String login;
    public String nickName;
    public int rank;
    public int time;
    public int roundPT;
    public int teamID;
    public int lap;
    public int point;
    public int won;
    public int maxCP;
    public int maxCPtime;
    public int finished;
    public int exPoints;
    public int exTeam;
    public boolean mapAuthor = false;
    public boolean giveupMapAuthor = false;
    public String lowerText;
    public String gameMode;

    public ASPlayerScore() {
        this.login = "";
        this.nickName = "";
        this.rank = 0;
        this.time = 0;
        this.roundPT = 0;
        this.lap = 0;
        this.point = 0;
        this.won = 0;
        this.teamID = -1;
        this.mapAuthor = false;
        this.giveupMapAuthor = false;
        this.maxCP = -1;
        this.maxCPtime = -1;
        this.finished = -1;
        this.exPoints = -1;
        this.exTeam = -1;
        this.lowerText = "";
        this.gameMode = "";
    }

    public ASPlayerScore(SVCMainThread svc, int pl, String game) {
        boolean b = false;
        if (svc.players != null && svc.players.length > pl && pl >= 0 && svc.players[pl] != null) {
            b = true;
        }
        this.login = "";
        if (b) {
            this.login = svc.players[pl].login;
        }
        this.nickName = "";
        if (b) {
            this.nickName = svc.players[pl].nickName;
        }
        this.rank = 0;
        this.time = 0;
        if (b) {
            this.time = svc.players[pl].nowFinishTime;
        }
        this.roundPT = 0;
        if (b) {
            this.roundPT = svc.players[pl].roundPoints;
        }
        if (b && svc.players[pl].teamTotalPoints > 0) {
            this.roundPT = svc.players[pl].teamTotalPoints;
        }
        this.lap = 0;
        if (b) {
            this.lap = svc.players[pl].nowLap;
        }
        this.point = 0;
        this.won = 0;
        this.teamID = -1;
        if (b) {
            this.teamID = svc.players[pl].teamID;
        }
        this.maxCP = -1;
        if (b) {
            this.maxCP = svc.players[pl].clearMaxCP;
        }
        this.maxCPtime = -1;
        if (b) {
            this.maxCPtime = svc.players[pl].clearMaxCPtime;
        }
        this.finished = -1;
        if (b) {
            this.finished = svc.players[pl].finishCount;
        }
        this.exPoints = -1;
        this.exTeam = -1;
        this.mapAuthor = false;
        this.giveupMapAuthor = false;
        this.lowerText = "";
        this.gameMode = game;
    }

    public ASPlayerScore(ASPlayerScore asp) {
        this.login = asp.login;
        this.nickName = asp.nickName;
        this.rank = 0;
        this.time = 0;
        this.roundPT = 0;
        this.lap = asp.lap;
        this.point = asp.point;
        this.won = asp.won;
        this.teamID = asp.teamID;
        this.mapAuthor = false;
        this.giveupMapAuthor = false;
        this.finished = asp.finished;
        this.maxCP = asp.maxCP;
        this.maxCPtime = asp.maxCPtime;
        this.exPoints = -1;
        this.exTeam = -1;
        this.lowerText = "";
        this.gameMode = "";
    }

    public String retGameScoreXML(SVCMainThread svc, int no) {
        String xml = "";
        String img = "";
        img = no % 2 == 0 ? svc.ml.image.scoreEvenBack : svc.ml.image.scoreOddBack;
        if (this.point > 0) {
            if (no == 0) {
                img = svc.ml.image.score1stBack;
            } else if (no == 1) {
                img = svc.ml.image.score2ndBack;
            } else if (no == 2) {
                img = svc.ml.image.score3rdBack;
            }
        }
        if (this.mapAuthor && StartUp.tool.getBoolean(StartUp.cdc.nowCM.mlAutoScoreShow[1])) {
            img = svc.ml.image.scoreAuthorBack;
        }
        xml = String.valueOf(xml) + "<quad posn=\"0 0 2\" sizen=\"15 5\" halign=\"left\" valign=\"top\" image=\"" + img + "\" />";
        double font = svc.cdc.tmVersion == 1 ? 0.7 : 0.8;
        xml = String.valueOf(xml) + "<label posn=\"1.39 -2.59 3\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$555" + StartUp.tool.getPlaceStringZERO(this.rank) + "\" />";
        xml = String.valueOf(xml) + "<label posn=\"1.3 -2.5 4\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$fff" + StartUp.tool.getPlaceStringZERO(this.rank) + "\"/>";
        font = svc.cdc.tmVersion == 1 ? 0.7 : 0.8;
        xml = String.valueOf(xml) + "<label posn=\"13.79 -2.59 3\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$555" + this.point + "pt\" />";
        xml = String.valueOf(xml) + "<label posn=\"13.7 -2.5 4\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$fff" + this.point + "pt\" />";
        xml = String.valueOf(xml) + this.retNickText(this.nickName, svc);
        if (this.gameMode.equals("Rounds")) {
            xml = String.valueOf(xml) + "<label posn=\"7.54 -3.94 3\" scale=\"0.6\" sizen=\"21 2\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$aaa" + this.lowerText + "\"/>";
            xml = String.valueOf(xml) + "<label posn=\"7.5 -3.9 4\" scale=\"0.6\" sizen=\"21 2\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$000" + this.lowerText + "\"/>";
        } else if (this.gameMode.equals("TimeAttack") || this.gameMode.equals("Laps") || this.gameMode.equals("LapEX")) {
            if (this.time > 0) {
                double sc = 0.37;
                if (svc.cdc.tmVersion == 1) {
                    sc = 0.325;
                }
                xml = String.valueOf(xml) + "<label posn=\"7.5 -4 3\" scale=\"" + sc + "\" halign=\"center\" valign=\"center\" style=\"TextRaceChrono\" text=\"" + svc.cdc.nowCM.mesDecoration[2] + this.lowerText + "\"/>";
            } else {
                xml = String.valueOf(xml) + "<label posn=\"7.6 -4 3\" scale=\"0.6\" sizen=\"21 2\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$444" + this.lowerText + "\"/>";
                xml = String.valueOf(xml) + "<label posn=\"7.5 -3.9 4\" scale=\"0.6\" sizen=\"21 2\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$f99" + this.lowerText + "\"/>";
            }
        } else if (this.gameMode.equals("Team")) {
            xml = String.valueOf(xml) + "<label posn=\"7.54 -3.94 4\" scale=\"0.6\" sizen=\"21 2\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$ccc" + this.lowerText + "\"/>";
            xml = String.valueOf(xml) + "<label posn=\"7.5 -3.9 5\" scale=\"0.6\" sizen=\"21 2\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$000" + this.lowerText + "\"/>";
            if (this.teamID > -1) {
                String col = this.teamID == 0 ? "88fc" : "f88c";
                xml = String.valueOf(xml) + "<quad posn=\"7.5 -4.2 3\" sizen=\"9.2 0.5\" halign=\"center\" valign=\"top\" bgcolor=\"" + col + "\" />";
            }
        } else if (!this.gameMode.equals("Stunts")) {
            this.gameMode.equals("Cup");
        }
        xml = String.valueOf(xml) + "</frame>";
        img = null;
        return xml;
    }

    public String retTotalScoreXML(SVCMainThread svc, int no) {
        String xml = "";
        String img = "";
        img = no % 2 == 0 ? svc.ml.image.scoreEvenBack : svc.ml.image.scoreOddBack;
        if (no == 0) {
            img = svc.ml.image.score1stBack;
        } else if (no == 1) {
            img = svc.ml.image.score2ndBack;
        } else if (no == 2) {
            img = svc.ml.image.score3rdBack;
        }
        xml = String.valueOf(xml) + "<quad posn=\"0 0 2\" sizen=\"15 5\" halign=\"left\" valign=\"top\" image=\"" + img + "\" />";
        double font = svc.cdc.tmVersion == 1 ? 0.7 : 0.8;
        xml = String.valueOf(xml) + "<label posn=\"1.39 -2.59 3\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$555" + StartUp.tool.getPlaceStringZERO(this.rank) + "\" />";
        xml = String.valueOf(xml) + "<label posn=\"1.3 -2.5 4\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$fff" + StartUp.tool.getPlaceStringZERO(this.rank) + "\"/>";
        font = svc.cdc.tmVersion == 1 ? 0.7 : 0.8;
        xml = String.valueOf(xml) + "<label posn=\"13.79 -2.59 3\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$555" + this.point + "pt\" />";
        xml = String.valueOf(xml) + "<label posn=\"13.7 -2.5 4\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$fff" + this.point + "pt\" />";
        String nick = this.nickName;
        nick = nick.replaceAll("\"", "\u201d");
        xml = String.valueOf(xml) + this.retNickText(nick, svc);
        nick = null;
        if (this.won > 0) {
            font = svc.cdc.tmVersion == 1 ? 0.6 : 0.7;
            xml = String.valueOf(xml) + "<label posn=\"7.55 -3.90 3\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$333Won " + this.won + " games\"/>";
            xml = String.valueOf(xml) + "<label posn=\"7.5 -3.85 4\" scale=\"" + font + "\" halign=\"center\" valign=\"center\" style=\"TextInfoSmall\" text=\"$fffWon " + this.won + " games\"/>";
        }
        xml = String.valueOf(xml) + "</frame>";
        img = null;
        return xml;
    }

    private String retNickText(String nick, SVCMainThread svc) {
        if (nick == null) {
            return "";
        }
        nick = nick.replaceAll("\"", "\u201d");
        String ret = "";
        int chkS = StartUp.tool.returnStringCount(nick);
        double size = 10.0;
        double dif = 0.0;
        double scale = 0.0;
        if (svc.cdc.tmVersion == 1) {
            if (chkS < 22) {
                dif = 0.1;
                scale = 0.95;
                size = 10.0;
            } else if (chkS < 24) {
                dif = 0.09;
                scale = 0.85;
                size = 11.0;
            } else if (chkS < 26) {
                dif = 0.08;
                scale = 0.8;
                size = 11.5;
            } else if (chkS < 28) {
                dif = 0.07;
                scale = 0.75;
                size = 12.5;
            } else if (chkS < 30) {
                dif = 0.06;
                scale = 0.7;
                size = 13.5;
            } else if (chkS < 32) {
                dif = 0.05;
                scale = 0.65;
                size = 14.5;
            } else if (chkS < 34) {
                dif = 0.04;
                scale = 0.6;
                size = 15.5;
            } else if (chkS < 36) {
                dif = 0.03;
                scale = 0.55;
                size = 17.0;
            } else {
                dif = 0.02;
                scale = 0.6;
                size = 19.0;
            }
        } else if (chkS < 22) {
            dif = 0.1;
            scale = 1.0;
            size = 9.0;
        } else if (chkS < 24) {
            dif = 0.09;
            scale = 0.95;
            size = 9.5;
        } else if (chkS < 26) {
            dif = 0.08;
            scale = 0.9;
            size = 10.5;
        } else if (chkS < 28) {
            dif = 0.07;
            scale = 0.85;
            size = 11.5;
        } else if (chkS < 30) {
            dif = 0.06;
            scale = 0.8;
            size = 12.0;
        } else if (chkS < 32) {
            dif = 0.05;
            scale = 0.75;
            size = 13.0;
        } else if (chkS < 34) {
            dif = 0.04;
            scale = 0.7;
            size = 14.0;
        } else if (chkS < 36) {
            dif = 0.03;
            scale = 0.65;
            size = 15.0;
        } else {
            dif = 0.02;
            scale = 0.6;
            size = 16.0;
        }
        ret = String.valueOf(ret) + "<label posn=\"" + (7.5 + dif) + " " + (-3.25 - dif) + " 3\" scale=\"" + scale + "\" sizen=\"" + size + " 2\" halign=\"center\" valign=\"bottom\" style=\"TextInfoSmall\" text=\"$z$555" + StartUp.tool.getGrayColorText(nick) + "\" />";
        ret = String.valueOf(ret) + "<label posn=\"7.5 -3.25 4\" scale=\"" + scale + "\" sizen=\"" + size + " 2\" halign=\"center\" valign=\"bottom\" style=\"TextInfoSmall\" text=\"$z$fff" + nick + "\" />";
        return ret;
    }
}

