#
# st2ch_mod
#   ver.  0.4.4
#
# 2ch.net log viewer for Python/S60
#


import appuifw
import socket
import urllib
import httplib
import e32
import os
import stat
from graphics import *
from key_codes import *
import sys
sys.path.append('e:\\resource')
import japanese
import gzip
from cStringIO import StringIO
import re

sys.setdefaultencoding('shift_jis')

JOGAI=["www.monazilla.org","irc.2ch.net","find.2ch.net","epg.2ch.net"]
UA='Monazilla/1.00 (st2ch/0.42)'

class st2ch:
    
    def __init__(self):
        self.status=1
        self.BKstat=0
        self.viewing=1
        self.BKcurNo=0
        self.BKstaNo=0
        self.TXcurNo=0
        self.TXstaNo=0
        self.BDcurNo=0
        self.BDstaNo=0
        self.BDlastNo=[]
        self.SBcurNo=0
        self.SBstaNo=0
        self.SBlastNo=0
        self.BDexp=-1
        self.curNo=0
        self.lastNo=0
        self.lastBFNo=-1
        self.staSLNo=0
        self.staLNNo=0
        self.botSLNo=0
        self.botLNNo=0
        self.datMod=0
        self.titleData=""
        self.scrData = [["" for tmpA in range(1)] for tmpB in range(1)]
        self.script_lock = e32.Ao_lock()
        self.boardData = []
        self.subData = []
        self.bookData = []
        self.putData = []
        self.menu_exit = (unicode("Exit"), self.do_exit)
        self.menu_board = (unicode("Board"), self.state1)
        self.menu_subject = (unicode("Subject"), self.state3)
        self.menu_book = (unicode("Bookmark"), self.state4)
        self.menu_adbook = (unicode("Add Bookmark"), self.addbook)
        self.menu_delbook = (unicode("Delete Bookmark"), self.delbook)
        self.menu_subupd = (unicode("Update"), self.subupdate)
        self.menu_boardupd = (unicode("Update"), self.boardupdate)
        self.menu_datupd = (unicode("Update"), self.datupdate)
        self.menu_junkai = (unicode("All Update"), self.junkai)
        self.menu_find = (unicode("Find"), self.findtext)
        self.menu_fdel = (unicode("Delete File"), self.filedel)
        self.menu_jump = (unicode("Jump"), self.jumpnum)
        self.menu_srvmove = (unicode("Server Move"), self.servermove)
        self.menu_serchurl = (unicode("URL open(Auto)"), self.serchurl)
        self.menu_serchcont = (unicode("Data open(Auto)"), self.serchcont)
        self.menu_openurl = (unicode("URL open(Edit)"), self.openurl)
        self.menu_google = (unicode("Serch Google(Edit)"), self.google)
        self.menu_postcom = (unicode("Post Comment"), self.postdata)
        
        #for Customize
        self.MOJI1=62
        self.GYOU1=18
        self.HABA1=11
        self.BKITA1=250
        self.NAME1=1
        self.k_left1=EKeyLeftArrow
        self.k_right1=EKeyRightArrow
        self.k_up1=EKeyUpArrow
        self.k_down1=EKeyDownArrow
        self.k_state1=EKeySelect
        self.k_enter1=EKeyEnter     #*01
        self.k_oup1=EKey2
        self.k_odown1=EKey5
        self.k_rot1=EKeyStar
        self.MOJI2=62
        self.GYOU2=18
        self.HABA2=11
        self.BKITA2=250
        self.NAME2=1
        self.k_left2=EKeyLeftArrow
        self.k_right2=EKeyRightArrow
        self.k_up2=EKeyUpArrow
        self.k_down2=EKeyDownArrow
        self.k_state2=EKeySelect
        self.k_enter2=EKeyEnter     #*01
        self.k_oup2=EKey2
        self.k_odown2=EKey5
        self.k_rot2=EKeyStar
        self.path2ch = "e:\\documents\\_2ch\\"
        self.pathtmp = "d:\\"
#        self.FONT=unicode("JapanPlain16") #*01
        self.FONT=(u"heisei Kaku gothic S60", 18, FONT_BOLD|FONT_ANTIALIAS) #*01
        self.COOKIE1=unicode("suka")
        self.COOKIE2=unicode("pontan")
        self.MOJI=62
        self.GYOU=18
        self.HABA=11
        self.BKITA=250
        self.NAME=1

        self.B_HABA = 85 #*0.4.3 masa, Board Title Width 


    def postdata(self):
        if self.BKstat==1:
            subpath1=self.bookData[self.BKstaNo+self.BKcurNo][0]
            subpath2=self.bookData[self.BKstaNo+self.BKcurNo][1]
            datname=self.bookData[self.BKstaNo+self.BKcurNo][2].split(".")
        elif self.BKstat==0:
            subpath1=self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]
            subpath2=self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]
            datname=self.subData[self.TXstaNo+self.TXcurNo][0].split(".")
        
        if subpath1.find(unicode("machi.to"))>=0:
            appuifw.note(unicode("Not support![Machi BBS]"), "error")
            return
        
        tmp=appuifw.query(unicode("Name:"), "text", u"None")
        if tmp==None:
            self.script_lock.signal()
            return
        elif tmp==u"None":
            tmp=""
        if len(self.putData)>0:
            self.putData[0]=tmp
        else:
            self.putData.append(tmp)
        tmp=appuifw.query(unicode("Mail:"), "text", u"sage")
        if tmp==None:
            self.script_lock.signal()
            return
        if len(self.putData)>1:
            self.putData[1]=tmp
        else:
            self.putData.append(tmp)
        
        self.status=5
        honbun=""
        
        for tmpA in range(self.GYOU-2):
            if len(self.putData)>tmpA+2:
                tmp=appuifw.query(unicode("Line #"+str(tmpA+1)+":"), "text", unicode(self.putData[tmpA+2]))
                if tmp==None:
                    self.script_lock.signal()
                    break
                else:
                    self.putData[tmpA+2]=tmp
            else:
                tmp=appuifw.query(unicode("Line #"+str(tmpA+1)+":"), "text")
                if tmp==None:
                    self.script_lock.signal()
                    break
                else:
                    self.putData.append(tmp)
            honbun=honbun+tmp+unicode("\n")
            
        if tmpA==0:
            self.status=2
            self.script_lock.signal()
            return
        
        subque=appuifw.query(unicode("Re-edit line #(0:post data):"), "number", 0)
        while subque!=0:
            if subque==None:
                self.status=2
                self.script_lock.signal()
                return
            else:
                tmp=appuifw.query(unicode("Line #"+str(subque)+":"), "text", unicode(self.putData[subque+1]))
                if tmp!=None:
                    self.putData[subque+1]=tmp
            subque=appuifw.query(unicode("Re-edit line #(0:post data):"), "number", 0)
        
        Psubmit = unicode("書き込む","UTF-8").encode('shift_jis')
        Psubmit2 = unicode("上記全てを承諾して書き込む","UTF-8").encode('shift_jis')
        Pname = self.putData[0].encode('shift_jis')
        Pmail = self.putData[1].encode('shift_jis')
        Phon = honbun.encode('shift_jis')
        
        cont={}
        cont['bbs']=subpath2
        cont['key']=datname[0]
        cont['time']=1
        cont['submit']=Psubmit
        cont['FROM']=Pname
        cont['mail']=Pmail
        cont['MESSAGE']=Phon
        
        postdata = urllib.urlencode(cont)
        
        apid=socket.select_access_point()
        apo=socket.access_point(apid)
        socket.set_default_access_point(apo)
        
        chdat = self.put(subpath1, 'http://'+subpath1+'/test/bbs.cgi', postdata, {'Host': subpath1, 'Referer': 'http://'+subpath1+'/'+subpath2+'/',\
                'User-Agent': 'Monazilla/1.00 (st2ch/0.42)', 'Connection': 'keep-alive', 'Content-Type': 'text/html; charset=x-sjis'} )
        
        chsta = chdat["status"]
        chcok = chdat["Set-Cookie"]
        
        if chsta!=200:
            appuifw.note(unicode("Post error![code:"+chsta+"]"), "error")
            self.status=2
            socket.set_default_access_point(None)
            self.script_lock.signal()
            return
        
        subque=appuifw.query(unicode("投稿に関して発生する責任は全て投稿者に帰します。全責任を負うことを承諾して書き込みますか？","UTF-8"), "query")
        
        if subque==None:
            appuifw.note(unicode("Post canceled!"), "info")
            self.status=2
            socket.set_default_access_point(None)
            self.script_lock.signal()
            return
        
        cont['submit']=Psubmit2
        cont[self.COOKIE1]=self.COOKIE2
        
        postdata = urllib.urlencode(cont)
        
        chdat2 = self.put(subpath1, 'http://'+subpath1+'/test/bbs.cgi', postdata, {'Host': subpath1, 'Referer': 'http://'+subpath1+'/'+subpath2+'/',\
                 'User-Agent': 'Monazilla/1.00 (st2ch/0.42)', 'Cookie': chcok, 'Connection': 'close', 'Content-Type': 'text/html; charset=x-sjis'} )
        
        chsta2 = chdat2["status"]
        chhon2 = chdat2["content"]
        
        if chsta2==200:
            appuifw.note(unicode("Post completed!"), "conf")
            self.status=2
            socket.set_default_access_point(None)
            self.script_lock.signal()
            return
        else:
            appuifw.note(unicode("Post error![code:"+chsta2+"]"), "error")
            self.status=2
            socket.set_default_access_point(None)
            self.script_lock.signal()
            return


    def rot_land(self):
        appuifw.app.orientation='landscape'
        appuifw.app.screen = "full"  #*044
        self.MOJI=self.MOJI2
        self.GYOU=self.GYOU2
        self.HABA=self.HABA2
        self.BKITA=self.BKITA2
        self.NAME=self.NAME2
        self.script_lock.signal()
        
        canvas.bind(self.k_left2, self.moveleft)
        canvas.bind(self.k_right2, self.moveright)
        canvas.bind(self.k_up2, self.moveup)
        canvas.bind(self.k_down2, self.movedown)
        canvas.bind(self.k_state2, self.statechange)
        canvas.bind(self.k_enter2, self.statechange) #*01
        canvas.bind(self.k_oup2, self.oneup)
        canvas.bind(self.k_odown2, self.onedown)
        canvas.bind(self.k_rot2, self.rot_port)


    def rot_port(self):
        appuifw.app.orientation='portrait'
        appuifw.app.screen = "full" #*044
        self.MOJI=self.MOJI1
        self.GYOU=self.GYOU1
        self.HABA=self.HABA1
        self.BKITA=self.BKITA1
        self.NAME=self.NAME1
        self.script_lock.signal()
        
        canvas.bind(self.k_left1, self.moveleft)
        canvas.bind(self.k_right1, self.moveright)
        canvas.bind(self.k_up1, self.moveup)
        canvas.bind(self.k_down1, self.movedown)
        canvas.bind(self.k_state1, self.statechange)
        canvas.bind(self.k_enter1, self.statechange) #*01
        canvas.bind(self.k_oup1, self.oneup)
        canvas.bind(self.k_odown1, self.onedown)
        canvas.bind(self.k_rot1, self.rot_land)


    def rot_normal(self): #*044
        appuifw.app.orientation='portrait'
        appuifw.app.screen = "normal"
#        self.script_lock.signal()



    def serchurl(self):
        tmpA=self.staLNNo
        
        tmpdoc=u""
        dsA=self.staSLNo
        dsB=self.staLNNo
        dsY=0
        
        while dsY < self.GYOU:
            while dsB < len(self.scrData[dsA]):
                tmpdoc=tmpdoc+unicode(self.scrData[dsA][dsB],'Shift_JIS','ignore')
                dsY=dsY+1
                dsB=dsB+1
                if dsY > (self.GYOU-1):
                    break
            
            if dsY > (self.GYOU-1):
                break
            dsA=dsA+1
            if dsA>=self.lastNo:
                break
            dsB=0
        
        tempname=tmpdoc.split(u"ttp:")
        if len(tempname)<2:
            appuifw.note(unicode("No found URL!"), "error")
            self.script_lock.signal()
            return
        else:
            tmpB=len(tempname)-1
            url=[u"" for tmpC in range(tmpB)]
        
        for tmpD in range(tmpB):
            tempurl=re.findall( r'[-_.!~*\'()a-zA-Z0-9;/?:@&=+$,%#]+',tempname[tmpD+1] )
            url[tmpD]=u"http:"+tempurl[0]
        
        for tmpE in range(tmpB):
            que=appuifw.query(unicode("Open URL["+url[tmpE]+"]?"), "query")
            if que==None:
                self.script_lock.signal()
                if tmpE==tmpB:
                    return
            else:
                internal_url = '4 '+ url[tmpE]
                try:
                    e32.start_exe('BrowserNG.exe', ' "%s"' %internal_url, 1)
                    self.script_lock.signal()
                    return
                except:
                    appuifw.note(unicode("URL open error!"), "error")
                    self.script_lock.signal()
                    return


    def serchcont(self):
        tmpA=self.staLNNo
        
        tmpdoc=u""
        dsA=self.staSLNo
        dsB=self.staLNNo
        dsY=0
        
        while dsY < self.GYOU:
            while dsB < len(self.scrData[dsA]):
                tmpdoc=tmpdoc+unicode(self.scrData[dsA][dsB],'Shift_JIS','ignore')
                dsY=dsY+1
                dsB=dsB+1
                if dsY > (self.GYOU-1):
                    break
            
            if dsY > (self.GYOU-1):
                break
            dsA=dsA+1
            if dsA>=self.lastNo:
                break
            dsB=0
        
        tempname=tmpdoc.split(u"ttp:")
        if len(tempname)<2:
            appuifw.note(unicode("No found URL!"), "error")
            self.script_lock.signal()
            return
        else:
            tmpB=len(tempname)-1
            url=[u"" for tmpC in range(tmpB)]
        
        for tmpD in range(tmpB):
            tempurl=re.findall( r'[-_.!~*\'()a-zA-Z0-9;/?:@&=+$,%#]+',tempname[tmpD+1] )
            url[tmpD]=u"http:"+tempurl[0]
        
        for tmpE in range(tmpB):
            que=appuifw.query(unicode("Open["+url[tmpE]+"]?"), "query")
            if que==None:
                self.script_lock.signal()
                if tmpE==tmpB:
                    return
            else:
                fname=url[tmpE].split("/")
                tempfile=self.pathtmp+fname[len(fname)-1]
                
                try:
                    urllib.urlretrieve(url[tmpE], tempfile)
                    lock=e32.Ao_lock()
                    content_handler = appuifw.Content_handler(lock.signal)
                    content_handler.open(tempfile)
                    lock.wait()
                    self.script_lock.signal()
                    return
                except:
                    appuifw.note(unicode("Data open error!"), "error")
                    self.script_lock.signal()
                    return


    def google(self):
        tmpA=self.staLNNo
        tmpB=appuifw.query(unicode("Edit Line No.:"), "number", 1)
        if tmpB==None:
            self.script_lock.signal()
            return
        
        tmpB=tmpB+tmpA
        tmpdoc=u""
        while tmpA < len(self.scrData[self.staSLNo])-1 and tmpA<tmpB:
            tmpdoc=tmpdoc+unicode(self.scrData[self.staSLNo][tmpA],'Shift_JIS','ignore')
            tmpA=tmpA+1
        if len(tmpdoc)>80:
            tmpdoc=tmpdoc[:80]
        
        if tmpdoc[len(tmpdoc)-1]==u" ":
            tmpdoc=tmpdoc[:len(tmpdoc)-1]
        
        url=appuifw.query(unicode("Edit URL:"), "text", tmpdoc)
        if url==None:
            self.script_lock.signal()
            return
        
        encoding = 'utf-8'
        query = [
            ('q', url.encode(encoding)),
            ('ie', encoding),
            ('oe', encoding),
        ]
        
        internal_url = '4 http://www.google.com/search?'+ urllib.urlencode(query)
        
        try:
            e32.start_exe('BrowserNG.exe', ' "%s"' %internal_url, 1)
            self.script_lock.signal()
            return
        
        except:
            appuifw.note(unicode("URL open error!"), "error")
            self.script_lock.signal()
            return


    def openurl(self):
        tmpA=self.staLNNo
        tmpB=appuifw.query(unicode("Edit Line No.:"), "number", 1)
        if tmpB==None:
            self.script_lock.signal()
            return
        
        tmpB=tmpB+tmpA
        tmpdoc=u""
        while tmpA < len(self.scrData[self.staSLNo])-1 and tmpA<tmpB:
            tmpdoc=tmpdoc+unicode(self.scrData[self.staSLNo][tmpA],'Shift_JIS','ignore')
            tmpA=tmpA+1
        if len(tmpdoc)>80:
            tmpdoc=tmpdoc[:80]
        
        if tmpdoc[len(tmpdoc)-1]==u" ":
            tmpdoc=tmpdoc[:len(tmpdoc)-1]
        
        url=appuifw.query(unicode("Edit URL:"), "text", tmpdoc)
        if url==None:
            self.script_lock.signal()
            return
        
        internal_url = '4 '+ url
        
        try:
            e32.start_exe('BrowserNG.exe', ' "%s"' %internal_url, 1)
            self.script_lock.signal()
            return
        
        except:
            appuifw.note(unicode("URL open error!"), "error")
            self.script_lock.signal()
            return


    def servermove(self):
        if self.BDexp >= 0:
            orgsrv = appuifw.query(unicode("Before server name:"), "text", unicode(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]))
            if orgsrv==None:
                self.script_lock.signal()
                return
            orgdir = appuifw.query(unicode("Before directory name:"), "text", unicode(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]))
            if orgdir==None:
                self.script_lock.signal()
                return
            newsrv = appuifw.query(unicode("After server name:"), "text", unicode(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]))
            if newsrv==None:
                self.script_lock.signal()
                return
            newdir = appuifw.query(unicode("After directory name:"), "text", unicode(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]))
            if newdir==None:
                self.script_lock.signal()
                return
            subque = appuifw.query(unicode(orgsrv+"/"+orgdir+" >>> "+newsrv+"/"+newdir+" OK?"), "query")
            if subque == 1:
                self.bookread()
                f=open('d:\\st2ch.log','w')
                f.write(orgdir+'\n')
                f.close
                
                if (os.path.exists(self.path2ch+orgsrv+'\\'+orgdir)):
                    try:
                        os.renames(self.path2ch+orgsrv+'\\'+orgdir, self.path2ch+newsrv+'\\'+newdir)
                        
                        f=open(self.path2ch+'bookmark.txt','w')
                        tmpA=len(self.bookData)-1
                        while tmpA >=0:
                            if self.bookData[tmpA][1]==orgdir:
                                self.bookData[tmpA]=newsrv,newdir,self.bookData[tmpA][2],self.bookData[tmpA][3],\
                                                  self.bookData[tmpA][4],self.bookData[tmpA][5],self.bookData[tmpA][6]
                                
                            f.write(self.bookData[tmpA][0]+"\n")
                            f.write(self.bookData[tmpA][1]+"\n")
                            f.write(self.bookData[tmpA][2]+"\n")
                            f.write(self.bookData[tmpA][3]+"\n")
                            f.write(self.bookData[tmpA][4]+"\n")
                            f.write(self.bookData[tmpA][5]+"\n")
                            f.write(self.bookData[tmpA][6]+"\n")
                            tmpA=tmpA-1

                        f.close
                        appuifw.note(unicode("Movedir completed! ["+newsrv+"\\"+newdir+"]"), "conf")
                        self.script_lock.signal()
                        return
                        
                    except:
                        appuifw.note(unicode("Movedir error! ["+orgsrv+"\\"+orgdir+"]"), "error")
                        return
                else:
                    appuifw.note(unicode("Not exists dir! ["+orgsrv+"\\"+orgdir+"]"), "error")
                    return


    def confread(self):
        try:
            f=open('e:\\python\\st2ch_m.conf','r') #*01
            fData=f.read()
            f.close
        except:
            return
        
        lnData=fData.split("\n")
        
        for tmpA in range(len(lnData)):
            confData=lnData[tmpA].split("=")
            if confData[0]=="PATH":
                self.path2ch=confData[1]
            elif confData[0]=="TEMP":
                self.pathtmp=confData[1]
#            elif confData[0]=="FONT":
#                self.FONT=unicode(confData[1]) #*01
            elif confData[0]=="FONT_TPL":
                font_wk=confData[1].split(",")
                self.FONT=(unicode(font_wk[0]),int(font_wk[1]),int(font_wk[2]))
            elif confData[0]=="MOJI1":
                self.MOJI1=int(confData[1])
            elif confData[0]=="GYOU1":
                self.GYOU1=int(confData[1])
            elif confData[0]=="HABA1":
                self.HABA1=int(confData[1])
            elif confData[0]=="BKITA1":
                self.BKITA1=int(confData[1])
            elif confData[0]=="NAME1":
                self.NAME1=int(confData[1])
            elif confData[0]=="MOJI2":
                self.MOJI2=int(confData[1])
            elif confData[0]=="GYOU2":
                self.GYOU2=int(confData[1])
            elif confData[0]=="HABA2":
                self.HABA2=int(confData[1])
            elif confData[0]=="BKITA2":
                self.BKITA2=int(confData[1])
            elif confData[0]=="NAME2":
                self.NAME2=int(confData[1])
            elif confData[0]=="LEFT1":
                self.k_left1=int(confData[1],16)
            elif confData[0]=="RIGHT1":
                self.k_right1=int(confData[1],16)
            elif confData[0]=="UP1":
                self.k_up1=int(confData[1],16)
            elif confData[0]=="DOWN1":
                self.k_down1=int(confData[1],16)
            elif confData[0]=="SELECT1":
                self.k_state1=int(confData[1],16)
            elif confData[0]=="ENTER1":            #*01
                self.k_enter1=int(confData[1],16)
            elif confData[0]=="ONEUP1":
                self.k_oup1=int(confData[1],16)
            elif confData[0]=="ONEDOWN1":
                self.k_odown1=int(confData[1],16)
            elif confData[0]=="ROTATE1":
                self.k_rot1=int(confData[1],16)
            elif confData[0]=="LEFT2":
                self.k_left2=int(confData[1],16)
            elif confData[0]=="RIGHT2":
                self.k_right2=int(confData[1],16)
            elif confData[0]=="UP2":
                self.k_up2=int(confData[1],16)
            elif confData[0]=="DOWN2":
                self.k_down2=int(confData[1],16)
            elif confData[0]=="SELECT2":
                self.k_state2=int(confData[1],16)
            elif confData[0]=="ENTER2":            #*01
                self.k_enter2=int(confData[1],16)
            elif confData[0]=="ONEUP2":
                self.k_oup2=int(confData[1],16)
            elif confData[0]=="ONEDOWN2":
                self.k_odown2=int(confData[1],16)
            elif confData[0]=="ROTATE2":
                self.k_rot2=int(confData[1],16)
            elif confData[0]=="COOKIE1":
                self.COOKIE1=unicode(confData[1])
            elif confData[0]=="COOKIE2":
                self.COOKIE2=unicode(confData[1])
            elif confData[0]=="B_HABA":
                self.B_HABA=int(confData[1])  #*0.4.3 masa
            

    def filedel(self):
        
        if self.status==3:
            fname=self.path2ch+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]+"\\"+\
                  self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]+"\\"+self.subData[self.TXstaNo+self.TXcurNo][0]
            if self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1].find(unicode("machi.to"))>=0:
                fname=fname+".dat"
            infname=self.subData[self.TXstaNo+self.TXcurNo][0].split(".")
            fname2=self.path2ch+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]+"\\"+\
                   self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]+"\\info\\"+infname[0]+".inf"
        elif self.status==4:
            fname=self.path2ch+self.bookData[self.BKstaNo+self.BKcurNo][0]+"\\"+self.bookData[self.BKstaNo+self.BKcurNo][1]+"\\"+\
                  self.bookData[self.BKstaNo+self.BKcurNo][2]
            if self.bookData[self.BKstaNo+self.BKcurNo][0].find(unicode("machi.to"))>=0:
                fname=fname+".dat"
            infname=self.bookData[self.BKstaNo+self.BKcurNo][2].split(".")
            fname2=self.path2ch+self.bookData[self.BKstaNo+self.BKcurNo][0]+"\\"+self.bookData[self.BKstaNo+self.BKcurNo][1]+"\\info\\"+infname[0]+".inf"
        
        subque = appuifw.query(unicode("Delete file:"+fname+" ?"), "query")
        if subque == 1:
            try:
                os.remove(fname)
                os.remove(fname2)
            except:
                appuifw.note(unicode("Delete error!"), "error")
        
        self.script_lock.signal()


    def jumpnum(self):
        jnum = appuifw.query(unicode("Jump to:"), "number")
        if jnum==None:
            self.script_lock.signal()
            return
        
        if self.status==2:
            if jnum>=self.lastNo:
                self.staSLNo=self.lastNo-1
                self.staLNNo=0
            elif jnum<1:
                self.staSLNo=0
                self.staLNNo=0
            else:
                self.staSLNo=jnum-1
                self.staLNNo=0
            self.script_lock.signal()


    def findtext(self):
        ftext = appuifw.query(unicode("Serch for:"), "text")
        if ftext==None:
            self.script_lock.signal()
            return
        
        if self.status==3:
            tmpA=self.TXstaNo+self.TXcurNo+1
            if tmpA>len(self.subData)-1:
                tmpA=0
            
            while tmpA < len(self.subData):
                stext=unicode(self.subData[tmpA][1],'Shift_JIS','ignore').lower()
                if stext.find(unicode(ftext).lower())>=0:
                    if tmpA>17:
                        self.TXcurNo=17
                        self.TXstaNo=tmpA-17
                    else:
                        self.TXcurNo=tmpA
                        self.TXstaNo=0
                    self.script_lock.signal()
                    break
                    
                tmpA=tmpA+1
                if tmpA == len(self.subData):
                    tmpA=0

                if tmpA == self.TXstaNo+self.TXcurNo:
                    appuifw.note(unicode("Not found"), "info")
                    self.script_lock.signal()
                    break
        elif self.status==2:
            tmpA=self.staSLNo+1
            if tmpA>self.lastNo-1:
                tmpA=0
            
            while tmpA < self.lastNo:
                tmpB=1
                stext=""
                while tmpB<len(self.scrData[tmpA])-1:
                    stext=stext+unicode(self.scrData[tmpA][tmpB],'Shift_JIS','ignore').lower()
                    tmpB=tmpB+1
                if stext.find(unicode(ftext).lower())>=0:
                    self.staSLNo=tmpA
                    self.staLNNo=0
                    self.script_lock.signal()
                    break
                
                tmpA=tmpA+1
                if tmpA == self.lastNo:
                    tmpA=0
                
                if tmpA == self.staSLNo:
                    appuifw.note(unicode("Not found"), "info")
                    self.script_lock.signal()
                    break


    def junkai(self):
        self.status=0
        tmpUpdate=[]
        
        for tmpA in range(len(self.bookData)):
            
            f=open('d:\\st2ch.log','w')
            f.write(str(tmpA)+'\n')
            f.close
            
            if int(self.bookData[tmpA][5])==1:
                infname=self.bookData[tmpA][2].split(".")
                if (os.path.exists(self.path2ch+self.bookData[tmpA][0]+'\\'+self.bookData[tmpA][1]+'\\info\\'+infname[0]+'.inf')):
                    f=open(self.path2ch+self.bookData[tmpA][0]+'\\'+self.bookData[tmpA][1]+'\\info\\'+infname[0]+'.inf','r')
                    fdata=f.read()
                    f.close
                    lnData=fdata.split('\n')
                    if self.bookData[tmpA][0].find(unicode("machi.to"))>=0:
                        datSize=0
                    else:
                        datSize=os.stat(self.path2ch+self.bookData[tmpA][0]+'\\'+self.bookData[tmpA][1]+'\\'+infname[0]+".dat")[stat.ST_SIZE]
                    tmpB=tmpA,lnData[0],lnData[1],lnData[2],self.bookData[tmpA][0],self.bookData[tmpA][1],infname[0],datSize
                else:
                    tmpB=tmpA,"",0,0,self.bookData[tmpA][0],self.bookData[tmpA][1],infname[0],-1
                    
                tmpUpdate.append(tmpB)
        
        apid=socket.select_access_point()
        apo=socket.access_point(apid)
        socket.set_default_access_point(apo)
        
        for tmpC in range(len(tmpUpdate)):
            
            f=open('d:\\st2ch.log','w')
            f.write(str(tmpC)+'\n')
            f.close
            
            canvas.rectangle((0,(self.GYOU-2)*self.HABA-1,800,(self.GYOU-1)*self.HABA),fill=0xF0E68C)
            canvas.text( (self.HABA*3,(self.GYOU-1)*self.HABA), unicode("No.%d updating..."%(tmpUpdate[tmpC][0]+1)), 0xDC143C, self.FONT)
            self.script_lock.signal()
            try:
                if tmpUpdate[tmpC][7]>=0:
                    if tmpUpdate[tmpC][4].find(unicode("machi.to"))>=0:
                        chdat=self.get(tmpUpdate[tmpC][4],"http://"+tmpUpdate[tmpC][4]+"/bbs/offlaw.cgi/"+tmpUpdate[tmpC][5]+"/"+tmpUpdate[tmpC][6]+"/"+str(int(tmpUpdate[tmpC][3])+1)+"-",\
                                       {'User-Agent': UA,'If-Modified-Since': tmpUpdate[tmpC][1]} )
                    else:
                        chdat=self.get(tmpUpdate[tmpC][4],"http://"+tmpUpdate[tmpC][4]+"/"+tmpUpdate[tmpC][5]+"/dat/"+tmpUpdate[tmpC][6]+".dat",\
                                       {'User-Agent': UA,'If-Modified-Since': tmpUpdate[tmpC][1],'Range': 'bytes='+str(tmpUpdate[tmpC][7])+'-'} )
                else:
                    if tmpUpdate[tmpC][4].find(unicode("machi.to"))>=0:
                        chdat=self.get(tmpUpdate[tmpC][4],"http://"+tmpUpdate[tmpC][4]+"/bbs/offlaw.cgi/"+tmpUpdate[tmpC][5]+"/"+tmpUpdate[tmpC][6]+"/",\
                                       {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
                    else:
                        chdat=self.get(tmpUpdate[tmpC][4],"http://"+tmpUpdate[tmpC][4]+"/"+tmpUpdate[tmpC][5]+"/dat/"+tmpUpdate[tmpC][6]+".dat",\
                                       {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
                
                chsta=chdat["status"]
                chmod=chdat["last-modified"]
                chhon=chdat["content"]
            except:
                subque = appuifw.query(unicode("Connection error[%s/%s]. Retry?"%(tmpUpdate[tmpC][5],tmpUpdate[tmpC][6])), "query")
                if subque == 1:
                    self.status=4
                    self.infsave()
                    socket.set_default_access_point(None)
                    self.script_lock.signal()
                    self.junkai()
                else:
                    self.status=4
                    self.infsave()
                    socket.set_default_access_point(None)
                    self.script_lock.signal()
                    return
            
            if chsta==200 and tmpUpdate[tmpC][7]<0:
                if not(os.path.exists(self.path2ch+tmpUpdate[tmpC][4])):
                    os.mkdir(self.path2ch+tmpUpdate[tmpC][4])

                if not(os.path.exists(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5])):
                    os.mkdir(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5])

                if not(os.path.exists(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\info')):
                    os.mkdir(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\info')

                f=open(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\'+tmpUpdate[tmpC][6]+'.dat','w')
                f.write(chhon)
                f.close
                
                f=open(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\info\\'+tmpUpdate[tmpC][6]+'.inf','w')
                f.write(chmod+'\n'+str(tmpUpdate[tmpC][2])+'\n'+str(tmpUpdate[tmpC][3])+'\n')
                f.close
                
                self.bookData[tmpUpdate[tmpC][0]]=self.bookData[tmpUpdate[tmpC][0]][0],self.bookData[tmpUpdate[tmpC][0]][1],\
                                                  self.bookData[tmpUpdate[tmpC][0]][2],self.bookData[tmpUpdate[tmpC][0]][3],\
                                                  self.bookData[tmpUpdate[tmpC][0]][4],self.bookData[tmpUpdate[tmpC][0]][5],str(chsta)
                
            elif chsta==206 or (chsta==200 and tmpUpdate[tmpC][7]>=0):
                f=open(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\'+tmpUpdate[tmpC][6]+'.dat','a')
                f.write(chhon)
                f.close
                
                if tmpUpdate[tmpC][4].find(unicode("machi.to"))>=0:
                    lnData=chhon.split("\n")
                    
                    f=open(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\info\\'+tmpUpdate[tmpC][6]+'.inf','w')
                    f.write(chmod+'\n'+str(tmpUpdate[tmpC][2])+'\n'+str(int(tmpUpdate[tmpC][3])+len(lnData)-1)+'\n')
                    f.close
                else:
                    f=open(self.path2ch+tmpUpdate[tmpC][4]+'\\'+tmpUpdate[tmpC][5]+'\\info\\'+tmpUpdate[tmpC][6]+'.inf','w')
                    f.write(chmod+'\n'+str(tmpUpdate[tmpC][2])+'\n'+str(tmpUpdate[tmpC][3])+'\n')
                    f.close
                
                self.bookData[tmpUpdate[tmpC][0]]=self.bookData[tmpUpdate[tmpC][0]][0],self.bookData[tmpUpdate[tmpC][0]][1],\
                                                  self.bookData[tmpUpdate[tmpC][0]][2],self.bookData[tmpUpdate[tmpC][0]][3],\
                                                  self.bookData[tmpUpdate[tmpC][0]][4],self.bookData[tmpUpdate[tmpC][0]][5],str(chsta)
                
            else:
                self.bookData[tmpUpdate[tmpC][0]]=self.bookData[tmpUpdate[tmpC][0]][0],self.bookData[tmpUpdate[tmpC][0]][1],\
                                                  self.bookData[tmpUpdate[tmpC][0]][2],self.bookData[tmpUpdate[tmpC][0]][3],\
                                                  self.bookData[tmpUpdate[tmpC][0]][4],self.bookData[tmpUpdate[tmpC][0]][5],str(chsta)
            
        f=open('d:\\st2ch.log','w')
        for tmpD in range(len(tmpUpdate)):
            f.write(str(tmpUpdate[tmpD][1])+'\n')
        f.close
        
        self.status=4
        self.infsave()
        socket.set_default_access_point(None)
        self.script_lock.signal()


    def datupdate(self):

        if self.BKstat==1:
            subpath1=self.bookData[self.BKstaNo+self.BKcurNo][0]
            subpath2=self.bookData[self.BKstaNo+self.BKcurNo][1]
            datname=self.bookData[self.BKstaNo+self.BKcurNo][2].split(".")
        elif self.BKstat==0:
            subpath1=self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]
            subpath2=self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]
            datname=self.subData[self.TXstaNo+self.TXcurNo][0].split(".")
        
        datReadLine=0
        datAllLine=0
        
        try:
            f=open(self.path2ch+subpath1+'\\'+subpath2+'\\info\\'+datname[0]+'.inf','r')
            fdata=f.read()
            f.close
            lnData=fdata.split('\n')
            datModify=lnData[0]
            datReadLine=str(lnData[1])
            
            if subpath1.find(unicode("machi.to"))<0:
                datSize=os.stat(self.path2ch+subpath1+'\\'+subpath2+'\\'+datname[0]+".dat")[stat.ST_SIZE]
                datAllLine=str(lnData[2])
            else:
                datAllLine=str(int(lnData[2])+1)
            
            if subpath1.find(unicode("machi.to"))>=0:
                chdat=self.get(subpath1, "http://"+subpath1+"/bbs/offlaw.cgi/"+subpath2+"/"+datname[0]+"/"+datAllLine+"-", {'User-Agent': UA,'If-Modified-Since': datModify} )
            else:
                chdat=self.get(subpath1, "http://"+subpath1+"/"+subpath2+"/dat/"+datname[0]+".dat", {'User-Agent': UA,'If-Modified-Since': datModify,'Range': 'bytes='+str(datSize)+'-'} )
            
            chsta=chdat["status"]
            chmod=chdat["last-modified"]
            chhon=chdat["content"]

        except IOError:
            if not(os.path.exists(self.path2ch+subpath1)):
                os.mkdir(self.path2ch+subpath1)

            if not(os.path.exists(self.path2ch+subpath1+'\\'+subpath2)):
                os.mkdir(self.path2ch+subpath1+'\\'+subpath2)

            if not(os.path.exists(self.path2ch+subpath1+'\\'+subpath2+'\\info')):
                os.mkdir(self.path2ch+subpath1+'\\'+subpath2+'\\info')
            
            if subpath1.find(unicode("machi.to"))>=0:
                chdat=self.get(subpath1, "http://"+subpath1+"/bbs/offlaw.cgi/"+subpath2+"/"+datname+"/", {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
            else:
                chdat=self.get(subpath1, "http://"+subpath1+"/"+subpath2+"/dat/"+datname[0]+".dat", {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
            
            chsta=chdat["status"]
            chmod=chdat["last-modified"]
            chhon=chdat["content"]
        
        if chsta==200 or chsta==206:
            try:
                tmpf=open(self.path2ch+subpath1+'\\'+subpath2+'\\'+datname[0]+'.dat','a')
                tmpf.write(chhon)
                tmpf.close
            except:
                self.script_lock.signal()
                appuifw.note(unicode( "Error code:%d"%(chsta) ), "error")
        
        if chsta==200 or chsta==206:
            lnData=chhon.split("\n")
            appendData = [["" for tmpA in range(1)] for tmpB in range(len(lnData))]

            for tmpC in range(len(lnData)):
                spData = lnData[tmpC].split("<>")
                if subpath1.find(unicode("machi.to"))>=0:
                    spData = spData[1:]
                
                if len(spData) < 3:
                    break
                    
                count=str(self.lastNo+tmpC+1)
                
                tmpData=spData[0].split("</b>")
                tmpData2=tmpData[0]
                if len(tmpData)>1:
                    comData=tmpData[1].split("<b>")
                    tmpData2=tmpData2+comData[0]+comData[1]
                
                if self.NAME==1:
                    appendData[tmpC][0] = count+": "+tmpData2+" ["+spData[1]+"] "+spData[2]
                else:
                    appendData[tmpC][0] = count+": "+tmpData2+" ["+spData[1]+"]"
                    appendData[tmpC].append("     "+spData[2])
                
                if subpath1.find(unicode("machi.to"))>=0:
                    comData = spData[3].split("<br>")
                else:
                    if spData[3][0]==" ":
                        comData = spData[3][1:].split(" <br> ")
                    else:
                        comData = spData[3].split(" <br> ")
                
                for tmpD in range(len(comData)):

                    tmpData = comData[tmpD].split("<")
                    if len(tmpData) > 1:
                        
                        comData[tmpD]=""
                        
                        for tmpE in range(len(tmpData)):
                            tmpData2 = tmpData[tmpE].split(">")
                            if len(tmpData2) > 1:
                                comData[tmpD]=comData[tmpD]+tmpData2[1]
                            else:
                                comData[tmpD]=comData[tmpD]+tmpData2[0]
                    
                    tmpData = comData[tmpD].split("&lt;")
                    if len(tmpData) > 1:
                        
                        comData[tmpD]=""
                        tmpE=0
                        
                        for tmpE in range(len(tmpData)):
                            if tmpE == 0:
                                comData[tmpD]=tmpData[0]
                            else:
                                comData[tmpD]=comData[tmpD]+"<"+tmpData[tmpE]
                    
                    tmpData = comData[tmpD].split("&gt;")
                    if len(tmpData) > 1:
                        
                        comData[tmpD]=""
                        tmpE=0
                        
                        for tmpE in range(len(tmpData)):
                            if tmpE == 0:
                                comData[tmpD]=tmpData[0]
                            else:
                                comData[tmpD]=comData[tmpD]+">"+tmpData[tmpE]
                    
                    tmpData = comData[tmpD].split("&quot;")
                    if len(tmpData) > 1:
                        
                        comData[tmpD]=""
                        tmpE=0
                        
                        for tmpE in range(len(tmpData)):
                            if tmpE == 0:
                                comData[tmpD]=tmpData[0]
                            else:
                                comData[tmpD]=comData[tmpD]+'"'+tmpData[tmpE]
                    
                    tmpST=0
                    tmpED=self.MOJI
                    
                    while len(comData[tmpD][tmpST:]) > self.MOJI:
                        tmp29 = comData[tmpD][tmpST:tmpED-1]
                        tmp30 = comData[tmpD][tmpST:tmpED]
                        tmp31 = comData[tmpD][tmpST:tmpED+1]
                    
                        if len(unicode(tmp30,'Shift_JIS','ignore')) == len(unicode(tmp31,'Shift_JIS','ignore')):
                            appendData[tmpC].append(tmp30)
                            tmpST=tmpST+self.MOJI
                            tmpED=tmpED+self.MOJI
                        elif len(unicode(tmp29,'Shift_JIS','ignore')) == len(unicode(tmp30,'Shift_JIS','ignore')):
                            appendData[tmpC].append(tmp31)
                            tmpST=tmpST+self.MOJI+1
                            tmpED=tmpED+self.MOJI+1
                        else:
                            appendData[tmpC].append(tmp30)
                            tmpST=tmpST+self.MOJI
                            tmpED=tmpED+self.MOJI
                    
                    appendData[tmpC].append(comData[tmpD][tmpST:])
                
                appendData[tmpC].append(' ')
            
            self.scrData = self.scrData+appendData
            self.lastNo = self.lastNo+len(lnData)-1
            self.datMod = chmod

            appuifw.app.title=unicode("["+str(self.lastNo)+"]"+self.titleData,'Shift_JIS','ignore')
            self.script_lock.signal()
            appuifw.note(unicode("Update completed!"), "conf")

        elif chsta==304:
            self.script_lock.signal()
            appuifw.note(unicode("No update!"), "info")
        elif chsta==416:
            self.script_lock.signal()
            appuifw.note(unicode( "Data size error!"), "error")


    def boardupdate(self):

        chsta = 0
        try:
            chdat=self.get("menu.2ch.net", "http://menu.2ch.net/bbsmenu.html", {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
            
            chsta=chdat["status"]
            chmod=chdat["last-modified"]
            chhon=chdat["content"]
            
            lnData=chhon.split("\n")
            catego=""
            bbstable=""
            
            for tmpA in range(len(lnData)):
                
                if catego != "" or len( lnData[tmpA].split("B>") ) >1:
                    if len( lnData[tmpA].split("B>") ) >1:
                        catData = lnData[tmpA].split("B>")
                        catego = catData[1][:len(catData[1])-2]

                        bbstable=bbstable+"\n"+catego+"\n"
                            
                    elif len( lnData[tmpA].split(".2ch.net/") ) >1:
                        
                        urlData = lnData[tmpA].split("http://")
                        
                        if len( urlData[1].split("/") ) >3 and len( urlData[1].split("/>") ) >1:
                            servData = urlData[1].split("/")
                            server = servData[0]
                            direct = servData[1]
                            servData = urlData[1].split("/>")
                            title = servData[1].split("</A>")
                            if not(server in JOGAI):
                                bbstable=bbstable+title[0]+"\n"+server+"\n"+direct+"\n"
                        
                    elif len( lnData[tmpA].split(".bbspink.com/") ) >1:
                        
                        urlData = lnData[tmpA].split("http://")
                        
                        if len( urlData[1].split("/") ) >3 and len( urlData[1].split("/>") ) >1:
                            servData = urlData[1].split("/")
                            server = servData[0]
                            direct = servData[1]
                            title = servData[2][1:len(servData[2])-1]
                            bbstable=bbstable+title+"\n"+server+"\n"+direct+"\n"
                        
                    elif len( lnData[tmpA].split(".machi.to/") ) >1:
                        
                        urlData = lnData[tmpA].split("http://")
                        
                        if len( urlData[1].split("/") ) >3:
                            servData = urlData[1].split("/")
                            server = servData[0]
                            direct = servData[1]
                            title = servData[2][15:len(servData[2])-1]
                            bbstable=bbstable+title+"\n"+server+"\n"+direct+"\n"
                        
                        if direct == "okinawa":
                            break
                        
            f=open(self.path2ch+'board.txt','w')
            f.write(bbstable)
            f.close
            
            lnData=bbstable.split("\n")
            
            self.BDlastNo=[]
            self.boardData = []
            tmpA=0
            tmpB=0
            
            while tmpA < len(lnData)-1:
                if len(lnData[tmpA]) < 1:
                    if len(lnData[tmpA+2]) < 1:
                        tmpA = tmpA+2
                    else:
                        tmpC = lnData[tmpA+1], ""
                        self.boardData.append(tmpC)
                        self.BDlastNo.append(tmpB)
                        tmpA = tmpA+2
                        tmpB = tmpB+1
                else:
                    tmpC = lnData[tmpA], lnData[tmpA+1], lnData[tmpA+2]
                    self.boardData.append(tmpC)
                    tmpA = tmpA+3
                    tmpB = tmpB+1

            self.BDcurNo=0
            self.BDstaNo=0
            self.BDexp=-1
            self.SBcurNo=0
            self.SBstaNo=0
            self.SBlastNo=0
            appuifw.note(unicode("Downloaded complete!"), "conf")
            self.script_lock.signal()

        except:
            self.script_lock.signal()
            appuifw.note(unicode( "Error code:%d"%(chsta) ), "error")


    def subupdate( self ):
        
        chsta = 0
        try:
            if self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1].find(unicode("machi.to"))>=0:
                url="http://"+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]+"/bbs/offlaw.cgi/"+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]+"/"
            else:
                url="http://"+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]+"/"+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]+"/subject.txt"
            
            chdat=self.get(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1], url, {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
            
            chsta=chdat["status"]
            chmod=chdat["last-modified"]
            chhon=chdat["content"]
            
            if chsta!=200:
                self.script_lock.signal()
                appuifw.note(unicode( "Error code:%d"%(chsta) ), "error")
                return
            
            f=open(self.path2ch+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]+'\\'+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]+'\\subject.txt','w')
            f.write(chhon)
            f.close

            lnData=chhon.split("\n")
            
            self.subData = []
            tmpA=0
            
            while tmpA < len(lnData)-1:
                if self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1].find(unicode("machi.to"))>=0:
                    tmpC = lnData[tmpA].split("<>")
                    tmpB = tmpC[1],tmpC[2]
                else:
                    tmpB = lnData[tmpA].split("<>")
                self.subData.append(tmpB)
                tmpA = tmpA+1
            self.TXcurNo=0
            self.TXstaNo=0
            self.script_lock.signal()
            appuifw.note(unicode("Downloaded complete!"), "conf")
            
        except:
            self.script_lock.signal()
            appuifw.note(unicode( "Error code:%d"%(chsta) ), "error")


    def delbook(self):
        
        if self.BKstaNo==0 and self.BKcurNo==0:
            self.bookData = self.bookData[1:]
        elif (self.BKstaNo+self.BKcurNo)==(len(self.bookData)-1):
            self.bookData = self.bookData[:self.BKstaNo+self.BKcurNo]
            if self.BKstaNo>0:
                self.BKstaNo = self.BKstaNo-1
            else:
                self.BKcurNo = self.BKcurNo-1
        else:
            self.bookData = self.bookData[:self.BKstaNo+self.BKcurNo]+self.bookData[self.BKstaNo+self.BKcurNo+1:]
        
        try:
            f=open(self.path2ch+'bookmark.txt','w')
            tmpA=len(self.bookData)-1
            while tmpA >=0:
                f.write(self.bookData[tmpA][0]+"\n")
                f.write(self.bookData[tmpA][1]+"\n")
                f.write(self.bookData[tmpA][2]+"\n")
                f.write(self.bookData[tmpA][3]+"\n")
                f.write(self.bookData[tmpA][4]+"\n")
                f.write(self.bookData[tmpA][5]+"\n")
                f.write(self.bookData[tmpA][6]+"\n")
                tmpA=tmpA-1
            
            f.close
            appuifw.note(unicode("Deleted!"),"conf")
            
        except:
            appuifw.note(unicode("Write error!"),"error")


    def addbook(self):
        try:
            f=open(self.path2ch+'bookmark.txt','r+')
            fData=f.read()
            
            lnData=fData.split("\n")
            
            self.bookData = []
            tmpA=0
            
            while tmpA < len(lnData)-1:
                self.bookData.append(lnData[tmpA])
                tmpA = tmpA+1
            
        except:
            f=open(self.path2ch+'bookmark.txt','w')

        self.bookData = []
        
        self.bookData.append(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1])
        self.bookData.append(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2])
        self.bookData.append(self.subData[self.TXstaNo+self.TXcurNo][0])
        self.bookData.append(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][0])
        
        tmpAD=self.subData[self.TXstaNo+self.TXcurNo][1].split("(")

        if len(tmpAD)>2:
            appAD=tmpAD[0]
            tmpB=1
            while tmpB <len(tmpAD)-1:
                appAD=appAD+"("+tmpAD[tmpB]
                tmpB=tmpB+1
        else:
            appAD=tmpAD[0]

        self.bookData.append(appAD)

        self.bookData.append("1")
        self.bookData.append("0")

        try:
            tmpA=0
            while tmpA < len(self.bookData):
                f.write(self.bookData[tmpA]+"\n")
                tmpA = tmpA+1
            
            f.close
            
            appuifw.note(unicode("Added bookmark!"),"conf")

        except:
            appuifw.note(unicode("Write error!"),"error")


    def backstate(self):
        if self.BKstat==1 and self.status==2:
            self.state4()
            self.script_lock.signal()
        elif self.BKstat==0 and self.status==2:
            self.state3()
            self.script_lock.signal()
        elif self.status==3:
            self.state1()
            self.script_lock.signal()
        elif self.status==4:
            self.state1()
            self.script_lock.signal()
        elif self.status==1:
            self.exit_key_handler()
            self.script_lock.signal()


    def infsave(self):
        f=open('d:\\st2ch.log','w')
        f.write(str(self.BKstat)+'\n')
        f.close
        
        if self.BKstat==1 and self.status==2:
            infname=self.bookData[self.BKstaNo+self.BKcurNo][2].split(".")
            f=open(self.path2ch+self.bookData[self.BKstaNo+self.BKcurNo][0]+'\\'+self.bookData[self.BKstaNo+self.BKcurNo][1]+'\\info\\'+infname[0]+'.inf','w')
            f.write(self.datMod+"\n%d\n%d\n" % (self.staSLNo,self.lastNo) )
            f.close
        elif self.BKstat==0 and self.status==2:
            infname=self.subData[self.TXstaNo+self.TXcurNo][0].split(".")
            f=open(self.path2ch+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1]+'\\'+self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2]+'\\info\\'+infname[0]+'.inf','w')
            f.write(self.datMod+"\n%d\n%d\n" % (self.staSLNo,self.lastNo) )
            f.close
        elif self.status==4:
            f=open(self.path2ch+'bookmark.txt','w')
            tmpA=len(self.bookData)-1
            while tmpA >=0:
                f.write(self.bookData[tmpA][0]+"\n")
                f.write(self.bookData[tmpA][1]+"\n")
                f.write(self.bookData[tmpA][2]+"\n")
                f.write(self.bookData[tmpA][3]+"\n")
                f.write(self.bookData[tmpA][4]+"\n")
                f.write(self.bookData[tmpA][5]+"\n")
                f.write(self.bookData[tmpA][6]+"\n")
                tmpA=tmpA-1
            f.close


    def state1(self):
        self.infsave()
        self.status=1
        appuifw.app.menu = [self.menu_book, self.menu_boardupd, self.menu_srvmove, self.menu_exit]
        appuifw.app.title=unicode("Board")


    def state3(self):
        self.infsave()
        self.status=3
        self.BKstat=0
        appuifw.app.menu = [self.menu_find, self.menu_subupd, self.menu_adbook, self.menu_fdel, self.menu_board, self.menu_book, self.menu_exit]
        appuifw.app.title=unicode(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][0],'Shift_JIS','ignore')


    def state4(self):
        self.infsave()
        self.status=4
        self.BKstat=1
        appuifw.app.menu = [self.menu_junkai, self.menu_delbook, self.menu_fdel, self.menu_board, self.menu_exit]
        appuifw.app.title=unicode("Bookmark")
        self.bookread()
        #need for 5800XM, because "redraw_callback" doesn't work in 5800XM
        self.draw_state() #*01
        


    def statechange(self):
        if self.status==1:
            if self.BDexp >= 0:
                appuifw.app.title=unicode(self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][0],'Shift_JIS','ignore')
                canvas.rectangle((0,(self.GYOU-1)*self.HABA,800,self.GYOU*self.HABA+2),fill=0x006400)
                canvas.text( (self.HABA*3,self.GYOU*self.HABA+1), unicode("Now loading..."), 0xFFD700, self.FONT)
                self.subread( self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1],self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2] )
                self.script_lock.signal()
            else:
                self.BDexp=self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo]
                if len(self.BDlastNo) > self.BDlastNo.index(self.BDstaNo)+self.BDcurNo+1:
                    self.SBlastNo=self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo+1] - self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo] - 1
                else:
                    self.SBlastNo=len(self.boardData) - self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo] - 1
                self.script_lock.signal()
        elif self.status==3:
            canvas.rectangle((0,(self.GYOU-1)*self.HABA,800,self.GYOU*self.HABA+2),fill=0x006400)
            canvas.text( (self.HABA*3,self.GYOU*self.HABA+1), unicode("Now loading..."), 0xFFD700, self.FONT)
            self.fileread( self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][1],self.boardData[self.BDexp+self.SBstaNo+self.SBcurNo+1][2],self.subData[self.TXstaNo+self.TXcurNo][0] )
            self.script_lock.signal()
        elif self.status==4:
            canvas.rectangle((0,(self.GYOU-1)*self.HABA,800,self.GYOU*self.HABA+2),fill=0x006400)
            canvas.text( (self.HABA*3,self.GYOU*self.HABA+1), unicode("Now loading..."), 0xFFD700, self.FONT)
            self.bookData[self.BKstaNo+self.BKcurNo]=self.bookData[self.BKstaNo+self.BKcurNo][0],self.bookData[self.BKstaNo+self.BKcurNo][1],\
                                                     self.bookData[self.BKstaNo+self.BKcurNo][2],self.bookData[self.BKstaNo+self.BKcurNo][3],\
                                                     self.bookData[self.BKstaNo+self.BKcurNo][4],self.bookData[self.BKstaNo+self.BKcurNo][5],"0"
            self.infsave()
            self.fileread( self.bookData[self.BKstaNo+self.BKcurNo][0],self.bookData[self.BKstaNo+self.BKcurNo][1],self.bookData[self.BKstaNo+self.BKcurNo][2] )
            self.script_lock.signal()


    def oneup(self):
        if self.status==2:
            if self.staLNNo > 0:
                self.staLNNo=self.staLNNo-1
            elif self.staSLNo > 0:
                self.staSLNo=self.staSLNo-1
                self.staLNNo=len(self.scrData[self.staSLNo])-1
            self.script_lock.signal()
        elif self.status==4:
            if self.bookData[self.BKstaNo+self.BKcurNo][5]=="1":
                self.bookData[self.BKstaNo+self.BKcurNo]=self.bookData[self.BKstaNo+self.BKcurNo][0],self.bookData[self.BKstaNo+self.BKcurNo][1],\
                                                         self.bookData[self.BKstaNo+self.BKcurNo][2],self.bookData[self.BKstaNo+self.BKcurNo][3],\
                                                         self.bookData[self.BKstaNo+self.BKcurNo][4],"0",self.bookData[self.BKstaNo+self.BKcurNo][6]
            else:
                self.bookData[self.BKstaNo+self.BKcurNo]=self.bookData[self.BKstaNo+self.BKcurNo][0],self.bookData[self.BKstaNo+self.BKcurNo][1],\
                                                         self.bookData[self.BKstaNo+self.BKcurNo][2],self.bookData[self.BKstaNo+self.BKcurNo][3],\
                                                         self.bookData[self.BKstaNo+self.BKcurNo][4],"1",self.bookData[self.BKstaNo+self.BKcurNo][6]
            self.script_lock.signal()


    def onedown(self):
        if self.status==2:
            if self.staLNNo < len(self.scrData[self.staSLNo])-1:
                self.staLNNo=self.staLNNo+1
            elif self.staSLNo < self.lastNo-1:
                self.staSLNo=self.staSLNo+1
                self.staLNNo=0
            self.script_lock.signal()


    def moveup(self):
        if self.status==2:
            if self.staLNNo > self.GYOU-2:
                self.staLNNo=self.staLNNo-(self.GYOU-1)
            else:
                muA=self.GYOU-1
                while muA>0:
                    self.staLNNo=self.staLNNo-1
                    if self.staLNNo<0:
                        self.staSLNo=self.staSLNo-1
                        if self.staSLNo<0:
                            self.staSLNo=0
                            self.staLNNo=0
                            break
                        self.staLNNo=len(self.scrData[self.staSLNo])-1
                    muA=muA-1
            self.script_lock.signal()
        elif self.status==1:
            if self.BDexp < 0:
                if self.BDcurNo > 0:
                    self.BDcurNo=self.BDcurNo-1
                    self.script_lock.signal()
                elif self.BDcurNo==0 and self.BDstaNo>0:
                    self.BDstaNo=self.BDlastNo[self.BDlastNo.index(self.BDstaNo)-1]
                    self.script_lock.signal()
            else:
                if self.SBcurNo > 0:
                    self.SBcurNo=self.SBcurNo-1
                    self.script_lock.signal()
                elif self.SBcurNo == 0 and self.SBstaNo>0:
                    self.SBstaNo = self.SBstaNo-1
                    self.script_lock.signal()
        elif self.status==3:
            if self.TXcurNo == 0:
                if self.TXstaNo > 0:
                    self.TXstaNo = self.TXstaNo - 1
                    self.script_lock.signal()
            else:
                self.TXcurNo = self.TXcurNo - 1
                self.script_lock.signal()
        elif self.status==4:
            if self.BKcurNo == 0:
                if self.BKstaNo > 0:
                    self.BKstaNo = self.BKstaNo - 1
                    self.script_lock.signal()
            else:
                self.BKcurNo = self.BKcurNo - 1
                self.script_lock.signal()


    def movedown(self):
        if self.status==2:
            if (self.staSLNo < self.lastNo) or ( (self.staSLNo == self.lastNo) and (self.staLNNo < len(self.scrData[self.lastNo])) ):
                self.staSLNo=self.botSLNo
                self.staLNNo=self.botLNNo
                self.script_lock.signal()
        elif self.status==1:
            if self.BDexp < 0:
                if self.BDcurNo >= self.GYOU-1:
                    if len(self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+1:])>=self.GYOU:
                        self.BDstaNo=self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+1]
                        self.script_lock.signal()
                else:
                    self.BDcurNo=self.BDcurNo+1
                    self.script_lock.signal()
                    
            else:
                if self.SBcurNo >= self.GYOU-1:
                    if self.SBlastNo - self.SBstaNo>self.GYOU:
                        self.SBstaNo = self.SBstaNo+1
                        self.script_lock.signal()
                elif self.SBcurNo < self.SBlastNo-1:
                    self.SBcurNo=self.SBcurNo+1
                    self.script_lock.signal()
        elif self.status==3:
            if self.TXcurNo == self.GYOU-1:
                if len(self.subData)-self.TXstaNo > self.GYOU:
                    self.TXstaNo = self.TXstaNo + 1
                    self.script_lock.signal()
            elif self.TXcurNo<len(self.subData)-1:
                self.TXcurNo = self.TXcurNo + 1
                self.script_lock.signal()
        elif self.status==4:
            if self.BKcurNo == self.GYOU-1:
                if len(self.bookData)-self.BKstaNo > self.GYOU:
                    self.BKstaNo = self.BKstaNo + 1
                    self.script_lock.signal()
            elif self.BKcurNo<len(self.bookData)-1:
                self.BKcurNo = self.BKcurNo + 1
                self.script_lock.signal()


    def moveleft(self):
        if self.status==2:
            if self.staLNNo > 0:
                self.staLNNo=0
            elif self.staSLNo > 0:
                self.staSLNo=self.staSLNo-1
                self.staLNNo=0
            self.script_lock.signal()
        elif self.status==1:
            if self.BDexp>=0:
                self.BDexp=-1
                self.SBcurNo=0
                self.SBstaNo=0
                self.script_lock.signal()
        elif self.status==3:
            if self.TXcurNo == 0:
                if self.TXstaNo < self.GYOU-1 and self.TXstaNo > 0:
                    self.TXstaNo = 0
                    self.script_lock.signal()
                elif self.TXstaNo >= self.GYOU-1:
                    self.TXstaNo = self.TXstaNo - (self.GYOU-1)
                    self.script_lock.signal()
            else:
                self.TXcurNo = 0
                self.script_lock.signal()
        elif self.status==4:
            if self.BKcurNo == 0:
                if self.BKstaNo < self.GYOU-1 and self.BKstaNo > 0:
                    self.BKstaNo = 0
                    self.script_lock.signal()
                elif self.BKstaNo >= self.GYOU-1:
                    self.BKstaNo = self.BKstaNo - (self.GYOU-1)
                    self.script_lock.signal()
            else:
                self.BKcurNo = 0
                self.script_lock.signal()


    def moveright(self):
        if self.status==2:
            if self.staSLNo < self.lastNo-1:
                self.staSLNo=self.staSLNo+1
                self.staLNNo=0
            self.script_lock.signal()
        elif self.status==1:
            if self.BDexp<0:
                self.BDexp=self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo]
                if len(self.BDlastNo) > self.BDlastNo.index(self.BDstaNo)+self.BDcurNo+1:
                    self.SBlastNo=self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo+1] - self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo] - 1
                else:
                    self.SBlastNo=len(self.boardData) - self.BDlastNo[self.BDlastNo.index(self.BDstaNo)+self.BDcurNo] - 1
                self.script_lock.signal()
        elif self.status==3:
            if self.TXcurNo == self.GYOU-1:
                if len(self.subData)-self.TXstaNo > (self.GYOU-1)*2:
                    self.TXstaNo = self.TXstaNo + (self.GYOU-1)
                    self.script_lock.signal()
                elif len(self.subData)-self.TXstaNo <= (self.GYOU-1)*2 and len(self.subData)-self.TXstaNo > self.GYOU:
                    self.TXstaNo = len(self.subData)-self.GYOU
                    self.script_lock.signal()
            else:
                self.TXcurNo = self.GYOU-1
                self.script_lock.signal()
        elif self.status==4:
            if self.BKcurNo == self.GYOU-1:
                if len(self.bookData)-self.BKstaNo > (self.GYOU-1)*2:
                    self.BKstaNo = self.BKstaNo + (self.GYOU-1)
                    self.script_lock.signal()
                elif len(self.bookData)-self.BKstaNo <= (self.GYOU-1)*2 and len(self.bookData)-self.BKstaNo > self.GYOU:
                    self.BKstaNo = len(self.bookData)-self.GYOU
                    self.script_lock.signal()
            elif len(self.bookData)>(self.GYOU-1):
                self.BKcurNo = (self.GYOU-1)
                self.script_lock.signal()
            else:
                self.BKcurNo = len(self.bookData)-1
                self.script_lock.signal()


    def do_exit(self):
        self.infsave()
        self.exit_key_handler()


    def exit_key_handler(self):
        appuifw.app.exit_key_handler = None
        self.viewing=0
        self.script_lock.signal()


    def put(self, host, path, params, headers={}):
        c = httplib.HTTPConnection(host)
        c.request("POST", path, params, headers)
        r = c.getresponse()
        content = r.read()
        
        return {"status":r.status,
                "Set-Cookie":r.getheader("Set-Cookie"),
                "content":content}


    def get(self, host, path, headers={}):
        c = httplib.HTTPConnection(host)
        c.request("GET", path, "", headers)

        canvas.rectangle((0,(self.GYOU-1)*self.HABA,800,self.GYOU*self.HABA+2),fill=0x006400)
        canvas.text( (self.HABA*3,self.GYOU*self.HABA+1), unicode("Now loading..."), 0xFFD700, self.FONT)

        r = c.getresponse()
        # Read content
        content = r.read()
        if r.getheader("Content-Encoding","") == "gzip":
            content = self.gunzip(content)
        # Return response in dictionary
        
        return {"status":r.status,
                "last-modified":r.getheader("last-modified"),
                "content":content}


    def gunzip(self, data):
        return gzip.GzipFile(fileobj=StringIO(data)).read()


    def subread( self,subpath1,subpath2 ):
        
        try:
            f=open(self.path2ch+subpath1+'\\'+subpath2+'\\subject.txt','r')
            fData=f.read()
            f.close
            
            lnData=fData.split("\n")
            
            self.subData = []
            tmpA=0
            
            while tmpA < len(lnData)-1:
                if subpath1.find(unicode("machi.to"))>=0:
                    tmpC = lnData[tmpA].split("<>")
                    tmpB = tmpC[1],tmpC[2]
                else:
                    tmpB = lnData[tmpA].split("<>")
                self.subData.append(tmpB)
                tmpA = tmpA+1
            self.status=3
            self.BKstat=0
            self.TXcurNo=0
            self.TXstaNo=0
            appuifw.app.menu = [self.menu_find, self.menu_subupd, self.menu_adbook, self.menu_fdel, self.menu_board, self.menu_book, self.menu_exit]
            
        except:
            subque = appuifw.query(unicode("No subject.txt, download now?"), "query")
            if subque == 1:
                
                if subpath1.find(unicode("machi.to"))>=0:
                    url = "http://"+subpath1+"/bbs/offlaw.cgi/"+subpath2+"/"
                else:
                    url = "http://"+subpath1+"/"+subpath2+"/subject.txt"
                
                chdat = self.get(subpath1, url, {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
                
                chsta = chdat["status"]
                chmod = chdat["last-modified"]
                chhon = chdat["content"]
                
                if not(os.path.exists(self.path2ch+subpath1)):
                    os.mkdir(self.path2ch+subpath1)

                if not(os.path.exists(self.path2ch+subpath1+'\\'+subpath2)):
                    os.mkdir(self.path2ch+subpath1+'\\'+subpath2)
                
                f=open(self.path2ch+subpath1+'\\'+subpath2+'\\subject.txt','w')
                f.write(chhon)
                f.close

                lnData=chhon.split("\n")
                
                self.subData = []
                tmpA=0
                
                while tmpA < len(lnData)-1:
                    if subpath1.find(unicode("machi.to"))>=0:
                        tmpC = lnData[tmpA].split("<>")
                        tmpB = tmpC[1],tmpC[2]
                    else:
                        tmpB = lnData[tmpA].split("<>")
                    self.subData.append(tmpB)
                    tmpA = tmpA+1
                self.status=3
                self.BKstat=0
                self.TXcurNo=0
                self.TXstaNo=0
                appuifw.app.menu = [self.menu_find, self.menu_subupd, self.menu_adbook, self.menu_fdel, self.menu_board, self.menu_book, self.menu_exit]
            else:
                self.status=1
                appuifw.app.title=unicode("Board")


    def boardread(self):
        f=open(self.path2ch+'board.txt','r')
        fData=f.read()
        f.close
        
        lnData=fData.split("\n")
        
        self.boardData = []
        tmpA=0
        tmpB=0
        
        while tmpA < len(lnData)-1:
            if len(lnData[tmpA]) < 1:
                if len(lnData[tmpA+2]) < 1:
                    tmpA = tmpA+2
                else:
                    tmpC = lnData[tmpA+1], ""
                    self.boardData.append(tmpC)
                    self.BDlastNo.append(tmpB)
                    tmpA = tmpA+2
                    tmpB = tmpB+1
            else:
                tmpC = lnData[tmpA], lnData[tmpA+1], lnData[tmpA+2]
                self.boardData.append(tmpC)
                tmpA = tmpA+3
                tmpB = tmpB+1


    def bookread(self):
        f=open(self.path2ch+'bookmark.txt','r')
        fData=f.read()
        f.close
        
        lnData=fData.split("\n")
        
        self.bookData = []
        tmpA=0
        tmpB=len(lnData)-2
        
        while tmpA < (len(lnData)-1)/7:
            tmpBook = lnData[tmpB-6], lnData[tmpB-5], lnData[tmpB-4], lnData[tmpB-3], lnData[tmpB-2], lnData[tmpB-1], lnData[tmpB]
            self.bookData.append( tmpBook )
            tmpA=tmpA+1
            tmpB=tmpB-7


    def fileread(self,subpath1,subpath2,datname):
        try:
            if subpath1.find(unicode("machi.to"))>=0:
                f=open(self.path2ch+subpath1+'\\'+subpath2+'\\'+datname+'.dat','r')
            else:
                f=open(self.path2ch+subpath1+'\\'+subpath2+'\\'+datname,'r')
            fData=f.read()
            f.close
            
            infname=datname.split(".")
            f2=open(self.path2ch+subpath1+'\\'+subpath2+'\\info\\'+infname[0]+'.inf','r')
            f2data=f2.read()
            f2.close
            
            lnData=f2data.split('\n')
            self.datMod=lnData[0]
            self.staSLNo=int(lnData[1])
            self.lastBFNo=int(lnData[2])-1

        except:
            subque = appuifw.query(unicode("No datfile, download now?"), "query")
            if subque == 1:
                if subpath1.find(unicode("machi.to"))>=0:
                    url = "http://"+subpath1+"/bbs/offlaw.cgi/"+subpath2+"/"+datname+"/"
                else:
                    url = "http://"+subpath1+"/"+subpath2+"/dat/"+datname
                
                chdat = self.get(subpath1, url, {'User-Agent': UA,'Accept-Encoding': 'gzip'} )
                
                chsta = chdat["status"]
                self.datMod = chdat["last-modified"]
                chhon = chdat["content"]

                if not(os.path.exists(self.path2ch+subpath1)):
                    os.mkdir(self.path2ch+subpath1)

                if not(os.path.exists(self.path2ch+subpath1+'\\'+subpath2)):
                    os.mkdir(self.path2ch+subpath1+'\\'+subpath2)

                if not(os.path.exists(self.path2ch+subpath1+'\\'+subpath2+'\\info')):
                    os.mkdir(self.path2ch+subpath1+'\\'+subpath2+'\\info')
                
                infname=datname.split(".")
                f2=open(self.path2ch+subpath1+'\\'+subpath2+'\\info\\'+infname[0]+'.inf','w')
                f2.write(self.datMod+'\n'+'0'+'\n'+'0'+'\n')
                f2.close
                
                if subpath1.find(unicode("machi.to"))>=0:
                    f=open(self.path2ch+subpath1+'\\'+subpath2+'\\'+datname+'.dat','w')
                else:
                    f=open(self.path2ch+subpath1+'\\'+subpath2+'\\'+datname,'w')
                f.write(chhon)
                f.close
                self.staSLNo=0
                
                fData=chhon
                self.lastBFNo=-1
            else:
                if self.BKstat==0:
                    self.status=3
                else:
                    self.status=4
                return
        
        lnData=fData.split("\n")
        self.lastNo=len(lnData)-1
        
        self.scrData = [["" for tmpA in range(1)] for tmpB in range(len(lnData)-1)]
        
        for tmpC in range(self.lastNo):
            spData = lnData[tmpC].split("<>")
            tmpMachi = len(subpath1.split(unicode("machi.to")))
            if tmpMachi>1:
                spData = spData[1:]
            
            if len(spData) < 3:
                break
            
            if tmpC==0:
                self.titleData=spData[4]
                appuifw.app.title=unicode("["+str(self.lastNo)+"]"+self.titleData,'Shift_JIS','ignore')
            
            tmpData=spData[0].split("</b>")
            tmpData2=tmpData[0]
            if len(tmpData)>1:
                comData=tmpData[1].split("<b>")
                tmpData2=tmpData2+comData[0]+comData[1]
            
            if self.NAME==1:
                self.scrData[tmpC][0] = "%d: %s [%s] %s" % (tmpC+1, tmpData2, spData[1], spData[2])
            else:
                self.scrData[tmpC][0] = "%d: %s [%s]" % (tmpC+1, tmpData2, spData[1])
                self.scrData[tmpC].append("     "+spData[2])
            
            if tmpMachi>1:
                comData = spData[3].split("<br>")
            else:
                if spData[3][0]==" ":
                    comData = spData[3][1:].split(" <br> ")
                else:
                    comData = spData[3].split(" <br> ")
            
            for tmpD in range(len(comData)):

                tmpData = comData[tmpD].split("<")
                
                if len(tmpData) > 1:
                    
                    comData[tmpD]=""
                    
                    for tmpE in range(len(tmpData)):
                        tmpData2 = tmpData[tmpE].split(">")
                        if len(tmpData2) > 1:
                            comData[tmpD]="%s%s" % (comData[tmpD], tmpData2[1])
                        else:
                            comData[tmpD]="%s%s" % (comData[tmpD], tmpData2[0])
                
                tmpData = comData[tmpD].split("&lt;")
                
                if len(tmpData) > 1:
                    
                    comData[tmpD]=""
                    tmpE=0
                    
                    for tmpE in range(len(tmpData)):
                        if tmpE == 0:
                            comData[tmpD]=tmpData[0]
                        else:
                            comData[tmpD]="%s<%s" % (comData[tmpD], tmpData[tmpE])
                
                tmpData = comData[tmpD].split("&gt;")
                
                if len(tmpData) > 1:
                    
                    comData[tmpD]=""
                    tmpE=0
                    
                    for tmpE in range(len(tmpData)):
                        if tmpE == 0:
                            comData[tmpD]=tmpData[0]
                        else:
                            comData[tmpD]="%s>%s" % (comData[tmpD], tmpData[tmpE])
                
                tmpData = comData[tmpD].split("&quot;")
                
                if len(tmpData) > 1:
                    
                    comData[tmpD]=""
                    tmpE=0
                    
                    for tmpE in range(len(tmpData)):
                        if tmpE == 0:
                            comData[tmpD]=tmpData[0]
                        else:
                            comData[tmpD]='%s"%s' % (comData[tmpD], tmpData[tmpE])
                
                tmpST=0
                tmpED=self.MOJI
                
                while len(comData[tmpD][tmpST:]) > self.MOJI:
                    tmp29 = comData[tmpD][tmpST:tmpED-1]
                    tmp30 = comData[tmpD][tmpST:tmpED]
                    tmp31 = comData[tmpD][tmpST:tmpED+1]
                
                    if len(unicode(tmp30,'Shift_JIS','ignore')) == len(unicode(tmp31,'Shift_JIS','ignore')):
                        self.scrData[tmpC].append(tmp30)
                        tmpST=tmpST+self.MOJI
                        tmpED=tmpED+self.MOJI
                    elif len(unicode(tmp29,'Shift_JIS','ignore')) == len(unicode(tmp30,'Shift_JIS','ignore')):
                        self.scrData[tmpC].append(tmp31)
                        tmpST=tmpST+self.MOJI+1
                        tmpED=tmpED+self.MOJI+1
                    else:
                        self.scrData[tmpC].append(tmp30)
                        tmpST=tmpST+self.MOJI
                        tmpED=tmpED+self.MOJI
                
                self.scrData[tmpC].append(comData[tmpD][tmpST:])
            
            self.scrData[tmpC].append(' ')

        self.status=2
        self.staLNNo=0
        self.botSLNo=0
        self.botLNNo=0

        if self.BKstat==0:
            appuifw.app.menu = [self.menu_find, self.menu_jump, (u"Open URL",(self.menu_serchcont,self.menu_serchurl,self.menu_google,self.menu_openurl)), self.menu_postcom, self.menu_datupd, self.menu_board, self.menu_subject, self.menu_book, self.menu_exit]
        else:
            appuifw.app.menu = [self.menu_find, self.menu_jump, (u"Open URL",(self.menu_serchcont,self.menu_serchurl,self.menu_google,self.menu_openurl)), self.menu_postcom, self.menu_datupd, self.menu_board, self.menu_book, self.menu_exit]
        
        return


    def draw_state(self):
        
        canvas.clear()
        
        #Slead View
        if self.status==2:
            dsA=self.staSLNo
            dsB=self.staLNNo
            dsY=0
            
            while dsY < self.GYOU:
                while dsB < len(self.scrData[dsA]):
                    if dsB==0:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(self.scrData[dsA][dsB],'Shift_JIS','ignore'), 0x008000, self.FONT)
                        if dsA>self.lastBFNo:
                            canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(str(dsA+1),'Shift_JIS','ignore'), 0xFF0000, self.FONT)
                        dsY=dsY+1
                    elif dsB==1 and self.NAME!=1:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(self.scrData[dsA][dsB],'Shift_JIS','ignore'), 0x008000, self.FONT)
                        dsY=dsY+1
                    else:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(self.scrData[dsA][dsB],'Shift_JIS','ignore'), 0x000000, self.FONT)
                        dsY=dsY+1
                    dsB=dsB+1
                
                if dsY > (self.GYOU-1):
                    break
                dsA=dsA+1
                if dsA>=self.lastNo:
                    dsA=dsA-1
                    break
                dsB=0
                
            self.botSLNo=dsA
            if dsY < self.GYOU:
                self.botLNNo=len(self.scrData[self.botSLNo])-2
            else:
                self.botLNNo=dsB-(dsY-(self.GYOU-1))
                if self.botLNNo<0:
                    self.botLNNo=0
        
        #Post view
        elif self.status==5:
            dsY=0
            while dsY < len(self.putData):
                if dsY==0:
                    canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(self.putData[dsY]+"["+self.putData[dsY+1]+"]"), 0x008000, self.FONT)
                    dsY=dsY+2
                else:
                    canvas.text( (1,(dsY-1)*self.HABA+self.HABA+1), unicode("%2d:"%(dsY-1)+self.putData[dsY]), 0x000000, self.FONT)
                    dsY=dsY+1
        
        #Board Title
        elif self.status==1:
            dsA=self.BDstaNo
            dsY=0
            
            if self.BDexp>=0:
                canvas.rectangle((0,0,self.B_HABA,800),fill=0xAAAAAA) #*0.4.3 m
            else:
                canvas.rectangle((self.B_HABA,0,800,800),fill=0xAAAAAA) #*0.4.3 m
            
            dsB=0 #*01 masa
            
            while dsY < self.GYOU:
                if self.BDlastNo[len(self.BDlastNo)-1] > self.BDlastNo[self.BDlastNo.index(dsA)]:
                    tmpStr = self.boardData[dsA][0]
                    if dsY == self.BDcurNo:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0xFF0000, self.FONT)
                        dsB=dsA
                    else:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0x000000, self.FONT)
                    dsA=self.BDlastNo[self.BDlastNo.index(dsA)+1]
                    dsY=dsY+1
                elif self.BDlastNo[len(self.BDlastNo)-1] == self.BDlastNo[self.BDlastNo.index(dsA)]:
                    tmpStr = self.boardData[dsA][0]
                    if dsY == self.BDcurNo:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0xFF0000, self.FONT)
                        dsB=dsA
                    else:
                        canvas.text( (1,dsY*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0x000000, self.FONT)
                    break

            dsA=dsB+self.SBstaNo+1
            if len(self.BDlastNo) > self.BDlastNo.index(dsB)+1:
                dsY=self.BDlastNo[self.BDlastNo.index(dsB)+1]
            else:
                dsY=len(self.boardData)
            
            dsB=0
            
            while dsY>dsA and dsB<self.GYOU:
                tmpStr = self.boardData[dsA][0]
                if self.BDexp>=0 and dsB == self.SBcurNo:
                    canvas.text( (self.B_HABA+5,dsB*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0xFF0000, self.FONT) #*0.4.3 m
                else:
                    canvas.text( (self.B_HABA+5,dsB*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0x000000, self.FONT) #*0.4.3 m
                dsA=dsA+1
                dsB=dsB+1
        
        #Slead Title
        elif self.status==3:
            canvas.rectangle((0,0,self.HABA*2+2,500),fill=0xAAAAAA) #*0.4.3 masa
            dsA=self.TXstaNo
            dsY=0
            while dsY < self.GYOU:
                tmpStr = self.subData[dsA][1]
                if dsY == self.TXcurNo:
                    canvas.text( (1,dsY*self.HABA+self.HABA+1), "%4d  %s" % (dsA+1,unicode(tmpStr,'Shift_JIS','ignore')), 0xFF0000, self.FONT) #*0.4.3 masa
                else:
                    canvas.text( (1,dsY*self.HABA+self.HABA+1), "%4d  %s" % (dsA+1,unicode(tmpStr,'Shift_JIS','ignore')), 0x000000, self.FONT) #*0.4.3 masa
                dsA=dsA+1
                dsY=dsY+1
                if dsA>=len(self.subData):
                    break
        
        #Bookmark
        elif self.status==4 or self.status==0:
            dsA=self.BKstaNo
            dsY=0
            while dsY < self.GYOU:
                if int(self.bookData[dsA][6])==200 or int(self.bookData[dsA][6])==206:
                    canvas.rectangle((0,dsY*self.HABA+1,self.HABA*2+2,dsY*self.HABA+self.HABA+1),fill=0xFFA500)
                elif int(self.bookData[dsA][6])==302 or int(self.bookData[dsA][6])==404:
                    canvas.rectangle((0,dsY*self.HABA+1,self.HABA*2+2,dsY*self.HABA+self.HABA+1),fill=0xDDA0DD)
                elif int(self.bookData[dsA][6])==416:
                    canvas.rectangle((0,dsY*self.HABA+1,self.HABA*2+2,dsY*self.HABA+self.HABA+1),fill=0xBC8F8F)
                else:
                    canvas.rectangle((0,dsY*self.HABA+1,self.HABA*2+2,dsY*self.HABA+self.HABA+1),fill=0xAAAAAA)
                
                if int(self.bookData[dsA][5])==1:
                    canvas.rectangle((self.HABA*2+2,dsY*self.HABA+1,800,dsY*self.HABA+self.HABA+1),fill=0x90EE90)
                
                tmpStr = self.bookData[dsA][4]
                if dsY == self.BKcurNo:
                    canvas.text( (1,dsY*self.HABA+self.HABA+1), "%4d  %s" % (dsA+1,unicode(tmpStr,'Shift_JIS','ignore')), 0xFF0000, self.FONT) #*0.4.3 masa
                else:
                    canvas.text( (1,dsY*self.HABA+self.HABA+1), "%4d  %s" % (dsA+1,unicode(tmpStr,'Shift_JIS','ignore')), 0x000000, self.FONT) #*0.4.3 masa
                dsA=dsA+1
                dsY=dsY+1
                if dsA>=len(self.bookData):
                    break
            
            dsA=self.BKstaNo
            dsY=0
            while dsY < self.GYOU:
                canvas.rectangle((self.BKITA-1,dsY*self.HABA+1,self.BKITA+200,dsY*self.HABA+self.HABA+1),fill=0xADD8E6)
                tmpStr = self.bookData[dsA][3]
                if dsY == self.BKcurNo:
                    canvas.text( (self.BKITA,dsY*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0xFF0000, self.FONT)
                else:
                    canvas.text( (self.BKITA,dsY*self.HABA+self.HABA+1), unicode(tmpStr,'Shift_JIS','ignore'), 0x000000, self.FONT)
                dsA=dsA+1
                dsY=dsY+1
                if dsA>=len(self.bookData):
                    break


window=st2ch()
window.confread()
window.boardread()

appuifw.app.exit_key_handler = window.script_lock.signal
appuifw.app.screen='normal'
canvas=appuifw.Canvas(redraw_callback=lambda rect:window.draw_state())
appuifw.app.body=canvas
appuifw.app.menu=[window.menu_book, window.menu_boardupd, window.menu_srvmove, window.menu_exit]
appuifw.app.title=unicode("Board")

window.rot_port()

window.viewing=1
while window.viewing:
    appuifw.app.exit_key_handler = window.backstate
    window.draw_state()
    window.script_lock.wait()
window.rot_normal()

