# -*- coding: utf-8 -*-

# 東京　日の出、日の入り、月の出、月の入り時刻、月齢を表示する

__scriptname__ = 'PySunMoon'
__Ver__        = '0.02(0)'
__Copyright__  = '(c) 2016-2017 masa'
__web__        = 'http://masaland.cocolog-nifty.com/'

import sys
import os
import os.path
if not hasattr(sys, "setdefaultencoding"):
    wk = sys.stdout
    reload(sys)
    sys.stdout = wk
sys.setdefaultencoding('utf-8')
if os.path.isdir('E:\\Python\\lib') :
    if not ('E:\\Python\\lib' in [sys.path[0]]):
        sys.path.insert(0, 'E:\\Python\\lib')

import e32
import re
import urllib
import japanese
import appuifw

if e32.pys60_version_info[0] == 2: #pys60 2.x.x
    import btsocket
    socket = btsocket
else:
    import socket

#------------------------------
APID = 3
URL = 'http://eco.mtk.nao.ac.jp/cgi-bin/koyomi/sunmoon.cgi?id=13'
#id=13 東京
#------------------------------

textbody = appuifw.Text()
textbody.color = 0x000000
textbody.font = 'title'
appuifw.app.body = textbody
script_lock = e32.Ao_lock()

def disp_msg(msg):
    global textbody
    textbody.add(msg)
    textbody.add(u'\n')

def about():
    msg =     (__scriptname__) \
     + '\n' + ('Ver_' + __Ver__) \
     + '\n' + (__Copyright__) \
     + '\n' + (__web__ )
    appuifw.query(unicode(msg, "utf-8"), "query")



pysunmoon_timer = e32.Ao_timer()


def com_timeout():
    msg = u'Time out error!'
    disp_msg(msg)
    appuifw.note(unicode("WEBアクセスでタイムアウトが発生しました", "utf-8"), "error", True)
    e32.ao_sleep(2)
    script_lock.signal()
    sys.exit()


def main():
    """メインの関数"""
    global textbody, APID, URL

    apid = socket.select_access_point()  #socket(Python 1.4.x) or btsocket(2.0.0)
    if apid == None: #AP select canceled
        pass
    else:
        APID = apid
        ap = socket.access_point(APID) #socket(Python 1.4.x) or btsocket(2.0.0)
        socket.set_default_access_point(ap)

    pysunmoon_timer.after(10,com_timeout)
    F = urllib.urlopen(URL)
    html = F.read()
    pysunmoon_timer.cancel()
    tmptext = re.sub(r'\n', '', html.decode('euc-jp'))
    tmptext = re.sub(u'<.+?>', u'', tmptext) #タグ削除
    tmptext = re.sub('.+?\)[\s][\s][\s][\s]*?', u'', tmptext) #先頭の不要文字削除

    ptn = ('([^\s]+?\))').decode('UTF-8') #地名抽出
    Lplace = re.findall(ptn, tmptext)
    if len(Lplace) > 0:
        Place = Lplace[0]

    Lname = ['日の出　：',
             '日南中時：',
             '日の入り：',
             '月の出　：',
             '月南中時：',
             '月の入り：',
             '正午月齢：'
             ]
    pt = [0,0,0,0,0,0,0]
    Ltime = [0,0,0,0,0,0,0]
    pt[0] = ('日の出([\s0-9:]{5})').decode('UTF-8')
    pt[1] = ('日南中時([\s0-9:]{5})').decode('UTF-8')
    pt[2] = ('日の入り([\s0-9:]{5})').decode('UTF-8')
    pt[3] = ('月の出([\s0-9:]{5})').decode('UTF-8')
    pt[4] = ('月南中時([\s0-9:]{5})').decode('UTF-8')
    pt[5] = ('月の入り([\s0-9:]{5})').decode('UTF-8')
    pt[6] = ('正午月齢\(([\s0-9.]{4})\)').decode('UTF-8')

    for i in range(7):
        Ljikoku = re.findall(pt[i], tmptext)
        if len(Ljikoku) > 0:
            Ltime[i] = Ljikoku[0]
        else:
            Ltime[i] = u'no data'

    spacer = ('　').decode('UTF-8')
    disp_msg(spacer+Place)
    for i in range(7):
        msg = Lname[i] + Ltime[i] # + '\n'
        disp_msg(msg)
    textbody.set_pos(0)

if __name__ == '__main__':
    old_body = appuifw.app.body
    old_title = appuifw.app.title
    appuifw.app.title = unicode(__scriptname__)
    appuifw.app.exit_key_handler = lambda:script_lock.signal()

    appuifw.app.menu = [(u'About',lambda:about() ),
                        (u'Exit', lambda:script_lock.signal())]
    main()
    script_lock.wait()
    appuifw.app.title = old_title
    appuifw.app.body = old_body

#appuifw.app.set_exit()
#sys.exit()
