# -*- coding:utf-8 -*-

# PyStnCurrency
# SYMBIAN_UID = 0xecd49d13
# web = "http://masaland.cocolog-nifty.com/"
#
__scriptname__ = 'PyStnCurrency'
__version__ = '0.03(0)'
__author__ = 'masa (http://masaland.cocolog-nifty.com/)'
__copyright__ = 'masa 2013'

"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU General Public License version 2 or later.

"""

import sys, os
sys.setdefaultencoding('utf-8')
if os.path.isdir('E:\\Python\\lib') :
    sys.path.insert(0, 'E:\\Python\\lib')

import e32
import os.path
import socket
import urllib
import appuifw
import re
import time

Debug_in  = 0 #*
Debug_out = 0 #*
# Debug output file
#   E:/Data/Currencytest0.htm

# 変数、定数（グローバル）
DAT_FILE = "" # 後で作成する（通常 E:\Data\Hiisi\PyStation\PyStnCurrency.dat）
FILE_NAME = "PyStnCurrency" # DAT_FILE にするファイル名 cfgファイルの設定が優先
VIEW_MODE = 1 # 1: 取得後画面に表示する　0: 表示しないで終了する
# DAT_FILEに出力するときの項目名
EN_NAME_MASTER = {"米ﾄﾞﾙ": "USD", "ﾕｰﾛ": "EUR", "英ﾎﾟﾝﾄﾞ": "GBP", "豪ﾄﾞﾙ": "AUD",
              "ｶﾅﾀﾞﾄﾞﾙ": "CAD", "NZﾄﾞﾙ": "NZD", "香港ﾄﾞﾙ": "HKD", "南ｱﾗﾝﾄﾞ": "SAR",
              "ﾌﾞﾗｼﾞﾙﾚｱﾙ": "BZR", "ﾄﾙｺﾘﾗ": "TKL", "ｲﾝﾄﾞﾈｼｱﾙﾋﾟｱ": "INR","ﾒｷｼｺﾍﾟｿ": "MXP"}

MEIGARA_CODE = "米ﾄﾞﾙ,ﾕｰﾛ,英ﾎﾟﾝﾄﾞ,豪ﾄﾞﾙ,ｶﾅﾀﾞﾄﾞﾙ,NZﾄﾞﾙ,香港ﾄﾞﾙ,南ｱﾗﾝﾄﾞ,ﾌﾞﾗｼﾞﾙﾚｱﾙ,ﾄﾙｺﾘﾗ,ｲﾝﾄﾞﾈｼｱﾙﾋﾟｱ,ﾒｷｼｺﾍﾟｿ"
# 表示したい通貨は、下記から選んで上の「MEIGARA_CODE」、または PyStation.cfg に
# コピー・ペーストすること。（正確でないと検出できないため）
# 注１：記述した順番で表示される。注２：PyStation.cfg の設定が優先される。
# 米ﾄﾞﾙ,ﾕｰﾛ,英ﾎﾟﾝﾄﾞ,豪ﾄﾞﾙ,ｶﾅﾀﾞﾄﾞﾙ,NZﾄﾞﾙ,香港ﾄﾞﾙ,南ｱﾗﾝﾄﾞ,ﾌﾞﾗｼﾞﾙﾚｱﾙ,ﾄﾙｺﾘﾗ,ｲﾝﾄﾞﾈｼｱﾙﾋﾟｱ,ﾒｷｼｺﾍﾟｿ

MARKET_CURRENCY = "JPY 1 1 #market"
# 野村證券 Data 20 minutes delayed
NEWS_URL = 'http://advance.quote.nomura.co.jp/meigara/nomura_mobile/QSearch.exe?F=Epforex'


try:
    import ConfigParser
except:
    appuifw.note(unicode('ConfigParserモジュールが見つかりません。'), 'error')
    raise
try:
    import appswitch
    ISAPPSWITCH = 1
    def switch_to_fg():
        appswitch.switch_to_fg(u'PyStnCurrency') #*
    def switch_to_bg():
        appswitch.switch_to_bg(u'PyStnCurrency') #*
except ImportError:
    ISAPPSWITCH = 0
try:
    import waplib
    ISWAPLIB = 1
except ImportError:
    ISWAPLIB = 0
try:
    import japanese
#    try:
#        japanese.aliases.encodings.aliases.aliases['sjis'] = \
#         'japanese.shift_jis_docomo'
#        '\xf8\x9f'.decode('sjis')
#        
#    except:
#        raise ImportError
except ImportError:
#    appuifw.note(unicode('JapaneseCodecs+emojiが見つかりません。'), 'error', 1)
    appuifw.note(unicode('JapaneseCodecsが見つかりません。'), 'error', 1)
    raise


class ConfigError(Exception):
    """設定エラー"""
    def __init__(self):
        pass
    def __str__(self):
        return repr(u'Configuration is incomplete.')

# データフォルダ
DATA_PATH = u'E:\\Data\\Hiisi\\PyStation'
if not os.path.exists(DATA_PATH):
    DATA_PATH = u'C:\\Data\\Hiisi\\PyStation'
    if not os.path.isdir(DATA_PATH):
        # データ保存に利用するドライブを選択
        drives = []
        if u'C:' in e32.drive_list():
            drives.append(u'C:\\Data\\Hiisi\\PyStation')
        if u'E:' in e32.drive_list():
            drives.append(u'E:\\Data\\Hiisi\\PyStation')
        drive = appuifw.popup_menu(drives,
                                   unicode('設定データ保存場所'))
        if drive == 0:
            DATA_PATH = u'C:\\Data\\Hiisi\\PyStation'
        elif drive == 1:
            DATA_PATH = u'E:\\Data\\Hiisi\\PyStation'
        else:
            appuifw.note(unicode('設定ファイルを作成できません。'), 'error')
            raise ConfigError
        try:
            os.makedirs(DATA_PATH)
        except OSError:
            appuifw.note(unicode('設定ファイルを作成できません。'), 'error')
            raise

# 設定ファイル
CFG_FILE = os.path.join(DATA_PATH, u'PyStation.cfg')
if os.path.isfile(CFG_FILE):
    cfg = ConfigParser.ConfigParser()
    cfg.read(CFG_FILE)
    write_f = ''
    try:
        APID = int(cfg.get('PyStation', 'APID'))
    except (ConfigParser.NoSectionError):
        APID = socket.select_access_point()
        if APID:
            cfg.add_section('PyStation')
            cfg.set('PyStation', 'APID', APID)
            write_f = 1
        else:
            raise ConfigError
    except (ConfigParser.NoOptionError):
        APID = socket.select_access_point()
        if APID:
            cfg.set('PyStation', 'APID', APID)
            write_f = 1
        else:
            raise ConfigError
    except:
        raise

    try:
        MEIGARA_CODE  = cfg.get('PyStation Currency', 'meigara_code')
    except (ConfigParser.NoSectionError):
        pass
    except (ConfigParser.NoOptionError):
        pass
    except:
        raise

    try:
        VIEW_MODE  = int(cfg.get('PyStation Currency', 'view_mode'))
    except (ConfigParser.NoSectionError):
        pass
    except (ConfigParser.NoOptionError):
        pass
    except:
        raise

    try:
        FILE_NAME  = cfg.get('PyStation Currency', 'file_name')
    except (ConfigParser.NoSectionError):
        pass
    except (ConfigParser.NoOptionError):
        pass
    except:
        raise

    if write_f:
        f = open(CFG_FILE, 'w')
        cfg.write(f)
        f.close()

else:
    try:
        APID = socket.select_access_point()
        if APID:
            cfg = ConfigParser.ConfigParser()
            cfg.add_section('PyStation')
            cfg.set('PyStation', 'APID', APID)
            f = open(CFG_FILE, 'w')
            cfg.write(f)
            f.close()
        else:
            raise ConfigError
    except:
        raise


# 表示する銘柄のコードリスト作成
meigara_code_list = []
meigara_code_list = [x.strip() for x in unicode(MEIGARA_CODE).split(u",") if len(x) > 1]

# 出力HTMLファイル
OUT_FILE = os.path.join(DATA_PATH, u'%s.html' % __scriptname__)
# レート出力DATファイル
if FILE_NAME:
    DAT_FILE = os.path.join(DATA_PATH, u'%s.dat' % FILE_NAME)
else:
    DAT_FILE = os.path.join(DATA_PATH, u'%s.dat' % __scriptname__)

#if os.path.exists(OUT_FILE):
if 1:
    try:
        f = open(OUT_FILE, 'w')
        f.write('<?xml version="1.0"?>\r\n')
        f.write('<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.1//EN" ')
        f.write('"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">\r\n')
        f.write('<html xmlns="http://www.w3.org/1999/xhtml" ')
        f.write('xml:lang="ja">\r\n')
        f.write('<head>\r\n')
        f.write('<meta http-equiv="Content-Type" ')
        f.write('content="text/html; charset=UTF-8" />\r\n')
        f.write('<title>PyStation Currency</title>\r\n')
        f.write('</head>\r\n')
        f.write('<body>\r\n')
        f.write('<h1>通貨レート</h1>\r\n')
        f.write('<p>接続エラー！　　または<br />データエラー！<br /><br />もう一度接続してください。</p>\r\n')
        f.write('<hr />\r\n')
        f.write('<p><a href="./PyStation.html">戻る</a></p>\r\n')
        f.write('</body>\r\n')
        f.write('</html>')
        f.close()
    except IOError:
        pass


def fetch():
    """ニュースを取得する"""
    if ISWAPLIB and APID == waplib.APID_WAP:
        waplib.wap_connection({'Accept-Charset': 'Shift_JIS'})
    ap = socket.access_point(APID)
    socket.set_default_access_point(ap)

    try:
        if not Debug_in: #*
            f = urllib.urlopen(NEWS_URL)
            data = f.read().decode('sjis')
            f.close()

        else:
            F = open('E:\\Data\\Currencytest0.htm')
            data = F.read().decode('sjis')
            F.close()

        if Debug_out and not Debug_in: #*
            wk = data.encode('sjis')
            F = open('E:\\Data\\Currencytest0.htm', 'w')
            F.write(wk)
            F.close()
        return data
    except:
        raise

def parse(data):
    """通貨名を探して、通貨毎のデータに切り出す"""
    f1 = unicode(">■円/", "UTF-8") #それぞれの先頭
    f2 = unicode("情報提供：", "UTF-8")   #最後（次の項目)

    pattern1 = re.compile(f1, re.I)
    pattern2 = re.compile(f2, re.I)

    start_list = []
    find_list = pattern1.finditer(data, 0)  #find all
    for x in find_list: #call iter. and get result one by one
        r_p = x.start()                       #position
        start_list.append(r_p)

    find_list = pattern2.search(data, 0)
    r_p = find_list.start()
    start_list.append(r_p)
    start_list.sort()

    data_list = []
    if len(start_list) > 1:
        for n in range(1, len(start_list)):
            data_list.append(data[start_list[n-1]:start_list[n]])
    """切り出し終わり"""

    """	通貨レート、発表日時を取り出す"""
    rate_dic = {} #キー（順番）、通貨名、レート1、レート2のディクショナリ
    if len(data_list)>0:
        #発表日時の取りだし
        datawk = data_list[0] 
        wk1 = re.findall(unicode('\[\d+/(\d+)/(\d+).*?;(\d+:\d+)\]'), datawk) 
          #return of findall is "list of tupple"
        if len(wk1) > 0 and len(wk1[0]) > 2:
            news_date = [int(wk1[0][0]), int(wk1[0][1]), wk1[0][2]]
        else:
            news_date = ["--", "--", "--:--"]

        """	通貨レートを取り出す"""
        """datalist[0]からひとつずつ処理する"""

        for i in range(len(data_list)):
            datawk = data_list[i]

            """ 通貨切り出し """
            wk1 = re.findall(unicode(">■円/(.+?)<", "UTF-8"), datawk)
            wk2 = re.findall(unicode("[ \t]*([0-9.]+?)-([0-9.]+?)<", "UTF-8"), datawk)

            if wk1 : #取りだしOK
                # MEIGARA_CODEに指定されている通貨かチェック
                wk_meigara = wk1[0]
                try:
                    idx = meigara_code_list.index(wk_meigara)
                except:
                    idx = None

                if idx != None and wk2 :
                    rate_dic[idx] = [(wk1[0]).encode("UTF-8"),
                                     str((wk2[0][0]).encode("UTF-8")),
                                     str((wk2[0][1]).encode("UTF-8"))]

    if rate_dic: # データがある
        rate_key = rate_dic.keys()
        rate_key.sort()
        year, month, day, hour, minute, sec = get_time()
        try:
            f = open(OUT_FILE, 'w')
            f.write('<?xml version="1.0"?>\r\n')
            f.write('<!DOCTYPE HTML PUBLIC ')
            f.write('"-//W3C//DTD XHTML 1.1//EN" ')
            f.write('"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">')
            f.write('\r\n')
            f.write('<html xmlns="http://www.w3.org/1999/xhtml" ')
            f.write('xml:lang="ja">\r\n')
            f.write('<head>\r\n')
            f.write('<meta http-equiv="Content-Type" ')
            f.write('content="text/html; charset=UTF-8" />\r\n')
            f.write('<title>PyStation Currency</title>\r\n')
            f.write('</head>\r\n')
            f.write('<body>\r\n')
            f.write('<font size="+0"><B>通貨レート</B></font>\r\n')
            f.write('<font size="+0"> (%s月%s日 %s)</font><br>\r\n' % 
                            (news_date[0], news_date[1], news_date[2]))

            f.write('<hr />\r\n')
            f.write('<TABLE border="0">')
            f.write('<TBODY>')
            # 表にして書き出す。meigara_code_listで指定されていて、検出できなかった
            # 通貨のレートは"---"にして出力する
            i, j, k = 0, 0, 0
            while i < len(meigara_code_list):
                if j < len(rate_key):
                    k = rate_key[j]
                else:
                    k = 100 # リストにはない長さの添え字にする

                f.write('<TR>')
                if k == i :
                    f.write('<TD>%s</TD> <TD>　</TD> <TD align="right">%s</TD> <TD>　</TD><TD align="right">%s</TD> \r\n'
                       % (rate_dic[k][0], rate_dic[k][1], rate_dic[k][2]))
                    i, j = i+1, j+1
                else:
                    f.write('<TD>%s</TD> <TD>　</TD> <TD align="right">%s</TD> <TD>　</TD><TD align="right">%s</TD> \r\n'
                       % (meigara_code_list[i], "---", "---"))

                    i = i+1
                f.write('</TR>')

            f.write('  </TBODY>')
            f.write('</TABLE>')
            f.write('<hr />\r\n')
            f.write('<a href="./PyStation.html">戻る</a><br />\r\n')
            f.write('<a href="%s">' % NEWS_URL)
            f.write('野村證券 為替情報</a>')
            f.write('<br>更新時刻：%d月%d日　%d:%02d\r\n' \
                             % (month, day, hour, minute))
            f.write('</body>\r\n')
            f.write('</html>')
            f.close()
        except IOError:
            pass
        except:
            f.close()
            raise

        # write "rate data" to DAT_FILE
        data = MARKET_CURRENCY # マーケットの中心通貨（1行目のデータ）
        for x in rate_key:
            data = data + "\n" + EN_NAME_MASTER[rate_dic[x][0]] + " " + rate_dic[x][1] \
               + " " + rate_dic[x][2] + " #" + rate_dic[x][0] + "\n"
        if data:
            try:
                Fo = open(DAT_FILE, 'w')
                Fo.write(data)
                Fo.close()
            except IOError:
                pass
            except:
                Fo.close()
                raise

        return True
    else:
        return False


def check_sig():
    """電波状況の確認"""
    import sysinfo
    try:
        sig = sysinfo.signal_bars()
    except:
        return 0
    else:
        if sig:
            return 1
        else:
            return 0

def get_time():
    """現在時刻の取得"""
    year = int(time.strftime('%Y', time.localtime()))
    month = int(time.strftime('%m', time.localtime()))
    day = int(time.strftime('%d', time.localtime()))
    hour = int(time.strftime('%H', time.localtime()))
    minute = int(time.strftime('%M', time.localtime()))
    sec = int(time.strftime('%S', time.localtime()))
    return (year, month, day, hour, minute, sec)


def main():
    """メインの関数"""
    if VIEW_MODE :
        textbody = appuifw.Text()
        appuifw.app.body = textbody
        textbody.color = 0x000000
        textbody.set(unicode('    PystnCurrecy\n\n    データ取得中', "UTF-8"))
        e32.ao_yield() # 画面反映
    else:
        # バックグラウンドに移動
        if ISAPPSWITCH: switch_to_bg()
    appuifw.app.title = unicode("PyStnCurrency", "utf-8")

    if check_sig():

        try:
            data = fetch()
            if data:
                news = parse(data)
                if news:
                    pass # 表示は下に移動
        except:
            raise

    if VIEW_MODE :
        textbody.set(unicode('    PystnCurrecy\n\n', "UTF-8"))
        e32.ao_yield() # 画面反映
        # フォアグラウンドに移動
        if ISAPPSWITCH: switch_to_fg()

        # 表示（結果、またはエラー画面）
        e32.start_exe('BrowserNG.exe', ' "file:///' + OUT_FILE + '"', 1)
    # end of main


if __name__ == '__main__':
    main()

#    appuifw.app.set_exit()
#    sys.exit()
