#-*- coding:utf-8 -*-

"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU Lesser General Public License version 2.1 or later.

  name      = PyFbuiutil
  version   = 0.01(1)
  author    = masa
  web__     = http://masaland.cocolog-nifty.com/
  Copyright = Copyright (c) 2009 masa
"""

import sys
sys.setdefaultencoding('utf-8')
sys.path.insert(0, 'E:\\Python\\lib')
import os
import appuifw
import e32
import dir_iter
import re
import types
from key_codes import EKeyLeftArrow
from key_codes import EKeyRightArrow

appuifw2_exist = 0
try:
    import appuifw2
    #appuifw = appuifw2
    appuifw2_exist = 1
except ImportError:
    #pass
    appuifw2_exist = 0

class Fbrowser:
    """
    use this class to browse and select files.
    after selected, file path will return.
    """
    def __init__(self, title):
        self.lock = e32.Ao_lock()
        self.dir_stack = []
        self.current_dir = dir_iter.Directory_iter(e32.drive_list())
        self.title = title
        self.entries = []
        self.entrylist = []


    def search_id(self, dir):
        ent = self.current_dir.list_repr()
        #if not self.current_dir.at_root:     # don't inset "."  and "..",
        #    list.insert(0, (u"."))           # this is only memo
        #    list.insert(0, (u".."))          # *1
        ent = [x[0] for x in ent]
        entlist = [x for x in ent]
        ent = self.sort_list(ent)

        #change name's string into upper_case
        for n in range(len(ent)):
            ent[n] = ent[n].upper()
        for n in range(len(entlist)):
            entlist[n] = entlist[n].upper()
        dir = dir.upper()
        #
        try:
            disp_id = ent.index(dir)
            id = entlist.index(dir)
        except:
            disp_id = None
            id = None
        return disp_id, id

    def go_default(self, default_path=None):
        if not default_path: return
        def_path = os.path.normpath(default_path)
        if not type(def_path) == types.UnicodeType:
            def_path = unicode(def_path)  #given def_path is not in unicode

        self.dir_stack = []
        self.current_dir = dir_iter.Directory_iter(e32.drive_list())

        if not os.path.isdir(def_path):
            rtn = appuifw.query(unicode('No default dir\n')+def_path,'query')
            return

        msg = 'Check chars upper/lower of'
        wk = def_path.split("\\")
        for x in wk:
            if x:  #when "." selected  ,splited last item is [] (enpty item)
                if self.current_dir.at_root:
                    disp_id, id = self.search_id(x) # C:/E:
                    if not id == None:
                        self.current_dir.add(id)
                        self.dir_stack.append(disp_id)
                    else:#  differ char upper/lower case 
                        rtn = appuifw.query(unicode(msg + '\n')+ x, 'query')
                        #self.dir_stack = []
                        #self.current_dir = dir_iter.Directory_iter(e32.drive_list())
                        return
                else:
                    disp_id, id = self.search_id("["+ x +"]")
                    if not id == None:
                        self.current_dir.add(id)
                        self.dir_stack.append(disp_id + 2)  # +2 for "." and ".." *1
                    else: # differ char upper/lower case
                        rtn = appuifw.query(unicode(msg + '\n')+ x,'query')
                        #self.dir_stack = []
                        #self.current_dir = dir_iter.Directory_iter(e32.drive_list())
                        return


    def select(self, default_path=None):
        #from key_codes import EKeyLeftArrow
        #from key_codes import EKeyRightArrow
        self.selection = None
        if default_path != None:
            self.go_default(default_path)

        self.list_setup()
        if appuifw2_exist == 1:
            self.lb = appuifw2.Listbox(self.entries, self.lbox_observe)
        else:
            self.lb = appuifw.Listbox(self.entries, self.lbox_observe)
        self.lb.bind(EKeyLeftArrow, lambda: self.lbox_observe(1))
        self.lb.bind(EKeyRightArrow, lambda: self.lbox_observe(2))
        old_title = appuifw.app.title
        self.refresh()
        self.lock.wait()
        appuifw.app.title = old_title
        appuifw.app.body = None
        self.lb = None
        return self.selection

    def refresh(self):
        appuifw.app.title = unicode(self.title)
        appuifw.app.menu = []
        appuifw.app.exit_key_handler = self.do_cancel
        appuifw.app.body = self.lb

    def list_setup(self):
        self.entries = self.current_dir.list_repr()
        if not self.current_dir.at_root:
            self.entries.insert(0, (u".", u""))
            self.entries.insert(0, (u"..", u""))
            self.entries = [x[0] for x in self.entries]
        else:
            self.entries = [x[0] + "    " + x[1] for x in self.entries]
        self.entrylist = [x for x in self.entries]
        self.entries = self.sort_list(self.entries)


    def sort_list(self, list):
        wk_a = []
        wk_c = []
        for x in list:
            if x[0] == '[' or  x[0] == '.':
                wk_c.append(x)
            else:
                wk_a.append(x)
        return wk_c + wk_a


    def do_cancel(self):
        self.selection = None
        self.exit_key_handler()

    def do_dummy(self):
        pass

    def exit_key_handler(self):
        appuifw.app.exit_key_handler = None
        self.lock.signal()

    def lbox_observe(self, ind = None):
        if not ind == None:
            idx = ind    # 1 or 2
        else:
            idx = 0
        disp_Index = self.lb.current()
        Index = self.entrylist.index(self.entries[disp_Index])
        focused_item = 0

        if self.current_dir.at_root:
            if not idx == 1:                        # not Left Arrow Key
                self.dir_stack.append(disp_Index)
                self.current_dir.add(Index)
            else:                                   # Left Arrow Key
                focused_item = disp_Index                # don't move pointer
        elif idx == 1:                              # Left Arrow Key
            focused_item = self.dir_stack.pop()
            self.current_dir.pop()
        elif idx == 2:                              # Right Arrow Key
            if Index == 0 or Index == 1:            # ".." or "." selected
                focused_item = disp_Index
            elif os.path.isdir(self.current_dir.entry(Index-2)):
                self.dir_stack.append(disp_Index)
                self.current_dir.add(Index-2)
            else:                                   # file selected
                focused_item = disp_Index                # don't move pointer

        elif Index == 0:                              #".." selected
            focused_item = self.dir_stack.pop()
            self.current_dir.pop()

        elif Index == 1:                              # "." selected
            # Return current directory
            self.selection = (self.current_dir.name(), '')
            self.lock.signal()
            return

        elif os.path.isdir(self.current_dir.entry(Index-2)):
            self.dir_stack.append(disp_Index)
            self.current_dir.add(Index-2)

        # file selected, Return current directory and file name
        else:
            item = self.current_dir.entry(Index-2)
            self.selection = os.path.split(item)
            self.lock.signal()
            return

        entries_bak = [x for x in self.entries] #*1 for appuifw2.Listbox
        self.list_setup()
        self.refresh()
        #*1 back to 0 Listbox pointer (need for appuifw2)
        if disp_Index >= len(self.entries):
            self.lb.set_list(entries_bak, 0) #*1
        self.lb.set_list(self.entries, focused_item)


class Getpath:
  """
  This class contain 2 procedures.
    get_read_path : get file path for read
    get_write_path: get file path for write
  Both proc return file path. When selection is canceled, return None
  """
  def __init__(self):
    pass

  def get_read_path(self, title="Select", default_path=None):
    """
    get file path for read.
    "file_path" is complete path to selected file.
    When selection is canceled, the content of file_path is None.
    """
    self.fb = Fbrowser(title) # use with Fbrowser class
    file_path = ''
    current_dir = default_path
    while True:
      sel_path = self.fb.select(current_dir)
      if sel_path == None:
        file_path = None
        break
      file_path = os.path.join(sel_path[0],sel_path[1])
      current_dir = sel_path[0] # default dir for next self.fb
      if os.path.isfile(file_path):
        break

    return file_path


  def get_write_path(self,title="File name", default_path=None, \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt"):
    """
    get file path for write.
    "file_path" is complete path to selected file.
    When selection is canceled, the content of file_path is None.
    """
    self.fb = Fbrowser(title)
    file_path = ''
    current_dir = default_path
    while True:
      sel_path = self.fb.select(current_dir)
      if sel_path == None:
        file_path = None
        break
      file_path = os.path.join(sel_path[0], sel_path[1])
      current_dir = sel_path[0]

      if os.path.isfile(file_path):
        if appuifw.query(unicode(msg_ow+'\n'+sel_path[1]),"query"):
          break # over write
      elif os.path.isdir(file_path):
        nfile_name = appuifw.query(unicode(msg_fn), "text", \
                                              unicode(msg_ex))
        if nfile_name is not None:
          file_path = os.path.join(sel_path[0], nfile_name)
          if os.path.isfile(file_path):
            if appuifw.query(unicode(msg_ow+'\n'+nfile_name),"query"):
              break
          else:
            break

    return file_path


class Testproc:
  """
  Test class that tests Fbrowser, get_readfilename, and 
  get_writefilename. Gotten file name is only displayed. 
  """
  def __init__(self):
    self.lock = e32.Ao_lock()
    self.body = appuifw.Text()
    self.gp = Getpath()



  def run(self):
      self.start_msg = ["Choose operation from menu.\n",
                        "Show selected file path.\n",
                        "File never overwrite."]
      self.disp_result(self.start_msg)
      self.refresh()
      self.lock.wait()


  def do_none(self):
    pass


  def exit_key_handler(self):
    appuifw.app.exit_key_handler = None
    self.lock.signal()


  def refresh(self):
      appuifw.app.title = unicode("Testproc")
      appuifw.app.menu = [
             (unicode("Get&disp rd file1"), self.test_get_read_path1),
             (unicode("Get&disp rd file2"), self.test_get_read_path2),
             (unicode("Get&disp rd file3"), self.test_get_read_path3),
             (unicode("Get&disp wr file1"), self.test_get_write_path1),
             (unicode("Get&disp wr file2"), self.test_get_write_path2),
             (unicode("Get&disp wr file3"), self.test_get_write_path3),
             (unicode("Exit"), self.exit_key_handler)]
      appuifw.app.exit_key_handler = lambda: self.do_none()


  def disp_result(self,msglist):  # dispaly search result
    self.body.clear()
    appuifw.app.body = self.body
    self.body.font = 'dense'   # small
    self.body.color = 0x000000
    for i in range(len(msglist)):
        self.body.add(unicode((str(msglist[i])),'utf-8'))
#    self.body.set_pos(0) #  move cursol to top
    e32.ao_sleep(0.001,) # screen redrow


  def test_get_read_path1(self):
    file_path = self.gp.get_read_path(title="Select", default_path=None)
    if file_path == None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_read_path2(self):
    file_path = self.gp.get_read_path(title="Select", \
                              default_path = "E:\\DATA\\masa")
    if file_path == None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_read_path3(self):
    file_path = self.gp.get_read_path(title="Select", \
                                    default_path = "E:\\Data\\masa\\Zzz")
    if file_path == None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_write_path1(self):
    file_path = self.gp.get_write_path(title="File name", default_path=None, \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt")
    if file_path != None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_write_path2(self):
    file_path = self.gp.get_write_path(title="File name", \
               default_path = "E:\\DATA\\masa", \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt")
    if file_path != None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_write_path3(self):
    file_path = self.gp.get_write_path(title="File name", \
               default_path = "E:\\Data\\masa\\Zzz", \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt")
    if file_path != None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


if __name__ == '__main__':
  Tp = Testproc()
  Tp.run()
#  appuifw.app.set_exit()
#  sys.exit()
