# -*- coding:utf-8 -*-

"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU General Public License version 2 or later.
"""
__script__ = "PyR2KKJtool"
__ver__    = "0.02(0)"
__author__ = 'masa'
__web__    = "http://masaland.cocolog-nifty.com/"
__Copyright__ = '(c) 2009-2014 masa'

import sys
sys.setdefaultencoding('utf-8')
sys.path.insert(0, 'E:\\Python\\lib')

#------options  (can change if you want)-------------------------
r2kkj_ini_file = "E:\\Data\\masa\\PyR2KKJ.ini"
word_dic_file = "E:\\Data\\word.utf8"
word_my_file  = "E:\\Data\\word_my.utf8"
word_myusr_file  = "E:\\Data\\word_myusr.utf8"
SKK_dictionary = 1
Font = "dense"  #"normal"

#-------global variables (no need to change)----------------------
Err_exit = 0
LOG  = 0
LOGF = "E:\\Data\\PyR2KKJ_LOG.txt"
#------------------------------------------------------------------

import os
import appuifw
import e32
import re
#import codecs

Err_exit = 0

try:
    from PyFbuiutil import Fbrowser
    from PyFbuiutil import Getpath
except:
    appuifw.query(unicode("Please install PyFbuiutl.py"), "query")
#    sys.exit(0)
    Err_exit = 1


def confread():
    global word_dic_file
    global word_my_file
    global word_myusr_file
    global SKK_dictionary
    global LOG
    global Font

    try:
        f = open(r2kkj_ini_file,'r')
        fData = f.read()
        f.close
    except:
        return

    #split by \n and omit line that contain only (CR/LF)
    lnDatalist = [x for x in fData.split("\n") if len(x) > 1]

    for lnData in lnDatalist:
        lnDatawk = re.sub("[ \t]+"," ",lnData)
        lnDatawk = (re.sub("[\n\r]+","",lnDatawk)).strip()

        confData = lnDatawk.split(" ")
        if len(confData) < 2: continue # no confData[1] error
        if   confData[0] == "word_dic_file": word_dic_file = confData[1]
        elif confData[0] == "word_my_file" : word_my_file  = confData[1]
        elif confData[0] == "word_myusr_file": word_myusr_file = confData[1]
        elif confData[0] == "SKK_dictionary": SKK_dictionary = int(confData[1])
        elif confData[0] == "LOG": LOG = int(confData[1])
        elif confData[0] == "Font"    : Font = confData[1]


def make_mydic(in_dic="", usr_dic="", out_dic="", merge_flg=None, \
                                                  SKK_flg=None):
    lnDatalist0 = []
    lnDatalist1 = []
    return_flg = 0
    if merge_flg:
        FData = ''
        try:
            F0 = open(usr_dic,'r')
            try:
                FData = F0.read()
            finally:
                F0.close()
        except:
            rtn = appuifw.query(u'usr_dic file read error', 'query')
            return None
        #split by \n and omit line that contain only (CR/LF)
        FData = FData.decode("UTF-8", "replace")
        lnDatalist0 = [x.strip() for x in FData.split(u"\n") if len(x) > 1]

    #read dic file
    FData = ''
    try:
        F1 = open(in_dic,'r')
        try:
            FData = F1.read()
        finally:
            F1.close()
    except:
        rtn = appuifw.query(u'in_dic file read error', 'query')
        return None
    #split by \n and omit line that contain only (CR/LF)
    FData = FData.decode("UTF-8", "replace")
    lnDatalist1 = [x.strip() for x in FData.split(u"\n") if len(x) > 1]

    lnDatalist = lnDatalist0 + lnDatalist1
    Mydic_body = {}
    Mydic_key = []
    Keyword = ''
    Wordbody = []
    if LOG: logF = open(LOGF, 'w') #*LOG
    for lnData in lnDatalist:
        lnDatawk = re.sub(u"[ \t]+", u" ", lnData)
#        lnDatawk = (re.sub("[\n\r]+","",lnDatawk))
        dicData = lnDatawk.split(u" ")
        if len(dicData) < 2: continue # no dicData[1] line

        if SKK_flg:
            dicData[0], dicData[1] = SKK_dic_conv(dicData[0], dicData[1])
        else:
            dicData[0] = re.sub(u"[a-zA-Z\'\"]$", u"", dicData[0])
        if not dicData[0]:
            if LOG:
                logdt = (u'a '+str(dicData[1])+u' '+lnData+u' '+lnDatawk+u'\n').encode("UTF-8")
                logF.write(logdt) #*LOG
            continue

        word_list = []
        word_list = [x for x in dicData[1].split(u"/") if len(x) > 0]
        if not word_list:
            if LOG:
                logdt = (u'c '+str(dicData[0])+u' '+str(dicData[1])+u' '+ \
                            lnData+u' '+lnDatawk+u'\n').encode("UTF-8")
                logF.write(logdt) #*LOG
            continue

        if Keyword == '':
            Keyword     = dicData[0]
            Wordbody    = word_list
        elif Keyword == dicData[0]:
            for x in word_list:
                if x in Wordbody: continue
                Wordbody.append(x)
        else:
            if Keyword in Mydic_key:
                wk2 = Mydic_body[Keyword]
                for x in Wordbody:
                    if x in wk2: continue
                    wk2.append(x)
                Mydic_body[Keyword] = wk2
            else:
                Mydic_key.append(Keyword)
                Mydic_body[Keyword] = Wordbody
            Keyword = dicData[0]
            Wordbody = word_list
    else:
        if Keyword:
            if Keyword in Mydic_key:
                wk2 = Mydic_body[Keyword]
                for x in Wordbody:
                    if x in wk2: continue
                    wk2.append(x)
                Mydic_body[Keyword] = wk2
            else:
                Mydic_key.append(Keyword)
                Mydic_body[Keyword] = Wordbody

    Mydic_key.sort() # sort
    if LOG: logF.close() #*LOG

    try:
      F = open(out_dic, 'w')
      try:
          for Keyword in Mydic_key:
              Fdata = Keyword + u' '
              for Data in Mydic_body[Keyword]:
                  Fdata = Fdata + Data + u"/"
              Fdata = Fdata[: -1] + u"\n" #remove "/" at line end
              Fdata = Fdata.encode("UTF-8")
              F.write(Fdata)
              return_flg = 1
      finally:
          F.close()
    except:
        appuifw.query(u'out_dic file write error', 'query')
        return_flg = 0
    return return_flg


def SKK_dic_conv(Data0, Data1):
    key_wd = re.sub(u"[a-zA-Z\'\"]", u"", Data0)
    key_wd = re.sub(u"^;.*", u"", key_wd)
    if key_wd == u"":
        return None, None
    key_body = re.sub(u"^/", u"", Data1)
    key_body = re.sub(u"/$", u"", key_body)
#    key_body = re.sub(u";.*/", u"/", key_body) #No need ,for SKK_S,SKK_M dic
    if key_body == u"":
        return None, None
    else:
        return key_wd, key_body


class R2Ktool:
    def __init__(self):
        self.script_lock = e32.Ao_lock()
        self.SKK_dic  = 0


    def run(self):
        global word_dic_file
        global word_my_file
        global word_myusr_file
        global SKK_dictionary

        self.Gpath = Getpath()
        self.SKK_dic  = SKK_dictionary
        self.textbody = appuifw.Text()
        old_title = appuifw.app.title
        appuifw.app.title = unicode(__script__)
        self.refresh()
        if not os.path.exists(word_dic_file):
            self.disp_msg(u"Dictionary not exist\nplease install or\ncheck conf data"+\
                   u"\n\nselect next action...")
        else:
            if not os.path.exists(word_my_file):
                self.disp_msg(u'  Dictionary convert....')
                make_mydic(in_dic=word_dic_file, out_dic=word_my_file, \
                   merge_flg=None, SKK_flg=self.SKK_dic)
            self.disp_msg(u'select next action...')

        self.script_lock.wait()
        appuifw.app.title = old_title
        appuifw.app.body = None


    def refresh(self):
        appuifw.app.body = self.textbody
        self.textbody.font = Font  #'normal' #'dense'
        self.textbody.color = 0x000000
        appuifw.app.menu =  [
                           (u'Dictionary tool', (
                             (u'Convert', self.convert_dic),
                             (u'Merge', self.merge_dic))),
                           (u'About', self.about),
                           (u'Exit', self.exit_key_handler)]
        appuifw.app.exit_key_handler = self.exit_key_handler



    def do_exit(self):
        self.exit_key_handler()

    def check_exit(self):
        if appuifw.query(u"Really exit?\ndata already saved?", 'query'):
             self.exit_key_handler()

    def exit_key_handler(self):
        appuifw.app.exit_key_handler = None
        self.script_lock.signal()

    def show_er_val(self):
        import sys
        type, value = sys.exc_info() [:2]
        #appuifw.note(unicode(str(type)+'\n'+str(value)), 'error')
        rtn = appuifw.query(unicode(str(type)+'\n'+str(value)), 'query')

    def about(self):
        msg =     (__script__) \
         + '\n' + ('Ver_' + __ver__) \
         + '\n' + (__Copyright__) \
         + '\n' + (__web__ )
        appuifw.query(unicode(msg, "utf-8"), "query")


    def disp_msg(self, msg):
        self.textbody.set(msg)
        self.textbody.set_pos(0)
        e32.ao_yield()


    def convert_dic(self):
        global word_dic_file
        dir_path  = os.path.split(word_dic_file)[0]
        open_path = self.Gpath.get_read_path(title="Sel input file", default_path=dir_path)
        if not open_path == None:
            save_dest = self.Gpath.get_write_path(title='Output file name', \
                     default_path=dir_path, msg_ex=u'word_my.utf8')
            if not save_dest == None:
                self.refresh()
                self.disp_msg(u'\n  conversion in process....')
                make_mydic(in_dic=open_path, out_dic=save_dest, \
                       merge_flg=None, SKK_flg=self.SKK_dic)
        self.refresh()
        self.disp_msg(u'  select next action...')


    def merge_dic(self):
        global word_my_file
        global word_myusr_file

        my_file    = os.path.basename(word_my_file)
        myusr_file = os.path.basename(word_myusr_file)
        if os.path.exists(word_my_file) and os.path.exists(word_myusr_file):
            self.disp_msg(u'Merge ' + unicode(my_file) + u' and ' + \
                    unicode(myusr_file) + u'\nproc will overwrite ' + \
                    unicode(my_file) + u', delete ' + \
                    unicode(myusr_file) +  u'\ncontinue ?')
            rtn = appuifw.query(u'Please read screen msg\ncontinue ?', 'query')
            if rtn:
                self.disp_msg(u'  merge in process....')
                rtn = make_mydic(in_dic=word_my_file, usr_dic=word_myusr_file, \
                       out_dic=word_my_file, merge_flg=1)
                if rtn: #make dic success
                    try:
                        os.remove(word_myusr_file)
                    except:
                        self.show_er_val()
                else:
                    rtn = appuifw.query(u'Merge failed', 'query')
        else:
          appuifw.note(u'no file (dic or usr_dic)', 'info')
        self.disp_msg(u'  Select next action...')


def main():
    if Err_exit: return
    confread()
    R2KT = R2Ktool()
    R2KT.run()
    del R2KT

if __name__ == '__main__':
    main()

#    appuifw.app.set_exit()
#    sys.exit()
