# -*- coding:utf-8 -*-

"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU General Public License version 2 or later.
"""
__script__ = "PyR2KKJ"
__ver__    = "0.02(0)"
__author__ = "masa"
__web__    = "http://masaland.cocolog-nifty.com/"
__Copyright__ = "(c) 2009-2014 masa"

import sys
sys.setdefaultencoding('utf-8')
sys.path.insert(0, 'E:\\Python\\lib')

#------options  (can change if you want)-------------------------
r2kkj_ini_file = "E:\\Data\\masa\\PyR2KKJ.ini"
word_dic_file = "E:\\Data\\word.utf8"
word_my_file  = "E:\\Data\\word_my.utf8"
word_myusr_file  = "E:\\Data\\word_myusr.utf8"
def_dir = "E:\\Data"
learning  = 0
auto_next = 1
SKK_dictionary = 1
Encoding = "AUTO"     #default encoding for open file
#Encoding = "UTF-8"   
#Encoding = "UTF-16"
#Encoding = "Shift-JIS"
Delimiter = "/delimiter/" #正規表現に使われる文字は使わない（*など）
Font = "dense"  #"normal" #*20

#-------global variables (no need to change)----------------------
JP_CODECS = 0
My_dic_key = []
My_dic_body = []
My_usrdic_key = []
My_usrdic_body = []
Err_exit = 0

#-------global variables (can change if you want)----------------
#KB_dic item description  "Roman":["for conversion","for display"]
KB_dic ={
        u"a":["あ","あ"], u"ba":["は","ば"], u"bi":["ひ","び"],
        u"bu":["ふ","ぶ"], u"be":["へ","べ"], u"bo":["ほ","ぼ"],
        u"bya":["ひや","びゃ"], u"byu":["ひゆ","びゅ"], u"byo":["ひよ","びょ"],
        u"cha":["ちや","ちゃ"], u"chi":["ち","ち"], u"chu":["ちゆ","ちゅ"],
        u"che":["ちえ","ちぇ"], u"cho":["ちよ","ちょ"], u"ccha":["つちや","っちゃ"],
        u"cchi":["つち","っち"], u"cchu":["つちゆ","っちゅ"], 
        u"cche":["つちえ","っちぇ"],u"tchi":["つち","っち"],
        u"ccho":["つちよ","っちょ"], u"da":["た","だ"], u"di":["ち","ぢ"],
        u"du":["つ","づ"], u"de":["て","で"], u"do":["と","ど"],
        u"ddi":["つち","っぢ"],
        u"dya":["ちや","ぢゃ"], u"dyu":["ちゆ","ぢゅ"], u"dyo":["ちよ","ぢょ"],
        u"e":["え","え"], u"fa":["ふあ","ふぁ"], u"fi":["ふい","ふぃ"],
        u"fu":["ふ","ふ"], u"fe":["ふえ","ふぇ"], u"fo":["ふお","ふぉ"],
        u"fya":["ふや","ふゃ"], u"fyu":["ふゆ","ふゅ"], u"fyo":["ふよ","ふょ"],
        u"ga":["か","が"], u"gi":["き","ぎ"], u"gu":["く","ぐ"],
        u"ge":["け","げ"], u"go":["こ","ご"], u"gya":["きや","ぎゃ"],
        u"gyu":["きゆ","ぎゅ"], u"gyo":["きよ","ぎょ"], u"ha":["は","は"],
        u"hi":["ひ","ひ"], u"hu":["ふ","ふ"], u"he":["へ","へ"],
        u"ho":["ほ","ほ"], u"hya":["ひや","ひゃ"], u"hyu":["ひゆ","ひゅ"],
        u"hyo":["ひよ","ひょ"], u"i":["い","い"], u"ja":["しや","じゃ"],
        u"ji":["し","じ"], u"ju":["しゆ","じゅ"], u"je":["しえ","じぇ"],
        u"jo":["しよ","じょ"], u"jya":["しや","じゃ"], u"jyu":["しゆ","じゅ"],
        u"jyo":["しよ","じょ"], u"jji":["つし","っじ"],
        u"ka":["か","か"], u"ki":["き","き"],
        u"ku":["く","く"], u"ke":["け","け"], u"ko":["こ","こ"],
        u"kya":["きや","きゃ"], u"kyu":["きゆ","きゅ"], u"kyo":["きよ","きょ"],
        u"kka":["つか","っか"], u"kki":["つき","っき"], u"kku":["つく","っく"],
        u"kke":["つけ","っけ"], u"kko":["つこ","っこ"], u"kkya":["つきや","っきゃ"],
        u"kkyu":["つきゆ","っきゅ"], u"kkyo":["つきよ","っきょ"], u"ma":["ま","ま"],
        u"mi":["み","み"], u"mu":["む","む"], u"me":["め","め"],
        u"mo":["も","も"], u"mya":["みや","みゃ"], u"myu":["みゆ","みゅ"],
        u"myo":["みよ","みょ"], u"na":["な","な"],
        u"ni":["に","に"], u"nu":["ぬ","ぬ"], u"ne":["ね","ね"],
        u"no":["の","の"], u"nya":["にや","にゃ"], u"nyu":["にゆ","にゅ"],
        u"nyo":["によ","にょ"], u"o":["お","お"], u"pa":["は","ぱ"],
        u"pi":["ひ","ぴ"], u"pu":["ふ","ぷ"], u"pe":["へ","ぺ"],
        u"po":["ほ","ぽ"], u"pya":["ひや","ぴゃ"], u"pyu":["ひゆ","ぴゅ"],
        u"pyo":["ひよ","ぴょ"], u"ppa":["つは","っぱ"], u"ppi":["つひ","っぴ"],
        u"ppu":["つふ","っぷ"], u"ppe":["つへ","っぺ"], u"ppo":["つほ","っぽ"],
        u"ppya":["つひや","っぴゃ"], u"ppyu":["つひゆ","っぴゅ"], 
        u"ppyo":["つひよ","っぴょ"],
        u"ra":["ら","ら"], u"ri":["り","り"], u"ru":["る","る"],
        u"re":["れ","れ"], u"ro":["ろ","ろ"], u"rya":["りや","りゃ"],
        u"ryu":["りゆ","りゅ"], u"ryo":["りよ","りょ"], u"sa":["さ","さ"],
        u"si":["し","し"], u"shi":["し","し"], u"su":["す","す"],
        u"se":["せ","せ"], u"so":["そ","そ"], u"sha":["しや","しゃ"],
        u"shu":["しゆ","しゅ"], u"sho":["しよ","しょ"], u"sya":["しや","しゃ"],
        u"syu":["しゆ","しゅ"], u"syo":["しよ","しょ"], u"ssa":["つさ","っさ"],
        u"ssi":["つし","っし"], u"sshi":["つし","っし"], u"ssu":["つす","っす"],
        u"sse":["つせ","っせ"], u"sso":["つそ","っそ"], u"ssha":["つしや","っしゃ"],
        u"sshu":["つしゆ","っしゅ"], u"ssho":["つしよ","っしょ"], 
        u"ssya":["つしや","っしゃ"],
        u"ssyu":["つしゆ","っしゅ"], u"ssyo":["つしよ","っしょ"], u"ta":["た","た"],
        u"ti":["ち","ち"], u"tsu":["つ","つ"], u"tu":["つ","つ"],
        u"te":["て","て"], u"to":["と","と"], u"tya":["ちや","ちゃ"],
        u"tyu":["ちゆ","ちゅ"], u"tyo":["ちよ","ちょ"], u"tta":["つた","った"],
        u"tti":["つち","っち"], u"ttsu":["つつ","っつ"], u"ttu":["つつ","っつ"],
        u"tte":["つて","って"], u"tto":["つと","っと"], u"ttya":["つちや","っちゃ"],
        u"ttyu":["つちゆ","っちゅ"], u"ttyo":["つちよ","っちょ"], u"u":["う","う"],
        u"va":["は","ば"], u"vi":["ひ","び"], u"vu":["ふ","ぶ"],
        u"ve":["へ","べ"], u"vo":["ほ","ぼ"], u"wa":["わ","わ"],
        u"wo":["を","を"], u"ya":["や","や"], u"yu":["ゆ","ゆ"],
        u"yo":["よ","よ"], u"za":["さ","ざ"], u"zi":["し","じ"],
        u"zu":["す","ず"], u"ze":["せ","ぜ"], u"zo":["そ","ぞ"], u"zzi":["つし","っじ"],
        u"zya":["しや","じゃ"], u"zyu":["しゆ","じゅ"], u"zyo":["しよ","じょ"],
        u".":["。","。"], u",":["、","、"], u"-":["ー","ー"],
        u"(":["（","（"], u")":["）","）"], 
        u"mba":["んは","んば"], u"mbi":["んひ","んび"], u"mbu":["んふ","んぶ"], 
        u"mbe":["んへ","んべ"], u"mbo":["んほ","んぼ"], u"mbya":["んひや","んびゃ"],
        u"mbyu":["んひゆ","んびゅ"], u"mbyo":["んひよ","んびょ"], 
        u"mma":["んま","んま"], u"mmi":["んみ","んみ"],
        u"mmu":["んむ","んむ"], u"mme":["んめ","んめ"], u"mmo":["んも","んも"],
        u"mmya":["んみや","んみゃ"], u"mmyu":["んみゆ","んみゅ"],
        u"mmyo":["んみよ","んみょ"],
        u"mpa":["んは","んぱ"], u"mpi":["んひ","んぴ"],
        u"mpu":["んふ","んぷ"], u"mpe":["んへ","んぺ"], u"mpo":["んほ","んぽ"],
        u"mpya":["んひや","んぴゃ"], u"mpyu":["んひゆ","んぴゅ"],
        u"mpyo":["んひよ","んぴょ"], 

        u"n'":["ん", "ん"], u"n\n":["ん", "ん"], u"nn\n":["ん", "ん"],
        u"nn":["ん","ん"]
        }
Henkan_tbl = {
            "あ":"ア", "い":"イ", "う":"ウ", "え":"エ", "お":"オ", 
            "か":"カ", "き":"キ", "く":"ク", "け":"ケ", "こ":"コ", 
            "さ":"サ", "し":"シ", "す":"ス", "せ":"セ", "そ":"ソ", 
            "た":"タ", "ち":"チ", "つ":"ツ", "て":"テ", "と":"ト", 
            "な":"ナ", "に":"ニ", "ぬ":"ヌ", "ね":"ネ", "の":"ノ", 
            "は":"ハ", "ひ":"ヒ", "ふ":"フ", "へ":"ヘ", "ほ":"ホ", 
            "ま":"マ", "み":"ミ", "む":"ム", "め":"メ", "も":"モ", 
            "や":"ヤ", "ゆ":"ユ", "よ":"ヨ", 
            "ら":"ラ", "り":"リ", "る":"ル", "れ":"レ", "ろ":"ロ", 
            "わ":"ワ", "を":"ヲ", "ん":"ン",
            "ぁ":"ァ", "ぃ":"ィ", "ぅ":"ゥ", "ぇ":"ェ", "ぉ":"ォ", 
            "ゃ":"ャ", "ゅ":"ュ", "ょ":"ョ", "っ":"ッ", 
            "が":"ガ", "ぎ":"ギ", "ぐ":"グ", "げ":"ゲ", "ご":"ゴ", 
            "ざ":"ザ", "じ":"ジ", "ず":"ズ", "ぜ":"ゼ", "ぞ":"ゾ", 
            "だ":"ダ", "ぢ":"ヂ", "づ":"ヅ", "で":"デ", "ど":"ド", 
            "ば":"バ", "び":"ビ", "ぶ":"ブ", "べ":"ベ", "ぼ":"ボ", 
            "ぱ":"パ", "ぴ":"ピ", "ぷ":"プ", "ぺ":"ペ", "ぽ":"ポ", 
            "A":"Ａ", "B":"Ｂ", "C":"Ｃ", "D":"Ｄ", "E":"Ｅ", "F":"Ｆ",
            "G":"Ｇ", "H":"Ｈ", "I":"Ｉ", "J":"Ｊ", "K":"Ｋ", "L":"Ｌ",
            "M":"Ｍ", "N":"Ｎ", "O":"Ｏ", "P":"Ｐ", "Q":"Ｑ", "R":"Ｒ",
            "S":"Ｓ", "T":"Ｔ", "U":"Ｕ", "V":"Ｖ", "W":"Ｗ", "X":"Ｘ", 
            "Y":"Ｙ", "Z":"Ｚ", "a":"ａ", "b":"ｂ", "c":"ｃ", "d":"ｄ", 
            "e":"ｅ", "f":"ｆ", "g":"ｇ", "h":"ｈ", "i":"ｉ", "j":"ｊ", 
            "k":"ｋ", "l":"ｌ", "m":"ｍ", "n":"ｎ", "o":"ｏ", "p":"ｐ", 
            "q":"ｑ", "r":"ｒ", "s":"ｓ", "t":"ｔ", "u":"ｕ", "v":"ｖ", 
            "w":"ｗ", "x":"ｘ", "y":"ｙ", "z":"ｚ",
            " ":"　", 
            "*":"＊", "+":"＋", "(":"（", ")":"）", "<":"＜", ">":"＞", 
            "?":"？", "/":"／", "#":"＃", "%":"％", "\\":"￥",  "|":"｜",
            "[":"「", "]":"」", "!":"！", "$":"＄", "&":"＆", ",":"，",
            "-":"―", ".":"．", ":":"：", ";":"；", "=":"〓", "@":"＠",
            "0":"０", "1":"１", "2":"２", "3":"３", "4":"４", 
            "5":"５", "6":"６", "7":"７", "8":"８", "9":"９",
            }
Hankana_tbl = {
            "あ":"ｱ", "い":"ｲ", "う":"ｳ", "え":"ｴ", "お":"ｵ", 
            "か":"ｶ", "き":"ｷ", "く":"ｸ", "け":"ｹ", "こ":"ｺ", 
            "さ":"ｻ", "し":"ｼ", "す":"ｽ", "せ":"ｾ", "そ":"ｿ", 
            "た":"ﾀ", "ち":"ﾁ", "つ":"ﾂ", "て":"ﾃ", "と":"ﾄ", 
            "な":"ﾅ", "に":"ﾆ", "ぬ":"ﾇ", "ね":"ﾈ", "の":"ﾉ", 
            "は":"ﾊ", "ひ":"ﾋ", "ふ":"ﾌ", "へ":"ﾍ", "ほ":"ﾎ", 
            "ま":"ﾏ", "み":"ﾐ", "む":"ﾑ", "め":"ﾒ", "も":"ﾓ", 
            "や":"ﾔ", "ゆ":"ﾕ", "よ":"ﾖ", 
            "ら":"ﾗ", "り":"ﾘ", "る":"ﾙ", "れ":"ﾚ", "ろ":"ﾛ", 
            "わ":"ﾜ", "を":"ｦ", "ん":"ﾝ", 
            "ぁ":"ｧ", "ぃ":"ｨ", "ぅ":"ｩ", "ぇ":"ｪ", "ぉ":"ｫ", 
            "ゃ":"ｬ", "ゅ":"ｭ", "ょ":"ｮ", "っ":"ｯ", 
            "が":"ｶﾞ", "ぎ":"ｷﾞ", "ぐ":"ｸﾞ", "げ":"ｹﾞ", "ご":"ｺﾞ", 
            "ざ":"ｻﾞ", "じ":"ｼﾞ", "ず":"ｽﾞ", "ぜ":"ｾﾞ", "ぞ":"ｿﾞ", 
            "だ":"ﾀﾞ", "ぢ":"ﾁﾞ", "づ":"ﾂﾞ", "で":"ﾃﾞ", "ど":"ﾄﾞ", 
            "ば":"ﾊﾞ", "び":"ﾋﾞ", "ぶ":"ﾌﾞ", "べ":"ﾍﾞ", "ぼ":"ﾎﾞ", 
            "ぱ":"ﾊﾟ", "ぴ":"ﾋﾟ", "ぷ":"ﾌﾟ", "ぺ":"ﾍﾟ", "ぽ":"ﾎﾟ"
            }

import os
import appuifw
import e32
import re
#import codecs
from key_codes import EKeyLeftArrow
from key_codes import EKeyRightArrow
from key_codes import EKeyUpArrow
from key_codes import EKeyDownArrow
from key_codes import EKeyYes
from key_codes import EKeyBackspace
from key_codes import EKeySelect  #Center key
from key_codes import EKeyEnter   #Enter key (SU-8W)

Err_exit = 0
try:
    import japanese
    JP_CODECS = 1
except:
    JP_CODECS = 0
    if Encoding.upper() == "SHIFT-JIS":
        appuifw.query(unicode("Option is Shift-JIS\nPlease install japanese"), "query")
        Err_exit = 1

try:
    from PyFbuiutil import Fbrowser
    from PyFbuiutil import Getpath
except:
    appuifw.query(unicode("Please install PyFbuiutl.py"), "query")
#    sys.exit(0)
    Err_exit = 1


def confread():
    global word_dic_file
    global word_my_file
    global word_myusr_file
    global def_dir
    global learning
    global auto_next
    global SKK_dictionary
    global Encoding
    global Font #*20

    try:
        f = open(r2kkj_ini_file,'r')
        fData = f.read()
        f.close
    except:
        return

    #split by \n and omit line that contain only (CR/LF)
    lnDatalist = [x for x in fData.split("\n") if len(x) > 1]

    for lnData in lnDatalist:
        lnDatawk = re.sub("[ \t]+"," ",lnData)
#        lnDatawk = (re.sub("[\n\r]+","",lnDatawk)).strip()
        lnDatawk = (re.sub("^[ ]+","",lnDatawk))

        confData = lnDatawk.split(" ")
        if len(confData) < 2: continue # no confData[1] error
        if   confData[0] == "word_dic_file": word_dic_file = confData[1]
        elif confData[0] == "word_my_file" : word_my_file  = confData[1]
        elif confData[0] == "word_myusr_file": word_myusr_file = confData[1]
        elif confData[0] == "def_dir"  : def_dir = confData[1]
        elif confData[0] == "learning" : learning  = int(confData[1])
        elif confData[0] == "auto_next": auto_next = int(confData[1])
        elif confData[0] == "SKK_dictionary": SKK_dictionary = int(confData[1])
        elif confData[0] == "Encoding": Encoding = confData[1]
        elif confData[0] == "Font"    : Font = confData[1]


def read_mydic(dic_file):
    """read dictionary file (word_my_file or word_myusr_file)"""
    FData = ''
    try:
        F = open(dic_file, 'r')
        try:
            FData = F.read()
        finally:
            F.close()
    except:
        pass

    #split by \n and omit line that contain only (CR/LF)
    lnDatalist = [x for x in FData.split("\n") if len(x) > 1]

    Mydic_body = []
    Mydic_key = []
    for lnData in lnDatalist:
        lnDatawk = re.sub("[ \t]+"," ",lnData)
        lnDatawk = (re.sub("[\n\r]+","",lnDatawk))
        dicData = lnDatawk.split(" ")
        if   len(dicData) < 2: continue # no dicData[1] line

        Mydic_key.append(dicData[0])
        Mydic_body.append(dicData[1])
    return Mydic_key, Mydic_body


def write_my_usrdic():
    global My_usrdic_key
    global My_usrdic_body
    global word_myusr_file
    if not My_usrdic_key: #no user dic data
        return
    try:
        F = open(word_myusr_file, 'w')
        try:
            for n in range(len(My_usrdic_key)):
                Fdata = My_usrdic_key[n] + ' ' + My_usrdic_body[n] + '\n'
                F.write(Fdata)
        finally:
            F.close()
    except:
        appuifw.note(u'user dic file write error', 'info')


class R2KConv:
    def __init__(self):
        self.script_lock = e32.Ao_lock()
        self.cur_timer = e32.Ao_timer()
        self.next_timer = e32.Ao_timer()
        self.clrkey_timer = e32.Ao_timer()
        self.dic_txt = ""
        self.dsp_txt = ""
        self.txt_word = ""
        self.out_word = ""
        self.dic_st_p = 0
        self.dic_sp_p = 0
        self.dsp_st_p = 0
        self.dsp_sp_p = 0
        self.dsp_cr_p = 0
        self.cursor_pos = 0
        self.Learning = 0
        self.SKK_dic  = 0
        self.page = ''
        self.clrkey_cnt = 0
        self.delimiter = ''
        self.enterkey_flg = 0


    def run(self):
        global My_dic_key
        global My_dic_body
        global My_usrdic_key
        global My_usrdic_body
        global word_dic_file
        global word_my_file
        global word_myusr_file
        global learning
        global SKK_dictionary
        global Delimiter

        self.Gpath = Getpath()
        self.Learning = learning
        self.SKK_dic  = SKK_dictionary
        self.delimiter = unicode(Delimiter)
        self.make_menu_list()
        self.textbody = appuifw.Text()
        old_title = appuifw.app.title
        appuifw.app.title = unicode(__script__)
        self.refresh()
        if not os.path.exists(word_my_file):
            self.disp_msg(u"Dictionary not exist\nplease install dic or\ncheck conf data"+\
                                      u"\n\nselect next action...")
        else:
            self.disp_msg(u'  Dictionary open....')
            My_dic_key, My_dic_body = read_mydic(word_my_file)
            if self.Learning == 1 and os.path.exists(word_myusr_file):
                self.disp_msg(u'  User dictionary open....')
                My_usrdic_key, My_usrdic_body = read_mydic(word_myusr_file)
            self.new_rtxt(first=True)


        self.script_lock.wait()
        if self.Learning and My_usrdic_key: #save learning dic
            write_my_usrdic()
        appuifw.app.title = old_title
        appuifw.app.body = None


    def set_pointer_initial(self):
        self.dic_txt = ""
        self.dsp_txt = ""
        self.txt_word = ""
        self.out_word = ""
        self.dic_st_p = 0
        self.dic_sp_p = 0
        self.dsp_st_p = 0
        self.dsp_sp_p = 0
        self.dsp_cr_p = 0


    def make_menu_list(self):
        menu_file = [(u'File', (
                       (u'Open', self.open_cv_file),
                       (u'Save result', self.save_cv_file),
                       (u'Save mid data', self.save_mid_file)))]
        menu_edit_main =[
                    (u'Edit', (
                      (u'Input new R_text', self.new_rtxt),
                      (u'Add R_text here', self.add_rtxt_here),
                      (u'Add R_text last', self.add_rtxt_last),
                      (u'Edit screen text', self.go_edit))),
                    (u'Conv', (
                      (unicode('--> Ａア＊１(zenkaku)'), self.conv_to_zenkaku),
                      (unicode('--> ｱｲｳ (han kana)'), self.conv_to_hankana)))]
        menu_edit_edit = [(u'Edit', (
                            (u'Input new R_text', self.new_rtxt),
                            (u'Add R_text here', self.add_rtxt_here),
                            (u'Add R_text last', self.add_rtxt_last),
                            (u'Convert R to KKJ', self.open_edittxt))),
                          (u'Go to', (
                            (u'Top', self.goto_top),
                            (u'Last', self.goto_last)))]
        menu_edit_pfep =[
                    (u'Edit', (
                      (u'Input new R_text', self.new_rtxt),
                      (u'Add R_text last', self.add_rtxt_last),
                      (u'Edit screen text', self.go_edit))),
                      (unicode('Conv --> Ａ＊１(zenkaku)'), self.conv_to_zen_pfep)]
        menu_others = [(u'About', self.about),
                         (u'Exit', self.check_exit)]
        self.refresh_menu_main = menu_file + menu_edit_main + menu_others
        self.refresh_menu_edit = menu_file + menu_edit_edit + menu_others
        self.refresh_menu_pfep = menu_file + menu_edit_pfep + menu_others


    def refresh(self):
#        self.page = 'main'
        appuifw.app.title = unicode(__script__) + u' m'
        appuifw.app.body = self.textbody
        self.textbody.font = Font  #'normal' #'dense'
        self.textbody.color = 0x000000
        appuifw.app.menu = self.refresh_menu_main
        appuifw.app.exit_key_handler = self.check_exit
        appuifw.app.body.bind(EKeyLeftArrow,self.sel_leftarwky) 
        appuifw.app.body.bind(EKeyRightArrow,self.sel_rightarwky) 
        appuifw.app.body.bind(EKeyUpArrow,self.sel_uparwky) 
        appuifw.app.body.bind(EKeyDownArrow,self.sel_downarwky) 
        appuifw.app.body.bind(EKeyYes,self.sel_yeskey) 
        appuifw.app.body.bind(EKeyBackspace,self.sel_clrkey) 
        appuifw.app.body.bind(EKeySelect,self.sel_uparwky) 
        appuifw.app.body.bind(EKeyEnter,self.sel_enterky) 


    def refresh_edit(self):
        self.page = 'edit'
        appuifw.app.title = unicode(__script__) + u' e'
        appuifw.app.menu = self.refresh_menu_edit
        appuifw.app.exit_key_handler = self.check_exit
        appuifw.app.body.bind(EKeyLeftArrow, None) 
        appuifw.app.body.bind(EKeyRightArrow, None) 
        appuifw.app.body.bind(EKeyUpArrow, None) 
        appuifw.app.body.bind(EKeyDownArrow, None) 
        appuifw.app.body.bind(EKeyYes, None) 
        appuifw.app.body.bind(EKeyBackspace,None) 
        appuifw.app.body.bind(EKeySelect,None) 
        appuifw.app.body.bind(EKeyEnter,None) 


    def refresh_pfep(self):
        self.page = 'pfep'
        appuifw.app.title = unicode(__script__) + u' p'
        appuifw.app.menu = self.refresh_menu_pfep
        appuifw.app.exit_key_handler = self.check_exit
        appuifw.app.body.bind(EKeyLeftArrow, self.sel_leftarw_pfep) 
        appuifw.app.body.bind(EKeyRightArrow, self.sel_rightarw_pfep) 
        appuifw.app.body.bind(EKeyUpArrow, self.sel_uparw_pfep) 
        appuifw.app.body.bind(EKeyDownArrow, self.sel_downarw_pfep) 
        appuifw.app.body.bind(EKeyYes, self.conv_edittxt) 
        appuifw.app.body.bind(EKeyBackspace,self.sel_clrkey_pfep) 
        appuifw.app.body.bind(EKeySelect,self.sel_uparw_pfep) 
        appuifw.app.body.bind(EKeyEnter,self.sel_enter_pfep) 


    def do_exit(self):
        self.exit_key_handler()

    def check_exit(self):
        if appuifw.query(u"Really exit?\ndata already saved?", 'query'):
              self.exit_key_handler()

    def exit_key_handler(self):
        appuifw.app.exit_key_handler = None
        self.script_lock.signal()

    def show_er_val(self):
        import sys
        type, value = sys.exc_info() [:2]
        #appuifw.note(unicode(str(type)+'\n'+str(value)), 'error')
        rtn = appuifw.query(unicode(str(type)+'\n'+str(value)), 'query')

    def about(self):
        msg =     (__script__) \
          + '\n' + ('Ver_' + __ver__) \
          + '\n' + (__Copyright__) \
          + '\n' + (__web__ )
        appuifw.query(unicode(msg, "utf-8"), "query")


    def disp_msg(self, msg):
        self.textbody.set(msg)
        self.textbody.set_pos(0)
        e32.ao_yield()


    def open_cv_file(self, first=None):
        if not first:
            if not appuifw.query(u"Really open?\ndata already saved?", 'query'):
                return
        self.disp_msg(u' select next action...')
        self.set_pointer_initial() #set pointer, buffer to initial

        open_path = self.Gpath.get_read_path(default_path=def_dir)
        self.refresh()
        if open_path == None:
#            appuifw.query(u"Canceled\nSelect option menu ", 'query')
            return

#        self.page = 'edit' #*
        self.page = 'pfep' #*

        try:
            F = open(open_path,'r')
            FData = F.read()
            F.close
        except:
            self.show_er_val()
            return

        """encoding check, and decode """
        u_text = self.check_and_decode(FData)
        u_text = (re.sub(u"\r",u"",u_text))
        u_text = (re.sub(u"^[\n]+",u"",u_text))

        if u_text == None: return #decoding error, please check option param.
        u_text = (re.sub(u"\n",u"\u2029",u_text)) 

        """convert roman_text to kana, 
              outputs are self.dic_txt, self.dsp_txt
        """
        rtn = self.conv2kana(u_text)
        if rtn:
            #exec R to KKJ convert
            self.disp_msg(self.dsp_txt)
            self.get_oneword()
            if self.txt_word:
                self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
            else:
                self.disp_msg(u'No data\nselect next action')
#                appuifw.query(u'No data\nselect next action', "query")
        else:
            self.disp_msg(u'No data\nselect next action')
#            appuifw.query(u"Can't convert roman file", 'query')


    def check_and_decode(self, text_data):
        """Check encoding and decode"""
        global JP_CODECS
        global Encoding
        if Encoding.upper() == "AUTO":
            if JP_CODECS == 1:
                enc_list = ["UTF-8", "Shift-JIS", "UTF-16"]
            else:
                enc_list = ["UTF-8", "UTF-16"]
        else:
            enc_list = [Encoding]
        new_data = ''
        for enc in enc_list:
            try:
                new_data = text_data.decode(enc)
                break
            except:
                pass
        else:
            new_data = None
            self.show_er_val()
        return new_data


    def conv2kana(self, text):
        """convert roman sentence into kana, input is unicode text"""
        Key_in = ''
        kb_wd = ''
        self.dic_txt = ''
        self.dsp_txt = ''

        Text = (re.sub(u"^[\n]+","",text))
#        Text = (re.sub(u"^[\u2029]+","",Text))
        Text = (re.sub(u"\n",u"\u2029",Text)) 

        n = 0
        while n < len(Text):
            Key_in = Key_in + Text[n]
            delimit_pos = re.search(u"\'"+self.delimiter+u"\'", Key_in, re.I)
            if not delimit_pos == None: #delimiter('/delimiter/')
                start_pos = delimit_pos.start()
                if not start_pos == 0: #xyz'/delimiter/'
                    self.dic_txt = self.dic_txt + Key_in[0:start_pos]
                    self.dsp_txt = self.dsp_txt + Key_in[0:start_pos]
                else: #Key_in contain only delimiter
                    if len(self.dic_txt) > 0 and self.dic_txt[-1] == u"\u2029":
                        self.dic_txt = self.dic_txt[:-1] #remove inserted LF
                    if len(self.dsp_txt) > 0 and self.dsp_txt[-1] == u"\u2029":
                        self.dsp_txt = self.dsp_txt[:-1]
                self.dic_st_p = self.dic_sp_p = len(self.dic_txt)
                self.dsp_st_p = self.dsp_cr_p = self.dsp_sp_p = len(self.dsp_txt)
                kb_wd = ''
                Key_in = ''
                n = n + 1
            elif re.search(u"[\'\"].*[\'\"\u2029]", Key_in, re.I):
                #xyz"abc" format text
                self.dic_txt = self.dic_txt + Key_in
                self.dsp_txt = self.dsp_txt + Key_in
                kb_wd = ''
                Key_in = ''
                n = n + 1
            elif re.search(u"[\'\"][^\'\"]*", Key_in, re.I) and (Key_in).lower() != u"n'":
                #xyz"abc  format
                n = n + 1
            elif re.search(u"[a-z (),.\'-]", Text[n], re.I) == None:
                #Kana or some symbol char
                self.dic_txt = self.dic_txt + Key_in
                self.dsp_txt = self.dsp_txt + Key_in
                kb_wd = ''
                Key_in = ''
                n = n + 1
            else: # alfabet or space or ,.'()- and not (xyz"abc" or xyz"abc  format)
                if Text[n].lower() == u"n" and n == len(Text) - 1: # n[EOF] or nn[EOF]
                    wk_Key_in = Key_in + u"\n" # n\n or nn\n
                elif Text[n].lower() == u"n" and n < len(Text) -1 and Text[n+1] == u"\u2029":
                    #n[LF] or nn[LF]  --> n\n or nn\n
                    wk_Key_in = Key_in + u"\n"
                elif Text[n].lower() == u"n" and n < len(Text) -1 and \
                                    re.search(u"[aiueoyn\']", Text[n+1],re.I) == None: #*8
                    wk_Key_in = Key_in + u"\n"
                else:
                    wk_Key_in = Key_in

                try:
                    kb_wd = KB_dic[((wk_Key_in).lower())]   #.encode('UTF-8')]
                except:
                    kb_wd = None
                if kb_wd:
                    self.dic_txt = self.dic_txt + unicode(kb_wd[0])
                    self.dsp_txt = self.dsp_txt + unicode(kb_wd[1])
                    kb_wd = ''
                    Key_in = ''
                    n = n + 1
                else:
                    if re.search(u"[ \']", Text[n], re.I):
                        self.dic_txt = self.dic_txt + Key_in
                        self.dsp_txt = self.dsp_txt + Key_in
                        kb_wd = ''
                        Key_in = ''
                        n = n + 1
                    elif re.search(u"[,.()-]", Text[n], re.I): #,.()-
                        self.dic_txt = self.dic_txt + Key_in[:-1]
                        self.dsp_txt = self.dsp_txt + Key_in[:-1]
                        kb_wd = ''
                        Key_in = ''
                    else: #a-z
                        n = n + 1
        else:
            self.dic_txt = self.dic_txt + Key_in
            self.dsp_txt = self.dsp_txt + Key_in
        if self.SKK_dic: #if SKK dictionary ,use dsp_txt
            self.dic_txt = self.dsp_txt
        if self.dic_txt:return True #exist data
        else:           return None


    def get_oneword(self):
        """get one word for convert Kana to Kanji"""
        n = self.dic_st_p
        m = 0
        while n < len(self.dic_txt):
            if not self.dic_txt[n] == u' ' and \
                          not self.dic_txt[n] == unicode('。') and \
                          not self.dic_txt[n] == unicode('、') and \
                          not self.dic_txt[n] == unicode('（') and \
                          not self.dic_txt[n] == unicode('）') and \
                          not self.dic_txt[n] == u"\u2029" :
                wk_wd = self.dic_txt[self.dic_st_p:n+1]
                if re.search(u"[\'\"].*[\'\"]", wk_wd): #*7
                    self.txt_word = self.dic_txt[self.dic_st_p:n+1]
                    self.dic_sp_p = n + 1
                    self.dsp_sp_p = self.dsp_st_p + m + 1
                    self.dsp_cr_p = self.dsp_st_p + m + 1
                    break
                n = n + 1
                m = m + 1
            else:
                if m == 0 and self.dic_txt[n] == u' ':
                        self.txt_word = self.dic_txt[self.dic_st_p:n+1]
                        self.dic_sp_p = n + 1
                        self.dsp_sp_p = self.dsp_st_p + m + 1
                        self.dsp_cr_p = self.dsp_st_p + m + 1
                        break
                else:
                    if m == 0 and self.dic_txt[n] == u"\u2029": #u"\u2029" #*5
                        self.txt_word = self.dic_txt[self.dic_st_p:n+1]
                        self.dic_sp_p = n + 1
                        self.dsp_sp_p = self.dsp_st_p + m + 1
                        self.dsp_cr_p = self.dsp_st_p + m
                    elif self.dic_txt[n] == u"\u2029": #u"\u2029" #*5
                        self.txt_word = self.dic_txt[self.dic_st_p:n]
                        self.dic_sp_p = n
                        self.dsp_sp_p = self.dsp_st_p + m
                        self.dsp_cr_p = self.dsp_st_p + m
                    elif  not self.dic_txt[n] == u' ': #。/、（）
                        self.txt_word = self.dic_txt[self.dic_st_p:n+1]
                        self.dic_sp_p = n + 1
                        self.dsp_sp_p = self.dsp_st_p + m + 1
                        self.dsp_cr_p = self.dsp_st_p + m + 1
                    else: # u' '
                        wk_wd = self.dic_txt[self.dic_st_p:n]
                        if re.search(u"[\'\"][^\'\"]*", wk_wd): #*7
                            #xyz"abc  format
                            n = n + 1
                            m = m + 1
                            continue
                        self.txt_word = self.dic_txt[self.dic_st_p:n]
                        self.dic_sp_p = n + 1
                        self.dsp_sp_p = self.dsp_st_p + m + 1
                        self.dsp_cr_p = self.dsp_st_p + m
                    break
        else:
            if m == 0:
                self.txt_word = ''
            else:
                self.txt_word = self.dic_txt[self.dic_st_p:n]
                self.dic_sp_p = n
                self.dsp_sp_p = self.dsp_st_p + m
                self.dsp_cr_p = self.dsp_st_p + m


    def conv_word(self):
        global My_dic_key
        global My_dic_body
        global My_usrdic_key
        global My_usrdic_body
        if self.txt_word == u"\u2029": #only LF, fix then go to next
            self.out_word = self.txt_word
            #set result word to screen, then convert next
            self.fix_and_next(dt_len=len(self.txt_word))
            return
        #make candidate word list
        conv_len = self.dsp_cr_p - self.dsp_st_p
        Word = self.txt_word[:conv_len]
        out_word_list = []
        look_up_dic_flg = 0
        wk_list = []

        m = len(Word)
        while m > 0:
            wk_wd = (Word[:m]).encode('UTF-8')

            if self.Learning and My_usrdic_key:
                #exist user dictionary, search word
                try:
                    ind = My_usrdic_key.index(wk_wd)
                except:
                    ind = None
                if not ind == None:
                    wk_list = My_usrdic_body[ind].split("/")
                    key_word = My_usrdic_key[ind]
                    look_up_dic_flg = 1
                    break
            #no word in user dic, search My_dic
            try:
                ind = My_dic_key.index(wk_wd)
            except:
                ind = None
            if not ind == None:
                wk_list = My_dic_body[ind].split("/")
                key_word = My_dic_key[ind]
                look_up_dic_flg = 2
                break
            else:
                m = m - 1

        if wk_list:
            out_word_list = [(unicode(x)) for x in wk_list]
            
        else:
            out_word_list = [Word]
            m = len(Word)
            #look_up_dic_flg = 0 #no need,already set 0 at top of proc

        #display candidate word list,then get selected word
        wd_wk = self.textbody.get(self.dsp_st_p, m) #for title on pop up menu
        #change hilighted span
        self.textbody.set_pos(self.dsp_st_p + m)
        self.select_redraw(self.dsp_st_p, self.dsp_cr_p) #*2
        self.select_highlight(self.dsp_st_p,self.dsp_st_p + m) #*2
        idx = appuifw.popup_menu(out_word_list, wd_wk)
        if idx == None: #select canceled
            self.select_highlight(self.dsp_st_p,self.dsp_cr_p) #*2
            return
        self.out_word = out_word_list[idx]

        #learning option process
        if idx != 0 and self.Learning: #not top of word list
            wd_wk = wk_list[idx]
            del wk_list[idx]
            wk_list.insert(0, wd_wk)
            new_body_list = ''
            for x in wk_list:
                new_body_list = new_body_list + x + "/"
            new_body_list = new_body_list[: -1] #remove "/" at line end 
            if look_up_dic_flg == 1: #found in user dic
                My_usrdic_body[ind] = new_body_list
            elif look_up_dic_flg == 2: #found in dic, add to user dic
                My_usrdic_key.append(key_word)
                My_usrdic_body.append(new_body_list)

        #set result word to screen, then convert next
        self.fix_and_next(dt_len=m)


    def fix_and_next(self, dt_len=0):
        global auto_next
        m = dt_len
        if m == len(self.txt_word): #word convert complete
            sel_len = self.dsp_sp_p - self.dsp_st_p
            self.textbody.set_pos(self.dsp_st_p) #move cursor ,need before delete
            self.textbody.delete(self.dsp_st_p, sel_len)
            self.textbody.set_pos(self.dsp_st_p) #need before add
            self.textbody.add(self.out_word)
            self.dsp_txt = self.textbody.get() #*11

            self.dic_st_p = self.dic_sp_p
            self.dsp_st_p = self.dsp_st_p + len(self.out_word)
            self.dsp_sp_p = self.dsp_st_p
            self.dsp_cr_p = self.dsp_st_p

            self.get_oneword()
            if self.txt_word:
                self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
                if auto_next or self.txt_word == u"\u2029":
                    self.start_next_timer() #*4
            else: # all word(s) converted
                if self.page == 'edit':
                    self.refresh_edit()
                else:
                    self.refresh_pfep()
                    cur_pos = self.textbody.get_pos()
                    if cur_pos == len(self.textbody.get()):
                        self.textbody.add(u'\n')  #* need '\n' to fix cursor pos
                        self.textbody.set_pos(cur_pos)

        else:
            sel_len = m
            self.textbody.set_pos(self.dsp_st_p) #move cursor ,need before delete
            self.textbody.delete(self.dsp_st_p, sel_len)
            self.textbody.set_pos(self.dsp_st_p) #need before add
            self.textbody.add(self.out_word)
            self.dsp_txt = self.textbody.get() #*11

            self.dsp_st_p = self.dsp_st_p + len(self.out_word)
            self.dsp_cr_p = self.dsp_st_p + (len(self.txt_word) - m)
            self.dsp_sp_p = self.dsp_sp_p - (m - len(self.out_word))

            self.txt_word = self.txt_word[m:]
            self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
            if auto_next or self.txt_word == u"\u2029":
                self.start_next_timer() #*4


    def text_encode(self, encoding="UTF-8", text=None):
        old_title = appuifw.app.title
        appuifw.app.title = u"please wait..."
        e32.ao_yield()
        if text == None:
            Text = self.textbody.get()
        else:
            Text = text
        try:
            if encoding.upper() == "UTF-8": #UTF-8
                Text = Text.replace(u"\u2029", u"\n")
                Text = Text.replace(u"\uFF5E", u"\u301C")
                Text = Text.encode("UTF-8")
            else: #Shift-JIS
                Text = Text.replace(u"\u2029", u"\r\n")
                Text = Text.replace(u"\uFF5E", u"\u301C") #wave line
                Text = Text.replace(u"\uFF0D", u"\u30FC") #hyphen
                Text = Text.encode("japanese.Shift-JIS")
        except:
            #appuifw.note(unicode("Encoding Error\ntext not saved"), "error")
            self.show_er_val()
            Text = None
        appuifw.app.title = old_title
        return Text


    def save_cv_file(self):
        text = self.textbody.get()
        self.save_file(text=text)


    def save_mid_file(self):
        mid_data = self.textbody.get(0,self.dsp_st_p) + \
                    (u"\u2029" + u"\'" + self.delimiter + u"\'") + \
                    self.txt_word + self.dic_txt[self.dic_sp_p:]
        self.save_file(text=mid_data)


    def save_file(self, text):
        save_dest = self.Gpath.get_write_path(title='File name', \
                    default_path=def_dir)
        if save_dest == None:
            self.refresh()
            return

        save_txt = self.text_encode(encoding='UTF-8', text=text)
        self.refresh()
        try:
                F = open(save_dest,'w')
                try:
                        F.write(save_txt)
                finally:
                        F.close()
        except:
                self.show_er_val()


    def sel_leftarwky(self):
        if self.dsp_cr_p > self.dsp_st_p + 1:
            self.select_redraw(self.dsp_st_p, self.dsp_cr_p)
            self.dsp_cr_p = self.dsp_cr_p - 1
            self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
        self.start_cursor_timer() #*3


    def sel_rightarwky(self):
        if self.dsp_cr_p < self.dsp_sp_p and \
                    self.dsp_cr_p < self.dsp_st_p + len(self.txt_word):
            self.select_redraw(self.dsp_st_p, self.dsp_cr_p)
            self.dsp_cr_p = self.dsp_cr_p + 1
            self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
        self.start_cursor_timer() #*3


    def sel_uparwky(self):
        if self.txt_word:
            m = self.dsp_cr_p - self.dsp_st_p
            self.out_word = self.textbody.get(self.dsp_st_p, m)
            #set result word to screen, then convert next
            self.fix_and_next(dt_len=m)
        self.start_cursor_timer() #*3

    def sel_downarwky(self):
        if self.txt_word:
            self.conv_word()
        else:
            self.get_oneword()
            if self.txt_word:
                self.conv_word()
        self.start_cursor_timer() #*3


    def sel_yeskey(self):
        self.conv_to_zenhan() #conv to Zenkaku Katakana/ABC/Symbol


    def sel_clrkey(self):
        self.clrkey_cnt = self.clrkey_cnt + 1
        self.start_clrkey_timer()

    def sel_enterky(self):
        self.enterkey_flg = 1
        self.sel_uparwky()


    def after_clrkey(self):
        """recover data that is cleared by clear key"""
        cur_pos = self.textbody.get_pos()
        out_dt  = self.dsp_txt[cur_pos : cur_pos + self.clrkey_cnt]
        self.textbody.add(out_dt)
        self.select_highlight(self.dsp_st_p, self.dsp_cr_p) 
        self.clrkey_cnt = 0


    def sel_clrkey_pfep(self):
        self.start_clrkey_timer_pfep()


    def after_clrkey_pfep(self):
        cur_pos = self.textbody.get_pos()
        if cur_pos < self.dsp_sp_p: #入力中のデータクリアなら何もしない
            #カーソルがdsp_sp_pより前に行ったら、ポインタをカーソルに合わせる
            self.dsp_st_p = self.dsp_sp_p = self.dsp_cr_p = cur_pos


    def sel_leftarw_pfep(self):
        self.start_cursor_timer()


    def sel_rightarw_pfep(self):
        self.start_cursor_timer()


    def sel_uparw_pfep(self):
        self.dic_st_p = self.dic_sp_p = 0
        cur_pos = self.textbody.get_pos()
        if (self.enterkey_flg and self.dsp_st_p == self.dsp_sp_p and
                self.dsp_st_p == cur_pos):
            self.enterkey_flg = 2 #don't delete LF after cursor timer and fix it
        else:
            self.dsp_st_p = self.dsp_sp_p = self.dsp_cr_p = cur_pos
        self.start_cursor_timer() #*3


    def sel_downarw_pfep(self):
        self.conv_edittxt()
        self.start_cursor_timer()


    def sel_enter_pfep(self):  #Enter key (SU-8W)
        self.enterkey_flg = 1
        self.sel_uparw_pfep()

    def set_cursor_pos(self):
        if self.enterkey_flg == 1: #delete LF of Enter key(after no conv fix)
            self.textbody.delete(self.cursor_pos, 1)
            self.textbody.set_pos(self.cursor_pos) #*3
        elif self.enterkey_flg == 2: #fix LF of Enter key(no conv/fix word)
            cur_pos = self.textbody.get_pos()
            self.dsp_st_p = self.dsp_sp_p = self.dsp_cr_p = cur_pos
        else:
            self.textbody.set_pos(self.cursor_pos) #*3
        self.enterkey_flg = 0


    #must cur_timer value << next_timer value
    def start_cursor_timer(self, value=0.005):
        self.cursor_pos = self.textbody.get_pos() #*3
        self.cur_timer.cancel() #*3
        self.cur_timer.after(value, lambda:self.set_cursor_pos()) #*3


    def go_next_conv(self): #*4
            self.conv_word()


    def start_next_timer(self, value=0.015): #*4
        self.next_timer.cancel()
        self.next_timer.after(value, lambda:self.go_next_conv())


    def start_clrkey_timer(self, value=0.005):
        self.clrkey_timer.cancel()
        self.clrkey_timer.after(value, lambda:self.after_clrkey())


    def start_clrkey_timer_pfep(self, value=0.005):
        self.clrkey_timer.cancel()
        self.clrkey_timer.after(value, lambda:self.after_clrkey_pfep())


    def select_highlight(self, start_pos, end_pos):
        """Highlight selected word(s)"""
        text = self.textbody
        sel_len = end_pos - start_pos
        cb_txt = text.get(start_pos, sel_len)
        """highlight selected word"""
        old_style = text.style
        text.style = appuifw.HIGHLIGHT_STANDARD
        #text.highlight_color = 0xffff00
        text.delete(start_pos, sel_len)
        text.set_pos(start_pos)
        text.add(cb_txt)
        text.style = old_style

        """necessary to reflect the highlight correctly"""
        old_body = appuifw.app.body #*2 
        appuifw.app.body = old_body #*2


    def select_redraw(self,start_pos, end_pos):
        """Clear highlight"""
        text = self.textbody
        cur_pos = text.get_pos()
        sel_len = end_pos - start_pos
        cb_txt = text.get(start_pos, sel_len)
        text.delete(start_pos, sel_len)
        text.set_pos(start_pos)
        text.add(cb_txt)
        text.set_pos(cur_pos)


    def conv_to_zenkaku(self):
        self.conv_to_zenhan(conv_tbl=Henkan_tbl)


    def conv_to_hankana(self):
        self.conv_to_zenhan(conv_tbl=Hankana_tbl)


    def conv_to_zenhan(self, conv_tbl=Henkan_tbl):
        """convert kana/ABC/*() to zenkaku or kana to hankaku kana"""
        if self.txt_word:
            m = self.dsp_cr_p - self.dsp_st_p
            u_txt = self.textbody.get(self.dsp_st_p, m)
            wd_wk = ''
            for x in u_txt:
                y = x.encode('UTF-8')
                try:   new_code = conv_tbl[y]
                except:new_code = None
                if new_code: wd_wk = wd_wk + new_code
                else:        wd_wk = wd_wk + y
            self.out_word = unicode(wd_wk)
            #len(self.out_word) is no good,because length of hankaku_dakuonn_char
            #is 2 (not 1) (length of zenkaku_dakuon is 1)
#            m = len(self.out_word)
            m = len(u_txt) 
            #set result word to screen, then convert next
            self.fix_and_next(dt_len=m)


    def conv_to_zen_pfep(self):
        self.dic_st_p = self.dic_sp_p = 0
        cur_pos = self.textbody.get_pos()
        self.dic_txt = ''
        if cur_pos > self.dsp_sp_p:
            u_txt_len = cur_pos - self.dsp_sp_p
            self.txt_word = self.textbody.get(self.dsp_sp_p, u_txt_len)
            self.dsp_cr_p = self.dsp_sp_p = cur_pos
            self.conv_to_zenhan(conv_tbl=Henkan_tbl)


    def goto_top(self):
        self.textbody.set_pos(0)


    def goto_last(self):
        last_pos = len(self.textbody.get())
        self.textbody.set_pos(last_pos)


    def go_edit(self):
        #*10 clear hilight
        txt_len = len(self.textbody.get())
        if txt_len > self.dsp_st_p:
            if txt_len >= self.dsp_cr_p:
                self.select_redraw(self.dsp_st_p, self.dsp_cr_p)
            else:
                self.select_redraw(self.dsp_st_p, txt_len)
        self.refresh_edit()


    def new_rtxt(self, first=None):
        if not first:
            if not appuifw.query(u"Really make new text?\ndata already saved?", "query"):
                return

        self.set_pointer_initial() #set pointer, buffer to initial
        self.refresh_pfep()
#        self.disp_msg('')
        self.disp_msg(u'\n') #* need '\n' to fix cursor pos
#        self.textbody.set_pos(0)


    def add_rtxt_here(self):
        self.add_rtxt_proc()


    def add_rtxt_last(self):
        self.textbody.set_pos(len(self.textbody.get())) #set cursor to last
        self.add_rtxt_proc()

    def add_rtxt_proc(self):
        cur_pos = self.textbody.get_pos()
        #*10 clear hilight
        txt_len = len(self.textbody.get())
        if txt_len > self.dsp_st_p:
            if txt_len >= self.dsp_cr_p:
                self.select_redraw(self.dsp_st_p, self.dsp_cr_p)
            else:
                self.select_redraw(self.dsp_st_p, txt_len)
        self.dic_st_p = self.dic_sp_p = 0
        self.dic_txt = ''
        self.dsp_st_p = self.dsp_cr_p = self.dsp_sp_p = cur_pos
        if cur_pos == len(self.textbody.get()):
            self.textbody.add(u'\n')  #* need '\n' to fix cursor pos
            self.textbody.set_pos(cur_pos)
        self.refresh_pfep()


    def open_edittxt(self):
        if not appuifw.query(u"Really R to KKJ?", 'query'):
                return
        self.set_pointer_initial() #set pointer, buffer to initial

        u_txt = self.textbody.get()
        rtn = self.conv2kana(u_txt)
        if rtn:
            self.page = 'pfep' #*
            self.refresh()
            self.disp_msg(self.dsp_txt)
            self.get_oneword()
            if self.txt_word:
                self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
            else:
#                self.disp_msg(u'No data\nselect next action')
                appuifw.query(u'No data\nselect next action', "query")
        else:
            appuifw.query(u"Can't convert roman file", 'query')
#            self.disp_msg(u'No data\nselect next action')


    def conv_edittxt(self):
        global auto_next
        self.dic_st_p = self.dic_sp_p = 0
        cur_pos = self.textbody.get_pos()
        if cur_pos > self.dsp_sp_p:
            u_txt_len = cur_pos - self.dsp_sp_p
            u_txt = self.textbody.get(self.dsp_sp_p, u_txt_len)
            self.textbody.set_pos(self.dsp_sp_p) #move cursor ,need before delete
            self.textbody.delete(self.dsp_sp_p, u_txt_len)
#            self.textbody.set_pos(self.dsp_sp_p)
            rtn = self.conv2kana(u_txt)
            if rtn:
                self.refresh()
                self.textbody.set_pos(self.dsp_sp_p) #need before add
                self.textbody.add(self.dsp_txt)
                self.dsp_txt = self.textbody.get() #*20 need when pushed clear key
                self.get_oneword()
                if self.txt_word:
                    self.select_highlight(self.dsp_st_p, self.dsp_cr_p)
                    if auto_next: self.start_next_timer()
                else:
                    appuifw.query(u'No data\nselect next action', "query")
            else:
                appuifw.query(u"New data not exist\nselect next action", 'query')
        else:
            self.dsp_st_p = self.dsp_cr_p = self.dsp_sp_p = cur_pos
#            appuifw.query(u'No convert data\nSome data deleted\nselect next action', "query")


def main():
    if Err_exit: return
    confread()
    R2K = R2KConv()
    R2K.run()
    del R2K

if __name__ == '__main__':
    main()

#    appuifw.app.set_exit()
#    sys.exit()

