# -*- coding:utf-8 -*-
"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU General Public License version 2 or later.

"""
__scriptname__ = 'PyMyViewer'
__version__ = '0.02(1)'
__author__ = 'masa'
__web__ = 'http://masaland.cocolog-nifty.com/'
__copyright__ = 'Copyright (C) 2008-2012 masa'


import sys
sys.setdefaultencoding('utf-8')
sys.path.insert(0, 'E:\\Python\\lib')

import e32
import os
import appuifw
import graphics
import re
import dir_iter
try:
    from PyFbuiutil import Fbrowser
    Err_exit = 0
except:
    rtn = appuifw.query(unicode("Please install PyFbuiutl.py"), "query")
#    sys.exit(0)
    Err_exit = 1


#### Please change here or INI_FILE.
#### If INI_FILE exists,INI_FILE is used instead of this part.
INI_FILE   = 'E:\\Data\\masa\\PyMyViewer.ini'
Home_path  = 'E:\\Images\\Camera'
Error_image = 'E:\\Data\\masa\\error_image.jpg'
#

# other global variables,no need to change
Menu_msg = ['＊＊Select menu＊＊','＊＊from option＊＊']

# view size = normal
pxn0,pxn1,pxn2      = 16, 132, 248 # 16+(96+20)*n
pyn0,pyn1,pyn2,pyn3 = 15, 132, 249, 366 # 15+(72+5+20+5+15)*n
ptn0,ptn1,ptn2,ptn3 = 112, 229, 346, 463 # (15+72+5+20)+(5+15+72+5+20)*n

pos_listn = [[pxn0,pyn0,ptn0],[pxn1,pyn0,ptn0],[pxn2,pyn0,ptn0],
			 [pxn0,pyn1,ptn1],[pxn1,pyn1,ptn1],[pxn2,pyn1,ptn1],
			 [pxn0,pyn2,ptn2],[pxn1,pyn2,ptn2],[pxn2,pyn2,ptn2],
			 [pxn0,pyn3,ptn3],[pxn1,pyn3,ptn3],[pxn2,pyn3,ptn3]]
Max_cntn = 12
Widthn, Heightn = 96,72

# view size = big
pxb0,pxb1      = 16, 180 # 16+(144+20)*n
pyb0,pyb1,pyb2 = 15, 168, 321 # 15+(108+5+20+5+15)*n
ptb0,ptb1,ptb2 = 148, 301, 454 # (15+108+5+20)+(5+15+108+5+20)*n

pos_listb = [[pxb0,pyb0,ptb0],[pxb1,pyb0,ptb0],
			 [pxb0,pyb1,ptb1],[pxb1,pyb1,ptb1],
			 [pxb0,pyb2,ptb2],[pxb1,pyb2,ptb2]]
Max_cntb = 6
Widthb, Heightb = 144,108


class Viewer:
    def __init__(self):
        self.v_lock = e32.Ao_lock()
        self.WIDTH  = Widthn
        self.HEIGHT = Heightn
        self.pos_list = pos_listn
        self.Max_cnt = Max_cntn
        self.Disp_size = 0 # 0:normal 1:big

    def run(self):
        self.In_path = Home_path
        self.index = ''
        self.cnt = 0
        self.Fb = Fbrowser("Select")
        self.canvas = appuifw.Canvas()
        appuifw.app.body = self.canvas
        self.cwidth,self.cheight = self.canvas.size
        self.refresh()
        self.v_lock.wait()
        del self.Fb

    def refresh(self,msg=Menu_msg):
        self.disp_msg(msg,fontsize='normal')
        self.set_dirmenu()

    def show_er_val(self,file_name):
        import sys
        type, value = sys.exc_info() [:2]
        #appuifw.note(unicode(str(type)+'\n'+str(value)), 'error')
        rtn = appuifw.query(unicode(str(type)+'\n'+str(value)+'\n'+file_name), 'query')


    def sel_dir(self):
        sel_path = self.Fb.select(default_path = self.In_path)
        if sel_path:
            self.In_path = sel_path[0]
            self.view_image()
        else:
            self.refresh()

    def home_dir(self):
        self.In_path = Home_path
        if os.path.isdir(self.In_path):
            self.view_image()
        else:
            rtn = appuifw.query(unicode('No Home_dir or not dir\n' + \
                                           self.In_path),'query')
            self.refresh()

    def change_size(self):
        if self.Disp_size == 0: # 0:normal
            self.Disp_size = 1  # 1:big
            self.pos_list = pos_listb
            self.Max_cnt = Max_cntb
            self.WIDTH, self.HEIGHT = Widthb, Heightb
            msg = '      (display 2x3)'
        else:
            self.Disp_size = 0
            self.pos_list = pos_listn
            self.Max_cnt = Max_cntn
            self.WIDTH, self.HEIGHT = Widthn, Heightn
            msg = '      (display 3x4)'
        msg = Menu_msg + ['', '     size changed', msg]
        self.disp_msg(msg, fontsize='normal')

    def selected_exit(self):
        self.EXIT_FLG = 1
        self.v_lock.signal()

    def selected_can(self):
        self.CAN_FLG = 1
        self.index = ''
        self.cnt = 0
        self.refresh()

    def set_mainmenu(self):
        appuifw.app.title = unicode(__scriptname__ + '  ' + __version__)
        appuifw.app.exit_key_handler = lambda:self.selected_exit() 
        appuifw.app.menu = [(unicode('Exit'), self.selected_exit)] 

    def set_submenu(self):
        appuifw.app.title = unicode(__scriptname__ + '  ' + __version__)
        appuifw.app.exit_key_handler = lambda:self.selected_exit()
        appuifw.app.menu = [(unicode('OK/Next'),self.view_image),
                            (unicode('Cancel'),self.selected_can ),
                            (unicode('Exit'), self.selected_exit)]

    def set_dirmenu(self):
        appuifw.app.title = unicode(__scriptname__ + '  ' + __version__)
        appuifw.app.exit_key_handler = lambda:self.selected_exit()
        appuifw.app.menu = [(unicode('View image'),
                               ((unicode('Go to select dir'),self.sel_dir),
                                (unicode('Go to Home dir'),self.home_dir),
                                (unicode('Current dir'), self.view_image))),
                            (unicode('Change image size'),self.change_size ),
                            (unicode('Exit'), self.selected_exit)]


    def disp_msg(self,msg,fontsize='dense'):
        appuifw.app.body = self.canvas
        txt_img = graphics.Image.new((self.cwidth,self.cheight))
        txt_img.rectangle(((0,0),(self.cwidth,self.cheight)),fill=(0,0,0))
        for i in range(len(msg)):
            py = 46 + 54 * (i)
            pt1 = py - 30
            pt2 = py + 6
            if msg[i]:
                if i < 2:
                    txt_img.rectangle(((15,pt1),(345,pt2)),fill=(224,20,20))
                txt_img.text((50,py), unicode(msg[i]), \
						fill=(255,255,255), font=fontsize)
        self.canvas.blit(txt_img)


    def view_image(self):
        self.EXIT_FLG = 0
        self.CAN_FLG = 0
        clear_img = graphics.Image.new((self.cwidth,self.cheight))
        self.canvas.blit(clear_img)

        self.set_submenu()

#       ビューの初回ならリスト作成（OKで来る2回目以降は作成しない）
        if not self.index:
            self.filelist = [x.decode('utf-8') for x in os.listdir(self.In_path) \
				if os.path.isfile(os.path.join(self.In_path, x)) and \
				(os.path.splitext(x)[1][1:3]).lower() == "jp" ]
            if self.filelist == []:
                self.disp_msg(['', '＊＊No JPG File in dir＊＊'],fontsize='normal')
                self.set_dirmenu()
                return

            self.filelist.sort()
            self.filelist.reverse()

            menu_list = [u'file select',u'all files',u'cancel']
            menu = appuifw.selection_list(menu_list)
            if menu == 0:
                self.index = appuifw.multi_selection_list(choices=self.filelist)
                if not self.index:
                    self.refresh()
                    return #exit
            elif menu == 1:
                self.index = [x for x in range(len(self.filelist))]
            else:
                self.refresh()
                return #exit

#       処理中表示
        self.disp_msg(['', '    ＊＊画像処理中＊＊'],fontsize='normal')

#       ビュー処理
        p = 0
        display_img = []
        name_list = []
        for r in range(self.cnt, len(self.index)):
            x = self.index[r]
            file_name = self.filelist[x]
            name_list.append(os.path.splitext(file_name)[0])

            appuifw.app.title = file_name # display image file name
            FILE = os.path.join(self.In_path, file_name)

            try:
                img = graphics.Image.open(FILE)
            except:
                self.show_er_val(file_name)
                try:
                    img = graphics.Image.open(Error_image)
                except:
                    self.disp_msg(['', '＊＊No Error_image file＊＊'],fontsize='normal')
                    self.index = ''
                    self.set_dirmenu()
                    return
            display_img.append(img.resize((self.WIDTH, self.HEIGHT),keepaspect=1))

#            ＊１：処理した画像を表示する（表示は１画像のみ、前の画像は消える）
#            appuifw.app.body = self.canvas
#            pos_x = self.pos_list[p][0]
#            pos_y = self.pos_list[p][1]
#            clear_img = graphics.Image.new((self.cwidth,self.cheight))
#            clear_img.rectangle(((0,0),(self.cwidth,self.cheight)),fill=(0,0,0))
#            self.canvas.blit(clear_img)
#            self.canvas.blit(display_img[p],target=(pos_x,pos_y), \
#					source=((0,0),display_img[p].size))

#            ＊２：処理中の画像の名前を表示する。
#            appuifw.app.body = self.canvas
#            txt_img = graphics.Image.new((self.cwidth,self.cheight))
#            txt_img.rectangle(((0,0),(self.cwidth,self.cheight)),fill=(0,0,0))
#            txt_img.text((80,46), unicode('＊＊画像処理中＊＊'), \
#						fill=(255,255,255), font='normal')
#            txt_img.text((80,100), unicode(file_name), \
#						fill=(255,255,255), font='normal')
#            self.canvas.blit(txt_img)

            p = p + 1
            self.cnt = self.cnt + 1

            if p == self.Max_cnt:  #screen full
                self.set_submenu()
                n = len(display_img)
                appuifw.app.body = self.canvas
                txt_img = graphics.Image.new((self.cwidth,self.cheight))
                txt_img.rectangle(((0,0),(self.cwidth,self.cheight)),fill=(0,0,0))

                for i in range(n):
                    pos_x = self.pos_list[i][0]
                    pos_y = self.pos_list[i][1]
                    pos_t = self.pos_list[i][2]
                    txt_img.text((pos_x,pos_t), unicode(name_list[i]), \
						fill=(255,255,255), font='symbol')
                self.canvas.blit(txt_img)

                for i in range(n):
                    pos_x = self.pos_list[i][0]
                    pos_y = self.pos_list[i][1]
                    pos_t = self.pos_list[i][2]
                    self.canvas.blit(display_img[i], target=(pos_x,pos_y), \
						source=((0,0), display_img[i].size))
                p = 0
                if self.cnt >= len(self.index): #002(1) no more picture
                    self.index = ''             #002(1)
                    self.cnt = 0                #002(1)
                break

            if self.EXIT_FLG or self.CAN_FLG:
                self.index = ''
                self.cnt = 0
                break


        else:   # no more picture
            self.set_submenu()
            n = len(display_img)
            appuifw.app.body = self.canvas
            txt_img = graphics.Image.new((self.cwidth,self.cheight))
            txt_img.rectangle(((0,0),(self.cwidth,self.cheight)),fill=(0,0,0))

            for i in range(n):
                pos_x = self.pos_list[i][0]
                pos_y = self.pos_list[i][1]
                pos_t = self.pos_list[i][2]
                txt_img.text((pos_x,pos_t), unicode(name_list[i]), \
						fill=(255,255,255), font='symbol')
            self.canvas.blit(txt_img)

            for i in range(n):
                pos_x = self.pos_list[i][0]
                pos_y = self.pos_list[i][1]
                pos_t = self.pos_list[i][2]
                self.canvas.blit(display_img[i], target=(pos_x,pos_y), \
						source=((0,0), display_img[i].size))
            self.index = ''
            self.cnt = 0

def confread():
    global Home_path
    global Error_image
    try:
        f = open(INI_FILE,'r')
        fData = f.read()
        f.close
    except:
        return
    fData = unicode(fData)

    #split by \n and omit line that contain only (CR/LF)
    lnDatalist = [x for x in fData.split(u"\n") if len(x) > 1]

    for lnData in lnDatalist:
        lnDatawk = re.sub(u"[ \t]+",u" ",lnData)
        lnDatawk = (re.sub(u"[\n\r]+",u"",lnDatawk)).strip()
        confData=lnDatawk.split(u" ")
        if len(confData) < 2: continue # no confData[1] error
        if confData[0]   == u"Home_path" : Home_path = (confData[1])
        if confData[0]   == u"Error_image" : Error_image = (confData[1])


def main():
    """メインの関数"""
    old_title = appuifw.app.title
    confread()
    View = Viewer()
    View.run()
    appuifw.app.title = old_title


if __name__ == '__main__':
    if Err_exit == 0:
        main()
#appuifw.app.set_exit()
#sys.exit()
