#-*- coding:utf-8 -*-

"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU Lesser General Public License version 2.1 or later.

  name      = PyFbuiutil
  version   = 0.01(0)
  author    = masa
  web__     = http://masaland.cocolog-nifty.com/
  Copyright = Copyright (c) 2009 masa
"""

import sys
sys.setdefaultencoding('utf-8')
sys.path.insert(0, 'E:\\Python\\lib')
import os
import appuifw
import e32
import dir_iter
from key_codes import EKeyLeftArrow
from key_codes import EKeyRightArrow

class Fbrowser:
    """
    use this class to browse and select files.
    after selected, file path will return.
    """
    def __init__(self, title):
        self.lock = e32.Ao_lock()
        self.dir_stack = []
        self.current_dir = dir_iter.Directory_iter(e32.drive_list())
        self.title = title
        self.entries =[]


    def search_id(self, dir):
        list=self.current_dir.list_repr()
        list=[x[0] for x in list]
        #if not self.current_dir.at_root:     # don't inset "."  and "..",
        #    list.insert(0, (u"."))           # this is only memo
        #    list.insert(0, (u".."))          # *1
        return list.index(dir)

    def go_default(self, default_path=None):
        def_path = os.path.normpath(default_path)
        if not os.path.isdir(def_path):
            rtn = appuifw.query(unicode('No default dir or not dir\n'+def_path),'query')
            self.dir_stack = []
            self.current_dir = dir_iter.Directory_iter(e32.drive_list())
            return
        self.current_dir = dir_iter.Directory_iter(e32.drive_list())
        wk = def_path.split("\\")
        self.dir_stack=[]
        for x in wk:
            if x:  #when "." selected  ,splited last item is [] (enpty item)
                if self.current_dir.at_root:
                    id = self.search_id(x) # C:/E:
                    self.current_dir.add(id)
                    self.dir_stack.append(id)
                else:
                    id = self.search_id("["+ x +"]")
                    self.current_dir.add(id)
                    self.dir_stack.append(id + 2)  # +2 for "." and ".." *1

    def select(self, default_path=None):
        #from key_codes import EKeyLeftArrow
        #from key_codes import EKeyRightArrow
        self.selection = None
        if default_path != None:
            self.go_default(default_path)
        self.entries = self.current_dir.list_repr()
        if not self.current_dir.at_root:
            self.entries.insert(0, (u".", u""))
            self.entries.insert(0, (u"..", u""))
            self.entries = [x[0] for x in self.entries]
        else:
            self.entries = [x[0] + "    " + x[1] for x in self.entries]
        self.lb = appuifw.Listbox(self.entries, self.lbox_observe)
        self.lb.bind(EKeyLeftArrow, lambda: self.lbox_observe(1))
        self.lb.bind(EKeyRightArrow, lambda: self.lbox_observe(2))
        old_title = appuifw.app.title
        self.refresh()
        self.lock.wait()
        appuifw.app.title = old_title
        appuifw.app.body = None
        self.lb = None
        return self.selection

    def refresh(self):
        appuifw.app.title = unicode(self.title)
        appuifw.app.menu = []
        appuifw.app.exit_key_handler = self.do_cancel
        appuifw.app.body = self.lb

    def do_cancel(self):
        self.selection = None
        self.exit_key_handler()

    def do_dummy(self):
        pass

    def exit_key_handler(self):
        appuifw.app.exit_key_handler = None
        self.lock.signal()

    def lbox_observe(self, ind = None):
        if not ind == None:
            idx = ind    # 1 or 2
        else:
            idx = 0
        index = self.lb.current()
        focused_item = 0

        if self.current_dir.at_root:
            if not idx == 1:                        # not Left Arrow Key
                self.dir_stack.append(index)
                self.current_dir.add(index)
            else:                                   # Left Arrow Key
                focused_item = index                # don't move pointer
        elif idx == 1:                              # Left Arrow Key
            focused_item = self.dir_stack.pop()
            self.current_dir.pop()
        elif idx == 2:                              # Right Arrow Key
            if index == 0 or index == 1:            # ".." or "." selected
                focused_item = index
            elif os.path.isdir(self.current_dir.entry(index-2)):
                self.dir_stack.append(index)
                self.current_dir.add(index-2)
            else:                                   # file selected
                focused_item = index                # don't move pointer

        #elif index == 0:                              #".." selected
        elif self.entries[index] == u'..':             #".." selected
            focused_item = self.dir_stack.pop()
            self.current_dir.pop()

        #= Return current directory
        #elif index == 1:                              # "." selected
        elif self.entries[index] == u'.':              #= "."selected
            self.selection = (self.current_dir.name(), '')
#            item = self.current_dir.entry(index-2)
#            self.selection = (item, '')
            self.lock.signal()
            return

        elif os.path.isdir(self.current_dir.entry(index-2)):
            self.dir_stack.append(index)
            self.current_dir.add(index-2)

        # file selected, Return current directory and file name
        else:
            item = self.current_dir.entry(index-2)
            self.selection = os.path.split(item)
            self.lock.signal()
            return

        self.entries = self.current_dir.list_repr()
        if not self.current_dir.at_root:
            self.entries.insert(0, (u".", u""))
            self.entries.insert(0, (u"..", u""))
            self.entries = [x[0] for x in self.entries]
        else:
            self.entries = [x[0] + "    " + x[1] for x in self.entries]
        self.lb.set_list(self.entries, focused_item)


class Getpath:
  """
  This class contain 2 procedures.
    get_read_path : get file path for read
    get_write_path: get file path for write
  Both proc return file path. When selection is canceled, return None
  """
  def __init__(self):
    pass

  def get_read_path(self, title="Select", default_path=None):
    """
    get file path for read.
    "file_path" is complete path to selected file.
    When selection is canceled, the content of file_path is None.
    """
    self.fb = Fbrowser(title) # use with Fbrowser class
    file_path = ''
    current_dir = default_path
    while True:
      sel_path = self.fb.select(current_dir)
      if sel_path == None:
        file_path = None
        break
      file_path = os.path.join(sel_path[0],sel_path[1])
      current_dir = sel_path[0] # default dir for next self.fb
      if os.path.isfile(file_path):
        break

    return file_path


  def get_write_path(self,title="File name", default_path=None, \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt"):
    """
    get file path for write.
    "file_path" is complete path to selected file.
    When selection is canceled, the content of file_path is None.
    """
    self.fb = Fbrowser(title)
    file_path = ''
    current_dir = default_path
    while True:
      sel_path = self.fb.select(current_dir)
      if sel_path == None:
        file_path = None
        break
      file_path = os.path.join(sel_path[0], sel_path[1])
      current_dir = sel_path[0]

      if os.path.isfile(file_path):
        if appuifw.query(unicode(msg_ow+'\n'+sel_path[1]),"query"):
          break # over write
      elif os.path.isdir(file_path):
        nfile_name = appuifw.query(unicode(msg_fn), "text", \
                                              unicode(msg_ex))
        if nfile_name is not None:
          file_path = os.path.join(sel_path[0], nfile_name)
          if os.path.isfile(file_path):
            if appuifw.query(unicode(msg_ow+'\n'+nfile_name),"query"):
              break
          else:
            break

    return file_path


class Testproc:
  """
  Test class that tests Fbrowser, get_readfilename, and 
  get_writefilename. Gotten file name is only displayed. 
  """
  def __init__(self):
    self.lock = e32.Ao_lock()
    self.body = appuifw.Text()
    self.gp = Getpath()



  def run(self):
      self.start_msg = ["Choose operation from menu.\n",
                        "Show selected file path.\n",
                        "File never overwrite."]
      self.disp_result(self.start_msg)
      self.refresh()
      self.lock.wait()


  def do_none(self):
    pass


  def exit_key_handler(self):
    appuifw.app.exit_key_handler = None
    self.lock.signal()


  def refresh(self):
      appuifw.app.title = unicode("Testproc")
      appuifw.app.menu = [
             (unicode("Get&disp rd file1"), self.test_get_read_path1),
             (unicode("Get&disp rd file2"), self.test_get_read_path2),
             (unicode("Get&disp rd file3"), self.test_get_read_path3),
             (unicode("Get&disp wr file1"), self.test_get_write_path1),
             (unicode("Get&disp wr file2"), self.test_get_write_path2),
             (unicode("Get&disp wr file3"), self.test_get_write_path3),
             (unicode("Exit"), self.exit_key_handler)]
      appuifw.app.exit_key_handler = lambda: self.do_none()


  def disp_result(self,msglist):  # dispaly search result
    self.body.clear()
    appuifw.app.body = self.body
    self.body.font = 'dense'   # small
    self.body.color = 0x000000
    for i in range(len(msglist)):
        self.body.add(unicode((str(msglist[i])),'utf-8'))
#    self.body.set_pos(0) #  move cursol to top
    e32.ao_sleep(0.001,) # screen redrow


  def test_get_read_path1(self):
    file_path = self.gp.get_read_path(title="Select", default_path=None)
    if file_path == None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_read_path2(self):
    file_path = self.gp.get_read_path(title="Select", \
                              default_path = "E:\\Data\\masa")
    if file_path == None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_read_path3(self):
    file_path = self.gp.get_read_path(title="Select", \
                                    default_path = "E:\\Data\\masa\\Zzz")
    if file_path == None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_write_path1(self):
    file_path = self.gp.get_write_path(title="File name", default_path=None, \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt")
    if file_path != None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_write_path2(self):
    file_path = self.gp.get_write_path(title="File name", \
               default_path = "E:\\Data\\masa", \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt")
    if file_path != None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


  def test_get_write_path3(self):
    file_path = self.gp.get_write_path(title="File name", \
               default_path = "E:\\Data\\masa\\Zzz", \
               msg_ow="Allow overwrite ?", msg_fn="File name", \
               msg_ex="new_text.txt")
    if file_path != None:
        # Processing when file selection is canceled
        pass
    else:
        # Processing when correct file name has gotten
        pass

    rtn = appuifw.query(unicode(file_path),"query")
    self.disp_result(self.start_msg)
    self.refresh()


if __name__ == '__main__':
  Tp = Testproc()
  Tp.run()
#  appuifw.app.set_exit()
#  sys.exit()
