# -*- coding:utf-8 -*-
"""
This program is free software.This program is distributed 
WITHOUT ANY WARRANTY.You should use it on your own risk. 

You can modify/redistribute it under the terms of the 
GNU General Public License version 2 or later.

"""

__pmshell_script__ = 'PyMyShell'
__pmshell_ver__ = '0.04(0)'
__pmshell_author__ = 'masa'
__pmshell_web__ = 'http://masaland.cocolog-nifty.com/'
#__copyright__ = 'Copyright (C) 2008-2017 masa'
__pmshell_copyr__     = '(C) 2008-2017 masa'

import sys
import os
import os.path
if not hasattr(sys, "setdefaultencoding"):
    wk = sys.stdout
    reload(sys)
    sys.stdout = wk
sys.setdefaultencoding('utf-8')
if os.path.isdir('E:\\Python\\lib') :
    if not ('E:\\Python\\lib' in [sys.path[0]]):
        sys.path.insert(0, 'E:\\Python\\lib')

import appuifw
import e32
import re
import dir_iter
import time
from key_codes import EKeyLeftArrow
from key_codes import EKeyRightArrow

appuifw2_exist = 0
try:
    import appuifw2
    #appuifw = appuifw2
    appuifw2_exist = 1
except ImportError:
    #pass
    appuifw2_exist = 0

#------- config data---------------------------
__pmshell_inifile__ = 'E:/Data/masa/PyMyShell.ini'
pmshell_Jump_range = 4   #Jump range (Right/Left Arrow key)
pmshell_slide_scroll = 1 # 1:slide scroll active / 0:inactive
pmshell_interval = 0.01  # list screen redraw interval

pmshell_Lists ={
    unicode('01_ふぶき')        :u'E:/Python/fubuki_m.py',
    unicode('02_ふぶき変換')    :u'E:/Python/fubuki2htm.py',
    unicode('03_画像リサイズ')  :u'E:/Python/PyResizeJpgS.py',
    unicode('04_ファイル転送')  :u'E:/Python/PyMyFTP.py',
    unicode('05_電話帳')        :u'E:/Python/jContacts.py',
    unicode('06_ノートNdb')     :u'E:/Python/PyNoteNdb.py',
    unicode('07_ノートPad')     :u'E:/Python/PyNotePad.py',
    unicode('08_st2ch')         :u'E:/Python/st2ch.py',
    unicode('09_Filebrowser')   :u'E:/Python/Filebrowser.py' ,
    unicode('10_PyMyEditor')    :u'E:/Python/PyMyEditor.py'
        }
#----------------------------------------------

def confread():
    global pmshell_Lists
    global pmshell_Jump_range
    global pmshell_slide_scroll

    try:
        F = open(__pmshell_inifile__,'r')
        FData = F.read()
        F.close()
    except:
        return

    FLists  = {}
    cnt = 0
    #split by \n and omit line that contain only (CR/LF)
    lnDatalist = [x for x in FData.split("\n") if len(x) > 1]

    for lnData in lnDatalist:
        lnDatawk = re.sub("[ \t]+"," ",lnData)
        lnDatawk = (re.sub("[\n\r]+","",lnDatawk)).strip()
        confData = lnDatawk.split(" ")
        if len(confData) < 2: continue # no confData[1] error
        if   confData[0].lower() == "jump_range"  : pmshell_Jump_range = int(confData[1])
        elif confData[0].lower() == "slide_scroll": pmshell_slide_scroll = int(confData[1])
        elif confData[0].lower() == "Interval"    : pmshell_interval = int(confData[1])
        elif confData[0].lower() == "lists":
            if len(confData) > 2: # 
                #Insert "no_" 
                cnt = cnt + 1
                if cnt < 10 : cnt_str = '0'+str(cnt)+'_'
                else:         cnt_str = str(cnt)+'_'
                FLists.update({unicode(cnt_str + confData[1]):unicode(confData[2])})
    if FLists:
        FLists.update({u'_':u'_'}) #dummy item スライドスクロール有効時に必要
        pmshell_Lists = FLists


class Shell:
    def __init__(self):
        self.lock = e32.Ao_lock()
        self.lists = pmshell_Lists
        self.sel_list = []
        self.timer = e32.Ao_timer()

    def run(self):
        confread()
        self.lists = pmshell_Lists
        self.sel_list = self.lists.keys()
        self.sel_list.sort()
        if appuifw2_exist == 1:
            self.sel_listbox = appuifw2.Listbox(self.sel_list,self.exec_app)
        else:
            self.sel_listbox = appuifw.Listbox(self.sel_list,self.exec_app)
        self.sel_listbox.bind(EKeyLeftArrow, lambda: self.jump('b'))
        self.sel_listbox.bind(EKeyRightArrow, lambda: self.jump('f'))
        old_title = appuifw.app.title
        self.refresh()
        if pmshell_slide_scroll:
            self.timer.after(pmshell_interval,self.timeout_cb)
        self.lock.wait()
        self.timer.cancel() 
        self.sel_listbox = None
        appuifw.app.title = old_title
#        appuifw.app.body = None
        appuifw.app.body = appuifw.Text() #python 2.0.0


    def refresh(self):
        appuifw.app.title = unicode(__pmshell_script__)
        appuifw.app.menu = [(u'Exec app',self.exec_app ),
                            (u'Goto',
                              ((u'goto num',self.goto_num),
                               (u'top',lambda: self.jump('t')),
                               (u'mid',lambda: self.jump('m')),
                               (u'last',lambda: self.jump('l')))),
                            (u'Page up/down',
                              ((u'page up',lambda: self.jump('b')),
                               (u'page down',lambda: self.jump('f')))),
                            (u'About',self.about ),
                            (u'Exit', self.exit_key_handler)]
        appuifw.app.exit_key_handler = self.do_dummy #self.exit_key_handler
        appuifw.app.body = self.sel_listbox


    def timeout_cb(self):
        appuifw.app.body = self.sel_listbox
#        e32.ao_yield()
        self.timer.cancel() 
        self.timer.after(pmshell_interval,self.timeout_cb)


    def do_dummy(self):
        return

    def do_exit(self):
        appuifw.app.body = appuifw.Text() #python 2.0.0
        self.lock.signal()

    def exit_key_handler(self):
        appuifw.app.exit_key_handler = None
        appuifw.app.body = appuifw.Text() #python 2.0.0
        self.lock.signal()

    def exec_app(self):
        self.timer.cancel()
        i = self.sel_listbox.current()
        item = self.lists.get(self.sel_list[i])

        if i == len(self.sel_list)-1: # end of list [EOL] #*0040
            pass
        elif os.path.isfile(item):
            try:
                execfile(item, globals())
            except:
                appuifw.note(u'Error !!\nSome error occured when exec py!', 'error')
        else:
            appuifw.note(u'Error !!\nNo such py file !', 'error')
        self.refresh()
        #delete duplicated E/C:\Python\lib
        flg_Elib = flg_Clib = 0
        wk = []
        for n in range(0, len(sys.path)):
            if (sys.path[n]).upper() == 'E:\\PYTHON\\LIB':
                if flg_Elib == 0:
                    wk.append(sys.path[n])
                    flg_Elib = 1
            elif (sys.path[n]).upper() == 'C:\\PYTHON\\LIB':
                if flg_Clib == 0:
                    wk.append(sys.path[n])
                    flg_Clib = 1
            else:
                wk.append(sys.path[n])
        sys.path = wk
        if pmshell_slide_scroll:
            self.timer.cancel()
            self.timer.after(pmshell_interval,self.timeout_cb)


    def about(self):
        msg = ('App : ' + __pmshell_script__ + '\n') + \
              ('Ver : ' + __pmshell_ver__ + '\n') + \
              (__pmshell_copyr__ + '\n') + \
              (__pmshell_web__ )
        appuifw.query(unicode(msg, "utf-8"), "query")

    def jump(self, flg):
        i = self.sel_listbox.current()
        i_max = len(self.sel_list) - 2 # - 1 #*0040
        if   flg == 'f': # f jump forward
            i = i + pmshell_Jump_range
            if i > i_max : i = i_max
        elif flg == 'b': # b jump backward
            i = i - pmshell_Jump_range
            if i < 0 : i = 0
        elif flg == 't': # t top page
            i = 0
        elif flg == 'm': # m middle
            i = i_max/2
        elif flg == 'l': # l last page
            i = i_max
        self.sel_listbox.set_list(self.sel_list, i)


    def goto_num(self):
        num = appuifw.query(u"Go to num", "number", 1)
        if num != None:
            if num == 0:
                i = 0
            else:
                num_max = len(self.sel_list) - 1 # - 0 #*0040
                if num > num_max:
                    i = num_max - 1
                else:
                    i = num - 1
            self.sel_listbox.set_list(self.sel_list, i)


def main():
    S = Shell()
    S.run()
    del S

if __name__ == '__main__':
    main()
#appuifw.app.set_exit()
#sys.exit()
