/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.parser.rule;

import java.util.HashMap;
import java.util.Map;
import jp.hishidama.html.parser.rule.HtParser;
import jp.hishidama.html.parser.rule.ParseBody;
import jp.hishidama.html.parser.rule.ParseDd;
import jp.hishidama.html.parser.rule.ParseHead;
import jp.hishidama.html.parser.rule.ParseHtml;
import jp.hishidama.html.parser.rule.ParseInline;
import jp.hishidama.html.parser.rule.ParseLi;
import jp.hishidama.html.parser.rule.ParseOption;
import jp.hishidama.html.parser.rule.ParsePriority;
import jp.hishidama.html.parser.rule.ParseRb;
import jp.hishidama.html.parser.rule.ParseTbody;
import jp.hishidama.html.parser.rule.ParseTd;
import jp.hishidama.html.parser.rule.ParseTr;

public class HtParserManager {
    protected final Map<String, HtParser> map = new HashMap<String, HtParser>();
    protected HtParser defaultParser;

    public HtParserManager() {
        this.init();
    }

    protected void init() {
        this.initParsers();
        this.initNoBody();
        this.initOmmitS();
        this.initOmmitE();
        this.initBlock();
    }

    protected void initParsers() {
        String[] inline;
        String[] stringArray = inline = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "address", "legend", "a", "font", "tt", "i", "b", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "sub", "sup", "span", "bdo", "q", "label"};
        int n = inline.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.setParser(new ParseInline(name));
            ++n2;
        }
        int prio = 255;
        this.setParser(new ParseHtml(prio));
        this.setParser(new ParsePriority("frameset", --prio));
        this.setParser(new ParsePriority("noframes", --prio));
        this.setParser(new ParseHead(--prio));
        this.setParser(new ParseBody(prio));
        int table_prio = --prio;
        int dl_prio = prio;
        this.setParser(new ParsePriority("table", prio));
        this.setParser(new ParsePriority("ul", prio));
        this.setParser(new ParsePriority("ol", prio));
        this.setParser(new ParsePriority("dl", prio));
        this.setParser(new ParseLi(--prio));
        this.setParser(new ParseDd("dd", --dl_prio));
        this.setParser(new ParseDd("dt", dl_prio));
        this.setParser(new ParseTbody("thead", --table_prio));
        this.setParser(new ParseTbody("tbody", table_prio));
        this.setParser(new ParseTbody("tfoot", table_prio));
        this.setParser(new ParseTr(--table_prio));
        this.setParser(new ParseTd("td", --table_prio));
        this.setParser(new ParseTd("th", table_prio));
        this.setParser(new ParseOption());
        this.setParser(new ParseRb("rb"));
        this.setParser(new ParseRb("rp"));
        this.setParser(new ParseRb("rt"));
    }

    protected void initNoBody() {
        String[] names;
        String[] stringArray = names = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param", "wbr"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            HtParser p = this.getParser(name);
            p.setNoBody(true);
            ++n2;
        }
    }

    protected void initOmmitS() {
        String[] names;
        String[] stringArray = names = new String[]{"body", "head", "html", "rb", "tbody"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            HtParser p = this.getParser(name);
            p.setOmmitS(true);
            ++n2;
        }
    }

    protected void initOmmitE() {
        String[] names;
        String[] stringArray = names = new String[]{"body", "dd", "dt", "head", "html", "li", "option", "p", "rb", "rp", "rt", "tbody", "td", "tfoot", "th", "thead", "tr"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            HtParser p = this.getParser(name);
            p.setOmmitE(true);
            ++n2;
        }
    }

    protected void initBlock() {
        String[] names;
        String[] stringArray = names = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "multicol"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            HtParser p = this.getParser(name);
            p.setBlock(true);
            ++n2;
        }
    }

    protected void setParser(HtParser p) {
        p.setManager(this);
        this.map.put(p.getName(), p);
    }

    protected final HtParser getCachedParser(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.map.get(name.toLowerCase());
    }

    public final HtParser getParser(String name) {
        HtParser p = this.getCachedParser(name);
        if (p == null) {
            if (name == null || name.isEmpty()) {
                return this.getDefaultParser();
            }
            p = this.newParser(name);
            this.setParser(p);
        }
        return p;
    }

    public final HtParser getDefaultParser() {
        if (this.defaultParser == null) {
            HtParser p = this.newParser(null);
            p.setManager(this);
            this.defaultParser = p;
        }
        return this.defaultParser;
    }

    protected HtParser newParser(String name) {
        return new HtParser(name);
    }
}

