/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.parser.rule;

import java.util.ArrayList;
import java.util.List;
import jp.hishidama.html.lexer.token.ListToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.parser.elem.HtElement;
import jp.hishidama.html.parser.elem.HtListElement;
import jp.hishidama.html.parser.elem.HtTagElement;
import jp.hishidama.html.parser.elem.HtTokenElement;
import jp.hishidama.html.parser.rule.HtParserManager;

public class HtParser {
    protected boolean DEBUG = false;
    private String name;
    protected boolean noBody = false;
    protected boolean ommitS = false;
    protected boolean ommitE = false;
    protected boolean block = false;
    protected int prio = 0;
    protected HtParserManager manager;

    protected HtParser(String name) {
        this.setName(name);
    }

    public final void setName(String name) {
        if (name != null) {
            this.name = name.toLowerCase();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setNoBody(boolean b) {
        this.noBody = b;
    }

    public final boolean hasNoBody() {
        return this.noBody;
    }

    public final void setOmmitS(boolean b) {
        this.ommitS = b;
    }

    public final boolean canOmmitS() {
        return this.ommitS;
    }

    public final void setOmmitE(boolean b) {
        this.ommitE = b;
    }

    public final boolean canOmmitE() {
        return this.ommitE;
    }

    public final void setBlock(boolean b) {
        this.block = b;
    }

    public final boolean isBlock() {
        return this.block;
    }

    protected final int getPriority() {
        return this.prio;
    }

    protected final void setManager(HtParserManager manager) {
        this.manager = manager;
    }

    public HtListElement parse(ListToken tlist) {
        List<HtElement> elist = this.parseInit(tlist);
        this.parsePriority(elist, -1);
        this.parseList(elist, -1);
        HtListElement ret = new HtListElement();
        ret.setList(elist);
        return ret;
    }

    protected final List<HtElement> parseInit(ListToken tlist) {
        ArrayList<HtElement> elist = new ArrayList<HtElement>(tlist.size());
        for (Token t : tlist) {
            if (t instanceof Tag) {
                Tag tag = (Tag)t;
                if (tag.isStart() && tag.isEnd()) {
                    HtTagElement te = new HtTagElement();
                    te.setStartTag(tag);
                    te.setFix(true);
                    elist.add(te);
                    continue;
                }
                String name = tag.getName();
                if (name == null || name.isEmpty()) {
                    HtTagElement ee = new HtTagElement();
                    ee.setStartTag(tag);
                    ee.setFix(true);
                    elist.add(ee);
                    continue;
                }
                HtTokenElement e = new HtTokenElement(t);
                e.setFix(false);
                elist.add(e);
                continue;
            }
            HtTokenElement e = new HtTokenElement(t);
            e.setFix(true);
            elist.add(e);
        }
        return elist;
    }

    protected final int parsePriority(List<HtElement> elist, int stag) {
        HtParser p = this.manager.getDefaultParser();
        return p.parsePriority0(elist, stag);
    }

    protected final int parsePriority0(List<HtElement> elist, int stag) {
        if (elist == null) {
            return -1;
        }
        int i = stag + 1;
        while (i < elist.size()) {
            HtElement e = elist.get(i);
            if (!(!e.isTag() || e.isStart() && e.isEnd())) {
                String name;
                HtParser p;
                int pr;
                int n = this.parsePriorityEnd(elist, stag, i, e);
                if (n >= 0) {
                    i = n;
                    return n;
                }
                if (!e.isFix() && e.isStart() && (pr = (p = this.manager.getParser(name = e.getName())).getPriority()) > 0 && pr >= this.getPriority() && (n = p.parsePriority0(elist, i)) >= 0) {
                    i = n;
                }
            }
            ++i;
        }
        return this.parsePriorityNotFound(elist, stag);
    }

    protected int parsePriorityEnd(List<HtElement> elist, int stag, int pos, HtElement e) {
        return -1;
    }

    protected int parsePriorityNotFound(List<HtElement> elist, int stag) {
        return -1;
    }

    protected boolean parseMain(HtTagElement te) {
        HtParser p = this.manager.getDefaultParser();
        p.parseList(te.getList(), -1);
        boolean fix = true;
        List<HtElement> list = te.getList();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                HtElement e = list.get(i);
                fix &= e.isFix();
                ++i;
            }
        }
        te.setFix(fix);
        return fix;
    }

    protected void parseList(List<HtElement> elist, int stag) {
        if (elist == null) {
            return;
        }
        this.parseNoBody(elist, stag);
        this.parsePair(elist, stag);
        this.parseProper(elist, stag);
        this.parseEndTag(elist, stag);
    }

    protected final void parseNoBody(List<HtElement> elist, int stag) {
        if (stag != -1) {
            return;
        }
        int i = elist.size() - 1;
        while (i >= stag + 1) {
            HtElement e = elist.get(i);
            if (!e.isFix()) {
                int n;
                String name;
                HtParser p;
                if (e instanceof HtTagElement) {
                    HtTagElement te = (HtTagElement)e;
                    this.parseMain(te);
                } else if (!e.isEnd() && (p = this.manager.getParser(name = e.getName())).hasNoBody() && (n = this.searchEndTag(elist, i + 1, name)) < 0) {
                    this.setFix(elist, i, -1, -1, -1);
                }
            }
            --i;
        }
    }

    protected final int searchEndTag(List<HtElement> elist, int pos, String name) {
        int i = pos;
        while (i < elist.size()) {
            HtElement e = elist.get(i);
            if (e.isTag() && (!e.isStart() || !e.isEnd()) && e.isEnd() && name.equalsIgnoreCase(e.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected final void parsePair(List<HtElement> elist, int stag) {
        if (stag != -1) {
            return;
        }
        int i = elist.size() - 1;
        while (i >= stag + 1) {
            HtElement e = elist.get(i);
            if (!e.isFix() && e instanceof HtTokenElement && !e.isEnd()) {
                String name = e.getName();
                HtParser p = this.manager.getParser(name);
                p.parsePairSub(elist, i);
            }
            --i;
        }
    }

    protected final void parsePairSub(List<HtElement> elist, int stag) {
        assert (this.name != null);
        int i = stag + 1;
        while (i < elist.size()) {
            HtElement e = elist.get(i);
            if (!(!e.isTag() || e.isStart() && e.isEnd())) {
                if (e.isEnd() && this.name.equalsIgnoreCase(e.getName())) {
                    this.setFix(elist, stag, stag + 1, i - 1, i);
                    return;
                }
                if (!e.isFix()) {
                    return;
                }
            }
            ++i;
        }
        this.parsePairNotFound(elist, stag);
    }

    protected void parsePairNotFound(List<HtElement> elist, int stag) {
        if (this.hasNoBody()) {
            this.setFix(elist, stag, -1, -1, -1);
        } else if (this.canOmmitE()) {
            this.setFix(elist, stag, stag + 1, elist.size() - 1, -1);
        } else if (this.DEBUG) {
            HtElement e = elist.get(stag);
            Tag t = e.getStartTag();
            System.out.printf("check1[%d] %s%n", t.getLine(), e.getName());
        }
    }

    protected final void parseProper(List<HtElement> elist, int stag) {
        if (elist == null) {
            return;
        }
        int i = stag + 1;
        while (i < elist.size()) {
            HtElement e = elist.get(i);
            if (e.isTag()) {
                int n = this.parseProperCheckEnd(elist, stag, i, e);
                if (n >= 0) {
                    i = n;
                    return;
                }
                if (!e.isStart() || !e.isEnd()) {
                    if (e.isStart()) {
                        if (!e.isFix()) {
                            HtParser p = this.manager.getParser(e.getName());
                            p.parseProper(elist, i);
                        }
                    } else if (this.name != null && this.name.equalsIgnoreCase(e.getName())) {
                        this.setFix(elist, stag, stag + 1, i - 1, i);
                        return;
                    }
                }
            }
            ++i;
        }
        this.parseProperNotFound(elist, stag);
    }

    protected int parseProperCheckEnd(List<HtElement> elist, int stag, int pos, HtElement he) {
        return -1;
    }

    protected void parseProperNotFound(List<HtElement> elist, int stag) {
        int i = elist.size() - 1;
        while (i > stag) {
            HtElement e = elist.get(i);
            if (!e.isFix() && e.isStart() && !e.isEnd()) {
                HtParser p = this.manager.getParser(e.getName());
                if (p.hasNoBody()) {
                    this.setFix(elist, i, -1, -1, -1);
                } else if (this.DEBUG) {
                    Tag t = e.getStartTag();
                    System.out.printf("check3[%d] %s%n", t.getLine(), e.getName());
                }
            }
            --i;
        }
    }

    protected final void parseEndTag(List<HtElement> elist, int stag) {
        if (stag != -1) {
            return;
        }
        int i = stag + 1;
        while (i < elist.size()) {
            HtParser p;
            int n;
            HtElement e = elist.get(i);
            if (!e.isFix() && !e.isStart() && e.isEnd() && (n = (p = this.manager.getParser(e.getName())).parseEndTagCheck(elist, i, e)) >= 0) {
                i = n;
            }
            ++i;
        }
    }

    protected int parseEndTagCheck(List<HtElement> elist, int etag, HtElement he) {
        if (this.hasNoBody()) {
            this.setFix(elist, -1, -1, -1, etag);
            return etag;
        }
        if (this.DEBUG) {
            HtElement e = elist.get(etag);
            Tag t = e.getEndTag();
            System.out.printf("check4[%d] %s%n", t.getLine(), e.getName());
        }
        return -1;
    }

    protected void setFix(List<HtElement> elist, int stag, int start, int end, int etag) {
        HtTagElement ne = this.setFix0(elist, stag, start, end, etag);
        this.parseMain(ne);
    }

    protected HtTagElement setFix0(List<HtElement> elist, int stag, int start, int end, int etag) {
        HtTagElement ne = new HtTagElement();
        if (stag >= 0) {
            ne.setStartTag(elist.get(stag).getStartTag());
        }
        if (etag >= 0) {
            ne.setEndTag(elist.get(etag).getEndTag());
        }
        if (start <= end && start > -1) {
            int i = start;
            while (i <= end) {
                HtElement e = elist.get(i);
                ne.add(e);
                ++i;
            }
        }
        int min = elist.size();
        int max = -1;
        if (stag >= 0) {
            if (stag < min) {
                min = stag;
            }
            if (stag > max) {
                max = stag;
            }
        }
        if (start <= end) {
            if (start >= 0) {
                if (start < min) {
                    min = start;
                }
                if (start > max) {
                    max = start;
                }
            }
            if (end >= 0) {
                if (end < min) {
                    min = end;
                }
                if (end > max) {
                    max = end;
                }
            }
        }
        if (etag >= 0) {
            if (etag < min) {
                min = etag;
            }
            if (etag > max) {
                max = etag;
            }
        }
        int i = max;
        while (i >= min + 1) {
            elist.remove(i);
            --i;
        }
        elist.set(min, ne);
        return ne;
    }
}

