/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.parser.elem;

import java.io.IOException;
import java.io.Writer;
import jp.hishidama.html.lexer.token.ListToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.parser.elem.HtElement;

public class HtTokenElement
extends HtElement {
    protected Token token;
    protected Tag tag;

    public HtTokenElement(Token t) {
        this.setToken(t);
    }

    public void setToken(Token t) {
        this.token = t;
        if (t instanceof Tag) {
            this.tag = (Tag)t;
            this.name = this.tag.getName();
            if (this.name != null) {
                this.name = this.name.toLowerCase();
            }
        } else {
            this.tag = null;
            this.name = null;
        }
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public boolean isTag() {
        return this.tag != null;
    }

    @Override
    public boolean isStart() {
        if (this.tag != null) {
            return this.tag.isStart();
        }
        return false;
    }

    @Override
    public boolean isEnd() {
        if (this.tag != null) {
            return this.tag.isEnd();
        }
        return false;
    }

    @Override
    public Tag getStartTag() {
        if (this.isStart()) {
            return this.tag;
        }
        return null;
    }

    @Override
    public Tag getEndTag() {
        if (!this.isStart()) {
            return this.tag;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.token == null;
    }

    @Override
    public int getTextLength() {
        if (this.token != null) {
            return this.token.getTextLength();
        }
        return 0;
    }

    @Override
    public void writeTo(StringBuilder sb) {
        if (this.token != null) {
            this.token.writeTo(sb);
        }
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        if (this.token != null) {
            this.token.writeTo(w);
        }
    }

    @Override
    public HtElement searchToken(Token t) {
        if (this.token == t) {
            return this;
        }
        return null;
    }

    @Override
    public void toToken(ListToken tlist) {
        if (this.token != null) {
            tlist.add(this.token);
        }
    }
}

