/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.parser.elem;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jp.hishidama.html.lexer.token.ListToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.parser.elem.HtElement;

public class HtListElement
extends HtElement
implements Iterable<HtElement> {
    protected List<HtElement> list;

    @Override
    public Tag getStartTag() {
        return null;
    }

    @Override
    public Tag getEndTag() {
        return null;
    }

    public void add(HtElement he) {
        if (this.list == null) {
            this.list = new ElemList();
        }
        this.list.add(he);
    }

    public void add(int n, HtElement he) {
        if (this.list == null) {
            this.list = new ElemList();
        }
        this.list.add(n, he);
    }

    public void setList(List<HtElement> elist) {
        this.list = elist;
        for (HtElement e : elist) {
            e.setParent(this);
        }
    }

    public List<HtElement> getList() {
        return this.list;
    }

    @Override
    public Iterator<HtElement> iterator() {
        if (this.list == null) {
            return Collections.emptyList().iterator();
        }
        return this.list.iterator();
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public HtElement get(int i) {
        if (this.list == null) {
            return null;
        }
        if (i < 0 || i >= this.list.size()) {
            return null;
        }
        return this.list.get(i);
    }

    public int indexOf(HtElement he) {
        if (this.list == null) {
            return -1;
        }
        return this.list.indexOf(he);
    }

    public HtElement remove(int i) {
        if (this.list == null) {
            return null;
        }
        if (i < 0 || i >= this.list.size()) {
            return null;
        }
        return this.list.remove(i);
    }

    @Override
    public boolean isEmpty() {
        return this.list == null || this.list.isEmpty();
    }

    @Override
    public int getTextLength() {
        int len = 0;
        if (this.list != null) {
            for (HtElement e : this.list) {
                if (e == null) continue;
                len += e.getTextLength();
            }
        }
        return len;
    }

    @Override
    public void writeTo(StringBuilder sb) {
        if (this.list != null) {
            for (HtElement e : this.list) {
                if (e == null) continue;
                e.writeTo(sb);
            }
        }
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        if (this.list != null) {
            for (HtElement e : this.list) {
                if (e == null) continue;
                e.writeTo(w);
            }
        }
    }

    @Override
    public HtElement searchToken(Token t) {
        if (this.list != null) {
            for (HtElement e : this.list) {
                HtElement r;
                if (e == null || (r = e.searchToken(t)) == null) continue;
                return r;
            }
        }
        return null;
    }

    @Override
    public void toToken(ListToken tlist) {
        if (this.list != null) {
            for (HtElement e : this.list) {
                if (e == null) continue;
                e.toToken(tlist);
            }
        }
    }

    protected class ElemList
    extends ArrayList<HtElement> {
        private static final long serialVersionUID = 1L;

        protected ElemList() {
        }

        @Override
        public boolean add(HtElement element) {
            element.setParent(HtListElement.this);
            return super.add(element);
        }

        @Override
        public void add(int index, HtElement element) {
            element.setParent(HtListElement.this);
            super.add(index, element);
        }

        @Override
        public HtElement set(int index, HtElement element) {
            element.setParent(HtListElement.this);
            return super.set(index, element);
        }
    }
}

