/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.parser.elem;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import jp.hishidama.html.lexer.token.CrLfAtom;
import jp.hishidama.html.lexer.token.ListToken;
import jp.hishidama.html.lexer.token.SkipToken;
import jp.hishidama.html.lexer.token.SpaceAtom;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.parser.elem.HtElement;
import jp.hishidama.html.parser.elem.HtListElement;
import jp.hishidama.html.parser.elem.HtTagElement;
import jp.hishidama.html.parser.elem.HtTokenElement;

public class HtElementUtil {
    public static void dumpTree(HtElement he, int tab) {
        HtElementUtil.dumpTree(he, tab, System.out);
    }

    public static void dumpTree(HtElement he, int tab, File f) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(f);
            HtElementUtil.dumpTree(he, tab, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void dumpTree(HtElement he, int tab, File f, String encoding) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(f, encoding);
            HtElementUtil.dumpTree(he, tab, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void dumpTree(HtElement he, int tab, PrintStream out) {
        if (he instanceof HtListElement) {
            String ename;
            String name;
            HtListElement hle = (HtListElement)he;
            Tag stag = hle.getStartTag();
            Tag etag = hle.getEndTag();
            if (stag != null) {
                name = stag != null ? stag.getName() : "null";
                HtElementUtil.printTab(out, tab);
                out.printf("<%s> [%d]%b%n", name, stag.getLine(), hle.isFix());
            } else if (etag != null) {
                name = etag.getName();
                HtElementUtil.printTab(out, tab);
                out.printf("(%s) [%d]%b%n", name, etag.getLine(), hle.isFix());
            }
            List<HtElement> elist = hle.getList();
            if (elist != null) {
                for (HtElement e : elist) {
                    HtElementUtil.dumpTree(e, tab + 1, out);
                }
            }
            if (etag != null) {
                ename = etag.getName();
                int line = etag.getLine();
                HtElementUtil.printTab(out, tab);
                out.printf("</%s> [%d]%b%n", ename, line, hle.isFix());
            } else if (stag != null) {
                ename = stag.getName();
                int line = stag.getLine();
                HtElementUtil.printTab(out, tab);
                out.printf("(/%s) [%d]%b%n", ename, line, hle.isFix());
            }
        } else if (he instanceof HtTokenElement) {
            HtTokenElement het = (HtTokenElement)he;
            Token t = het.getToken();
            String s = t.getText();
            if ((s = s.replaceAll("[\r\n]+", " ").trim()).isEmpty()) {
                return;
            }
            String name = t.getClass().getSimpleName();
            int line = t.getLine();
            HtElementUtil.printTab(out, tab);
            out.printf("%s[%d]%b: %s%n", name, line, he.isFix(), s);
        }
    }

    protected static void printTab(PrintStream out, int tab) {
        int i = 0;
        while (i < tab) {
            out.print("  ");
            ++i;
        }
    }

    public static void dumpNotFix(HtElement he) {
        HtElementUtil.dumpNotFix(he, System.out);
    }

    public static void dumpNotFix(HtElement he, PrintStream out) {
        if (he instanceof HtTokenElement) {
            if (!he.isFix()) {
                HtTokenElement te = (HtTokenElement)he;
                Token t = te.getToken();
                out.printf("[%d]%s%n", t.getLine(), t.getText());
            }
            return;
        }
        if (he instanceof HtListElement) {
            HtListElement elist = (HtListElement)he;
            for (HtElement e : elist) {
                HtElementUtil.dumpNotFix(e, out);
            }
        }
    }

    public static ListToken toToken(HtElement he) {
        ListToken tlist = new ListToken();
        he.toToken(tlist);
        return tlist;
    }

    public static void splitFirstSkip(HtTagElement te) {
        HtTokenElement ce = HtElementUtil.cutFirstSkip(te);
        if (ce != null) {
            HtListElement pe = te.getParent();
            int n = pe.indexOf(te);
            pe.add(n, ce);
        }
    }

    public static HtTokenElement cutFirstSkip(HtElement he) {
        HtListElement le;
        HtElement e;
        if (he instanceof HtTokenElement) {
            HtTokenElement te = (HtTokenElement)he;
            Token t = te.getToken();
            if (t instanceof TextToken) {
                TextToken tt = (TextToken)t;
                TextToken c = HtElementUtil.cutFirstSkip(tt);
                if (c == tt) {
                    return te;
                }
                HtTokenElement ce = new HtTokenElement(c);
                ce.setFix(te.isFix());
                return ce;
            }
        } else if (he instanceof HtListElement && (e = (le = (HtListElement)he).get(0)) != null) {
            HtTokenElement ce = HtElementUtil.cutFirstSkip(e);
            if (ce == e || e.isEmpty()) {
                le.remove(0);
            }
            return ce;
        }
        return null;
    }

    static TextToken cutFirstSkip(TextToken tt) {
        if (tt instanceof SkipToken) {
            return tt;
        }
        int e = -1;
        int i = 0;
        while (i < tt.size()) {
            Token t = tt.get(i);
            if (!(t instanceof SkipToken) && !(t instanceof SpaceAtom) && !(t instanceof CrLfAtom)) break;
            e = i++;
        }
        if (e >= 0) {
            if (e == tt.size() - 1) {
                return tt;
            }
            ListToken skip = tt.cut(0, e);
            TextToken nt = new TextToken(skip.size());
            for (Token t : skip) {
                nt.add(t);
            }
            return nt;
        }
        return null;
    }

    public static void splitLastSkip(HtTagElement te) {
        HtTokenElement ce = HtElementUtil.cutLastSkip(te);
        if (ce != null) {
            HtListElement pe = te.getParent();
            int n = pe.indexOf(te);
            pe.add(n + 1, ce);
        }
    }

    public static HtTokenElement cutLastSkip(HtElement he) {
        int n;
        HtListElement le;
        HtElement e;
        if (he instanceof HtTokenElement) {
            HtTokenElement te = (HtTokenElement)he;
            Token t = te.getToken();
            if (t instanceof TextToken) {
                TextToken tt = (TextToken)t;
                TextToken c = HtElementUtil.cutLastSkip(tt);
                if (c == tt) {
                    return te;
                }
                HtTokenElement ce = new HtTokenElement(c);
                ce.setFix(te.isFix());
                return ce;
            }
        } else if (he instanceof HtListElement && (e = (le = (HtListElement)he).get(n = le.size() - 1)) != null) {
            HtTokenElement ce = HtElementUtil.cutLastSkip(e);
            if (ce == e || e.isEmpty()) {
                le.remove(n);
            }
            return ce;
        }
        return null;
    }

    static TextToken cutLastSkip(TextToken tt) {
        if (tt instanceof SkipToken) {
            return tt;
        }
        int s = -1;
        int i = tt.size() - 1;
        while (i >= 0) {
            Token t = tt.get(i);
            if (!(t instanceof SkipToken) && !(t instanceof SpaceAtom) && !(t instanceof CrLfAtom)) break;
            s = i--;
        }
        if (s >= 0) {
            if (s == 0) {
                return tt;
            }
            ListToken skip = tt.cut(s, tt.size() - 1);
            TextToken nt = new TextToken(skip.size());
            for (Token t : skip) {
                nt.add(t);
            }
            return nt;
        }
        return null;
    }
}

