/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.token;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.hishidama.html.lexer.token.CrLfAtom;
import jp.hishidama.html.lexer.token.SkipToken;
import jp.hishidama.html.lexer.token.SpaceAtom;
import jp.hishidama.html.lexer.token.Token;

public class ListToken
extends Token
implements Iterable<Token> {
    protected final List<Token> list;

    @Override
    public ListToken clone() throws CloneNotSupportedException {
        return new ListToken(this);
    }

    protected ListToken(ListToken o) {
        super(o);
        this.list = new ArrayList<Token>(o.list.size());
        int i = 0;
        while (i < o.list.size()) {
            try {
                Token t = o.list.get(i);
                if (t != null) {
                    t = t.clone();
                }
                this.list.add(t);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    public ListToken() {
        this(8);
    }

    public ListToken(int size) {
        this.list = new ArrayList<Token>(size);
    }

    public void add(Token token) {
        this.list.add(token);
    }

    public void add(int n, Token token) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.list.size()) {
            this.add(token);
        } else {
            this.list.add(n, token);
        }
    }

    protected void set(Enum<?> en, Token token) {
        this.set(en.ordinal(), token);
    }

    public void set(int n, Token token) {
        int i = this.list.size();
        while (i <= n) {
            this.list.add(null);
            ++i;
        }
        this.list.set(n, token);
    }

    protected Token get(Enum<?> en) {
        return this.get(en.ordinal());
    }

    public Token get(int n) {
        if (n >= this.list.size()) {
            return null;
        }
        return this.list.get(n);
    }

    public Token getLast() {
        int n = this.list.size() - 1;
        if (n >= 0) {
            return this.list.get(n);
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public int getTextLength() {
        int len = 0;
        for (Token token : this.list) {
            if (token == null) continue;
            len += token.getTextLength();
        }
        return len;
    }

    @Override
    public void writeTo(StringBuilder sb) {
        for (Token token : this.list) {
            if (token == null) continue;
            token.writeTo(sb);
        }
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        for (Token token : this.list) {
            if (token == null) continue;
            token.writeTo(w);
        }
    }

    @Override
    public int calcLine(int n) {
        this.line = n;
        for (Token token : this.list) {
            if (token == null) continue;
            n = token.calcLine(n);
        }
        return n;
    }

    @Override
    public Iterator<Token> iterator() {
        return this.list.iterator();
    }

    public Token remove(Token t) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i) == t) {
                return this.list.remove(i);
            }
            ++i;
        }
        return null;
    }

    public ListToken cut(Token start, Token end) {
        int s = -1;
        int e = -1;
        if (start == null) {
            s = 0;
        }
        if (end == null && (e = this.list.size() - 1) < 0) {
            return null;
        }
        if (s < 0 || e < 0) {
            int i = 0;
            while (i < this.list.size()) {
                Token t = this.list.get(i);
                if (t != null) {
                    if (t == start) {
                        s = i;
                        if (e >= 0) break;
                    }
                    if (t == end) {
                        e = i;
                        if (s >= 0) break;
                    }
                }
                ++i;
            }
        }
        return this.cut(s, e);
    }

    public ListToken cut(int s, int e) {
        if (s < 0 || e < 0 || e >= this.list.size() || s > e) {
            return null;
        }
        return this.cut0(s, e);
    }

    protected ListToken cut0(int s, int e) {
        ListToken n = new ListToken(e - s);
        int i = s;
        while (i <= e) {
            Token t = this.list.remove(s);
            if (t != null) {
                n.add(t);
            }
            ++i;
        }
        return n;
    }

    public ListToken cutWithPreSkip(Token token) {
        int s = -1;
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i) == token) {
                s = i;
                break;
            }
            ++i;
        }
        if (s < 0) {
            return null;
        }
        int e = s;
        while (s > 0) {
            Token t = this.list.get(s - 1);
            if (!(t instanceof SkipToken) && !(t instanceof SpaceAtom) && !(t instanceof CrLfAtom)) break;
            --s;
        }
        return this.cut0(s, e);
    }
}

