/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.AttrRule;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkupRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.token.AttributeToken;
import jp.hishidama.html.lexer.token.XmlDeclare;

public class XmlDeclRule
extends MarkupRule {
    protected AttrRule attrRule;
    protected final SeparateRule DECL_SEP_RULE = this.createDeclSepRule();
    protected static final CharType[] START_TYPE = new CharType[]{CharType.TAGO, CharType.QUES};

    protected XmlDeclRule(HtLexer data) {
        super(data);
        this.setSepRule(this.DECL_SEP_RULE);
    }

    protected void setAttrRule(AttrRule rule) {
        this.attrRule = rule;
        this.attrRule.setSepRule(this.DECL_SEP_RULE);
    }

    protected SeparateRule createDeclSepRule() {
        return new DeclSepRule();
    }

    public boolean isStart(HtLexerRule.Chars cs) throws IOException {
        return cs.isType(START_TYPE);
    }

    @Override
    @Deprecated
    public XmlDeclare parse() throws IOException {
        return (XmlDeclare)super.parse();
    }

    @Override
    protected XmlDeclare parse(HtLexerRule.Chars cs) throws IOException {
        StringBuilder tago = cs.clear(START_TYPE.length);
        XmlDeclare tag = this.createXmlDeclToken();
        tag.setTag1(tago);
        this.parseName(tag);
        this.parseAttr(tag);
        this.parseTagC(tag);
        return tag;
    }

    protected XmlDeclare createXmlDeclToken() {
        return new XmlDeclare();
    }

    protected void parseAttr(XmlDeclare tag) throws IOException {
        AttributeToken attr;
        while ((attr = this.attrRule.parse()) != null) {
            tag.addAttribute(attr);
            tag.addSkip(this.skipSpace());
        }
    }

    protected class DeclSepRule
    implements SeparateRule {
        protected DeclSepRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            switch (ch.getType()) {
                case SPACE: 
                case EOL: {
                    return true;
                }
                case QUES: {
                    Char n = XmlDeclRule.this.data.readChar();
                    XmlDeclRule.this.data.unreadChar(n);
                    if (n.getType() != CharType.TAGC) break;
                    return true;
                }
            }
            return false;
        }
    }
}

