/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.token.CrLfAtom;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.ValueToken;
import jp.hishidama.html.lexer.token.WordAtom;

public class ValueRule
extends HtLexerRule {
    protected ValueRule(HtLexer data) {
        super(data);
    }

    @Override
    public ValueToken parse() throws IOException {
        Char ch = this.data.readChar();
        if (ch == Char.EOF) {
            return null;
        }
        switch (ch.getType()) {
            case DQ: 
            case SQ: {
                return this.parseQuote(ch);
            }
        }
        return this.parseString(ch);
    }

    protected ValueToken createValueToken() {
        return new ValueToken();
    }

    protected ValueToken parseString(Char ch) throws IOException {
        StringBuilder sb = null;
        while (ch != Char.EOF) {
            if (this.parseEnd(ch)) {
                this.data.unreadChar(ch);
                break;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((CharSequence)ch.getSB());
            ch = this.data.readChar();
        }
        ValueToken token = null;
        if (sb != null) {
            WordAtom str = new WordAtom(sb);
            TextToken text = new TextToken();
            text.add(str);
            token = this.createValueToken();
            token.setValue(text);
        }
        return token;
    }

    protected ValueToken parseQuote(Char ch) throws IOException {
        ValueToken token = this.createValueToken();
        token.setQuote1(ch.getSB());
        CharType q = ch.getType();
        StringBuilder sb = null;
        TextToken text = null;
        ch = this.data.readChar();
        while (ch != Char.EOF) {
            CharType tt = ch.getType();
            if (tt == q) {
                token.setQuote2(ch.getSB());
                break;
            }
            if (tt == CharType.EOL) {
                if (text == null) {
                    text = new TextToken();
                }
                if (sb != null) {
                    WordAtom str = new WordAtom(sb);
                    text.add(str);
                    sb = null;
                }
                CrLfAtom eol = new CrLfAtom(ch.getSB());
                text.add(eol);
            } else {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append((CharSequence)ch.getSB());
            }
            ch = this.data.readChar();
        }
        if (text == null && sb == null) {
            sb = new StringBuilder(0);
        }
        if (sb != null) {
            if (text == null) {
                text = new TextToken();
            }
            WordAtom str = new WordAtom(sb);
            text.add(str);
        }
        token.setValue(text);
        return token;
    }

    public ValueToken parseAll(String quote1, String quote2) throws IOException {
        ValueToken token = this.createValueToken();
        if (quote1 != null) {
            token.setQuote1(quote1);
        }
        StringBuilder sb = null;
        TextToken text = null;
        Char ch = this.data.readChar();
        while (ch != Char.EOF) {
            CharType tt = ch.getType();
            if (tt == CharType.EOL) {
                if (text == null) {
                    text = new TextToken();
                }
                if (sb != null) {
                    WordAtom str = new WordAtom(sb);
                    text.add(str);
                    sb = null;
                }
                CrLfAtom eol = new CrLfAtom(ch.getSB());
                text.add(eol);
            } else {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append((CharSequence)ch.getSB());
            }
            ch = this.data.readChar();
        }
        if (text == null && sb == null) {
            sb = new StringBuilder(0);
        }
        if (sb != null) {
            if (text == null) {
                text = new TextToken();
            }
            WordAtom str = new WordAtom(sb);
            text.add(str);
        }
        token.setValue(text);
        if (quote2 != null) {
            token.setQuote2(quote2);
        }
        return token;
    }
}

