/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.token.CrLfAtom;
import jp.hishidama.html.lexer.token.SpaceAtom;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.WordAtom;

public class TextRule
extends HtLexerRule {
    protected TextRule(HtLexer data) {
        super(data);
    }

    @Override
    public TextToken parse() throws IOException {
        TextToken text = null;
        StringBuilder sb = null;
        Char ch = this.data.readChar();
        while (ch != Char.EOF) {
            if (this.parseEnd(ch)) {
                this.data.unreadChar(ch);
                break;
            }
            switch (ch.getType()) {
                case SPACE: 
                case EOL: {
                    if (text == null) {
                        text = new TextToken();
                    }
                    if (sb != null) {
                        WordAtom str = new WordAtom(sb);
                        text.add(str);
                        sb = null;
                    }
                    WordAtom wa = ch.getType() == CharType.EOL ? new CrLfAtom(ch.getSB()) : new SpaceAtom(ch.getSB());
                    text.add(wa);
                    break;
                }
                default: {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append((CharSequence)ch.getSB());
                }
            }
            ch = this.data.readChar();
        }
        if (sb != null) {
            if (text == null) {
                text = new TextToken();
            }
            WordAtom str = new WordAtom(sb);
            text.add(str);
        }
        return text;
    }
}

