/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.AttrRule;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkupRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.token.AttributeToken;
import jp.hishidama.html.lexer.token.Tag;

public class TagRule
extends MarkupRule {
    protected AttrRule attrRule;
    protected final SeparateRule TAG_SEP_RULE = this.createTagSepRule();
    protected static final CharType[] START_TYPE = new CharType[]{CharType.TAGO};

    protected TagRule(HtLexer data) {
        super(data);
        this.setSepRule(this.TAG_SEP_RULE);
    }

    protected void setAttrRule(AttrRule rule) {
        this.attrRule = rule;
        this.attrRule.setSepRule(this.TAG_SEP_RULE);
    }

    protected SeparateRule createTagSepRule() {
        return new TagSepRule();
    }

    public boolean isStart(HtLexerRule.Chars cs) throws IOException {
        if (!cs.isType(START_TYPE)) {
            return false;
        }
        Char ch = cs.get(1);
        if (ch.getType() == CharType.SLASH && (ch = cs.get(2)).getType() == CharType.TAGC) {
            return true;
        }
        if (ch.getType() != CharType.STRING) {
            return false;
        }
        char c = ch.getSB().charAt(0);
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    @Override
    @Deprecated
    public Tag parse() throws IOException {
        return (Tag)super.parse();
    }

    @Override
    protected Tag parse(HtLexerRule.Chars cs) throws IOException {
        StringBuilder tago = cs.clear(START_TYPE.length);
        Char c = this.data.readChar();
        if (c.getType() == CharType.SLASH) {
            tago.append((CharSequence)c.getSB());
        } else {
            this.data.unreadChar(c);
        }
        Tag tag = this.createTagToken();
        tag.setTag1(tago);
        this.parseName(tag);
        this.parseAttr(tag);
        this.parseTagC(tag);
        return tag;
    }

    protected Tag createTagToken() {
        return new Tag();
    }

    protected void parseAttr(Tag tag) throws IOException {
        AttributeToken attr;
        while ((attr = this.attrRule.parse()) != null) {
            tag.addAttribute(attr);
            tag.addSkip(this.skipSpace());
        }
    }

    protected class TagSepRule
    implements SeparateRule {
        protected TagSepRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            switch (ch.getType()) {
                case TAGC: {
                    return true;
                }
                case SLASH: {
                    Char n = TagRule.this.data.readChar();
                    TagRule.this.data.unreadChar(n);
                    if (n.getType() != CharType.TAGC) break;
                    return true;
                }
            }
            return false;
        }
    }
}

