/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.CDataRule;
import jp.hishidama.html.lexer.rule.CommentRule;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.rule.TagRule;
import jp.hishidama.html.lexer.token.CrLfAtom;
import jp.hishidama.html.lexer.token.ScriptToken;
import jp.hishidama.html.lexer.token.WordAtom;

public class ScriptRule
extends HtLexerRule {
    protected final SeparateRule SCRIPT_SEP_RULE = this.createSepRule();

    protected ScriptRule(HtLexer data) {
        super(data);
        this.setSepRule(this.SCRIPT_SEP_RULE);
    }

    protected SeparateRule createSepRule() {
        return new ScriptSepRule();
    }

    @Override
    public ScriptToken parse() throws IOException {
        Char ch;
        ScriptToken text = null;
        StringBuilder sb = null;
        block5: while ((ch = this.data.readChar()) != Char.EOF) {
            if (this.parseEnd(ch)) {
                this.data.unreadChar(ch);
                break;
            }
            switch (ch.getType()) {
                case EOL: {
                    if (text == null) {
                        text = this.createScriptToken();
                    }
                    if (sb != null) {
                        WordAtom str = new WordAtom(sb);
                        text.add(str);
                        sb = null;
                    }
                    CrLfAtom eol = new CrLfAtom(ch.getSB());
                    text.add(eol);
                    continue block5;
                }
                case SQ: {
                    if (text == null) {
                        text = this.createScriptToken();
                    }
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb = this.parseSQ(text, sb, ch);
                    continue block5;
                }
                case DQ: {
                    if (text == null) {
                        text = this.createScriptToken();
                    }
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb = this.parseDQ(text, sb, ch);
                    continue block5;
                }
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((CharSequence)ch.getSB());
        }
        if (sb != null) {
            if (text == null) {
                text = this.createScriptToken();
            }
            WordAtom str = new WordAtom(sb);
            text.add(str);
        }
        return text;
    }

    protected ScriptToken createScriptToken() {
        return new ScriptToken();
    }

    protected StringBuilder parseSQ(ScriptToken text, StringBuilder sb, Char ch) throws IOException {
        sb.append((CharSequence)ch.getSB());
        boolean esc = false;
        block5: while ((ch = this.data.readChar()) != Char.EOF) {
            switch (ch.getType()) {
                case SQ: {
                    if (esc) {
                        esc = false;
                        break;
                    }
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append((CharSequence)ch.getSB());
                    return sb;
                }
                case ESC: {
                    esc = !esc;
                    break;
                }
                case EOL: {
                    esc = false;
                    if (sb != null) {
                        WordAtom str = new WordAtom(sb);
                        text.add(str);
                        sb = null;
                    }
                    CrLfAtom eol = new CrLfAtom(ch.getSB());
                    text.add(eol);
                    continue block5;
                }
                default: {
                    esc = false;
                }
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((CharSequence)ch.getSB());
        }
        return sb;
    }

    protected StringBuilder parseDQ(ScriptToken text, StringBuilder sb, Char ch) throws IOException {
        sb.append((CharSequence)ch.getSB());
        boolean esc = false;
        block5: while ((ch = this.data.readChar()) != Char.EOF) {
            switch (ch.getType()) {
                case DQ: {
                    if (esc) {
                        esc = false;
                        break;
                    }
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append((CharSequence)ch.getSB());
                    return sb;
                }
                case ESC: {
                    esc = !esc;
                    break;
                }
                case EOL: {
                    esc = false;
                    if (sb != null) {
                        WordAtom str = new WordAtom(sb);
                        text.add(str);
                        sb = null;
                    }
                    CrLfAtom eol = new CrLfAtom(ch.getSB());
                    text.add(eol);
                    continue block5;
                }
                default: {
                    esc = false;
                }
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((CharSequence)ch.getSB());
        }
        return sb;
    }

    protected class ScriptSepRule
    implements SeparateRule {
        protected ScriptSepRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            if (ch.getType() != CharType.TAGO) {
                return false;
            }
            HtLexerRule.Chars cs = new HtLexerRule.Chars(ch);
            try {
                Char n;
                TagRule tagRule = ScriptRule.this.data.getTagRule();
                if (tagRule.isStart(cs) && cs.get(1).getType() == CharType.SLASH && (n = cs.get(2)).getType() == CharType.STRING && "script".equalsIgnoreCase(n.getString())) {
                    return true;
                }
                CommentRule cmtRule = ScriptRule.this.data.getCommentRule();
                if (cmtRule.isStart(cs)) {
                    return true;
                }
                CDataRule cdtRule = ScriptRule.this.data.getCDataRule();
                if (cdtRule.isStart(cs)) {
                    return true;
                }
            }
            finally {
                cs.clear(1);
            }
            return false;
        }
    }
}

