/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.CDataRule;
import jp.hishidama.html.lexer.rule.CommentRule;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkDeclRule;
import jp.hishidama.html.lexer.rule.TagRule;
import jp.hishidama.html.lexer.rule.XmlDeclRule;
import jp.hishidama.html.lexer.token.Markup;
import jp.hishidama.html.lexer.token.NameAtom;
import jp.hishidama.html.lexer.token.NamedMarkup;

public class MarkupRule
extends HtLexerRule {
    protected static final CharType[] START_TYPE = new CharType[]{CharType.TAGO};

    protected MarkupRule(HtLexer data) {
        super(data);
    }

    protected MarkupRule getMarkupRule(HtLexerRule.Chars cs) throws IOException {
        if (!cs.isType(START_TYPE)) {
            return null;
        }
        CommentRule cmtRule = this.data.getCommentRule();
        if (cmtRule.isStart(cs)) {
            return cmtRule;
        }
        CDataRule cdtRule = this.data.getCDataRule();
        if (cdtRule.isStart(cs)) {
            return cdtRule;
        }
        MarkDeclRule dclRule = this.data.getDeclareRule();
        if (dclRule.isStart(cs)) {
            return dclRule;
        }
        XmlDeclRule xdcRule = this.data.getXmlDeclRule();
        if (xdcRule.isStart(cs)) {
            return xdcRule;
        }
        TagRule rule = this.data.getTagRule();
        if (rule.isStart(cs)) {
            return rule;
        }
        return null;
    }

    @Override
    public Markup parse() throws IOException {
        HtLexerRule.Chars cs = new HtLexerRule.Chars();
        MarkupRule rule = this.getMarkupRule(cs);
        if (rule == null) {
            cs.clear(0);
            return null;
        }
        return rule.parse(cs);
    }

    protected Markup parse(HtLexerRule.Chars cs) throws IOException {
        throw new UnsupportedOperationException("\u30aa\u30fc\u30d0\u30fc\u30e9\u30a4\u30c9\u5fc5\u9808");
    }

    protected void parseName(NamedMarkup tag) throws IOException {
        StringBuilder sb = new StringBuilder();
        Char ch = this.data.readChar();
        block3: while (ch != Char.EOF) {
            if (this.parseEnd(ch)) {
                this.data.unreadChar(ch);
                break;
            }
            switch (ch.getType()) {
                case SPACE: 
                case EOL: 
                case TAGC: {
                    this.data.unreadChar(ch);
                    break block3;
                }
                default: {
                    sb.append((CharSequence)ch.getSB());
                    ch = this.data.readChar();
                }
            }
        }
        NameAtom name = this.createNameAtom();
        name.setName(sb);
        tag.setName(name);
        tag.addSkip(this.skipSpace());
    }

    protected NameAtom createNameAtom() {
        return new NameAtom();
    }

    protected void parseTagC(Markup tag) throws IOException {
        Char ch = this.data.readChar();
        if (ch == Char.EOF) {
            return;
        }
        StringBuilder sb = null;
        while (ch != Char.EOF) {
            if (sb == null) {
                sb = ch.getSB();
            } else {
                sb.append((CharSequence)ch.getSB());
            }
            if (ch.getType() == CharType.TAGC) break;
            ch = this.data.readChar();
        }
        tag.setTag2(sb);
    }
}

