/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkupRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.rule.ValueRule;
import jp.hishidama.html.lexer.token.MarkDeclare;
import jp.hishidama.html.lexer.token.ValueToken;

public class MarkDeclRule
extends MarkupRule {
    protected ValueRule valueRule;
    protected final SeparateRule DECL_SEP_RULE = this.createDeclSepRule();
    protected static final CharType[] START_TYPE = new CharType[]{CharType.TAGO, CharType.EXCL};

    protected MarkDeclRule(HtLexer data) {
        super(data);
        this.setSepRule(this.DECL_SEP_RULE);
    }

    protected void setValueRule(ValueRule rule) {
        this.valueRule = rule;
        this.valueRule.setSepRule(this.DECL_SEP_RULE);
    }

    protected SeparateRule createDeclSepRule() {
        return new DeclSepRule();
    }

    public boolean isStart(HtLexerRule.Chars cs) throws IOException {
        return cs.isType(START_TYPE);
    }

    @Override
    @Deprecated
    public MarkDeclare parse() throws IOException {
        return (MarkDeclare)super.parse();
    }

    @Override
    protected MarkDeclare parse(HtLexerRule.Chars cs) throws IOException {
        StringBuilder tago = cs.clear(START_TYPE.length);
        MarkDeclare tag = this.createMarkDeclareToken();
        tag.setTag1(tago);
        this.parseName(tag);
        this.parseValue(tag);
        this.parseTagC(tag);
        return tag;
    }

    protected MarkDeclare createMarkDeclareToken() {
        return new MarkDeclare();
    }

    protected void parseValue(MarkDeclare tag) throws IOException {
        ValueToken value;
        while ((value = this.valueRule.parse()) != null) {
            tag.addValue(value);
            tag.addSkip(this.skipSpace());
        }
    }

    protected class DeclSepRule
    implements SeparateRule {
        protected DeclSepRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            switch (ch.getType()) {
                case SPACE: 
                case EOL: 
                case TAGC: {
                    return true;
                }
            }
            return false;
        }
    }
}

