/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.token.CrLfAtom;
import jp.hishidama.html.lexer.token.SkipToken;
import jp.hishidama.html.lexer.token.SpaceAtom;
import jp.hishidama.html.lexer.token.Token;

public abstract class HtLexerRule {
    protected HtLexer data;
    protected SeparateRule sepRule;

    protected HtLexerRule(HtLexer data) {
        this.data = data;
    }

    public abstract Token parse() throws IOException;

    protected void setSepRule(SeparateRule sepRule) {
        this.sepRule = sepRule;
    }

    protected boolean parseEnd(Char ch) throws IOException {
        return this.sepRule.isEnd(ch);
    }

    public SkipToken skipSpace() throws IOException {
        Char ch;
        SkipToken skip = null;
        block4: while (true) {
            ch = this.data.readChar();
            switch (ch.getType()) {
                case SPACE: {
                    if (skip == null) {
                        skip = this.createSkipToken();
                    }
                    skip.add(new SpaceAtom(ch.getSB()));
                    continue block4;
                }
                case EOL: {
                    if (skip == null) {
                        skip = this.createSkipToken();
                    }
                    skip.add(new CrLfAtom(ch.getSB()));
                    continue block4;
                }
            }
            break;
        }
        this.data.unreadChar(ch);
        return skip;
    }

    protected SkipToken createSkipToken() {
        return new SkipToken();
    }

    protected class Chars {
        private List<Char> d = new ArrayList<Char>();

        public Chars() {
        }

        public Chars(Char c) {
            this.d.add(c);
        }

        public Char get(int n) throws IOException {
            int i = this.d.size();
            while (i <= n) {
                this.d.add(HtLexerRule.this.data.readChar());
                ++i;
            }
            return this.d.get(n);
        }

        public boolean isType(CharType[] types) throws IOException {
            int i = 0;
            while (i < types.length) {
                if (this.get(i).getType() != types[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public StringBuilder clear(int use) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < use) {
                sb.append((CharSequence)this.d.get(i).getSB());
                ++i;
            }
            this.unread(use);
            return sb;
        }

        protected void unread(int n) {
            int i = this.d.size() - 1;
            while (i >= n) {
                HtLexerRule.this.data.unreadChar(this.d.get(i));
                --i;
            }
            this.d.clear();
        }
    }
}

